/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public final class Intersection {
    protected Vec4 intersectionPoint;
    protected Double intersectionLength;
    protected Position intersectionPosition;
    protected boolean isTangent;
    protected Object object;

    public Intersection(Vec4 vec4, boolean bl) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.IntersectionPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intersectionPoint = vec4;
        this.isTangent = bl;
    }

    public Intersection(Vec4 vec4, double d, boolean bl) {
        this(vec4, bl);
        this.intersectionLength = d;
    }

    public Intersection(Vec4 vec4, Position position, boolean bl, Object object) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.IntersectionPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intersectionPoint = vec4;
        this.intersectionPosition = position;
        this.isTangent = bl;
        this.object = object;
    }

    public Position getIntersectionPosition() {
        return this.intersectionPosition;
    }

    public void setIntersectionPosition(Position position) {
        this.intersectionPosition = position;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Vec4 getIntersectionPoint() {
        return this.intersectionPoint;
    }

    public void setIntersectionPoint(Vec4 vec4) {
        this.intersectionPoint = vec4;
    }

    public boolean isTangent() {
        return this.isTangent;
    }

    public void setTangent(boolean bl) {
        this.isTangent = bl;
    }

    public Double getIntersectionLength() {
        return this.intersectionLength;
    }

    public static Queue<Intersection> sort(final Vec4 vec4, List<Intersection> list, List<Intersection> list2) {
        PriorityQueue<Intersection> priorityQueue = new PriorityQueue<Intersection>(10, new Comparator<Intersection>(){

            @Override
            public int compare(Intersection intersection, Intersection intersection2) {
                double d;
                if (intersection.intersectionPoint == null || intersection2.intersectionPoint == null) {
                    return 0;
                }
                double d2 = vec4.distanceTo3(intersection.intersectionPoint);
                return d2 < (d = vec4.distanceTo3(intersection2.intersectionPoint)) ? -1 : (d2 == d ? 0 : 1);
            }
        });
        if (list != null) {
            for (Intersection intersection : list) {
                priorityQueue.add(intersection);
            }
        }
        if (list2 != null) {
            for (Intersection intersection : list2) {
                priorityQueue.add(intersection);
            }
        }
        return priorityQueue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Intersection intersection = (Intersection)object;
        if (this.isTangent != intersection.isTangent) {
            return false;
        }
        return this.intersectionPoint.equals(intersection.intersectionPoint);
    }

    public int hashCode() {
        int n = this.intersectionPoint.hashCode();
        n = 29 * n + (this.isTangent ? 1 : 0);
        return n;
    }

    public String toString() {
        String string = "Intersection Point: " + this.intersectionPoint;
        String string2 = this.isTangent ? " is a tangent." : " not a tangent";
        return string + string2;
    }
}

