/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Sector
implements Cacheable,
Comparable<Sector>,
Iterable<LatLon> {
    public static final Sector FULL_SPHERE = new Sector(Angle.NEG90, Angle.POS90, Angle.NEG180, Angle.POS180);
    public static final Sector EMPTY_SECTOR = new Sector(Angle.ZERO, Angle.ZERO, Angle.ZERO, Angle.ZERO);
    private final Angle minLatitude;
    private final Angle maxLatitude;
    private final Angle minLongitude;
    private final Angle maxLongitude;
    private final Angle deltaLat;
    private final Angle deltaLon;

    public static Sector fromDegrees(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromDegrees(d), Angle.fromDegrees(d2), Angle.fromDegrees(d3), Angle.fromDegrees(d4));
    }

    public static Sector fromDegreesAndClamp(double d, double d2, double d3, double d4) {
        if (d < -90.0) {
            d = -90.0;
        }
        if (d2 > 90.0) {
            d2 = 90.0;
        }
        if (d3 < -180.0) {
            d3 = -180.0;
        }
        if (d4 > 180.0) {
            d4 = 180.0;
        }
        return new Sector(Angle.fromDegrees(d), Angle.fromDegrees(d2), Angle.fromDegrees(d3), Angle.fromDegrees(d4));
    }

    public static Sector fromDegrees(double[] dArray) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < 4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Sector.fromDegrees(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public static Sector fromDegrees(Rectangle2D rectangle2D) {
        return Sector.fromDegrees(rectangle2D.getY(), rectangle2D.getMaxY(), rectangle2D.getX(), rectangle2D.getMaxX());
    }

    public static Sector fromRadians(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromRadians(d), Angle.fromRadians(d2), Angle.fromRadians(d3), Angle.fromRadians(d4));
    }

    public static Sector fromUTMRectangle(int n, String string, double d, double d2, double d3, double d4) {
        if (n < 1 || n > 60) {
            String string2 = Logging.getMessage("generic.ZoneIsInvalid", n);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!"gov.nasa.worldwind.avkey.North".equals(string) && !"gov.nasa.worldwdind.avkey.South".equals(string)) {
            String string3 = Logging.getMessage("generic.HemisphereIsInvalid", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        LatLon latLon = UTMCoord.locationFromUTMCoord(n, string, d, d3, null);
        LatLon latLon2 = UTMCoord.locationFromUTMCoord(n, string, d2, d3, null);
        LatLon latLon3 = UTMCoord.locationFromUTMCoord(n, string, d2, d4, null);
        LatLon latLon4 = UTMCoord.locationFromUTMCoord(n, string, d, d4, null);
        return Sector.boundingSector(Arrays.asList(latLon, latLon2, latLon3, latLon4));
    }

    public static Sector boundingSector(Iterator<TrackPoint> iterator) {
        if (iterator == null) {
            String string = Logging.getMessage("nullValue.TracksPointsIteratorNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!iterator.hasNext()) {
            return EMPTY_SECTOR;
        }
        TrackPoint trackPoint = iterator.next();
        double d = trackPoint.getLatitude();
        double d2 = trackPoint.getLongitude();
        double d3 = d;
        double d4 = d2;
        while (iterator.hasNext()) {
            TrackPoint trackPoint2 = iterator.next();
            double d5 = trackPoint2.getLatitude();
            if (d5 < d) {
                d = d5;
            } else if (d5 > d3) {
                d3 = d5;
            }
            double d6 = trackPoint2.getLongitude();
            if (d6 < d2) {
                d2 = d6;
                continue;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector boundingSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!iterable.iterator().hasNext()) {
            return EMPTY_SECTOR;
        }
        double d = Angle.POS90.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.NEG90.getDegrees();
        double d4 = Angle.NEG180.getDegrees();
        for (LatLon latLon : iterable) {
            double d5;
            double d6 = latLon.getLatitude().getDegrees();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if ((d5 = latLon.getLongitude().getDegrees()) < d2) {
                d2 = d5;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector[] splitBoundingSectors(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!iterable.iterator().hasNext()) {
            return null;
        }
        double d = Angle.POS90.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.NEG90.getDegrees();
        double d4 = Angle.NEG180.getDegrees();
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d5;
            double d6 = latLon2.getLatitude().getDegrees();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if ((d5 = latLon2.getLongitude().getDegrees()) >= 0.0 && d5 < d2) {
                d2 = d5;
            }
            if (d5 <= 0.0 && d5 > d4) {
                d4 = d5;
            }
            if (latLon != null) {
                double d7 = latLon.getLongitude().getDegrees();
                if (Math.signum(d5) != Math.signum(d7) && Math.abs(d5 - d7) < 180.0) {
                    d4 = 0.0;
                    d2 = 0.0;
                }
            }
            latLon = latLon2;
        }
        if (d == d3 && d2 == d4) {
            return null;
        }
        return new Sector[]{Sector.fromDegrees(d, d3, d2, 180.0), Sector.fromDegrees(d, d3, -180.0, d4)};
    }

    public static Sector boundingSector(LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().degrees;
        double d2 = latLon.getLongitude().degrees;
        double d3 = latLon.getLatitude().degrees;
        double d4 = latLon.getLongitude().degrees;
        if (latLon2.getLatitude().degrees < d) {
            d = latLon2.getLatitude().degrees;
        } else if (latLon2.getLatitude().degrees > d3) {
            d3 = latLon2.getLatitude().degrees;
        }
        if (latLon2.getLongitude().degrees < d2) {
            d2 = latLon2.getLongitude().degrees;
        } else if (latLon2.getLongitude().degrees > d4) {
            d4 = latLon2.getLongitude().degrees;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector boundingSector(Globe globe, LatLon latLon, double d) {
        double d2 = d / globe.getRadiusAt(latLon);
        double d3 = Math.PI * 2;
        if (latLon.getLatitude().cos() > 0.0) {
            d3 = d2 / latLon.getLatitude().cos();
        }
        return new Sector(Angle.fromRadiansLatitude(latLon.getLatitude().radians - d2), Angle.fromRadiansLatitude(latLon.getLatitude().radians + d2), Angle.fromRadiansLongitude(latLon.getLongitude().radians - d3), Angle.fromRadiansLongitude(latLon.getLongitude().radians + d3));
    }

    public static Sector[] splitBoundingSectors(Globe globe, LatLon latLon, double d) {
        Sector[] sectorArray;
        double d2;
        double d3;
        Object object;
        Object object2;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = d / globe.getRadiusAt(latLon);
        double d5 = latLon.getLatitude().radians - d4;
        double d6 = latLon.getLatitude().radians + d4;
        if (d5 >= Angle.NEG90.radians && d6 <= Angle.POS90.radians) {
            double d7 = Math.abs(Angle.POS90.radians - d4) > 0.001 ? Math.acos(Math.tan(d4) * Math.tan(latLon.latitude.radians)) : Angle.POS90.radians;
            object2 = LatLon.greatCircleEndPosition(latLon, d7, d4);
            object = LatLon.greatCircleEndPosition(latLon, -d7, d4);
            d3 = Math.min(((LatLon)object2).longitude.radians, ((LatLon)object).longitude.radians);
            d2 = Math.max(((LatLon)object2).longitude.radians, ((LatLon)object).longitude.radians);
        } else {
            d3 = Angle.NEG180.radians;
            d2 = Angle.POS180.radians;
        }
        LatLon latLon2 = new LatLon(Angle.fromRadiansLatitude(d5), Angle.normalizedLongitude(Angle.fromRadians(d3)));
        LatLon latLon3 = new LatLon(Angle.fromRadiansLatitude(d6), Angle.normalizedLongitude(Angle.fromRadians(d2)));
        object2 = Arrays.asList(latLon2, latLon3);
        if (LatLon.locationsCrossDateLine((Iterable<? extends LatLon>)object2)) {
            return Sector.splitBoundingSectors((Iterable<? extends LatLon>)object2);
        }
        object = Sector.boundingSector((Iterable<? extends LatLon>)object2);
        if (object != null && !((Sector)object).equals(EMPTY_SECTOR)) {
            Sector[] sectorArray2 = new Sector[1];
            sectorArray = sectorArray2;
            sectorArray2[0] = object;
        } else {
            sectorArray = null;
        }
        return sectorArray;
    }

    public Sector(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.InputAnglesNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = angle;
        this.maxLatitude = angle2;
        this.minLongitude = angle3;
        this.maxLongitude = angle4;
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public Sector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = new Angle(sector.getMinLatitude());
        this.maxLatitude = new Angle(sector.getMaxLatitude());
        this.minLongitude = new Angle(sector.getMinLongitude());
        this.maxLongitude = new Angle(sector.getMaxLongitude());
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public final Angle getMinLatitude() {
        return this.minLatitude;
    }

    public final Angle getMinLongitude() {
        return this.minLongitude;
    }

    public final Angle getMaxLatitude() {
        return this.maxLatitude;
    }

    public final Angle getMaxLongitude() {
        return this.maxLongitude;
    }

    public final Angle getDeltaLat() {
        return this.deltaLat;
    }

    public final double getDeltaLatDegrees() {
        return this.deltaLat.degrees;
    }

    public final double getDeltaLatRadians() {
        return this.deltaLat.radians;
    }

    public final Angle getDeltaLon() {
        return this.deltaLon;
    }

    public final double getDeltaLonDegrees() {
        return this.deltaLon.degrees;
    }

    public final double getDeltaLonRadians() {
        return this.deltaLon.radians;
    }

    public boolean isWithinLatLonLimits() {
        return this.minLatitude.degrees >= -90.0 && this.maxLatitude.degrees <= 90.0 && this.minLongitude.degrees >= -180.0 && this.maxLongitude.degrees <= 180.0;
    }

    public boolean isSameSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!Sector.isSector(iterable)) {
            return false;
        }
        Sector sector = Sector.boundingSector(iterable);
        return sector.equals(this);
    }

    public static boolean isSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon[] latLonArray = new LatLon[5];
        int n = 0;
        for (LatLon latLon : iterable) {
            if (n > 4 || latLon == null) {
                return false;
            }
            latLonArray[n++] = latLon;
        }
        if (!latLonArray[0].getLatitude().equals(latLonArray[1].getLatitude())) {
            return false;
        }
        if (!latLonArray[2].getLatitude().equals(latLonArray[3].getLatitude())) {
            return false;
        }
        if (!latLonArray[0].getLongitude().equals(latLonArray[3].getLongitude())) {
            return false;
        }
        if (!latLonArray[1].getLongitude().equals(latLonArray[2].getLongitude())) {
            return false;
        }
        return n != 5 || latLonArray[4].equals(latLonArray[0]);
    }

    public LatLon getCentroid() {
        Angle angle = Angle.fromDegrees(0.5 * (this.getMaxLatitude().degrees + this.getMinLatitude().degrees));
        Angle angle2 = Angle.fromDegrees(0.5 * (this.getMaxLongitude().degrees + this.getMinLongitude().degrees));
        return new LatLon(angle, angle2);
    }

    public Vec4 computeCenterPoint(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = 0.5 * (this.minLatitude.degrees + this.maxLatitude.degrees);
        double d3 = 0.5 * (this.minLongitude.degrees + this.maxLongitude.degrees);
        Angle angle = Angle.fromDegrees(d2);
        Angle angle2 = Angle.fromDegrees(d3);
        return globe.computePointFromPosition(angle, angle2, d * globe.getElevation(angle, angle2));
    }

    public Vec4[] computeCornerPoints(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = new Vec4[4];
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        vec4Array[0] = globe.computePointFromPosition(angle, angle3, d * globe.getElevation(angle, angle3));
        vec4Array[1] = globe.computePointFromPosition(angle, angle4, d * globe.getElevation(angle, angle4));
        vec4Array[2] = globe.computePointFromPosition(angle2, angle4, d * globe.getElevation(angle2, angle4));
        vec4Array[3] = globe.computePointFromPosition(angle2, angle3, d * globe.getElevation(angle2, angle3));
        return vec4Array;
    }

    public static Sphere computeBoundingSphere(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double[] dArray = globe.getMinAndMaxElevations(sector);
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        Vec4[] vec4Array = new Vec4[]{globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2)};
        return Sphere.createBoundingSphere(vec4Array);
    }

    public static Box computeBoundingBox(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = globe.getMinAndMaxElevations(sector);
        return Sector.computeBoundingBox(globe, d, sector, dArray[0], dArray[1]);
    }

    public static Box computeBoundingBox(Globe globe, double d, Sector sector, double d2, double d3) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = d2 * d;
        double d5 = d3 * d;
        if (d4 == d5) {
            d5 = d4 + 10.0;
        }
        double[] dArray = new double[]{d4, d5, d5, d5, d4, d5, d5, d5, d5, d5, d4, d5, d5, d5, d4};
        Vec4[] vec4Array = new Vec4[15];
        globe.computePointsFromPositions(sector, 3, 5, dArray, vec4Array);
        try {
            return Box.computeBoundingBox(Arrays.asList(vec4Array));
        }
        catch (Exception exception) {
            return new Box(vec4Array[0]);
        }
    }

    public static Cylinder computeBoundingCylinder(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = globe.getMinAndMaxElevations(sector);
        return Sector.computeBoundingCylinder(globe, d, sector, dArray[0], dArray[1]);
    }

    public static Cylinder computeBoundingCylinder(Globe globe, double d, Sector sector, double d2, double d3) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = d2 * d;
        double d5 = d3 * d;
        if (d4 == d5) {
            d5 = d4 + 1.0;
        }
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        for (Object object : sector) {
            arrayList.add(globe.computePointFromPosition((LatLon)object, d4));
            arrayList.add(globe.computePointFromPosition((LatLon)object, d5));
        }
        arrayList.add(globe.computePointFromPosition(sector.getCentroid(), d5));
        if (sector.getDeltaLonDegrees() > 180.0) {
            Object object;
            Angle angle = sector.getCentroid().getLongitude();
            object = sector.getCentroid().getLatitude();
            Angle angle2 = Angle.midAngle(sector.getMinLongitude(), angle);
            arrayList.add(globe.computePointFromPosition((Angle)object, angle2, d5));
            angle2 = Angle.midAngle(angle, sector.getMaxLongitude());
            arrayList.add(globe.computePointFromPosition((Angle)object, angle2, d5));
            arrayList.add(globe.computePointFromPosition((Angle)object, sector.getMinLongitude(), d5));
            arrayList.add(globe.computePointFromPosition((Angle)object, sector.getMaxLongitude(), d5));
        }
        try {
            return Cylinder.computeBoundingCylinder(arrayList);
        }
        catch (Exception exception) {
            return new Cylinder((Vec4)arrayList.get(0), ((Vec4)arrayList.get(0)).add3(Vec4.UNIT_Y), 1.0);
        }
    }

    public static Cylinder computeBoundingCylinderOrig(Globe globe, double d, Sector sector) {
        return Cylinder.computeVerticalBoundingCylinder(globe, d, sector);
    }

    public static Cylinder computeBoundingCylinderOrig(Globe globe, double d, Sector sector, double d2, double d3) {
        return Cylinder.computeVerticalBoundingCylinder(globe, d, sector, d2, d3);
    }

    public final boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.containsDegrees(angle.degrees, angle2.degrees);
    }

    public final boolean contains(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.contains(latLon.getLatitude(), latLon.getLongitude());
    }

    public boolean containsRadians(double d, double d2) {
        return d >= this.minLatitude.radians && d <= this.maxLatitude.radians && d2 >= this.minLongitude.radians && d2 <= this.maxLongitude.radians;
    }

    public boolean containsDegrees(double d, double d2) {
        return d >= this.minLatitude.degrees && d <= this.maxLatitude.degrees && d2 >= this.minLongitude.degrees && d2 <= this.maxLongitude.degrees;
    }

    public boolean contains(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.minLongitude.degrees < this.minLongitude.degrees) {
            return false;
        }
        if (sector.maxLongitude.degrees > this.maxLongitude.degrees) {
            return false;
        }
        if (sector.minLatitude.degrees < this.minLatitude.degrees) {
            return false;
        }
        return !(sector.maxLatitude.degrees > this.maxLatitude.degrees);
    }

    public boolean intersects(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.maxLongitude.degrees < this.minLongitude.degrees) {
            return false;
        }
        if (sector.minLongitude.degrees > this.maxLongitude.degrees) {
            return false;
        }
        if (sector.maxLatitude.degrees < this.minLatitude.degrees) {
            return false;
        }
        return !(sector.minLatitude.degrees > this.maxLatitude.degrees);
    }

    public boolean intersectsInterior(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.maxLongitude.degrees <= this.minLongitude.degrees) {
            return false;
        }
        if (sector.minLongitude.degrees >= this.maxLongitude.degrees) {
            return false;
        }
        if (sector.maxLatitude.degrees <= this.minLatitude.degrees) {
            return false;
        }
        return !(sector.minLatitude.degrees >= this.maxLatitude.degrees);
    }

    public boolean intersectsSegment(LatLon latLon, LatLon latLon2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.BeginIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = Logging.getMessage("nullValue.EndIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0);
        Vec4 vec42 = new Vec4(latLon2.getLongitude().degrees, latLon2.getLatitude().degrees, 0.0);
        Vec4 vec43 = vec42.subtract3(vec4);
        Vec4 vec44 = vec4.add3(vec42).divide3(2.0);
        Vec4 vec45 = vec43.normalize3();
        double d = vec43.getLength3() / 2.0;
        LatLon latLon3 = this.getCentroid();
        Vec4 vec46 = new Vec4(latLon3.getLongitude().degrees, latLon3.getLatitude().degrees, 0.0);
        double d2 = this.getDeltaLonDegrees() / 2.0;
        double d3 = this.getDeltaLatDegrees() / 2.0;
        Vec4 vec47 = vec44.subtract3(vec46);
        if (Math.abs(vec47.x) > d2 + d * Math.abs(vec45.x)) {
            return false;
        }
        if (Math.abs(vec47.y) > d3 + d * Math.abs(vec45.y)) {
            return false;
        }
        Vec4 vec48 = new Vec4(vec45.y, -vec45.x, 0.0);
        return Math.abs(vec48.dot3(vec47)) <= d2 * Math.abs(vec48.x) + d3 * Math.abs(vec48.y);
    }

    public boolean intersectsAny(Iterable<? extends Sector> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Sector sector : iterable) {
            if (sector == null || !sector.intersects(this)) continue;
            return true;
        }
        return false;
    }

    public final Sector union(Sector sector) {
        if (sector == null) {
            return this;
        }
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        if (sector.minLatitude.degrees < this.minLatitude.degrees) {
            angle = sector.minLatitude;
        }
        if (sector.maxLatitude.degrees > this.maxLatitude.degrees) {
            angle2 = sector.maxLatitude;
        }
        if (sector.minLongitude.degrees < this.minLongitude.degrees) {
            angle3 = sector.minLongitude;
        }
        if (sector.maxLongitude.degrees > this.maxLongitude.degrees) {
            angle4 = sector.maxLongitude;
        }
        return new Sector(angle, angle2, angle3, angle4);
    }

    public final Sector union(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        Angle angle3 = this.minLatitude;
        Angle angle4 = this.maxLatitude;
        Angle angle5 = this.minLongitude;
        Angle angle6 = this.maxLongitude;
        if (angle.degrees < this.minLatitude.degrees) {
            angle3 = angle;
        }
        if (angle.degrees > this.maxLatitude.degrees) {
            angle4 = angle;
        }
        if (angle2.degrees < this.minLongitude.degrees) {
            angle5 = angle2;
        }
        if (angle2.degrees > this.maxLongitude.degrees) {
            angle6 = angle2;
        }
        return new Sector(angle3, angle4, angle5, angle6);
    }

    public static Sector union(Sector sector, Sector sector2) {
        if (sector == null || sector2 == null) {
            if (sector == sector2) {
                return sector;
            }
            return sector2 == null ? sector : sector2;
        }
        return sector.union(sector2);
    }

    public static Sector union(Iterable<? extends Sector> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.POS90;
        Angle angle2 = Angle.NEG90;
        Angle angle3 = Angle.POS180;
        Angle angle4 = Angle.NEG180;
        for (Sector sector : iterable) {
            if (sector == null) continue;
            for (LatLon latLon : sector) {
                if (latLon.getLatitude().degrees < angle.degrees) {
                    angle = latLon.getLatitude();
                }
                if (latLon.getLatitude().degrees > angle2.degrees) {
                    angle2 = latLon.getLatitude();
                }
                if (latLon.getLongitude().degrees < angle3.degrees) {
                    angle3 = latLon.getLongitude();
                }
                if (!(latLon.getLongitude().degrees > angle4.degrees)) continue;
                angle4 = latLon.getLongitude();
            }
        }
        return new Sector(angle, angle2, angle3, angle4);
    }

    public final Sector intersection(Sector sector) {
        Angle angle;
        Angle angle2;
        if (sector == null) {
            return this;
        }
        Angle angle3 = this.minLatitude.degrees > sector.minLatitude.degrees ? this.minLatitude : sector.minLatitude;
        Angle angle4 = angle2 = this.maxLatitude.degrees < sector.maxLatitude.degrees ? this.maxLatitude : sector.maxLatitude;
        if (angle3.degrees > angle2.degrees) {
            return null;
        }
        Angle angle5 = this.minLongitude.degrees > sector.minLongitude.degrees ? this.minLongitude : sector.minLongitude;
        Angle angle6 = angle = this.maxLongitude.degrees < sector.maxLongitude.degrees ? this.maxLongitude : sector.maxLongitude;
        if (angle5.degrees > angle.degrees) {
            return null;
        }
        return new Sector(angle3, angle2, angle5, angle);
    }

    public final Sector intersection(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        if (!this.contains(angle, angle2)) {
            return null;
        }
        return new Sector(angle, angle, angle2, angle2);
    }

    public static Sector intersection(Iterable<? extends Sector> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = null;
        for (Sector sector2 : iterable) {
            if (sector2 == null) continue;
            if (sector == null) {
                sector = sector2;
                continue;
            }
            if ((sector = sector.intersection(sector2)) != null) continue;
            break;
        }
        return sector;
    }

    public Sector[] subdivide() {
        Angle angle = Angle.average(this.minLatitude, this.maxLatitude);
        Angle angle2 = Angle.average(this.minLongitude, this.maxLongitude);
        Sector[] sectorArray = new Sector[]{new Sector(this.minLatitude, angle, this.minLongitude, angle2), new Sector(this.minLatitude, angle, angle2, this.maxLongitude), new Sector(angle, this.maxLatitude, this.minLongitude, angle2), new Sector(angle, this.maxLatitude, angle2, this.maxLongitude)};
        return sectorArray;
    }

    public Sector[] subdivide(int n) {
        double d = this.deltaLat.degrees / (double)n;
        double d2 = this.deltaLon.degrees / (double)n;
        Sector[] sectorArray = new Sector[n * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                sectorArray[n2++] = Sector.fromDegrees(this.minLatitude.degrees + d * (double)i, this.minLatitude.degrees + d * (double)i + d, this.minLongitude.degrees + d2 * (double)j, this.minLongitude.degrees + d2 * (double)j + d2);
            }
        }
        return sectorArray;
    }

    public double distanceTo(DrawContext drawContext, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = this.computeCornerPoints(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        Vec4 vec42 = this.computeCenterPoint(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        double d = vec4.distanceTo3(vec4Array[0]);
        double d2 = vec4.distanceTo3(vec4Array[1]);
        double d3 = vec4.distanceTo3(vec4Array[2]);
        double d4 = vec4.distanceTo3(vec4Array[3]);
        double d5 = vec4.distanceTo3(vec42);
        double d6 = d;
        if (d6 > d2) {
            d6 = d2;
        }
        if (d6 > d3) {
            d6 = d3;
        }
        if (d6 > d4) {
            d6 = d4;
        }
        if (d6 > d5) {
            d6 = d5;
        }
        return d6;
    }

    public double[] toArrayDegrees() {
        return new double[]{this.minLatitude.degrees, this.maxLatitude.degrees, this.minLongitude.degrees, this.maxLongitude.degrees};
    }

    public Rectangle2D toRectangleDegrees() {
        return new Rectangle2D.Double(this.getMinLongitude().degrees, this.getMinLatitude().degrees, this.getDeltaLonDegrees(), this.getDeltaLatDegrees());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.minLatitude.toString());
        stringBuilder.append(", ");
        stringBuilder.append(this.minLongitude.toString());
        stringBuilder.append(")");
        stringBuilder.append(", ");
        stringBuilder.append("(");
        stringBuilder.append(this.maxLatitude.toString());
        stringBuilder.append(", ");
        stringBuilder.append(this.maxLongitude.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public long getSizeInBytes() {
        return 4L * this.minLatitude.getSizeInBytes();
    }

    @Override
    public int compareTo(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) < 0) {
            return -1;
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) > 0) {
            return 1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) < 0) {
            return -1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) > 0) {
            return 1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) < 0) {
            return -1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) > 0) {
            return 1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) < 0) {
            return -1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<LatLon> iterator() {
        return new Iterator<LatLon>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < 4;
            }

            @Override
            public LatLon next() {
                LatLon latLon;
                if (this.position > 3) {
                    throw new NoSuchElementException();
                }
                switch (this.position) {
                    case 0: {
                        latLon = new LatLon(Sector.this.getMinLatitude(), Sector.this.getMinLongitude());
                        break;
                    }
                    case 1: {
                        latLon = new LatLon(Sector.this.getMinLatitude(), Sector.this.getMaxLongitude());
                        break;
                    }
                    case 2: {
                        latLon = new LatLon(Sector.this.getMaxLatitude(), Sector.this.getMaxLongitude());
                        break;
                    }
                    default: {
                        latLon = new LatLon(Sector.this.getMaxLatitude(), Sector.this.getMinLongitude());
                    }
                }
                ++this.position;
                return latLon;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<LatLon> asList() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        for (LatLon latLon : this) {
            arrayList.add(latLon);
        }
        return arrayList;
    }

    public double[] asDegreesArray() {
        return new double[]{this.getMinLatitude().degrees, this.getMaxLatitude().degrees, this.getMinLongitude().degrees, this.getMaxLongitude().degrees};
    }

    public double[] asRadiansArray() {
        return new double[]{this.getMinLatitude().radians, this.getMaxLatitude().radians, this.getMinLongitude().radians, this.getMaxLongitude().radians};
    }

    public LatLon[] getCorners() {
        LatLon[] latLonArray = new LatLon[]{new LatLon(this.minLatitude, this.minLongitude), new LatLon(this.minLatitude, this.maxLongitude), new LatLon(this.maxLatitude, this.maxLongitude), new LatLon(this.maxLatitude, this.minLongitude)};
        return latLonArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sector sector = (Sector)object;
        if (!this.maxLatitude.equals(sector.maxLatitude)) {
            return false;
        }
        if (!this.maxLongitude.equals(sector.maxLongitude)) {
            return false;
        }
        if (!this.minLatitude.equals(sector.minLatitude)) {
            return false;
        }
        return this.minLongitude.equals(sector.minLongitude);
    }

    public int hashCode() {
        int n = this.minLatitude.hashCode();
        n = 29 * n + this.maxLatitude.hashCode();
        n = 29 * n + this.minLongitude.hashCode();
        n = 29 * n + this.maxLongitude.hashCode();
        return n;
    }
}

