/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.WWObject;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.terrain.Tessellator;
import java.util.List;

public interface Globe
extends WWObject,
Extent {
    public Extent getExtent();

    public double getEquatorialRadius();

    public double getPolarRadius();

    public double getMaximumRadius();

    public double getRadiusAt(Angle var1, Angle var2);

    public double getElevation(Angle var1, Angle var2);

    public double getElevations(Sector var1, List<? extends LatLon> var2, double var3, double[] var5);

    public double[] getElevations(Sector var1, List<? extends LatLon> var2, double[] var3, double[] var4);

    public double getMaxElevation();

    public double getMinElevation();

    public Position getIntersectionPosition(Line var1);

    public double getEccentricitySquared();

    public Vec4 computePointFromPosition(Angle var1, Angle var2, double var3);

    public Vec4 computePointFromPosition(LatLon var1, double var2);

    public Vec4 computePointFromPosition(Position var1);

    public Vec4 computePointFromLocation(LatLon var1);

    public Position computePositionFromPoint(Vec4 var1);

    public void computePointsFromPositions(Sector var1, int var2, int var3, double[] var4, Vec4[] var5);

    public Vec4 computeSurfaceNormalAtLocation(Angle var1, Angle var2);

    public Vec4 computeSurfaceNormalAtPoint(Vec4 var1);

    public Vec4 computeNorthPointingTangentAtLocation(Angle var1, Angle var2);

    public Matrix computeModelCoordinateOriginTransform(Angle var1, Angle var2, double var3);

    public Matrix computeModelCoordinateOriginTransform(Position var1);

    public Matrix computeSurfaceOrientationAtPosition(Angle var1, Angle var2, double var3);

    public Matrix computeSurfaceOrientationAtPosition(Position var1);

    public Vec4 computeEllipsoidalPointFromPosition(Angle var1, Angle var2, double var3);

    public Vec4 computeEllipsoidalPointFromLocation(LatLon var1);

    public Vec4 computeEllipsoidalPointFromPosition(Position var1);

    public Position computePositionFromEllipsoidalPoint(Vec4 var1);

    public Vec4 computeEllipsoidalNormalAtLocation(Angle var1, Angle var2);

    public Matrix computeEllipsoidalOrientationAtPosition(Angle var1, Angle var2, double var3);

    public double getRadiusAt(LatLon var1);

    public double[] getMinAndMaxElevations(Angle var1, Angle var2);

    public double[] getMinAndMaxElevations(Sector var1);

    public Intersection[] intersect(Line var1, double var2);

    public Intersection[] intersect(Triangle var1, double var2);

    public Tessellator getTessellator();

    public void setTessellator(Tessellator var1);

    public SectorGeometryList tessellate(DrawContext var1);

    public Object getStateKey(DrawContext var1);

    public GlobeStateKey getGlobeStateKey(DrawContext var1);

    public GlobeStateKey getGlobeStateKey();

    public ElevationModel getElevationModel();

    public void setElevationModel(ElevationModel var1);

    public boolean isPointAboveElevation(Vec4 var1, double var2);
}

