/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;
import gov.nasa.worldwind.util.WWMath;

public class ProjectionMercator
extends AbstractGeographicProjection {
    public ProjectionMercator() {
        super(Sector.fromDegrees(-78.0, 78.0, -180.0, 180.0));
    }

    @Override
    public String getName() {
        return "Mercator";
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        if (angle.degrees > this.getProjectionLimits().getMaxLatitude().degrees) {
            angle = this.getProjectionLimits().getMaxLatitude();
        }
        if (angle.degrees < this.getProjectionLimits().getMinLatitude().degrees) {
            angle = this.getProjectionLimits().getMinLatitude();
        }
        if (angle2.degrees > this.getProjectionLimits().getMaxLongitude().degrees) {
            angle2 = this.getProjectionLimits().getMaxLongitude();
        }
        if (angle2.degrees < this.getProjectionLimits().getMinLongitude().degrees) {
            angle2 = this.getProjectionLimits().getMinLongitude();
        }
        double d2 = vec4 != null ? vec4.x : 0.0;
        double d3 = globe.getEquatorialRadius() * angle2.radians + d2;
        double d4 = Math.sqrt(globe.getEccentricitySquared());
        double d5 = Math.sin(angle.radians);
        double d6 = (1.0 + d5) / (1.0 - d5) * Math.pow((1.0 - d4 * d5) / (1.0 + d4 * d5), d4);
        double d7 = 0.5 * globe.getEquatorialRadius() * Math.log(d6);
        return new Vec4(d3, d7, d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = globe.getEquatorialRadius();
        double d2 = Math.sqrt(globe.getEccentricitySquared());
        double d3 = sector.getMinLatitude().radians;
        double d4 = sector.getMaxLatitude().radians;
        double d5 = sector.getMinLongitude().radians;
        double d6 = sector.getMaxLongitude().radians;
        double d7 = (d4 - d3) / (double)(n > 1 ? n - 1 : 1);
        double d8 = (d6 - d5) / (double)(n2 > 1 ? n2 - 1 : 1);
        double d9 = this.getProjectionLimits().getMinLatitude().radians;
        double d10 = this.getProjectionLimits().getMaxLatitude().radians;
        double d11 = this.getProjectionLimits().getMinLongitude().radians;
        double d12 = this.getProjectionLimits().getMaxLongitude().radians;
        double d13 = vec4.x;
        int n3 = 0;
        double d14 = d3;
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1) {
                d14 = d4;
            }
            d14 = WWMath.clamp(d14, d9, d10);
            double d15 = Math.sin(d14);
            double d16 = (1.0 + d15) / (1.0 - d15) * Math.pow((1.0 - d2 * d15) / (1.0 + d2 * d15), d2);
            double d17 = d * Math.log(d16) * 0.5;
            double d18 = d5;
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == n2 - 1) {
                    d18 = d6;
                }
                d18 = WWMath.clamp(d18, d11, d12);
                double d19 = d * d18 + d13;
                double d20 = dArray[n3];
                vec4Array[n3++] = new Vec4(d19, d17, d20);
                ++n5;
                d18 += d8;
            }
            ++n4;
            d14 += d7;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        double d = vec42 != null ? vec42.x : 0.0;
        double d2 = globe.getEccentricitySquared();
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        double d5 = d4 * d2;
        double d6 = Math.pow(Math.E, -vec4.y / globe.getEquatorialRadius());
        double d7 = 1.5707963267948966 - 2.0 * Math.atan(d6);
        double d8 = d2 / 2.0 + 5.0 * d3 / 24.0 + d4 / 12.0 + 13.0 * d5 / 360.0;
        double d9 = 7.0 * d3 / 48.0 + 29.0 * d4 / 240.0 + 811.0 * d5 / 11520.0;
        double d10 = 7.0 * d4 / 120.0 + 81.0 * d5 / 1120.0;
        double d11 = 4279.0 * d5 / 161280.0;
        double d12 = d7 - d9 + d11;
        double d13 = d8 - 3.0 * d10;
        double d14 = 2.0 * d9 - 8.0 * d11;
        double d15 = 4.0 * d10;
        double d16 = 8.0 * d11;
        double d17 = Math.sin(2.0 * d7);
        double d18 = d12 + d17 * (d13 + d17 * (d14 + d17 * (d15 + d16 * d17)));
        return Position.fromRadians(d18, (vec4.x - d) / globe.getEquatorialRadius(), vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        return Vec4.UNIT_Y;
    }
}

