/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;
import gov.nasa.worldwind.util.Logging;

public class ProjectionPolarEquidistant
extends AbstractGeographicProjection {
    protected static final int NORTH = 0;
    protected static final int SOUTH = 1;
    protected int pole = 0;

    public ProjectionPolarEquidistant() {
        super(Sector.FULL_SPHERE);
    }

    public ProjectionPolarEquidistant(String string) {
        super(Sector.FULL_SPHERE);
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.HemisphereIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.pole = string.equals("gov.nasa.worldwdind.avkey.South") ? 1 : 0;
    }

    @Override
    public String getName() {
        return (this.pole == 1 ? "South " : "North ") + "Polar Equidistant";
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    public String getPole() {
        return this.pole == 1 ? "gov.nasa.worldwdind.avkey.South" : "gov.nasa.worldwind.avkey.North";
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        if (this.pole == 0 && angle.degrees == 90.0 || this.pole == 1 && angle.degrees == -90.0) {
            return new Vec4(0.0, 0.0, d);
        }
        double d2 = globe.getRadius() * (1.5707963267948966 + angle.radians * (double)(this.pole == 1 ? 1 : -1));
        double d3 = d2 * Math.sin(angle2.radians);
        double d4 = d2 * Math.cos(angle2.radians) * (double)(this.pole == 1 ? 1 : -1);
        return new Vec4(d3, d4, d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = globe.getRadius();
        double d2 = sector.getMinLatitude().radians;
        double d3 = sector.getMaxLatitude().radians;
        double d4 = sector.getMinLongitude().radians;
        double d5 = sector.getMaxLongitude().radians;
        double d6 = (d3 - d2) / (double)(n > 1 ? n - 1 : 1);
        double d7 = (d5 - d4) / (double)(n2 > 1 ? n2 - 1 : 1);
        double d8 = this.pole == 1 ? 1.0 : -1.0;
        double d9 = 1.5707963267948966;
        int n3 = 0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double d10 = d4;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 == n2 - 1) {
                d10 = d5;
            }
            dArray2[n4] = Math.cos(d10);
            dArray3[n4] = Math.sin(d10);
            ++n4;
            d10 += d7;
        }
        double d11 = d2;
        int n5 = 0;
        while (n5 < n) {
            if (n5 == n - 1) {
                d11 = d3;
            }
            double d12 = d * (d9 + d11 * d8);
            if (this.pole == 0 && d11 == d9 || this.pole == 1 && d11 == -d9) {
                d12 = 0.0;
            }
            for (int i = 0; i < n2; ++i) {
                double d13 = d12 * dArray3[i];
                double d14 = d12 * dArray2[i] * d8;
                double d15 = dArray[n3];
                vec4Array[n3++] = new Vec4(d13, d14, d15);
            }
            ++n5;
            d11 += d6;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        double d = Math.sqrt(vec4.x * vec4.x + vec4.y * vec4.y);
        if (d < 1.0E-4) {
            return Position.fromDegrees(this.pole == 1 ? -90 : 90, 0.0, vec4.z);
        }
        double d2 = d / globe.getRadius();
        if (d2 > Math.PI) {
            d2 = Math.PI;
        }
        double d3 = Math.asin(Math.cos(d2) * (double)(this.pole == 1 ? -1 : 1));
        double d4 = Math.atan2(vec4.x, vec4.y * (double)(this.pole == 1 ? 1 : -1));
        return Position.fromRadians(d3, d4, vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        double d = Math.sin(angle2.radians) * (double)(this.pole == 1 ? 1 : -1);
        double d2 = Math.cos(angle2.radians);
        return new Vec4(d, d2, 0.0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectionPolarEquidistant projectionPolarEquidistant = (ProjectionPolarEquidistant)object;
        return this.pole == projectionPolarEquidistant.pole;
    }

    public int hashCode() {
        return this.pole;
    }
}

