/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.TMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;

public class ProjectionTransverseMercator
extends AbstractGeographicProjection {
    protected static Angle DEFAULT_WIDTH = Angle.fromDegrees(30.0);
    protected static Angle DEFAULT_CENTRAL_MERIDIAN = Angle.ZERO;
    protected static Angle DEFAULT_CENTRAL_LATITUDE = Angle.ZERO;
    protected Angle width = DEFAULT_WIDTH;
    protected Angle centralMeridian = DEFAULT_CENTRAL_MERIDIAN;
    protected Angle centralLatitude = DEFAULT_CENTRAL_LATITUDE;

    public ProjectionTransverseMercator() {
        super(ProjectionTransverseMercator.makeProjectionLimits(DEFAULT_CENTRAL_MERIDIAN, DEFAULT_WIDTH));
    }

    public ProjectionTransverseMercator(Angle angle) {
        super(ProjectionTransverseMercator.makeProjectionLimits(angle, DEFAULT_WIDTH));
        if (angle == null) {
            String string = Logging.getMessage("nullValue.CentralMeridianIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centralMeridian = angle;
    }

    public ProjectionTransverseMercator(Angle angle, Angle angle2) {
        super(ProjectionTransverseMercator.makeProjectionLimits(angle, DEFAULT_WIDTH));
        if (angle == null) {
            String string = Logging.getMessage("nullValue.CentralMeridianIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.CentralLatitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centralMeridian = angle;
        this.centralLatitude = angle2;
    }

    @Override
    public String getName() {
        return "Transverse Mercator";
    }

    public Angle getCentralMeridian() {
        return this.centralMeridian;
    }

    public void setCentralMeridian(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.CentralMeridianIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centralMeridian = angle;
        this.setProjectionLimits(ProjectionTransverseMercator.makeProjectionLimits(this.getCentralMeridian(), this.getWidth()));
    }

    public Angle getCentralLatitude() {
        return this.centralLatitude;
    }

    public void setCentralLatitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.CentralLatitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centralLatitude = angle;
    }

    public Angle getWidth() {
        return this.width;
    }

    public void setWidth(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = angle;
        this.setProjectionLimits(ProjectionTransverseMercator.makeProjectionLimits(this.getCentralMeridian(), this.getWidth()));
    }

    protected static Sector makeProjectionLimits(Angle angle, Angle angle2) {
        double d;
        double d2 = angle.degrees - angle2.degrees;
        if (d2 < -180.0) {
            d2 = -180.0;
        }
        if ((d = angle.degrees + angle2.degrees) > 180.0) {
            d = 180.0;
        }
        return Sector.fromDegrees(-90.0, 90.0, d2, d);
    }

    protected double getScale() {
        return 1.0;
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        if (angle.degrees > 86.0) {
            angle = Angle.fromDegrees(86.0);
        } else if (angle.degrees < -82.0) {
            angle = Angle.fromDegrees(-82.0);
        }
        if (angle2.degrees > this.centralMeridian.degrees + this.width.degrees) {
            angle2 = Angle.fromDegrees(this.centralMeridian.degrees + this.width.degrees);
        } else if (angle2.degrees < this.centralMeridian.degrees - this.width.degrees) {
            angle2 = Angle.fromDegrees(this.centralMeridian.degrees - this.width.degrees);
        }
        TMCoord tMCoord = TMCoord.fromLatLon(angle, angle2, globe, null, null, this.centralLatitude, this.centralMeridian, 0.0, 0.0, this.getScale());
        return new Vec4(tMCoord.getEasting(), tMCoord.getNorthing(), d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = sector.getMinLatitude().radians;
        double d2 = sector.getMaxLatitude().radians;
        double d3 = sector.getMinLongitude().radians;
        double d4 = sector.getMaxLongitude().radians;
        double d5 = (d2 - d) / (double)(n > 1 ? n - 1 : 1);
        double d6 = (d4 - d3) / (double)(n2 > 1 ? n2 - 1 : 1);
        double d7 = -1.43116998663535;
        double d8 = 1.5009831567151233;
        double d9 = this.centralMeridian.radians - this.width.radians;
        double d10 = this.centralMeridian.radians + this.width.radians;
        int n3 = 0;
        double d11 = d;
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1) {
                d11 = d2;
            }
            d11 = WWMath.clamp(d11, d7, d8);
            double d12 = d3;
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == n2 - 1) {
                    d12 = d4;
                }
                d12 = WWMath.clamp(d12, d9, d10);
                TMCoord tMCoord = TMCoord.fromLatLon(Angle.fromRadians(d11), Angle.fromRadians(d12), globe, null, null, this.centralLatitude, this.centralMeridian, 0.0, 0.0, this.getScale());
                double d13 = tMCoord.getEasting();
                double d14 = tMCoord.getNorthing();
                double d15 = dArray[n3];
                vec4Array[n3++] = new Vec4(d13, d14, d15);
                ++n5;
                d12 += d6;
            }
            ++n4;
            d11 += d5;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        TMCoord tMCoord = TMCoord.fromTM(vec4.x, vec4.y, globe, this.centralLatitude, this.centralMeridian, 0.0, 0.0, this.getScale());
        return new Position(tMCoord.getLatitude(), tMCoord.getLongitude(), vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        Angle angle3 = Angle.fromRadians(1.0E-7);
        if (angle.degrees + angle3.degrees >= 86.0) {
            Vec4 vec4 = this.geographicToCartesian(globe, angle, angle2, 0.0, null);
            Vec4 vec42 = this.geographicToCartesian(globe, angle.subtract(angle3), angle2, 0.0, null);
            return vec4.subtract3(vec42).normalize3();
        }
        if (angle.degrees - angle3.degrees <= -82.0) {
            Vec4 vec4 = this.geographicToCartesian(globe, angle.add(angle3), angle2, 0.0, null);
            Vec4 vec43 = this.geographicToCartesian(globe, angle, angle2, 0.0, null);
            return vec4.subtract3(vec43).normalize3();
        }
        Vec4 vec4 = this.geographicToCartesian(globe, angle.add(angle3), angle2, 0.0, null);
        Vec4 vec44 = this.geographicToCartesian(globe, angle.subtract(angle3), angle2, 0.0, null);
        return vec4.subtract3(vec44).normalize3();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectionTransverseMercator projectionTransverseMercator = (ProjectionTransverseMercator)object;
        if (!this.centralMeridian.equals(projectionTransverseMercator.centralMeridian)) {
            return false;
        }
        if (!this.centralLatitude.equals(projectionTransverseMercator.centralLatitude)) {
            return false;
        }
        return this.width.equals(projectionTransverseMercator.width);
    }

    public int hashCode() {
        int n = this.width.hashCode();
        n = 31 * n + this.centralMeridian.hashCode();
        n = 31 * n + this.centralLatitude.hashCode();
        return n;
    }
}

