/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;

public class ProjectionUPS
extends AbstractGeographicProjection {
    protected static final int NORTH = 0;
    protected static final int SOUTH = 1;
    protected static final Sector NORTH_LIMITS = Sector.fromDegrees(0.0, 90.0, -180.0, 180.0);
    protected static final Sector SOUTH_LIMITS = Sector.fromDegrees(-90.0, 0.0, -180.0, 180.0);
    protected int pole = 0;

    public ProjectionUPS() {
        super(NORTH_LIMITS);
    }

    public ProjectionUPS(String string) {
        super(string != null && string.equals("gov.nasa.worldwdind.avkey.South") ? SOUTH_LIMITS : NORTH_LIMITS);
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.HemisphereIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.pole = string.equals("gov.nasa.worldwdind.avkey.South") ? 1 : 0;
    }

    @Override
    public String getName() {
        return (this.pole == 1 ? "South " : "North ") + "Universal Polar Stereographic";
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        if (this.pole == 0 && angle.degrees == 90.0 || this.pole == 1 && angle.degrees == -90.0) {
            return new Vec4(0.0, 0.0, d);
        }
        double d2 = angle.radians;
        double d3 = angle2.radians;
        if (this.pole == 0 && d2 < 0.0) {
            d2 = 0.0;
        } else if (this.pole == 1 && d2 > 0.0) {
            d2 = 0.0;
        }
        double d4 = 0.994;
        double d5 = Math.sqrt(globe.getEccentricitySquared());
        double d6 = Math.sin(d2 * (double)(this.pole == 0 ? 1 : -1));
        double d7 = Math.sqrt((1.0 - d6) / (1.0 + d6) * Math.pow((1.0 + d5 * d6) / (1.0 - d5 * d6), d5));
        double d8 = Math.sqrt(Math.pow(1.0 + d5, 1.0 + d5) * Math.pow(1.0 - d5, 1.0 - d5));
        double d9 = 2.0 * globe.getEquatorialRadius() * d4 * d7 / d8;
        double d10 = d9 * Math.sin(d3);
        double d11 = -d9 * Math.cos(d3) * (double)(this.pole == 0 ? 1 : -1);
        return new Vec4(d10, d11, d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = sector.getMinLatitude().radians;
        double d2 = sector.getMaxLatitude().radians;
        double d3 = sector.getMinLongitude().radians;
        double d4 = sector.getMaxLongitude().radians;
        double d5 = (d2 - d) / (double)(n > 1 ? n - 1 : 1);
        double d6 = (d4 - d3) / (double)(n2 > 1 ? n2 - 1 : 1);
        double d7 = this.getProjectionLimits().getMinLatitude().radians;
        double d8 = this.getProjectionLimits().getMaxLatitude().radians;
        double d9 = this.getProjectionLimits().getMinLongitude().radians;
        double d10 = this.getProjectionLimits().getMaxLongitude().radians;
        int n3 = 0;
        double d11 = d;
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1) {
                d11 = d2;
            }
            d11 = WWMath.clamp(d11, d7, d8);
            double d12 = d3;
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == n2 - 1) {
                    d12 = d4;
                }
                d12 = WWMath.clamp(d12, d9, d10);
                vec4Array[n3] = this.geographicToCartesian(globe, Angle.fromRadiansLatitude(d11), Angle.fromRadiansLongitude(d12), dArray[n3], vec4);
                ++n3;
                ++n5;
                d12 += d6;
            }
            ++n4;
            d11 += d5;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        double d = vec42 != null ? vec42.x : 0.0;
        double d2 = vec4.x - d;
        double d3 = vec4.y;
        double d4 = Math.atan2(d2, d3 * (double)(this.pole == 0 ? -1 : 1));
        double d5 = 0.994;
        double d6 = Math.sqrt(globe.getEccentricitySquared());
        double d7 = Math.sqrt(d2 * d2 + d3 * d3);
        double d8 = Math.sqrt(Math.pow(1.0 + d6, 1.0 + d6) * Math.pow(1.0 - d6, 1.0 - d6));
        double d9 = d7 * d8 / (2.0 * globe.getEquatorialRadius() * d5);
        double d10 = globe.getEccentricitySquared();
        double d11 = d10 * d10;
        double d12 = d11 * d10;
        double d13 = d12 * d10;
        double d14 = 1.5707963267948966 - 2.0 * Math.atan(d9);
        double d15 = d10 / 2.0 + 5.0 * d11 / 24.0 + d12 / 12.0 + 13.0 * d13 / 360.0;
        double d16 = 7.0 * d11 / 48.0 + 29.0 * d12 / 240.0 + 811.0 * d13 / 11520.0;
        double d17 = 7.0 * d12 / 120.0 + 81.0 * d13 / 1120.0;
        double d18 = 4279.0 * d13 / 161280.0;
        double d19 = d14 - d16 + d18;
        double d20 = d15 - 3.0 * d17;
        double d21 = 2.0 * d16 - 8.0 * d18;
        double d22 = 4.0 * d17;
        double d23 = 8.0 * d18;
        double d24 = Math.sin(2.0 * d14);
        double d25 = d19 + d24 * (d20 + d24 * (d21 + d24 * (d22 + d23 * d24)));
        return Position.fromRadians(d25 *= (double)(this.pole == 0 ? 1 : -1), d4, vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        double d = Math.sin(angle2.radians) * (double)(this.pole == 1 ? 1 : -1);
        double d2 = Math.cos(angle2.radians);
        return new Vec4(d, d2, 0.0);
    }

    public Vec4 geographicToCartesianNGA(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        if (this.pole == 0 && angle.degrees == 90.0 || this.pole == 1 && angle.degrees == -90.0) {
            return new Vec4(0.0, 0.0, d);
        }
        double d2 = WWMath.clamp(angle.radians, this.getProjectionLimits().getMinLatitude().radians, this.getProjectionLimits().getMaxLatitude().radians);
        double d3 = globe.getEquatorialRadius();
        double d4 = d2 * (double)(this.pole == 0 ? 1 : -1);
        double d5 = angle2.radians;
        double d6 = Math.sin(d4);
        double d7 = Math.cos(d4);
        double d8 = Math.sqrt(globe.getEccentricitySquared());
        double d9 = Math.exp(d8 * Angle.arctanh(d8 * d6));
        double d10 = Math.sqrt(1.0 - d8 * d8) * Math.exp(d8 * Angle.arctanh(d8));
        double d11 = (1.0 + d6) / d9 + (1.0 - d6) * d9;
        double d12 = 2.0 * d7 / d11;
        double d13 = ((1.0 + d6) / d9 - (1.0 - d6) * d9) / d11;
        d11 = d10 * (1.0 + d13);
        double d14 = 1.988 * d3 * Math.sin(d5) * d12 / d11;
        double d15 = -1.988 * d3 * Math.cos(d5) * d12 / d11 * (double)(this.pole == 0 ? 1 : -1);
        return new Vec4(d14, d15, d);
    }

    public Position cartesianToGeographicNGA(Globe globe, Vec4 vec4, Vec4 vec42) {
        double d;
        double d2;
        double d3 = vec42 != null ? vec42.x : 0.0;
        double d4 = (vec4.x - d3) / 0.994;
        double d5 = vec4.y / (double)(0.994 * (double)this.pole == 0.0 ? 1 : -1);
        double d6 = globe.getEquatorialRadius();
        double d7 = Math.sqrt(globe.getEccentricitySquared());
        double d8 = Math.sqrt(1.0 - d7 * d7) * Math.exp(d7 * Angle.arctanh(d7));
        double d9 = d8 * d4 / (2.0 * d6);
        double d10 = d8 * d5 / (2.0 * d6);
        double d11 = d9 * d9 + d10 * d10;
        double d12 = Math.sqrt(d11);
        double d13 = 2.0 * d12 / (1.0 + d11);
        double d14 = d2 = (1.0 - d11) / (1.0 + d11);
        double d15 = 1.0;
        double d16 = 1.0E-8;
        for (int i = 0; i < 10 && !(Math.abs((d14 = ((1.0 + d2) * (d15 = Math.exp(d7 * Angle.arctanh(d7 * d14))) * d15 - (1.0 - d2)) / ((1.0 + d2) * d15 * d15 + (1.0 - d2))) - (d = d14)) <= d16); ++i) {
        }
        double d17 = 0.5 * ((1.0 + d14) / d15 + (1.0 - d14) * d15) * d13;
        double d18 = Math.atan2(d14, d17) * (double)this.pole == 0.0 ? 1.0 : -1.0;
        double d19 = Math.atan2(d4, -d5);
        if (d4 == 0.0 && d5 == 0.0) {
            d19 = 0.0;
        }
        return Position.fromRadians(d18, d19, vec4.z);
    }
}

