/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import javax.xml.xpath.XPath;
import org.w3c.dom.Element;

public abstract class AbstractLayer
extends WWObjectImpl
implements Layer {
    private boolean enabled = true;
    private boolean pickable = true;
    private double opacity = 1.0;
    private double minActiveAltitude = -1.7976931348623157E308;
    private double maxActiveAltitude = Double.MAX_VALUE;
    private boolean networkDownloadEnabled = true;
    private long expiryTime = 0L;
    private ScreenCredit screenCredit = null;
    private FileStore dataFileStore = WorldWind.getDataFileStore();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPickEnabled() {
        return this.pickable;
    }

    @Override
    public void setPickEnabled(boolean bl) {
        this.pickable = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        Boolean bl2 = this.enabled;
        this.enabled = bl;
        this.propertyChange(new PropertyChangeEvent(this, "Enabled", bl2, this.enabled));
    }

    @Override
    public String getName() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : this.toString();
    }

    @Override
    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    public String toString() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : super.toString();
    }

    @Override
    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public void setOpacity(double d) {
        this.opacity = d;
    }

    @Override
    public double getMinActiveAltitude() {
        return this.minActiveAltitude;
    }

    @Override
    public void setMinActiveAltitude(double d) {
        this.minActiveAltitude = d;
    }

    @Override
    public double getMaxActiveAltitude() {
        return this.maxActiveAltitude;
    }

    @Override
    public void setMaxActiveAltitude(double d) {
        this.maxActiveAltitude = d;
    }

    @Override
    public Double getMinEffectiveAltitude(Double d) {
        return null;
    }

    @Override
    public Double getMaxEffectiveAltitude(Double d) {
        return null;
    }

    @Override
    public double getScale() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.MapScale");
        return object != null && object instanceof Double ? (Double)object : 1.0;
    }

    @Override
    public boolean isNetworkRetrievalEnabled() {
        return this.networkDownloadEnabled;
    }

    @Override
    public void setNetworkRetrievalEnabled(boolean bl) {
        this.networkDownloadEnabled = bl;
    }

    public FileStore getDataFileStore() {
        return this.dataFileStore;
    }

    public void setDataFileStore(FileStore fileStore) {
        if (fileStore == null) {
            String string = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.dataFileStore = fileStore;
    }

    @Override
    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return true;
    }

    @Override
    public boolean isLayerActive(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            return false;
        }
        double d = position.getElevation();
        return d >= this.minActiveAltitude && d <= this.maxActiveAltitude;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doPreRender(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doRender(drawContext);
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doPick(drawContext, point);
    }

    protected void doPick(DrawContext drawContext, Point point) {
    }

    @Override
    public void dispose() {
    }

    protected void doPreRender(DrawContext drawContext) {
    }

    protected abstract void doRender(DrawContext var1);

    @Override
    public boolean isAtMaxResolution() {
        return !this.isMultiResolution();
    }

    @Override
    public boolean isMultiResolution() {
        return false;
    }

    @Override
    public String getRestorableState() {
        return null;
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreNotSupported");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    @Override
    public long getExpiryTime() {
        return this.expiryTime;
    }

    protected ScreenCredit getScreenCredit() {
        return this.screenCredit;
    }

    protected void setScreenCredit(ScreenCredit screenCredit) {
        this.screenCredit = screenCredit;
    }

    public static boolean isLayerConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element[] elementArray = WWXML.getElements(element, "//Layer", xPath);
        return elementArray != null && elementArray.length > 0;
    }

    public static Element createLayerConfigElements(AVList aVList, Element element) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.DisplayName", element, "DisplayName");
        WWXML.checkAndAppendDoubleElement(aVList, "gov.nasa.worldwind.avkey.Opacity", element, "Opacity");
        Double d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MaxActiveAltitude");
        Double d2 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MinActiveAltitude");
        if (d != null || d2 != null) {
            Element element2 = WWXML.appendElementPath(element, "ActiveAltitudes");
            if (d != null) {
                WWXML.setDoubleAttribute(element2, "max", d);
            }
            if (d2 != null) {
                WWXML.setDoubleAttribute(element2, "min", d2);
            }
        }
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", element, "NetworkRetrievalEnabled");
        WWXML.checkAndAppendDoubleElement(aVList, "gov.nasa.worldwind.avkey.MapScale", element, "MapScale");
        WWXML.checkAndAppendScreenCreditElement(aVList, "gov.nasa.worldwind.avkey.ScreenCredit", element, "ScreenCredit");
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.PickEnabled", element, "PickEnabled");
        return element;
    }

    public static AVList getLayerConfigParams(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DisplayName", "DisplayName", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.Opacity", "Opacity", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MaxActiveAltitude", "ActiveAltitudes/@max", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MinActiveAltitude", "ActiveAltitudes/@min", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", "NetworkRetrievalEnabled", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MapScale", "MapScale", xPath);
        WWXML.checkAndSetScreenCreditParam(element, aVList, "gov.nasa.worldwind.avkey.ScreenCredit", "ScreenCredit", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.MaxAbsentTileAttempts", "MaxAbsentTileAttempts", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval", "MinAbsentTileCheckInterval", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.PickEnabled", "PickEnabled", xPath);
        return aVList;
    }
}

