/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.coords.MGRSCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractGraticuleLayer;
import gov.nasa.worldwind.layers.Earth.UTMBaseGraticuleLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class MGRSGraticuleLayer
extends UTMBaseGraticuleLayer {
    public static final String GRATICULE_UTM_GRID = "Graticule.UTM.Grid";
    public static final String GRATICULE_100000M = "Graticule.100000m";
    public static final String GRATICULE_10000M = "Graticule.10000m";
    public static final String GRATICULE_1000M = "Graticule.1000m";
    public static final String GRATICULE_100M = "Graticule.100m";
    public static final String GRATICULE_10M = "Graticule.10m";
    public static final String GRATICULE_1M = "Graticule.1m";
    private GridZone[][] gridZones = new GridZone[20][60];
    private GridZone[] poleZones = new GridZone[4];
    private double zoneMaxAltitude = 5000000.0;
    private double squareMaxAltitude = 3000000.0;

    public MGRSGraticuleLayer() {
        this.initRenderingParams();
        this.metricScaleSupport.setScaleModulo(100000);
        this.setName(Logging.getMessage("layers.Earth.MGRSGraticule.Name"));
    }

    public String getMaximumGraticuleResolution() {
        String[] stringArray;
        String string = null;
        for (String string2 : stringArray = this.getOrderedTypes()) {
            GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(string2);
            if (!graticuleRenderingParams.isDrawLines()) continue;
            string = string2;
        }
        return string;
    }

    public void setMaximumGraticuleResolution(String string) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        boolean bl = false;
        for (String string3 : stringArray = this.getOrderedTypes()) {
            GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(string3);
            graticuleRenderingParams.setDrawLines(!bl);
            graticuleRenderingParams.setDrawLabels(!bl);
            if (bl || !string3.equals(string)) continue;
            bl = true;
        }
    }

    @Override
    public Color getGraticuleLineColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineColor();
    }

    @Override
    public void setGraticuleLineColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLineColor(color);
    }

    public void setGraticuleLineColor(Color color, Iterable<String> iterable) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setGraticuleLineColor(color, string);
        }
    }

    @Override
    public void setGraticuleLineColor(Color color) {
        String[] stringArray;
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineColor(color, string);
        }
    }

    @Override
    public double getGraticuleLineWidth(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineWidth();
    }

    @Override
    public void setGraticuleLineWidth(double d, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setLineWidth(d);
    }

    public void setGraticuleLineWidth(double d, Iterable<String> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setGraticuleLineWidth(d, string);
        }
    }

    @Override
    public void setGraticuleLineWidth(double d) {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineWidth(d, string);
        }
    }

    @Override
    public String getGraticuleLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineStyle();
    }

    @Override
    public void setGraticuleLineStyle(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.getRenderingParams(string2).setLineStyle(string);
    }

    public void setGraticuleLineStyle(String string, Iterable<String> iterable) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (iterable == null) {
            String string3 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        for (String string4 : iterable) {
            this.setGraticuleLineStyle(string, string4);
        }
    }

    @Override
    public void setGraticuleLineStyle(String string) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineStyle(string, string3);
        }
    }

    @Override
    public boolean isDrawLabels(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).isDrawLabels();
    }

    @Override
    public void setDrawLabels(boolean bl, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setDrawLabels(bl);
    }

    public void setDrawLabels(boolean bl, Iterable<String> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setDrawLabels(bl, string);
        }
    }

    @Override
    public void setDrawLabels(boolean bl) {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setDrawLabels(bl, string);
        }
    }

    @Override
    public Color getLabelColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelColor();
    }

    @Override
    public void setLabelColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelColor(color);
    }

    public void setLabelColor(Color color, Iterable<String> iterable) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setLabelColor(color, string);
        }
    }

    @Override
    public void setLabelColor(Color color) {
        String[] stringArray;
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setLabelColor(color, string);
        }
    }

    @Override
    public Font getLabelFont(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelFont();
    }

    @Override
    public void setLabelFont(Font font, String string) {
        if (font == null) {
            String string2 = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelFont(font);
    }

    public void setLabelFont(Font font, Iterable<String> iterable) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setLabelFont(font, string);
        }
    }

    @Override
    public void setLabelFont(Font font) {
        String[] stringArray;
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setLabelFont(font, string);
        }
    }

    @Override
    protected void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-16"));
        this.setRenderingParams(GRATICULE_UTM_GRID, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        this.setRenderingParams(GRATICULE_100000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 102, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 102, 255));
        this.setRenderingParams(GRATICULE_10000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.CYAN);
        graticuleRenderingParams.setValue("LabelColor", Color.CYAN);
        this.setRenderingParams(GRATICULE_1000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 153, 153));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 153, 153));
        this.setRenderingParams(GRATICULE_100M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(102, 255, 204));
        graticuleRenderingParams.setValue("LabelColor", new Color(102, 255, 204));
        this.setRenderingParams(GRATICULE_10M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(153, 153, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(153, 153, 255));
        this.setRenderingParams(GRATICULE_1M, graticuleRenderingParams);
    }

    protected String[] getOrderedTypes() {
        return new String[]{GRATICULE_UTM_GRID, GRATICULE_100000M, GRATICULE_10000M, GRATICULE_1000M, GRATICULE_100M, GRATICULE_10M, GRATICULE_1M};
    }

    @Override
    protected String getTypeFor(int n) {
        String string = null;
        switch (n) {
            case 100000: {
                string = GRATICULE_100000M;
                break;
            }
            case 10000: {
                string = GRATICULE_10000M;
                break;
            }
            case 1000: {
                string = GRATICULE_1000M;
                break;
            }
            case 100: {
                string = GRATICULE_100M;
                break;
            }
            case 10: {
                string = GRATICULE_10M;
                break;
            }
            case 1: {
                string = GRATICULE_1M;
            }
        }
        return string;
    }

    @Override
    protected void clear(DrawContext drawContext) {
        super.clear(drawContext);
        ++this.frameCount;
        this.applyTerrainConformance();
        this.metricScaleSupport.clear();
        this.metricScaleSupport.computeZone(drawContext);
    }

    private void applyTerrainConformance() {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.getRenderingParams(string).setValue("GraticuleLineConformance", this.terrainConformance);
        }
    }

    protected Sector computeVisibleSector(DrawContext drawContext) {
        return drawContext.getVisibleSector();
    }

    @Override
    protected void selectRenderables(DrawContext drawContext) {
        if (drawContext.getView().getEyePosition().getElevation() <= this.zoneMaxAltitude) {
            this.selectMGRSRenderables(drawContext, this.computeVisibleSector(drawContext));
            this.metricScaleSupport.selectRenderables(drawContext);
        } else {
            super.selectRenderables(drawContext);
        }
    }

    protected void selectMGRSRenderables(DrawContext drawContext, Sector sector) {
        ArrayList<GridZone> arrayList = this.getVisibleZones(drawContext);
        if (arrayList.size() > 0) {
            for (GridZone gridZone : arrayList) {
                gridZone.selectRenderables(drawContext, sector, this);
            }
        }
    }

    private ArrayList<GridZone> getVisibleZones(DrawContext drawContext) {
        ArrayList<GridZone> arrayList = new ArrayList<GridZone>();
        Sector sector = drawContext.getVisibleSector();
        if (sector != null) {
            Rectangle2D rectangle2D = this.getGridRectangleForSector(sector);
            if (rectangle2D != null) {
                int n = (int)rectangle2D.getY();
                while ((double)n <= rectangle2D.getY() + rectangle2D.getHeight()) {
                    int n2 = (int)rectangle2D.getX();
                    while ((double)n2 <= rectangle2D.getX() + rectangle2D.getWidth()) {
                        if (n != 19 || n2 != 31 && n2 != 33 && n2 != 35) {
                            if (this.gridZones[n][n2] == null) {
                                this.gridZones[n][n2] = new GridZone(this.getGridSector(n, n2));
                            }
                            if (this.gridZones[n][n2].isInView(drawContext)) {
                                arrayList.add(this.gridZones[n][n2]);
                            } else {
                                this.gridZones[n][n2].clearRenderables();
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            if (sector.getMaxLatitude().degrees > 84.0) {
                if (this.poleZones[2] == null) {
                    this.poleZones[2] = new GridZone(Sector.fromDegrees(84.0, 90.0, -180.0, 0.0));
                }
                if (this.poleZones[3] == null) {
                    this.poleZones[3] = new GridZone(Sector.fromDegrees(84.0, 90.0, 0.0, 180.0));
                }
                arrayList.add(this.poleZones[2]);
                arrayList.add(this.poleZones[3]);
            }
            if (sector.getMinLatitude().degrees < -80.0) {
                if (this.poleZones[0] == null) {
                    this.poleZones[0] = new GridZone(Sector.fromDegrees(-90.0, -80.0, -180.0, 0.0));
                }
                if (this.poleZones[1] == null) {
                    this.poleZones[1] = new GridZone(Sector.fromDegrees(-90.0, -80.0, 0.0, 180.0));
                }
                arrayList.add(this.poleZones[0]);
                arrayList.add(this.poleZones[1]);
            }
        }
        return arrayList;
    }

    private Rectangle2D getGridRectangleForSector(Sector sector) {
        Rectangle rectangle = null;
        if (sector.getMinLatitude().degrees < 84.0 && sector.getMaxLatitude().degrees > -80.0) {
            Sector sector2 = Sector.fromDegrees(Math.max(sector.getMinLatitude().degrees, -80.0), Math.min(sector.getMaxLatitude().degrees, 84.0), sector.getMinLongitude().degrees, sector.getMaxLongitude().degrees);
            int n = this.getGridColumn(sector2.getMinLongitude().degrees);
            int n2 = this.getGridColumn(sector2.getMaxLongitude().degrees);
            int n3 = this.getGridRow(sector2.getMinLatitude().degrees);
            int n4 = this.getGridRow(sector2.getMaxLatitude().degrees);
            if (n3 <= 17 && n4 >= 17 && n2 == 30) {
                n2 = 31;
            }
            if (n3 <= 19 && n4 >= 19) {
                if (n == 31) {
                    n = 30;
                }
                if (n2 == 31) {
                    n2 = 32;
                }
                if (n == 33) {
                    n = 32;
                }
                if (n2 == 33) {
                    n2 = 34;
                }
                if (n == 35) {
                    n = 34;
                }
                if (n2 == 35) {
                    n2 = 36;
                }
            }
            rectangle = new Rectangle(n, n3, n2 - n, n4 - n3);
        }
        return rectangle;
    }

    private int getGridColumn(Double d) {
        int n = (int)Math.floor((d + 180.0) / 6.0);
        return Math.min(n, 59);
    }

    private int getGridRow(Double d) {
        int n = (int)Math.floor((d + 80.0) / 8.0);
        return Math.min(n, 19);
    }

    private Sector getGridSector(int n, int n2) {
        int n3;
        int n4 = n3 + ((n3 = -80 + n * 8) != 72 ? 8 : 12);
        int n5 = -180 + n2 * 6;
        int n6 = n5 + 6;
        if (n == 17 && n2 == 30) {
            n6 -= 3;
        } else if (n == 17 && n2 == 31) {
            n5 -= 3;
        } else if (n == 19 && n2 == 30) {
            n6 += 3;
        } else if (n == 19 && n2 == 31) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 32) {
            n5 -= 3;
            n6 += 3;
        } else if (n == 19 && n2 == 33) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 34) {
            n5 -= 3;
            n6 += 3;
        } else if (n == 19 && n2 == 35) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 36) {
            n5 -= 3;
        }
        return Sector.fromDegrees(n3, n4, n5, n6);
    }

    private boolean isNorthNeighborInView(GridZone gridZone, DrawContext drawContext) {
        if (gridZone.isUPS) {
            return true;
        }
        int n = this.getGridRow(((GridZone)gridZone).sector.getCentroid().getLatitude().degrees);
        int n2 = this.getGridColumn(((GridZone)gridZone).sector.getCentroid().getLongitude().degrees);
        GridZone gridZone2 = n + 1 <= 19 ? this.gridZones[n + 1][n2] : null;
        return gridZone2 != null && gridZone2.isInView(drawContext);
    }

    private boolean isEastNeighborInView(GridZone gridZone, DrawContext drawContext) {
        if (gridZone.isUPS) {
            return true;
        }
        int n = this.getGridRow(((GridZone)gridZone).sector.getCentroid().getLatitude().degrees);
        int n2 = this.getGridColumn(((GridZone)gridZone).sector.getCentroid().getLongitude().degrees);
        GridZone gridZone2 = n2 + 1 <= 59 ? this.gridZones[n][n2 + 1] : null;
        return gridZone2 != null && gridZone2.isInView(drawContext);
    }

    private class GridZone {
        private static final double ONEHT = 100000.0;
        private static final double TWOMIL = 2000000.0;
        private Sector sector;
        private boolean isUPS = false;
        private String name = "";
        private int UTMZone = 0;
        private String hemisphere = null;
        private ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private ArrayList<UTMBaseGraticuleLayer.SquareZone> squares;

        public GridZone(Sector sector) {
            this.sector = sector;
            this.isUPS = sector.getMaxLatitude().degrees > 84.0 || sector.getMinLatitude().degrees < -80.0;
            try {
                MGRSCoord mGRSCoord = MGRSCoord.fromLatLon(sector.getCentroid().getLatitude(), sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                if (this.isUPS) {
                    this.name = mGRSCoord.toString().substring(2, 3);
                    this.hemisphere = sector.getMinLatitude().degrees > 0.0 ? "gov.nasa.worldwind.avkey.North" : "gov.nasa.worldwdind.avkey.South";
                } else {
                    this.name = mGRSCoord.toString().substring(0, 3);
                    UTMCoord uTMCoord = UTMCoord.fromLatLon(sector.getCentroid().getLatitude(), sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                    this.UTMZone = uTMCoord.getZone();
                    this.hemisphere = uTMCoord.getHemisphere();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public Extent getExtent(Globe globe, double d) {
            return Sector.computeBoundingCylinder(globe, d, this.sector);
        }

        public boolean isInView(DrawContext drawContext) {
            return drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()));
        }

        public void selectRenderables(DrawContext drawContext, Sector sector, MGRSGraticuleLayer mGRSGraticuleLayer) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            for (AbstractGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext, sector) || object.type.equals("GridElement_LineNorth") && MGRSGraticuleLayer.this.isNorthNeighborInView(this, drawContext) || object.type.equals("GridElement_LineEast") && MGRSGraticuleLayer.this.isEastNeighborInView(this, drawContext)) continue;
                mGRSGraticuleLayer.addRenderable(object.renderable, MGRSGraticuleLayer.GRATICULE_UTM_GRID);
            }
            if (drawContext.getView().getEyePosition().getElevation() > MGRSGraticuleLayer.this.squareMaxAltitude) {
                return;
            }
            if (this.squares == null) {
                this.createSquares();
            }
            for (UTMBaseGraticuleLayer.SquareZone squareZone : this.squares) {
                if (squareZone.isInView(drawContext)) {
                    squareZone.selectRenderables(drawContext, sector);
                    continue;
                }
                squareZone.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.squares != null) {
                for (UTMBaseGraticuleLayer.SquareZone squareZone : this.squares) {
                    squareZone.clearRenderables();
                }
                this.squares.clear();
                this.squares = null;
            }
        }

        private void createSquares() {
            if (this.isUPS) {
                this.createSquaresUPS();
            } else {
                this.createSquaresUTM();
            }
        }

        private void createSquaresUTM() {
            try {
                UTMCoord uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                double d = uTMCoord.getNorthing();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                double d2 = uTMCoord.getNorthing();
                d2 = d2 == 0.0 ? 1.0E7 : d2;
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getMinLongitude(), MGRSGraticuleLayer.this.globe);
                double d3 = uTMCoord.getEasting();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), MGRSGraticuleLayer.this.globe);
                d3 = uTMCoord.getEasting() < d3 ? uTMCoord.getEasting() : d3;
                double d4 = 1000000.0 - d3;
                if (this.name.equals("32V")) {
                    d2 += 20000.0;
                }
                if (this.name.equals("31X")) {
                    d4 += 100000.0;
                }
                this.squares = MGRSGraticuleLayer.this.createSquaresGrid(this.UTMZone, this.hemisphere, this.sector, d3, d4, d, d2);
                this.setSquareNames();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void createSquaresUPS() {
            double d;
            double d2;
            double d3;
            double d4;
            this.squares = new ArrayList();
            if ("gov.nasa.worldwind.avkey.North".equals(this.hemisphere)) {
                d4 = 1300000.0;
                d3 = 2700000.0;
                d2 = this.name.equals("Y") ? 1300000.0 : 2000000.0;
                d = this.name.equals("Y") ? 2000000.0 : 2700000.0;
            } else {
                d4 = 800000.0;
                d3 = 3200000.0;
                d2 = this.name.equals("A") ? 800000.0 : 2000000.0;
                d = this.name.equals("A") ? 2000000.0 : 3200000.0;
            }
            this.squares = MGRSGraticuleLayer.this.createSquaresGrid(this.UTMZone, this.hemisphere, this.sector, d2, d, d4, d3);
            this.setSquareNames();
        }

        private void setSquareNames() {
            for (UTMBaseGraticuleLayer.SquareZone squareZone : this.squares) {
                this.setSquareName(squareZone);
            }
        }

        private void setSquareName(UTMBaseGraticuleLayer.SquareZone squareZone) {
            double d = 1.567855942887398E-6;
            try {
                MGRSCoord mGRSCoord = null;
                if (squareZone.centroid != null && squareZone.isPositionInside(new Position(squareZone.centroid, 0.0))) {
                    mGRSCoord = MGRSCoord.fromLatLon(squareZone.centroid.latitude, squareZone.centroid.longitude, MGRSGraticuleLayer.this.globe);
                } else if (squareZone.isPositionInside(squareZone.sw)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(squareZone.sw.getLatitude().radians + d), Angle.fromRadiansLongitude(squareZone.sw.getLongitude().radians + d), MGRSGraticuleLayer.this.globe);
                } else if (squareZone.isPositionInside(squareZone.se)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(squareZone.se.getLatitude().radians + d), Angle.fromRadiansLongitude(squareZone.se.getLongitude().radians - d), MGRSGraticuleLayer.this.globe);
                } else if (squareZone.isPositionInside(squareZone.nw)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(squareZone.nw.getLatitude().radians - d), Angle.fromRadiansLongitude(squareZone.nw.getLongitude().radians + d), MGRSGraticuleLayer.this.globe);
                } else if (squareZone.isPositionInside(squareZone.ne)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(squareZone.ne.getLatitude().radians - d), Angle.fromRadiansLongitude(squareZone.ne.getLongitude().radians - d), MGRSGraticuleLayer.this.globe);
                }
                if (mGRSCoord != null) {
                    squareZone.setName(mGRSCoord.toString().substring(3, 5));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void createRenderables() {
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.clear();
            arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 10000.0));
            arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 10000.0));
            Object object = MGRSGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.Linear");
            Sector sector = new Sector(this.sector.getMinLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMinLongitude());
            this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineWest"));
            if (!this.isUPS) {
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMaxLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), 10000.0));
                object = MGRSGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.Linear");
                sector = new Sector(this.sector.getMinLatitude(), this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineEast"));
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMaxLongitude(), 10000.0));
                object = MGRSGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.Linear");
                sector = new Sector(this.sector.getMinLatitude(), this.sector.getMinLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineSouth"));
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), 10000.0));
                object = MGRSGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.Linear");
                sector = new Sector(this.sector.getMaxLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineNorth"));
            }
            UserFacingText userFacingText = new UserFacingText(this.name, new Position(this.sector.getCentroid(), 0.0));
            userFacingText.setPriority(1.0E7);
            this.gridElements.add(new AbstractGraticuleLayer.GridElement(this.sector, userFacingText, "GridElement_GridZoneLabel"));
        }
    }
}

