/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.mercator.BasicMercatorTiledImageLayer;
import gov.nasa.worldwind.layers.mercator.MercatorSector;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;

public class PlainMapTileLayer
extends BasicMercatorTiledImageLayer {
    protected String name;
    protected Dimension tileSize;

    public PlainMapTileLayer(String string, String string2, Dimension dimension, String string3, String string4) {
        super(PlainMapTileLayer.createLevelSet(string, string2, dimension, string3, string4));
        this.name = string;
        this.tileSize = dimension;
    }

    public PlainMapTileLayer(String string, LevelSet levelSet) {
        super(levelSet);
        this.name = string;
        int n = (Integer)levelSet.getValue("gov.nasa.worldwind.avkey.TileWidthKey");
        int n2 = (Integer)levelSet.getValue("gov.nasa.worldwind.avkey.TileHeightKey");
        this.tileSize = new Dimension(n, n2);
    }

    @Override
    public String toString() {
        return this.name;
    }

    static LevelSet createLevelSet(String string, String string2, Dimension dimension, String string3, String string4) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", dimension.width);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", dimension.height);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string3);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new PlainMapTileURLBuilder(string4));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "h");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string4);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 20);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(22.5), Angle.fromDegrees(45.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new MercatorSector(-1.0, 1.0, Angle.NEG180, Angle.POS180));
        return new LevelSet(aVListImpl);
    }

    static class PlainMapTileURLBuilder
    implements TileUrlBuilder {
        String fileExtension;

        PlainMapTileURLBuilder(String string) {
            this.fileExtension = string;
        }

        @Override
        public URL getURL(Tile tile, String string) throws MalformedURLException {
            return new URL(tile.getLevel().getService() + (tile.getLevelNumber() + 3) + "/" + tile.getColumn() + "/" + ((1 << tile.getLevelNumber() + 3) - 1 - tile.getRow()) + this.fileExtension);
        }
    }
}

