/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.UPSCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractGraticuleLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;

public class UTMBaseGraticuleLayer
extends AbstractGraticuleLayer {
    public static final String GRATICULE_UTM = "Graticule.UTM";
    protected static final double ONEHT = 100000.0;
    protected static final int UTM_MIN_LATITUDE = -80;
    protected static final int UTM_MAX_LATITUDE = 84;
    protected MetricScaleSupport metricScaleSupport = new MetricScaleSupport();
    protected long frameCount = 0L;
    private static final int[][] specialMeridians = new int[][]{{3, 56, 64}, {6, 64, 72}, {9, 72, 84}, {21, 72, 84}, {33, 72, 84}};
    private static final String latBands = "CDEFGHJKLMNPQRSTUVWX";

    public UTMBaseGraticuleLayer() {
        this.createUTMRenderables();
        this.initRenderingParams();
        this.setPickEnabled(false);
        this.setName(Logging.getMessage("layers.Earth.UTMGraticule.Name"));
    }

    public boolean isDrawGraticule() {
        return this.getUTMRenderingParams().isDrawLines();
    }

    public void setDrawGraticule(boolean bl) {
        this.getUTMRenderingParams().setDrawLines(bl);
    }

    public Color getGraticuleLineColor() {
        return this.getUTMRenderingParams().getLineColor();
    }

    public void setGraticuleLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLineColor(color);
    }

    public double getGraticuleLineWidth() {
        return this.getUTMRenderingParams().getLineWidth();
    }

    public void setGraticuleLineWidth(double d) {
        this.getUTMRenderingParams().setLineWidth(d);
    }

    public String getGraticuleLineStyle() {
        return this.getUTMRenderingParams().getLineStyle();
    }

    public void setGraticuleLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getUTMRenderingParams().setLineStyle(string);
    }

    public boolean isDrawLabels() {
        return this.getUTMRenderingParams().isDrawLabels();
    }

    public void setDrawLabels(boolean bl) {
        this.getUTMRenderingParams().setDrawLabels(bl);
    }

    public Color getLabelColor() {
        return this.getUTMRenderingParams().getLabelColor();
    }

    public void setLabelColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLabelColor(color);
    }

    public Font getLabelFont() {
        return this.getUTMRenderingParams().getLabelFont();
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLabelFont(font);
    }

    protected String getTypeFor(int n) {
        return GRATICULE_UTM;
    }

    protected void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0.8f, 0.8f, 0.8f, 0.5f));
        graticuleRenderingParams.setValue("LabelColor", new Color(1.0f, 1.0f, 1.0f, 0.8f));
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        graticuleRenderingParams.setValue("DrawLabels", Boolean.TRUE);
        this.setRenderingParams(GRATICULE_UTM, graticuleRenderingParams);
    }

    private GraticuleRenderingParams getUTMRenderingParams() {
        return this.graticuleSupport.getRenderingParams(GRATICULE_UTM);
    }

    @Override
    protected void selectRenderables(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = drawContext.getVisibleSector();
        OrbitView orbitView = (OrbitView)drawContext.getView();
        Position position = orbitView.getCenterPosition();
        Double d = Angle.fromRadians((double)(orbitView.computePixelSizeAtDistance((double)orbitView.getZoom()) / drawContext.getGlobe().getEquatorialRadius())).degrees;
        Double d2 = d * orbitView.getViewport().getWidth() / 4.0;
        Position position2 = Position.fromDegrees(position.getLatitude().degrees - d2, position.getLongitude().degrees - d2, 0.0);
        Double d3 = position2.getLatitude().normalizedLatitude().degrees;
        d3 = Math.min(Math.max(d3, -76.0), 78.0);
        position2 = new Position(Angle.fromDegrees(d3), position2.getLongitude().normalizedLongitude(), 0.0);
        if (sector != null) {
            for (AbstractGraticuleLayer.GridElement gridElement : this.gridElements) {
                if (!gridElement.isInView(drawContext)) continue;
                if (gridElement.renderable instanceof GeographicText) {
                    GeographicText geographicText = (GeographicText)gridElement.renderable;
                    if (position2.getLatitude().degrees < 72.0 || "*32*34*36*".indexOf("*" + geographicText.getText() + "*") == -1) {
                        Position position3 = geographicText.getPosition();
                        if (gridElement.type.equals("GridElement_LatitudeLabel")) {
                            position3 = Position.fromDegrees(position3.getLatitude().degrees, position2.getLongitude().degrees, position3.getElevation());
                        } else if (gridElement.type.equals("GridElement_LongitudeLabel")) {
                            position3 = Position.fromDegrees(position2.getLatitude().degrees, position3.getLongitude().degrees, position3.getElevation());
                        }
                        geographicText.setPosition(position3);
                    }
                }
                this.graticuleSupport.addRenderable(gridElement.renderable, GRATICULE_UTM);
            }
        }
    }

    private void createUTMRenderables() {
        Object object;
        Object object2;
        Object object3;
        int n;
        this.gridElements = new ArrayList();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n2 = -180;
        int n3 = 1;
        for (n = 0; n < 60; ++n) {
            int n4;
            object3 = Angle.fromDegrees(n2);
            arrayList.clear();
            arrayList.add(new Position(Angle.fromDegrees(-80.0), (Angle)object3, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(-60.0), (Angle)object3, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(-30.0), (Angle)object3, 10000.0));
            arrayList.add(new Position(Angle.ZERO, (Angle)object3, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(30.0), (Angle)object3, 10000.0));
            if (n2 < 6 || n2 > 36) {
                n4 = 84;
                arrayList.add(new Position(Angle.fromDegrees(60.0), (Angle)object3, 10000.0));
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object3, 10000.0));
            } else if (n2 == 6) {
                n4 = 56;
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object3, 10000.0));
            } else {
                n4 = 72;
                arrayList.add(new Position(Angle.fromDegrees(60.0), (Angle)object3, 10000.0));
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object3, 10000.0));
            }
            object2 = this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
            Sector sector = Sector.fromDegrees(-80.0, n4, n2, n2);
            this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object2, "GridElement_Line"));
            object = new UserFacingText("" + n3, Position.fromDegrees(0.0, n2 + 3, 0.0));
            sector = Sector.fromDegrees(-90.0, 90.0, n2 + 3, n2 + 3);
            this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LongitudeLabel"));
            n2 += 6;
            ++n3;
        }
        for (n = 0; n < 5; ++n) {
            arrayList.clear();
            n2 = specialMeridians[n][0];
            arrayList.add(new Position(Angle.fromDegrees(specialMeridians[n][1]), Angle.fromDegrees(n2), 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(specialMeridians[n][2]), Angle.fromDegrees(n2), 10000.0));
            object3 = this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
            object2 = Sector.fromDegrees(specialMeridians[n][1], specialMeridians[n][2], n2, n2);
            this.gridElements.add(new AbstractGraticuleLayer.GridElement((Sector)object2, object3, "GridElement_Line"));
        }
        n = -80;
        for (int i = 0; i < 21; ++i) {
            object2 = Angle.fromDegrees(n);
            for (int j = 0; j < 4; ++j) {
                arrayList.clear();
                n2 = -180 + j * 90;
                arrayList.add(new Position((Angle)object2, Angle.fromDegrees(n2), 10000.0));
                arrayList.add(new Position((Angle)object2, Angle.fromDegrees(n2 + 30), 10000.0));
                arrayList.add(new Position((Angle)object2, Angle.fromDegrees(n2 + 60), 10000.0));
                arrayList.add(new Position((Angle)object2, Angle.fromDegrees(n2 + 90), 10000.0));
                object = this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.Linear");
                Sector sector = Sector.fromDegrees(n, n, n2, n2 + 90);
                this.gridElements.add(new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_Line"));
            }
            if (i < 20) {
                UserFacingText userFacingText = new UserFacingText("" + latBands.charAt(i), Position.fromDegrees(n + 4, 0.0, 0.0));
                object = Sector.fromDegrees(n + 4, n + 4, -180.0, 180.0);
                this.gridElements.add(new AbstractGraticuleLayer.GridElement((Sector)object, userFacingText, "GridElement_LatitudeLabel"));
            }
            n += n < 72 ? 8 : 12;
        }
    }

    protected Position computePosition(int n, String string, double d, double d2) {
        return n > 0 ? this.computePositionFromUTM(n, string, d, d2) : this.computePositionFromUPS(string, d, d2);
    }

    protected Position computePositionFromUTM(int n, String string, double d, double d2) {
        try {
            UTMCoord uTMCoord = UTMCoord.fromUTM(n, string, d, d2, this.globe);
            return new Position(Angle.fromRadiansLatitude(uTMCoord.getLatitude().radians), Angle.fromRadiansLongitude(uTMCoord.getLongitude().radians), 10000.0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected Position computePositionFromUPS(String string, double d, double d2) {
        try {
            UPSCoord uPSCoord = UPSCoord.fromUPS(string, d, d2, this.globe);
            return new Position(Angle.fromRadiansLatitude(uPSCoord.getLatitude().radians), Angle.fromRadiansLongitude(uPSCoord.getLongitude().radians), 10000.0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected ArrayList<SquareZone> createSquaresGrid(int n, String string, Sector sector, double d, double d2, double d3, double d4) {
        ArrayList<SquareZone> arrayList = new ArrayList<SquareZone>();
        double d5 = Math.floor(d / 100000.0) * 100000.0;
        double d6 = Math.floor(d3 / 100000.0) * 100000.0;
        int n2 = (int)Math.ceil((d2 - d5) / 100000.0);
        int n3 = (int)Math.ceil((d4 - d6) / 100000.0);
        SquareZone[][] squareZoneArray = new SquareZone[n3][n2];
        int n4 = 0;
        for (double d7 = d5; d7 < d2; d7 += 100000.0) {
            int n5 = 0;
            for (double d8 = d6; d8 < d4; d8 += 100000.0) {
                SquareZone squareZone = new SquareZone(n, string, sector, d7, d8, 100000.0);
                if (squareZone.boundingSector != null && !squareZone.isOutsideGridZone()) {
                    arrayList.add(squareZone);
                    squareZoneArray[n5][n4] = squareZone;
                }
                ++n5;
            }
            ++n4;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i = 0; i < n3; ++i) {
                SquareZone squareZone = squareZoneArray[i][n4];
                if (squareZone == null) continue;
                squareZone.setNorthNeighbor(i + 1 < n3 ? squareZoneArray[i + 1][n4] : null);
                squareZone.setEastNeighbor(n4 + 1 < n2 ? squareZoneArray[i][n4 + 1] : null);
            }
        }
        return arrayList;
    }

    protected class MetricScaleSupport {
        private int zone;
        private double offsetFactorX = -0.5;
        private double offsetFactorY = -0.5;
        private double visibleDistanceFactor = 10.0;
        private int scaleModulo = 10000000;
        private double maxResolution = 100000.0;
        UTMExtremes[] extremes;

        protected MetricScaleSupport() {
        }

        public int getZone() {
            return this.zone;
        }

        public void setScaleModulo(int n) {
            this.scaleModulo = n;
        }

        public void setMaxResolution(double d) {
            this.maxResolution = d;
            this.clear();
        }

        public void computeZone(DrawContext drawContext) {
            try {
                Position position = ((OrbitView)drawContext.getView()).getCenterPosition();
                if (position != null) {
                    if (position.latitude.degrees <= 84.0 && position.latitude.degrees >= -80.0) {
                        UTMCoord uTMCoord = UTMCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                        this.zone = uTMCoord.getZone();
                    } else {
                        this.zone = 0;
                    }
                }
            }
            catch (Exception exception) {
                this.zone = 0;
            }
        }

        public void clear() {
            int n = (int)Math.log10(this.maxResolution);
            this.extremes = new UTMExtremes[n];
            for (int i = 0; i < n; ++i) {
                this.extremes[i] = new UTMExtremes();
                this.extremes[i].clear();
            }
        }

        public void computeMetricScaleExtremes(int n, String string, AbstractGraticuleLayer.GridElement gridElement, double d) {
            if (n != this.zone) {
                return;
            }
            if (d < 1.0 || d > this.maxResolution) {
                return;
            }
            UTMExtremes uTMExtremes = this.extremes[(int)Math.log10(d) - 1];
            if (gridElement.type.equals("GridElement_LineEasting") || gridElement.type.equals("GridElement_LineEast") || gridElement.type.equals("GridElement_LineWest")) {
                uTMExtremes.minX = gridElement.value < uTMExtremes.minX ? gridElement.value : uTMExtremes.minX;
                uTMExtremes.maxX = gridElement.value > uTMExtremes.maxX ? gridElement.value : uTMExtremes.maxX;
            } else if (gridElement.type.equals("GridElement_LineNorthing") || gridElement.type.equals("GridElement_LineSouth") || gridElement.type.equals("GridElement_LineNorth")) {
                if (string.equals(uTMExtremes.minYHemisphere)) {
                    uTMExtremes.minY = gridElement.value < uTMExtremes.minY ? gridElement.value : uTMExtremes.minY;
                } else if (string.equals("gov.nasa.worldwdind.avkey.South")) {
                    uTMExtremes.minY = gridElement.value;
                    uTMExtremes.minYHemisphere = string;
                }
                if (string.equals(uTMExtremes.maxYHemisphere)) {
                    uTMExtremes.maxY = gridElement.value > uTMExtremes.maxY ? gridElement.value : uTMExtremes.maxY;
                } else if (string.equals("gov.nasa.worldwind.avkey.North")) {
                    uTMExtremes.maxY = gridElement.value;
                    uTMExtremes.maxYHemisphere = string;
                }
            }
        }

        public void selectRenderables(DrawContext drawContext) {
            try {
                String string;
                double d;
                double d2;
                Object object;
                OrbitView orbitView = (OrbitView)drawContext.getView();
                Double d3 = orbitView.computePixelSizeAtDistance(orbitView.getZoom());
                Double d4 = (double)orbitView.getViewport().width * d3 * this.offsetFactorX / 2.0;
                Double d5 = (double)orbitView.getViewport().height * d3 * this.offsetFactorY / 2.0;
                Position position = orbitView.getCenterPosition();
                if (this.zone > 0) {
                    object = UTMCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                    d2 = ((UTMCoord)object).getEasting() + d4;
                    d = ((UTMCoord)object).getNorthing() + d5;
                    string = ((UTMCoord)object).getHemisphere();
                    if (d < 0.0) {
                        d = 1.0E7 + d;
                        string = "gov.nasa.worldwdind.avkey.South";
                    }
                } else {
                    object = UPSCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                    d2 = ((UPSCoord)object).getEasting() + d4;
                    d = ((UPSCoord)object).getNorthing() + d5;
                    string = ((UPSCoord)object).getHemisphere();
                }
                object = drawContext.getView().getFrustumInModelCoordinates();
                for (int i = 0; i < this.extremes.length; ++i) {
                    Object object2;
                    Object object3;
                    Angle angle;
                    Object object4;
                    Position position2;
                    UTMExtremes uTMExtremes = this.extremes[i];
                    double d6 = Math.pow(10.0, i);
                    double d7 = d6 * 10.0;
                    String string2 = UTMBaseGraticuleLayer.this.getTypeFor((int)d6);
                    if (uTMExtremes.minX <= uTMExtremes.maxX) {
                        for (double d8 = uTMExtremes.minX; d8 <= uTMExtremes.maxX; d8 += d6) {
                            if (i != this.extremes.length - 1 && d8 % d7 == 0.0) continue;
                            try {
                                Angle angle2;
                                position2 = UTMBaseGraticuleLayer.this.computePosition(this.zone, string, d8, d);
                                if (position2 == null || !((Frustum)object).contains((Vec4)(object4 = UTMBaseGraticuleLayer.this.getSurfacePoint(drawContext, angle2 = position2.getLatitude(), angle = position2.getLongitude()))) || !this.isPointInRange(drawContext, (Vec4)object4)) continue;
                                object3 = String.valueOf((int)(d8 % (double)this.scaleModulo));
                                object2 = new UserFacingText((CharSequence)object3, new Position(angle2, angle, 0.0));
                                object2.setPriority(d7);
                                UTMBaseGraticuleLayer.this.addRenderable(object2, string2);
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                    if (uTMExtremes.maxYHemisphere.equals("gov.nasa.worldwdind.avkey.South") && uTMExtremes.maxY == 0.0) continue;
                    String string3 = uTMExtremes.minYHemisphere;
                    for (double d9 = uTMExtremes.minY; d9 <= uTMExtremes.maxY || !string3.equals(uTMExtremes.maxYHemisphere); d9 += d6) {
                        if (i != this.extremes.length - 1 && d9 % d7 == 0.0) continue;
                        try {
                            position2 = UTMBaseGraticuleLayer.this.computePosition(this.zone, string3, d2, d9);
                            if (position2 == null) continue;
                            angle = position2.getLatitude();
                            object3 = UTMBaseGraticuleLayer.this.getSurfacePoint(drawContext, angle, (Angle)(object4 = position2.getLongitude()));
                            if (((Frustum)object).contains((Vec4)object3) && this.isPointInRange(drawContext, (Vec4)object3)) {
                                object2 = String.valueOf((int)(d9 % (double)this.scaleModulo));
                                UserFacingText userFacingText = new UserFacingText((CharSequence)object2, new Position(angle, (Angle)object4, 0.0));
                                userFacingText.setPriority(d7);
                                UTMBaseGraticuleLayer.this.addRenderable(userFacingText, string2);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (string3.equals(uTMExtremes.maxYHemisphere) || !(d9 >= 1.0E7 - d6)) continue;
                        string3 = uTMExtremes.maxYHemisphere;
                        d9 = -d6;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private boolean isPointInRange(DrawContext drawContext, Vec4 vec4) {
            double d = UTMBaseGraticuleLayer.this.computeAltitudeAboveGround(drawContext);
            return drawContext.getView().getEyePoint().distanceTo3(vec4) < d * this.visibleDistanceFactor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                stringBuilder.append("level ");
                stringBuilder.append(String.valueOf(i));
                stringBuilder.append(" : ");
                UTMExtremes uTMExtremes = this.extremes[i];
                if (uTMExtremes.minX < uTMExtremes.maxX || !uTMExtremes.maxYHemisphere.equals("gov.nasa.worldwdind.avkey.South") || uTMExtremes.maxY != 0.0) {
                    stringBuilder.append(uTMExtremes.minX);
                    stringBuilder.append(", ");
                    stringBuilder.append(uTMExtremes.maxX);
                    stringBuilder.append(" - ");
                    stringBuilder.append(uTMExtremes.minY);
                    stringBuilder.append("gov.nasa.worldwind.avkey.North".equals(uTMExtremes.minYHemisphere) ? "N" : "S");
                    stringBuilder.append(", ");
                    stringBuilder.append(uTMExtremes.maxY);
                    stringBuilder.append("gov.nasa.worldwind.avkey.North".equals(uTMExtremes.maxYHemisphere) ? "N" : "S");
                } else {
                    stringBuilder.append("empty");
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        private class UTMExtremes {
            protected double minX;
            protected double maxX;
            protected double minY;
            protected double maxY;
            protected String minYHemisphere;
            protected String maxYHemisphere;

            public UTMExtremes() {
                this.clear();
            }

            public void clear() {
                this.minX = 1000000.0;
                this.maxX = 0.0;
                this.minY = 1.0E7;
                this.minYHemisphere = "gov.nasa.worldwind.avkey.North";
                this.maxY = 0.0;
                this.maxYHemisphere = "gov.nasa.worldwdind.avkey.South";
            }
        }
    }

    protected class SquareZone
    extends SquareSector {
        protected String name;
        protected SquareGrid squareGrid;
        protected ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private SquareZone northNeighbor;
        private SquareZone eastNeighbor;

        public SquareZone(int n, String string, Sector sector, double d, double d2, double d3) {
            super(n, string, sector, d, d2, d3);
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setNorthNeighbor(SquareZone squareZone) {
            this.northNeighbor = squareZone;
        }

        public void setEastNeighbor(SquareZone squareZone) {
            this.eastNeighbor = squareZone;
        }

        public void selectRenderables(DrawContext drawContext, Sector sector) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            boolean bl = this.getSizeInPixels(drawContext) > 100.0;
            String string = UTMBaseGraticuleLayer.this.getTypeFor((int)this.size);
            for (AbstractGraticuleLayer.GridElement gridElement : this.gridElements) {
                if (!gridElement.isInView(drawContext, sector) || gridElement.type.equals("GridElement_LineNorth") && this.isNorthNeighborInView(drawContext) || gridElement.type.equals("GridElement_LineEast") && this.isEastNeighborInView(drawContext)) continue;
                if (bl) {
                    UTMBaseGraticuleLayer.this.metricScaleSupport.computeMetricScaleExtremes(this.UTMZone, this.hemisphere, gridElement, this.size * 10.0);
                }
                UTMBaseGraticuleLayer.this.addRenderable(gridElement.renderable, string);
            }
            if (this.getSizeInPixels(drawContext) <= 100.0) {
                return;
            }
            if (this.squareGrid == null) {
                this.squareGrid = new SquareGrid(this.UTMZone, this.hemisphere, this.UTMZoneSector, this.SWEasting, this.SWNorthing, this.size);
            }
            if (this.squareGrid.isInView(drawContext)) {
                this.squareGrid.selectRenderables(drawContext, sector);
            } else {
                this.squareGrid.clearRenderables();
            }
        }

        private boolean isNorthNeighborInView(DrawContext drawContext) {
            return this.northNeighbor != null && this.northNeighbor.isInView(drawContext);
        }

        private boolean isEastNeighborInView(DrawContext drawContext) {
            return this.eastNeighbor != null && this.eastNeighbor.isInView(drawContext);
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.squareGrid != null) {
                this.squareGrid.clearRenderables();
                this.squareGrid = null;
            }
        }

        public void createRenderables() {
            Object object;
            Sector sector;
            Object object2;
            Position position;
            Position position2;
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.clear();
            if (this.isTruncated) {
                UTMBaseGraticuleLayer.this.computeTruncatedSegment(this.sw, this.nw, this.UTMZoneSector, arrayList);
            } else {
                arrayList.add(this.sw);
                arrayList.add(this.nw);
            }
            if (arrayList.size() > 0) {
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object2 = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                object = new AbstractGraticuleLayer.GridElement(sector, object2, "GridElement_LineWest");
                ((AbstractGraticuleLayer.GridElement)object).setValue(this.SWEasting);
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                UTMBaseGraticuleLayer.this.computeTruncatedSegment(this.se, this.ne, this.UTMZoneSector, arrayList);
            } else {
                arrayList.add(this.se);
                arrayList.add(this.ne);
            }
            if (arrayList.size() > 0) {
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object2 = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                object = new AbstractGraticuleLayer.GridElement(sector, object2, "GridElement_LineEast");
                ((AbstractGraticuleLayer.GridElement)object).setValue(this.SWEasting + this.size);
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                UTMBaseGraticuleLayer.this.computeTruncatedSegment(this.sw, this.se, this.UTMZoneSector, arrayList);
            } else {
                arrayList.add(this.sw);
                arrayList.add(this.se);
            }
            if (arrayList.size() > 0) {
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object2 = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                object = new AbstractGraticuleLayer.GridElement(sector, object2, "GridElement_LineSouth");
                ((AbstractGraticuleLayer.GridElement)object).setValue(this.SWNorthing);
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                UTMBaseGraticuleLayer.this.computeTruncatedSegment(this.nw, this.ne, this.UTMZoneSector, arrayList);
            } else {
                arrayList.add(this.nw);
                arrayList.add(this.ne);
            }
            if (arrayList.size() > 0) {
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object2 = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                object = new AbstractGraticuleLayer.GridElement(sector, object2, "GridElement_LineNorth");
                ((AbstractGraticuleLayer.GridElement)object).setValue(this.SWNorthing + this.size);
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            if (this.name != null && this.boundingSector.getDeltaLon().degrees * Math.cos(this.centroid.getLatitude().radians) > 0.2 && this.boundingSector.getDeltaLat().degrees > 0.2) {
                object = null;
                if (this.UTMZone != 0) {
                    object = this.centroid;
                } else if (this.isPositionInside(new Position(this.squareCenter, 0.0))) {
                    object = this.squareCenter;
                } else if (this.squareCenter.getLatitude().degrees <= this.UTMZoneSector.getMaxLatitude().degrees && this.squareCenter.getLatitude().degrees >= this.UTMZoneSector.getMinLatitude().degrees) {
                    object = this.centroid;
                }
                if (object != null) {
                    UserFacingText userFacingText = new UserFacingText(this.name, new Position((LatLon)object, 0.0));
                    userFacingText.setPriority(this.size * 10.0);
                    this.gridElements.add(new AbstractGraticuleLayer.GridElement(this.boundingSector, userFacingText, "GridElement_GridZoneLabel"));
                }
            }
        }
    }

    protected class SquareGrid
    extends SquareSector {
        private ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private ArrayList<SquareGrid> subGrids;

        public SquareGrid(int n, String string, Sector sector, double d, double d2, double d3) {
            super(n, string, sector, d, d2, d3);
        }

        @Override
        public boolean isInView(DrawContext drawContext) {
            if (!drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return !(this.getSizeInPixels(drawContext) <= 200.0);
        }

        public void selectRenderables(DrawContext drawContext, Sector sector) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            int n = (int)this.size / 10;
            boolean bl = this.getSizeInPixels(drawContext) > 340.0;
            String string = UTMBaseGraticuleLayer.this.getTypeFor(n);
            for (AbstractGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext, sector)) continue;
                if (bl) {
                    UTMBaseGraticuleLayer.this.metricScaleSupport.computeMetricScaleExtremes(this.UTMZone, this.hemisphere, object, this.size);
                }
                UTMBaseGraticuleLayer.this.addRenderable(object.renderable, string);
            }
            if (this.getSizeInPixels(drawContext) <= 400.0) {
                return;
            }
            if (this.subGrids == null) {
                this.createSubGrids();
            }
            for (SquareGrid squareGrid : this.subGrids) {
                if (squareGrid.isInView(drawContext)) {
                    squareGrid.selectRenderables(drawContext, sector);
                    continue;
                }
                squareGrid.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.subGrids != null) {
                for (SquareGrid squareGrid : this.subGrids) {
                    squareGrid.clearRenderables();
                }
                this.subGrids.clear();
                this.subGrids = null;
            }
        }

        public void createSubGrids() {
            this.subGrids = new ArrayList();
            double d = this.size / 10.0;
            for (int i = 0; i < 10; ++i) {
                double d2 = this.SWEasting + d * (double)i;
                for (int j = 0; j < 10; ++j) {
                    double d3 = this.SWNorthing + d * (double)j;
                    SquareGrid squareGrid = new SquareGrid(this.UTMZone, this.hemisphere, this.UTMZoneSector, d2, d3, d);
                    if (squareGrid.isOutsideGridZone()) continue;
                    this.subGrids.add(squareGrid);
                }
            }
        }

        public void createRenderables() {
            AbstractGraticuleLayer.GridElement gridElement;
            Sector sector;
            Object object;
            Position position;
            Position position2;
            double d;
            int n;
            this.gridElements = new ArrayList();
            double d2 = this.size / 10.0;
            ArrayList<Position> arrayList = new ArrayList<Position>();
            for (n = 1; n <= 9; ++n) {
                d = this.SWEasting + d2 * (double)n;
                arrayList.clear();
                position2 = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d, this.SWNorthing);
                position = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d, this.SWNorthing + this.size);
                if (this.isTruncated) {
                    UTMBaseGraticuleLayer.this.computeTruncatedSegment(position2, position, this.UTMZoneSector, arrayList);
                } else {
                    arrayList.add(position2);
                    arrayList.add(position);
                }
                if (arrayList.size() <= 0) continue;
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                gridElement = new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineEasting");
                gridElement.setValue(d);
                this.gridElements.add(gridElement);
            }
            for (n = 1; n <= 9; ++n) {
                d = this.SWNorthing + d2 * (double)n;
                arrayList.clear();
                position2 = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, this.SWEasting, d);
                position = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, this.SWEasting + this.size, d);
                if (this.isTruncated) {
                    UTMBaseGraticuleLayer.this.computeTruncatedSegment(position2, position, this.UTMZoneSector, arrayList);
                } else {
                    arrayList.add(position2);
                    arrayList.add(position);
                }
                if (arrayList.size() <= 0) continue;
                position2 = (Position)arrayList.get(0);
                position = (Position)arrayList.get(1);
                object = UTMBaseGraticuleLayer.this.createLineRenderable(new ArrayList(arrayList), "gov.nasa.worldwind.avkey.GreatCircle");
                sector = Sector.boundingSector(position2, position);
                gridElement = new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_LineNorthing");
                gridElement.setValue(d);
                this.gridElements.add(gridElement);
            }
        }
    }

    private class SquareSector {
        public static final int MIN_CELL_SIZE_PIXELS = 50;
        protected int UTMZone;
        protected String hemisphere;
        protected Sector UTMZoneSector;
        protected double SWEasting;
        protected double SWNorthing;
        protected double size;
        protected Position sw;
        protected Position se;
        protected Position nw;
        protected Position ne;
        protected Sector boundingSector;
        protected LatLon centroid;
        protected LatLon squareCenter;
        protected boolean isTruncated = false;

        public SquareSector(int n, String string, Sector sector, double d, double d2, double d3) {
            this.UTMZone = n;
            this.hemisphere = string;
            this.UTMZoneSector = sector;
            this.SWEasting = d;
            this.SWNorthing = d2;
            this.size = d3;
            this.sw = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d, d2);
            this.se = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d + d3, d2);
            this.nw = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d, d2 + d3);
            this.ne = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d + d3, d2 + d3);
            this.squareCenter = UTMBaseGraticuleLayer.this.computePosition(this.UTMZone, this.hemisphere, d + d3 / 2.0, d2 + d3 / 2.0);
            if (this.sw != null && this.se != null && this.nw != null && this.ne != null) {
                this.adjustDateLineCrossingPoints();
                this.boundingSector = Sector.boundingSector(Arrays.asList(this.sw, this.se, this.nw, this.ne));
                if (!this.isInsideGridZone()) {
                    this.boundingSector = this.UTMZoneSector.intersection(this.boundingSector);
                }
                this.centroid = this.boundingSector != null ? this.boundingSector.getCentroid() : this.squareCenter;
            }
            this.isTruncated = !this.isInsideGridZone();
        }

        private void adjustDateLineCrossingPoints() {
            ArrayList<Position> arrayList = new ArrayList<Position>(Arrays.asList(this.sw, this.se, this.nw, this.ne));
            if (!LatLon.locationsCrossDateLine(arrayList)) {
                return;
            }
            double d = 0.0;
            for (LatLon latLon : arrayList) {
                if (Math.abs(latLon.getLongitude().degrees) == 180.0) continue;
                d = Math.signum(latLon.getLongitude().degrees);
            }
            if (d == 0.0) {
                return;
            }
            if (Math.abs(this.sw.getLongitude().degrees) == 180.0 && Math.signum(this.sw.getLongitude().degrees) != d) {
                this.sw = new Position(this.sw.getLatitude(), this.sw.getLongitude().multiply(-1.0), this.sw.getElevation());
            }
            if (Math.abs(this.se.getLongitude().degrees) == 180.0 && Math.signum(this.se.getLongitude().degrees) != d) {
                this.se = new Position(this.se.getLatitude(), this.se.getLongitude().multiply(-1.0), this.se.getElevation());
            }
            if (Math.abs(this.nw.getLongitude().degrees) == 180.0 && Math.signum(this.nw.getLongitude().degrees) != d) {
                this.nw = new Position(this.nw.getLatitude(), this.nw.getLongitude().multiply(-1.0), this.nw.getElevation());
            }
            if (Math.abs(this.ne.getLongitude().degrees) == 180.0 && Math.signum(this.ne.getLongitude().degrees) != d) {
                this.ne = new Position(this.ne.getLatitude(), this.ne.getLongitude().multiply(-1.0), this.ne.getElevation());
            }
        }

        public Extent getExtent(Globe globe, double d) {
            return Sector.computeBoundingCylinder(globe, d, this.boundingSector);
        }

        public boolean isInView(DrawContext drawContext) {
            if (!drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return !(this.getSizeInPixels(drawContext) <= 50.0);
        }

        public boolean isInsideGridZone() {
            if (!this.isPositionInside(this.nw)) {
                return false;
            }
            if (!this.isPositionInside(this.ne)) {
                return false;
            }
            if (!this.isPositionInside(this.sw)) {
                return false;
            }
            return this.isPositionInside(this.se);
        }

        public boolean isOutsideGridZone() {
            if (this.isPositionInside(this.nw)) {
                return false;
            }
            if (this.isPositionInside(this.ne)) {
                return false;
            }
            if (this.isPositionInside(this.sw)) {
                return false;
            }
            return !this.isPositionInside(this.se);
        }

        public boolean isPositionInside(Position position) {
            return position != null && this.UTMZoneSector.contains(position);
        }

        public double getSizeInPixels(DrawContext drawContext) {
            View view = drawContext.getView();
            Vec4 vec4 = UTMBaseGraticuleLayer.this.getSurfacePoint(drawContext, this.centroid.getLatitude(), this.centroid.getLongitude());
            Double d = view.getEyePoint().distanceTo3(vec4);
            return this.size / view.computePixelSizeAtDistance(d);
        }
    }
}

