/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractGraticuleLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class GARSGraticuleLayer
extends AbstractGraticuleLayer {
    public static final String GRATICULE_GARS_LEVEL_0 = "Graticule.GARSLevel0";
    public static final String GRATICULE_GARS_LEVEL_1 = "Graticule.GARSLevel1";
    public static final String GRATICULE_GARS_LEVEL_2 = "Graticule.GARSLevel2";
    public static final String GRATICULE_GARS_LEVEL_3 = "Graticule.GARSLevel3";
    protected static final int MIN_CELL_SIZE_PIXELS = 40;
    protected GraticuleTile[][] gridTiles = new GraticuleTile[18][36];
    protected ArrayList<Double> latitudeLabels = new ArrayList();
    protected ArrayList<Double> longitudeLabels = new ArrayList();
    protected String angleFormat = "gov.nasa.worldwind.Geom.AngleDMS";
    protected double[] thresholds = new double[]{1200000.0, 600000.0, 180000.0};
    protected static ArrayList<String> latLabels;
    protected static ArrayList<String> lonLabels;
    protected static String chars;
    protected static String[][] level2Labels;

    public GARSGraticuleLayer() {
        this.initRenderingParams();
        this.setPickEnabled(false);
        this.setName(Logging.getMessage("layers.LatLonGraticule.Name"));
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.angleFormat.equals(string)) {
            return;
        }
        this.angleFormat = string;
        this.clearTiles();
        this.lastEyePoint = null;
    }

    public void set30MinuteThreshold(double d) {
        this.thresholds[0] = d;
    }

    public double get30MinuteThreshold() {
        return this.thresholds[0];
    }

    public void set15MinuteThreshold(double d) {
        this.thresholds[1] = d;
    }

    public double get15MinuteThreshold() {
        return this.thresholds[1];
    }

    public void set5MinuteThreshold(double d) {
        this.thresholds[2] = d;
    }

    public double get5MinuteThreshold() {
        return this.thresholds[2];
    }

    protected void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-16"));
        this.setRenderingParams(GRATICULE_GARS_LEVEL_0, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        this.setRenderingParams(GRATICULE_GARS_LEVEL_1, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelColor", Color.GREEN);
        this.setRenderingParams(GRATICULE_GARS_LEVEL_2, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.CYAN);
        graticuleRenderingParams.setValue("LabelColor", Color.CYAN);
        this.setRenderingParams(GRATICULE_GARS_LEVEL_3, graticuleRenderingParams);
    }

    protected String[] getOrderedTypes() {
        return new String[]{GRATICULE_GARS_LEVEL_0, GRATICULE_GARS_LEVEL_1, GRATICULE_GARS_LEVEL_2, GRATICULE_GARS_LEVEL_3};
    }

    protected String getTypeFor(double d) {
        if (d >= 10.0) {
            return GRATICULE_GARS_LEVEL_0;
        }
        if (d >= 0.5) {
            return GRATICULE_GARS_LEVEL_1;
        }
        if (d >= 0.25) {
            return GRATICULE_GARS_LEVEL_2;
        }
        if (d >= 0.08333333333333333) {
            return GRATICULE_GARS_LEVEL_3;
        }
        return null;
    }

    @Override
    protected void clear(DrawContext drawContext) {
        super.clear(drawContext);
        this.latitudeLabels.clear();
        this.longitudeLabels.clear();
        this.applyTerrainConformance();
    }

    private void applyTerrainConformance() {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.getRenderingParams(string).setValue("GraticuleLineConformance", this.terrainConformance);
        }
    }

    @Override
    protected void selectRenderables(DrawContext drawContext) {
        ArrayList<GraticuleTile> arrayList = this.getVisibleTiles(drawContext);
        if (arrayList.size() > 0) {
            for (GraticuleTile graticuleTile : arrayList) {
                graticuleTile.selectRenderables(drawContext);
            }
        }
    }

    protected ArrayList<GraticuleTile> getVisibleTiles(DrawContext drawContext) {
        Rectangle2D rectangle2D;
        ArrayList<GraticuleTile> arrayList = new ArrayList<GraticuleTile>();
        Sector sector = drawContext.getVisibleSector();
        if (sector != null && (rectangle2D = this.getGridRectangleForSector(sector)) != null) {
            int n = (int)rectangle2D.getY();
            while ((double)n <= rectangle2D.getY() + rectangle2D.getHeight()) {
                int n2 = (int)rectangle2D.getX();
                while ((double)n2 <= rectangle2D.getX() + rectangle2D.getWidth()) {
                    if (this.gridTiles[n][n2] == null) {
                        this.gridTiles[n][n2] = new GraticuleTile(this.getGridSector(n, n2), 20, 0);
                    }
                    if (this.gridTiles[n][n2].isInView(drawContext)) {
                        arrayList.add(this.gridTiles[n][n2]);
                    } else {
                        this.gridTiles[n][n2].clearRenderables();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private Rectangle2D getGridRectangleForSector(Sector sector) {
        int n = this.getGridColumn(sector.getMinLongitude().degrees);
        int n2 = this.getGridColumn(sector.getMaxLongitude().degrees);
        int n3 = this.getGridRow(sector.getMinLatitude().degrees);
        int n4 = this.getGridRow(sector.getMaxLatitude().degrees);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    private Sector getGridSector(int n, int n2) {
        int n3 = -90 + n * 10;
        int n4 = n3 + 10;
        int n5 = -180 + n2 * 10;
        int n6 = n5 + 10;
        return Sector.fromDegrees(n3, n4, n5, n6);
    }

    private int getGridColumn(Double d) {
        int n = (int)Math.floor((d + 180.0) / 10.0);
        return Math.min(n, 35);
    }

    private int getGridRow(Double d) {
        int n = (int)Math.floor((d + 90.0) / 10.0);
        return Math.min(n, 17);
    }

    protected void clearTiles() {
        for (int i = 0; i < 18; ++i) {
            for (int j = 0; j < 36; ++j) {
                if (this.gridTiles[i][j] == null) continue;
                this.gridTiles[i][j].clearRenderables();
                this.gridTiles[i][j] = null;
            }
        }
    }

    protected String makeAngleLabel(Angle angle, double d) {
        double[] dArray;
        double[] dArray2;
        double d2 = 1.0E-9;
        String string = this.getAngleFormat().equals("gov.nasa.worldwind.Geom.AngleDMS") ? (d >= 1.0 ? angle.toDecimalDegreesString(0) : ((dArray2 = angle.toDMS())[1] < d2 && dArray2[2] < d2 ? String.format("%4d\u00b0", (int)dArray2[0]) : (dArray2[2] < d2 ? String.format("%4d\u00b0 %2d\u2019", (int)dArray2[0], (int)dArray2[1]) : angle.toDMSString()))) : (this.getAngleFormat().equals("gov.nasa.worldwind.Geom.AngleDM") ? (d >= 1.0 ? angle.toDecimalDegreesString(0) : ((dArray = angle.toDMS())[1] < d2 && dArray[2] < d2 ? String.format("%4d\u00b0", (int)dArray[0]) : (dArray[2] < d2 ? String.format("%4d\u00b0 %2d\u2019", (int)dArray[0], (int)dArray[1]) : angle.toDMString()))) : (d >= 1.0 ? angle.toDecimalDegreesString(0) : (d >= 0.1 ? angle.toDecimalDegreesString(1) : (d >= 0.01 ? angle.toDecimalDegreesString(2) : (d >= 0.001 ? angle.toDecimalDegreesString(3) : angle.toDecimalDegreesString(4))))));
        return string;
    }

    protected void addLevel0Label(double d, String string, String string2, double d2, LatLon latLon) {
        if (string.equals("GridElement_LatitudeLabel")) {
            if (!string2.equals(GRATICULE_GARS_LEVEL_0) || !this.latitudeLabels.contains(d)) {
                this.latitudeLabels.add(d);
                String string3 = this.makeAngleLabel(Angle.fromDegrees(d), d2);
                UserFacingText userFacingText = new UserFacingText(string3, Position.fromDegrees(d, latLon.getLongitude().degrees, 0.0));
                userFacingText.setPriority(d2 * 1000000.0);
                this.addRenderable(userFacingText, string2);
            }
        } else if (!(!string.equals("GridElement_LongitudeLabel") || string2.equals(GRATICULE_GARS_LEVEL_0) && this.longitudeLabels.contains(d))) {
            this.longitudeLabels.add(d);
            String string4 = this.makeAngleLabel(Angle.fromDegrees(d), d2);
            UserFacingText userFacingText = new UserFacingText(string4, Position.fromDegrees(latLon.getLatitude().degrees, d, 0.0));
            userFacingText.setPriority(d2 * 1000000.0);
            this.addRenderable(userFacingText, string2);
        }
    }

    protected String makeLabel(Sector sector, String string) {
        if (string.equals(GRATICULE_GARS_LEVEL_1)) {
            int n = (int)((90.0 + sector.getCentroid().getLatitude().degrees) * 60.0 / 30.0);
            int n2 = (int)((180.0 + sector.getCentroid().getLongitude().degrees) * 60.0 / 30.0);
            return lonLabels.get(n2) + latLabels.get(n);
        }
        if (string.equals(GRATICULE_GARS_LEVEL_2)) {
            int n = (int)((90.0 + sector.getMinLatitude().degrees) * 60.0);
            int n3 = n % 30 / 15;
            int n4 = (int)((180.0 + sector.getMinLongitude().degrees) * 60.0);
            int n5 = n4 % 30 / 15;
            return level2Labels[n3][n5];
        }
        return "";
    }

    static {
        int n;
        latLabels = new ArrayList(360);
        lonLabels = new ArrayList(720);
        chars = "ABCDEFGHJKLMNPQRSTUVWXYZ";
        level2Labels = new String[][]{{"3", "4"}, {"1", "2"}};
        for (n = 1; n <= 720; ++n) {
            lonLabels.add(String.format("%03d", n));
        }
        for (n = 0; n < 360; ++n) {
            int n2 = chars.length();
            int n3 = n / n2;
            int n4 = n % n2;
            latLabels.add(String.format("%c%c", Character.valueOf(chars.charAt(n3)), Character.valueOf(chars.charAt(n4))));
        }
    }

    protected class GraticuleTile {
        private Sector sector;
        private int divisions;
        private int level;
        private ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private ArrayList<GraticuleTile> subTiles;

        public GraticuleTile(Sector sector, int n, int n2) {
            this.sector = sector;
            this.divisions = n;
            this.level = n2;
        }

        public Extent getExtent(Globe globe, double d) {
            return Sector.computeBoundingCylinder(globe, d, this.sector);
        }

        public boolean isInView(DrawContext drawContext) {
            if (!drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return this.level == 0 || !(drawContext.getView().getEyePosition().getAltitude() > GARSGraticuleLayer.this.thresholds[this.level - 1]);
        }

        public double getSizeInPixels(DrawContext drawContext) {
            View view = drawContext.getView();
            Vec4 vec4 = GARSGraticuleLayer.this.getSurfacePoint(drawContext, this.sector.getCentroid().getLatitude(), this.sector.getCentroid().getLongitude());
            double d = view.getEyePoint().distanceTo3(vec4);
            double d2 = this.sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius();
            return d2 / view.computePixelSizeAtDistance(d);
        }

        public void selectRenderables(DrawContext drawContext) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            String string = GARSGraticuleLayer.this.getTypeFor(this.sector.getDeltaLatDegrees());
            if (this.level == 0 && drawContext.getView().getEyePosition().getAltitude() > GARSGraticuleLayer.this.thresholds[0]) {
                LatLon latLon = GARSGraticuleLayer.this.computeLabelOffset(drawContext);
                for (AbstractGraticuleLayer.GridElement gridElement : this.gridElements) {
                    if (!gridElement.isInView(drawContext) || !gridElement.type.equals("GridElement_LineSouth") && !gridElement.type.equals("GridElement_LineNorth") && !gridElement.type.equals("GridElement_LineWest")) continue;
                    GARSGraticuleLayer.this.addRenderable(gridElement.renderable, string);
                    String object = gridElement.type.equals("GridElement_LineSouth") || gridElement.type.equals("GridElement_LineNorth") ? "GridElement_LatitudeLabel" : "GridElement_LongitudeLabel";
                    GARSGraticuleLayer.this.addLevel0Label(gridElement.value, object, string, this.sector.getDeltaLatDegrees(), latLon);
                }
                if (drawContext.getView().getEyePosition().getAltitude() > GARSGraticuleLayer.this.thresholds[0]) {
                    return;
                }
            }
            double d = drawContext.getView().getEyePosition().getAltitude();
            if (this.level == 0 && d <= GARSGraticuleLayer.this.thresholds[0] || this.level == 1 && d <= GARSGraticuleLayer.this.thresholds[1] || this.level == 2) {
                double d2 = this.sector.getDeltaLatDegrees() / (double)this.divisions;
                string = GARSGraticuleLayer.this.getTypeFor(d2);
                for (AbstractGraticuleLayer.GridElement gridElement : this.gridElements) {
                    if (!gridElement.isInView(drawContext)) continue;
                    GARSGraticuleLayer.this.addRenderable(gridElement.renderable, string);
                }
            }
            if (this.level == 0 && d > GARSGraticuleLayer.this.thresholds[1]) {
                return;
            }
            if (this.level == 1 && d > GARSGraticuleLayer.this.thresholds[2]) {
                return;
            }
            if (this.level == 2) {
                return;
            }
            if (this.subTiles == null) {
                this.createSubTiles();
            }
            for (GraticuleTile graticuleTile : this.subTiles) {
                if (graticuleTile.isInView(drawContext)) {
                    graticuleTile.selectRenderables(drawContext);
                    continue;
                }
                graticuleTile.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.subTiles != null) {
                for (GraticuleTile graticuleTile : this.subTiles) {
                    graticuleTile.clearRenderables();
                }
                this.subTiles.clear();
                this.subTiles = null;
            }
        }

        private void createSubTiles() {
            this.subTiles = new ArrayList();
            Sector[] sectorArray = this.sector.subdivide(this.divisions);
            int n = this.level + 1;
            int n2 = 10;
            if (n == 1) {
                n2 = 2;
            } else if (n == 2) {
                n2 = 3;
            }
            for (Sector sector : sectorArray) {
                this.subTiles.add(new GraticuleTile(sector, n2, n));
            }
        }

        private void createRenderables() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            this.gridElements = new ArrayList();
            double d = this.sector.getDeltaLatDegrees() / (double)this.divisions;
            for (double d2 = this.sector.getMinLongitude().degrees + (this.level == 0 ? 0.0 : d); d2 < this.sector.getMaxLongitude().degrees - d / 2.0; d2 += d) {
                Angle angle = Angle.fromDegrees(d2);
                ArrayList<Position> arrayList = new ArrayList<Position>(2);
                arrayList.add(new Position(this.sector.getMinLatitude(), angle, 0.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), angle, 0.0));
                object5 = GARSGraticuleLayer.this.createLineRenderable(arrayList, "gov.nasa.worldwind.avkey.Linear");
                object4 = Sector.fromDegrees(this.sector.getMinLatitude().degrees, this.sector.getMaxLatitude().degrees, d2, d2);
                object3 = d2 == this.sector.getMinLongitude().degrees ? "GridElement_LineWest" : "GridElement_Line";
                object2 = new AbstractGraticuleLayer.GridElement((Sector)object4, object5, (String)object3);
                object2.value = d2;
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object2);
            }
            for (double d3 = this.sector.getMinLatitude().degrees + (this.level == 0 ? 0.0 : d); d3 < this.sector.getMaxLatitude().degrees - d / 2.0; d3 += d) {
                object5 = Angle.fromDegrees(d3);
                object4 = new ArrayList<Position>(2);
                ((ArrayList)object4).add(new Position((Angle)object5, this.sector.getMinLongitude(), 0.0));
                ((ArrayList)object4).add(new Position((Angle)object5, this.sector.getMaxLongitude(), 0.0));
                object3 = GARSGraticuleLayer.this.createLineRenderable((Iterable<? extends Position>)object4, "gov.nasa.worldwind.avkey.Linear");
                object2 = Sector.fromDegrees(d3, d3, this.sector.getMinLongitude().degrees, this.sector.getMaxLongitude().degrees);
                String string = d3 == this.sector.getMinLatitude().degrees ? "GridElement_LineSouth" : "GridElement_Line";
                object = new AbstractGraticuleLayer.GridElement((Sector)object2, object3, string);
                ((AbstractGraticuleLayer.GridElement)object).value = d3;
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            if (this.sector.getMaxLatitude().equals(Angle.POS90)) {
                object5 = new ArrayList(2);
                ((ArrayList)object5).add(new Position(Angle.POS90, this.sector.getMinLongitude(), 0.0));
                ((ArrayList)object5).add(new Position(Angle.POS90, this.sector.getMaxLongitude(), 0.0));
                object4 = GARSGraticuleLayer.this.createLineRenderable((Iterable<? extends Position>)object5, "gov.nasa.worldwind.avkey.Linear");
                object3 = Sector.fromDegrees(90.0, 90.0, this.sector.getMinLongitude().degrees, this.sector.getMaxLongitude().degrees);
                object2 = new AbstractGraticuleLayer.GridElement((Sector)object3, object4, "GridElement_LineNorth");
                object2.value = 90.0;
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object2);
            }
            double d4 = this.sector.getDeltaLatDegrees() / (double)this.divisions;
            if (this.level == 0) {
                object3 = this.sector.subdivide(20);
                for (int i = 0; i < 20; ++i) {
                    for (int j = 0; j < 20; ++j) {
                        object = object3[i * 20 + j];
                        String string = GARSGraticuleLayer.this.makeLabel((Sector)object, GARSGraticuleLayer.GRATICULE_GARS_LEVEL_1);
                        this.addLabel(string, object3[i * 20 + j], d4);
                    }
                }
            } else if (this.level == 1) {
                object3 = GARSGraticuleLayer.this.makeLabel(this.sector, GARSGraticuleLayer.GRATICULE_GARS_LEVEL_1);
                object2 = this.sector.subdivide();
                this.addLabel((String)object3 + "3", object2[0], d4);
                this.addLabel((String)object3 + "4", object2[1], d4);
                this.addLabel((String)object3 + "1", object2[2], d4);
                this.addLabel((String)object3 + "2", object2[3], d4);
            } else if (this.level == 2) {
                object3 = GARSGraticuleLayer.this.makeLabel(this.sector, GARSGraticuleLayer.GRATICULE_GARS_LEVEL_1);
                object3 = (String)object3 + GARSGraticuleLayer.this.makeLabel(this.sector, GARSGraticuleLayer.GRATICULE_GARS_LEVEL_2);
                d4 = 0.26;
                object2 = this.sector.subdivide(3);
                this.addLabel((String)object3 + "7", object2[0], d4);
                this.addLabel((String)object3 + "8", object2[1], d4);
                this.addLabel((String)object3 + "9", object2[2], d4);
                this.addLabel((String)object3 + "4", object2[3], d4);
                this.addLabel((String)object3 + "5", object2[4], d4);
                this.addLabel((String)object3 + "6", object2[5], d4);
                this.addLabel((String)object3 + "1", object2[6], d4);
                this.addLabel((String)object3 + "2", object2[7], d4);
                this.addLabel((String)object3 + "3", object2[8], d4);
            }
        }

        protected void addLabel(String string, Sector sector, double d) {
            UserFacingText userFacingText = new UserFacingText(string, new Position(sector.getCentroid(), 0.0));
            userFacingText.setPriority(d * 1000000.0);
            AbstractGraticuleLayer.GridElement gridElement = new AbstractGraticuleLayer.GridElement(sector, userFacingText, "GridElement_GridZoneLabel");
            this.gridElements.add(gridElement);
        }
    }
}

