/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WWObject;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class LayerList
extends CopyOnWriteArrayList<Layer>
implements WWObject {
    private WWObjectImpl wwo = new WWObjectImpl(this);

    public LayerList() {
    }

    public LayerList(Layer[] layerArray) {
        if (layerArray == null) {
            String string = Logging.getMessage("nullValue.LayersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.addAll((Collection<? extends Layer>)Arrays.asList(layerArray));
    }

    public LayerList(LayerList layerList) {
        super(layerList);
    }

    public String getDisplayName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public void setDisplayName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    protected LayerList makeShallowCopy(LayerList layerList) {
        return new LayerList(layerList);
    }

    public static List<Layer> getListDifference(LayerList layerList, LayerList layerList2) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : layerList2) {
            if (layerList.contains(layer)) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    public static LayerList collapseLists(LayerList[] layerListArray) {
        if (layerListArray == null || layerListArray.length == 0) {
            String string = Logging.getMessage("nullValue.LayersListArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerList layerList = layerListArray[0];
        for (int i = 1; i < layerListArray.length; ++i) {
            LayerList layerList2 = layerListArray[i];
            for (Layer layer : layerList2) {
                layerList.add(layer);
            }
            for (Layer layer : layerList2) {
                layerList2.remove(layer);
            }
        }
        return layerList;
    }

    public static List<Layer> getLayersAdded(LayerList layerList, LayerList layerList2) {
        return LayerList.getListDifference(layerList, layerList2);
    }

    public static List<Layer> getLayersRemoved(LayerList layerList, LayerList layerList2) {
        return LayerList.getListDifference(layerList2, layerList);
    }

    @Override
    public boolean add(Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerList layerList = this.makeShallowCopy(this);
        super.add(layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        return true;
    }

    @Override
    public void add(int n, Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerList layerList = this.makeShallowCopy(this);
        super.add(n, layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
    }

    public void remove(Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.contains(layer)) {
            return;
        }
        LayerList layerList = this.makeShallowCopy(this);
        layer.removePropertyChangeListener(this);
        super.remove(layer);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
    }

    @Override
    public Layer remove(int n) {
        Layer layer = (Layer)this.get(n);
        if (layer == null) {
            return null;
        }
        LayerList layerList = this.makeShallowCopy(this);
        layer.removePropertyChangeListener(this);
        super.remove(n);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        return layer;
    }

    public boolean moveLower(Layer layer) {
        int n = this.indexOf(layer);
        if (n <= 0) {
            return false;
        }
        this.remove(n);
        this.add(n - 1, layer);
        return true;
    }

    public boolean moveHigher(Layer layer) {
        int n = this.indexOf(layer);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        this.add(n + 1, layer);
        return true;
    }

    @Override
    public Layer set(int n, Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Layer layer2 = (Layer)this.get(n);
        if (layer2 != null) {
            layer2.removePropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        super.set(n, layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        return layer2;
    }

    @Override
    public boolean remove(Object object) {
        for (Layer layer : this) {
            if (!layer.equals(object)) continue;
            layer.removePropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.remove(object);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public boolean addIfAbsent(Layer layer) {
        for (Layer layer2 : this) {
            if (!layer2.equals(layer)) continue;
            return false;
        }
        layer.addPropertyChangeListener(this);
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.addIfAbsent(layer);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Layer layer : this) {
            layer.removePropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.removeAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        for (Layer layer : this) {
            layer.addPropertyChangeListener(this);
        }
        return bl;
    }

    public boolean removeAll() {
        for (Layer layer : this) {
            layer.removePropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.retainAll(new ArrayList());
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public int addAllAbsent(Collection<? extends Layer> collection) {
        for (Layer layer : collection) {
            if (this.contains(layer)) continue;
            layer.addPropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        int n = super.addAllAbsent(collection);
        if (n > 0) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return n;
    }

    @Override
    public boolean addAll(Collection<? extends Layer> collection) {
        for (Layer layer : collection) {
            layer.addPropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.addAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends Layer> collection) {
        for (Layer layer : collection) {
            layer.addPropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.addAll(n, collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (Layer layer : this) {
            if (collection.contains(layer)) continue;
            layer.removePropertyChangeListener(this);
        }
        LayerList layerList = this.makeShallowCopy(this);
        boolean bl = super.retainAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList, this);
        }
        return bl;
    }

    @Override
    public void replaceAll(Collection<? extends Layer> collection) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        ArrayList<Layer> arrayList2 = new ArrayList<Layer>();
        for (Layer layer : collection) {
            if (!this.contains(layer)) {
                arrayList.add(layer);
                continue;
            }
            arrayList2.add(layer);
        }
        for (Layer layer : arrayList) {
            this.remove(layer);
        }
        super.clear();
        for (Layer layer : collection) {
            if (!arrayList2.contains(layer)) {
                layer.addPropertyChangeListener(this);
            }
            super.add(layer);
        }
    }

    public Layer getLayerByName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (Layer layer : this) {
            if (!layer.getName().equals(string)) continue;
            return layer;
        }
        return null;
    }

    public List<Layer> getLayersByClass(Class clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this) {
            if (!layer.getClass().equals(clazz)) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    @Override
    public Object getValue(String string) {
        return this.wwo.getValue(string);
    }

    @Override
    public Collection<Object> getValues() {
        return this.wwo.getValues();
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.wwo.getEntries();
    }

    @Override
    public String getStringValue(String string) {
        return this.wwo.getStringValue(string);
    }

    @Override
    public Object setValue(String string, Object object) {
        return this.wwo.setValue(string, object);
    }

    @Override
    public AVList setValues(AVList aVList) {
        return this.wwo.setValues(aVList);
    }

    @Override
    public boolean hasKey(String string) {
        return this.wwo.hasKey(string);
    }

    @Override
    public Object removeKey(String string) {
        return this.wwo.removeKey(string);
    }

    @Override
    public AVList copy() {
        return this.wwo.copy();
    }

    @Override
    public AVList clearList() {
        return this.wwo.clearList();
    }

    public LayerList sort() {
        if (this.size() <= 0) {
            return this;
        }
        Layer[] layerArray = new Layer[this.size()];
        this.toArray(layerArray);
        Arrays.sort(layerArray, new Comparator<Layer>(){

            @Override
            public int compare(Layer layer, Layer layer2) {
                return layer.getName().compareTo(layer2.getName());
            }
        });
        this.clear();
        super.addAll(Arrays.asList(layerArray));
        return this;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.wwo.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.wwo.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.wwo.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.wwo.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.wwo.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.wwo.firePropertyChange(string, object, object2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.wwo.propertyChange(propertyChangeEvent);
    }

    @Override
    public void onMessage(Message message) {
        this.wwo.onMessage(message);
    }

    @Override
    public String toString() {
        Object object = "";
        for (Layer layer : this) {
            object = (String)object + layer.toString() + ", ";
        }
        return object;
    }
}

