/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class RenderableLayer
extends AbstractLayer {
    protected Collection<Renderable> renderables = new ConcurrentLinkedQueue<Renderable>();
    protected Iterable<Renderable> renderablesOverride;
    protected PickSupport pickSupport = new PickSupport();

    public void addRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.RenderableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.renderables.add(renderable);
        if (renderable instanceof AVList) {
            ((AVList)((Object)renderable)).addPropertyChangeListener(this);
        }
    }

    public void addRenderable(int n, Renderable renderable) {
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.RenderableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.renderables.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Renderable> arrayList = new ArrayList<Renderable>(this.renderables);
        arrayList.add(n, renderable);
        this.renderables.clear();
        this.renderables.addAll(arrayList);
        if (renderable instanceof AVList) {
            ((AVList)((Object)renderable)).addPropertyChangeListener(this);
        }
    }

    public void addRenderables(Iterable<? extends Renderable> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (Renderable renderable : iterable) {
            if (renderable != null) {
                this.renderables.add(renderable);
            }
            if (!(renderable instanceof AVList)) continue;
            ((AVList)((Object)renderable)).addPropertyChangeListener(this);
        }
    }

    public void removeRenderable(Renderable renderable) {
        if (renderable == null) {
            String string = Logging.getMessage("nullValue.RenderableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.renderables.remove(renderable);
        if (renderable instanceof AVList) {
            ((AVList)((Object)renderable)).removePropertyChangeListener(this);
        }
    }

    public void removeAllRenderables() {
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearRenderables();
    }

    protected void clearRenderables() {
        if (this.renderables != null && this.renderables.size() > 0) {
            for (Renderable renderable : this.renderables) {
                if (!(renderable instanceof AVList)) continue;
                ((AVList)((Object)renderable)).removePropertyChangeListener(this);
            }
            this.renderables.clear();
        }
    }

    public int getNumRenderables() {
        if (this.renderablesOverride != null) {
            int n = 0;
            for (Renderable renderable : this.renderablesOverride) {
                ++n;
            }
            return n;
        }
        return this.renderables.size();
    }

    public Iterable<Renderable> getRenderables() {
        return this.getActiveRenderables();
    }

    protected Iterable<Renderable> getActiveRenderables() {
        if (this.renderablesOverride != null) {
            return this.renderablesOverride;
        }
        return Collections.unmodifiableCollection(this.renderables);
    }

    public void setRenderables(Iterable<Renderable> iterable) {
        this.renderablesOverride = iterable;
        this.disposeRenderables();
        this.clearRenderables();
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    @Override
    public void dispose() {
        if (this.renderablesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.disposeRenderables();
    }

    protected void disposeRenderables() {
        if (this.renderables != null && this.renderables.size() > 0) {
            for (Renderable renderable : this.renderables) {
                try {
                    if (renderable instanceof AVList) {
                        ((AVList)((Object)renderable)).removePropertyChangeListener(this);
                    }
                    if (!(renderable instanceof Disposable)) continue;
                    ((Disposable)((Object)renderable)).dispose();
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("generic.ExceptionAttemptingToDisposeRenderable");
                    Logging.logger().severe(string);
                }
            }
        }
        this.renderables.clear();
    }

    @Override
    protected void doPreRender(DrawContext drawContext) {
        this.doPreRender(drawContext, this.getActiveRenderables());
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.doPick(drawContext, this.getActiveRenderables(), point);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.doRender(drawContext, this.getActiveRenderables());
    }

    protected void doPreRender(DrawContext drawContext, Iterable<? extends Renderable> iterable) {
        for (Renderable renderable : iterable) {
            try {
                if (renderable == null || !(renderable instanceof PreRenderable)) continue;
                ((PreRenderable)((Object)renderable)).preRender(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhilePrerenderingRenderable");
                Logging.logger().severe(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPick(DrawContext drawContext, Iterable<? extends Renderable> iterable, Point point) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        try {
            for (Renderable renderable : iterable) {
                if (renderable == null) continue;
                Color color = drawContext.getUniquePickColor();
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                try {
                    renderable.render(drawContext);
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("generic.ExceptionWhilePickingRenderable");
                    Logging.logger().severe(string);
                    Logging.logger().log(Level.FINER, string, exception);
                    continue;
                }
                if (renderable instanceof Locatable) {
                    this.pickSupport.addPickableObject(color.getRGB(), renderable, ((Locatable)((Object)renderable)).getPosition(), false);
                    continue;
                }
                this.pickSupport.addPickableObject(color.getRGB(), renderable);
            }
            this.pickSupport.resolvePick(drawContext, point, this);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
        }
    }

    protected void doRender(DrawContext drawContext, Iterable<? extends Renderable> iterable) {
        for (Renderable renderable : iterable) {
            try {
                if (renderable == null) continue;
                renderable.render(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileRenderingRenderable");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.RenderableLayer.Name");
    }

    @Override
    public void onMessage(Message message) {
        for (Renderable renderable : this.renderables) {
            try {
                if (!(renderable instanceof MessageListener)) continue;
                ((MessageListener)((Object)renderable)).onMessage(message);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionInvokingMessageListener");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }
}

