/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class ViewControlsLayer
extends RenderableLayer {
    protected static final String IMAGE_PAN = "images/view-pan-64x64.png";
    protected static final String IMAGE_LOOK = "images/view-look-64x64.png";
    protected static final String IMAGE_HEADING_LEFT = "images/view-heading-left-32x32.png";
    protected static final String IMAGE_HEADING_RIGHT = "images/view-heading-right-32x32.png";
    protected static final String IMAGE_ZOOM_IN = "images/view-zoom-in-32x32.png";
    protected static final String IMAGE_ZOOM_OUT = "images/view-zoom-out-32x32.png";
    protected static final String IMAGE_PITCH_UP = "images/view-pitch-up-32x32.png";
    protected static final String IMAGE_PITCH_DOWN = "images/view-pitch-down-32x32.png";
    protected static final String IMAGE_FOV_NARROW = "images/view-fov-narrow-32x32.png";
    protected static final String IMAGE_FOV_WIDE = "images/view-fov-wide-32x32.png";
    protected static final String IMAGE_VE_UP = "images/view-elevation-up-32x32.png";
    protected static final String IMAGE_VE_DOWN = "images/view-elevation-down-32x32.png";
    protected ScreenAnnotation controlPan;
    protected ScreenAnnotation controlLook;
    protected ScreenAnnotation controlHeadingLeft;
    protected ScreenAnnotation controlHeadingRight;
    protected ScreenAnnotation controlZoomIn;
    protected ScreenAnnotation controlZoomOut;
    protected ScreenAnnotation controlPitchUp;
    protected ScreenAnnotation controlPitchDown;
    protected ScreenAnnotation controlFovNarrow;
    protected ScreenAnnotation controlFovWide;
    protected ScreenAnnotation controlVeUp;
    protected ScreenAnnotation controlVeDown;
    protected ScreenAnnotation currentControl;
    protected String position = "gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest";
    protected String layout = "gov.nasa.worldwind.avkey.Horizontal";
    protected Vec4 locationCenter = null;
    protected Vec4 locationOffset = null;
    protected double scale = 1.0;
    protected int borderWidth = 20;
    protected int buttonSize = 32;
    protected int panSize = 64;
    protected boolean initialized = false;
    protected Rectangle referenceViewport;
    protected boolean showPanControls = true;
    protected boolean showLookControls = false;
    protected boolean showZoomControls = true;
    protected boolean showHeadingControls = true;
    protected boolean showPitchControls = true;
    protected boolean showFovControls = false;
    protected boolean showVeControls = true;

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
        this.clearControls();
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
        this.clearControls();
    }

    protected int getButtonSize() {
        return this.buttonSize;
    }

    protected void setButtonSize(int n) {
        this.buttonSize = n;
        this.clearControls();
    }

    protected int getPanSize() {
        return this.panSize;
    }

    protected void setPanSize(int n) {
        this.panSize = n;
        this.clearControls();
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
        this.clearControls();
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!this.layout.equals(string)) {
            this.layout = string;
            this.clearControls();
        }
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
        this.clearControls();
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
        this.clearControls();
    }

    public boolean isShowPanControls() {
        return this.showPanControls;
    }

    public void setShowPanControls(boolean bl) {
        if (this.showPanControls != bl) {
            this.showPanControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowLookControls() {
        return this.showLookControls;
    }

    public void setShowLookControls(boolean bl) {
        if (this.showLookControls != bl) {
            this.showLookControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowHeadingControls() {
        return this.showHeadingControls;
    }

    public void setShowHeadingControls(boolean bl) {
        if (this.showHeadingControls != bl) {
            this.showHeadingControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowZoomControls() {
        return this.showZoomControls;
    }

    public void setShowZoomControls(boolean bl) {
        if (this.showZoomControls != bl) {
            this.showZoomControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowPitchControls() {
        return this.showPitchControls;
    }

    public void setShowPitchControls(boolean bl) {
        if (this.showPitchControls != bl) {
            this.showPitchControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowFovControls() {
        return this.showFovControls;
    }

    public void setShowFovControls(boolean bl) {
        if (this.showFovControls != bl) {
            this.showFovControls = bl;
            this.clearControls();
        }
    }

    public void setShowVeControls(boolean bl) {
        if (this.showVeControls != bl) {
            this.showVeControls = bl;
            this.clearControls();
        }
    }

    public boolean isShowVeControls() {
        return this.showVeControls;
    }

    public String getControlType(Object object) {
        if (object == null || !(object instanceof ScreenAnnotation)) {
            return null;
        }
        if (this.showPanControls && this.controlPan.equals(object)) {
            return "gov.nasa.worldwind.avkey.Pan";
        }
        if (this.showLookControls && this.controlLook.equals(object)) {
            return "gov.nasa.worldwind.avkey.ControlLook";
        }
        if (this.showHeadingControls && this.controlHeadingLeft.equals(object)) {
            return "gov.nasa.worldwind.avkey.HeadingLeft";
        }
        if (this.showHeadingControls && this.controlHeadingRight.equals(object)) {
            return "gov.nasa.worldwind.avkey.HeadingRight";
        }
        if (this.showZoomControls && this.controlZoomIn.equals(object)) {
            return "gov.nasa.worldwind.avkey.ZoomIn";
        }
        if (this.showZoomControls && this.controlZoomOut.equals(object)) {
            return "gov.nasa.worldwind.avkey.ZoomOut";
        }
        if (this.showPitchControls && this.controlPitchUp.equals(object)) {
            return "gov.nasa.worldwind.avkey.PitchUp";
        }
        if (this.showPitchControls && this.controlPitchDown.equals(object)) {
            return "gov.nasa.worldwind.avkey.PitchDown";
        }
        if (this.showFovControls && this.controlFovNarrow.equals(object)) {
            return "gov.nasa.worldwind.avkey.FovNarrow";
        }
        if (this.showFovControls && this.controlFovWide.equals(object)) {
            return "gov.nasa.worldwind.avkey.FovWide";
        }
        if (this.showVeControls && this.controlVeUp.equals(object)) {
            return "gov.nasa.worldwind.avkey.VerticalExaggerationUp";
        }
        if (this.showVeControls && this.controlVeDown.equals(object)) {
            return "gov.nasa.worldwind.avkey.VerticalExaggerationDown";
        }
        return null;
    }

    public Object getHighlightedObject() {
        return this.currentControl;
    }

    public void highlight(Object object) {
        if (this.currentControl == object) {
            return;
        }
        if (this.currentControl != null) {
            this.currentControl.getAttributes().setImageOpacity(-1.0);
            this.currentControl = null;
        }
        if (object != null && object instanceof ScreenAnnotation) {
            this.currentControl = (ScreenAnnotation)object;
            this.currentControl.getAttributes().setImageOpacity(1.0);
        }
    }

    @Override
    public void doRender(DrawContext drawContext) {
        if (!this.initialized) {
            this.initialize(drawContext);
        }
        if (!this.referenceViewport.equals(drawContext.getView().getViewport())) {
            this.updatePositions(drawContext);
        }
        super.doRender(drawContext);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void initialize(DrawContext drawContext) {
        if (this.initialized) {
            return;
        }
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        annotationAttributes.setBorderWidth(0.0);
        annotationAttributes.setCornerRadius(0);
        annotationAttributes.setSize(new Dimension(this.buttonSize, this.buttonSize));
        annotationAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
        annotationAttributes.setImageOpacity(0.5);
        annotationAttributes.setScale(this.scale);
        Point point = new Point(0, 0);
        if (this.showPanControls) {
            this.controlPan = new ScreenAnnotation("", point, annotationAttributes);
            this.controlPan.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.Pan");
            this.controlPan.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.Pan"));
            this.controlPan.getAttributes().setSize(new Dimension(this.panSize, this.panSize));
            this.addRenderable(this.controlPan);
        }
        if (this.showLookControls) {
            this.controlLook = new ScreenAnnotation("", point, annotationAttributes);
            this.controlLook.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.ControlLook");
            this.controlLook.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.ControlLook"));
            this.controlLook.getAttributes().setSize(new Dimension(this.panSize, this.panSize));
            this.addRenderable(this.controlLook);
        }
        if (this.showZoomControls) {
            this.controlZoomIn = new ScreenAnnotation("", point, annotationAttributes);
            this.controlZoomIn.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.ZoomIn");
            this.controlZoomIn.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.ZoomIn"));
            this.addRenderable(this.controlZoomIn);
            this.controlZoomOut = new ScreenAnnotation("", point, annotationAttributes);
            this.controlZoomOut.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.ZoomOut");
            this.controlZoomOut.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.ZoomOut"));
            this.addRenderable(this.controlZoomOut);
        }
        if (this.showHeadingControls) {
            this.controlHeadingLeft = new ScreenAnnotation("", point, annotationAttributes);
            this.controlHeadingLeft.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.HeadingLeft");
            this.controlHeadingLeft.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.HeadingLeft"));
            this.addRenderable(this.controlHeadingLeft);
            this.controlHeadingRight = new ScreenAnnotation("", point, annotationAttributes);
            this.controlHeadingRight.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.HeadingRight");
            this.controlHeadingRight.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.HeadingRight"));
            this.addRenderable(this.controlHeadingRight);
        }
        if (this.showPitchControls) {
            this.controlPitchUp = new ScreenAnnotation("", point, annotationAttributes);
            this.controlPitchUp.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.PitchUp");
            this.controlPitchUp.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.PitchUp"));
            this.addRenderable(this.controlPitchUp);
            this.controlPitchDown = new ScreenAnnotation("", point, annotationAttributes);
            this.controlPitchDown.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.PitchDown");
            this.controlPitchDown.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.PitchDown"));
            this.addRenderable(this.controlPitchDown);
        }
        if (this.showFovControls) {
            this.controlFovNarrow = new ScreenAnnotation("", point, annotationAttributes);
            this.controlFovNarrow.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.FovNarrow");
            this.controlFovNarrow.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.FovNarrow"));
            this.addRenderable(this.controlFovNarrow);
            this.controlFovWide = new ScreenAnnotation("", point, annotationAttributes);
            this.controlFovWide.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.FovWide");
            this.controlFovWide.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.FovWide"));
            this.addRenderable(this.controlFovWide);
        }
        if (this.showVeControls) {
            this.controlVeUp = new ScreenAnnotation("", point, annotationAttributes);
            this.controlVeUp.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.VerticalExaggerationUp");
            this.controlVeUp.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.VerticalExaggerationUp"));
            this.addRenderable(this.controlVeUp);
            this.controlVeDown = new ScreenAnnotation("", point, annotationAttributes);
            this.controlVeDown.setValue("gov.nasa.worldwind.avkey.ViewOperation", "gov.nasa.worldwind.avkey.VerticalExaggerationDown");
            this.controlVeDown.getAttributes().setImageSource(this.getImageSource("gov.nasa.worldwind.avkey.VerticalExaggerationDown"));
            this.addRenderable(this.controlVeDown);
        }
        this.updatePositions(drawContext);
        this.initialized = true;
    }

    protected Object getImageSource(String string) {
        if (string.equals("gov.nasa.worldwind.avkey.Pan")) {
            return IMAGE_PAN;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ControlLook")) {
            return IMAGE_LOOK;
        }
        if (string.equals("gov.nasa.worldwind.avkey.HeadingLeft")) {
            return IMAGE_HEADING_LEFT;
        }
        if (string.equals("gov.nasa.worldwind.avkey.HeadingRight")) {
            return IMAGE_HEADING_RIGHT;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ZoomIn")) {
            return IMAGE_ZOOM_IN;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ZoomOut")) {
            return IMAGE_ZOOM_OUT;
        }
        if (string.equals("gov.nasa.worldwind.avkey.PitchUp")) {
            return IMAGE_PITCH_UP;
        }
        if (string.equals("gov.nasa.worldwind.avkey.PitchDown")) {
            return IMAGE_PITCH_DOWN;
        }
        if (string.equals("gov.nasa.worldwind.avkey.FovWide")) {
            return IMAGE_FOV_WIDE;
        }
        if (string.equals("gov.nasa.worldwind.avkey.FovNarrow")) {
            return IMAGE_FOV_NARROW;
        }
        if (string.equals("gov.nasa.worldwind.avkey.VerticalExaggerationUp")) {
            return IMAGE_VE_UP;
        }
        if (string.equals("gov.nasa.worldwind.avkey.VerticalExaggerationDown")) {
            return IMAGE_VE_DOWN;
        }
        return null;
    }

    protected void updatePositions(DrawContext drawContext) {
        int n;
        int n2;
        boolean bl = this.layout.equals("gov.nasa.worldwind.avkey.Horizontal");
        int n3 = (this.showPanControls ? this.panSize : 0) + (this.showLookControls ? this.panSize : 0) + (this.showZoomControls ? this.buttonSize : 0) + (this.showHeadingControls ? this.buttonSize : 0) + (this.showPitchControls ? this.buttonSize : 0) + (this.showFovControls ? this.buttonSize : 0) + (this.showVeControls ? this.buttonSize : 0);
        int n4 = Math.max(this.panSize, this.buttonSize * 2);
        n3 = (int)((double)n3 * this.scale);
        n4 = (int)((double)n4 * this.scale);
        int n5 = 0;
        int n6 = (int)((double)this.buttonSize * this.scale);
        if (!bl) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
            n5 = (int)((double)this.buttonSize * this.scale);
            n6 = 0;
        }
        n2 = (int)((double)this.panSize * this.scale / 2.0);
        int n7 = (int)((double)this.buttonSize * this.scale / 2.0);
        Rectangle rectangle = new Rectangle(n3, n4);
        Point point = this.computeLocation(drawContext.getView().getViewport(), rectangle);
        int n8 = point.x;
        int n9 = n = bl ? point.y : point.y + n4;
        if (this.showPanControls) {
            if (!bl) {
                n -= (int)((double)this.panSize * this.scale);
            }
            this.controlPan.setScreenPoint(new Point(n8 + n2, n));
            if (bl) {
                n8 += (int)((double)this.panSize * this.scale);
            }
        }
        if (this.showLookControls) {
            if (!bl) {
                n -= (int)((double)this.panSize * this.scale);
            }
            this.controlLook.setScreenPoint(new Point(n8 + n2, n));
            if (bl) {
                n8 += (int)((double)this.panSize * this.scale);
            }
        }
        if (this.showZoomControls) {
            if (!bl) {
                n -= (int)((double)this.buttonSize * this.scale);
            }
            this.controlZoomIn.setScreenPoint(new Point(n8 + n7 + n5, n + n6));
            this.controlZoomOut.setScreenPoint(new Point(n8 + n7, n));
            if (bl) {
                n8 += (int)((double)this.buttonSize * this.scale);
            }
        }
        if (this.showHeadingControls) {
            if (!bl) {
                n -= (int)((double)this.buttonSize * this.scale);
            }
            this.controlHeadingLeft.setScreenPoint(new Point(n8 + n7 + n5, n + n6));
            this.controlHeadingRight.setScreenPoint(new Point(n8 + n7, n));
            if (bl) {
                n8 += (int)((double)this.buttonSize * this.scale);
            }
        }
        if (this.showPitchControls) {
            if (!bl) {
                n -= (int)((double)this.buttonSize * this.scale);
            }
            this.controlPitchUp.setScreenPoint(new Point(n8 + n7 + n5, n + n6));
            this.controlPitchDown.setScreenPoint(new Point(n8 + n7, n));
            if (bl) {
                n8 += (int)((double)this.buttonSize * this.scale);
            }
        }
        if (this.showFovControls) {
            if (!bl) {
                n -= (int)((double)this.buttonSize * this.scale);
            }
            this.controlFovNarrow.setScreenPoint(new Point(n8 + n7 + n5, n + n6));
            this.controlFovWide.setScreenPoint(new Point(n8 + n7, n));
            if (bl) {
                n8 += (int)((double)this.buttonSize * this.scale);
            }
        }
        if (this.showVeControls) {
            if (!bl) {
                n -= (int)((double)this.buttonSize * this.scale);
            }
            this.controlVeUp.setScreenPoint(new Point(n8 + n7 + n5, n + n6));
            this.controlVeDown.setScreenPoint(new Point(n8 + n7, n));
            if (bl) {
                n8 += (int)((double)this.buttonSize * this.scale);
            }
        }
        this.referenceViewport = drawContext.getView().getViewport();
    }

    protected Point computeLocation(Rectangle rectangle, Rectangle rectangle2) {
        double d;
        double d2;
        if (this.locationCenter != null) {
            d2 = this.locationCenter.x - (double)(rectangle2.width / 2);
            d = this.locationCenter.y - (double)(rectangle2.height / 2);
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            d2 = rectangle.getWidth() - (double)rectangle2.width - (double)this.borderWidth;
            d = rectangle.getHeight() - (double)rectangle2.height - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            d2 = rectangle.getWidth() - (double)rectangle2.width - (double)this.borderWidth;
            d = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            d2 = 0.0 + (double)this.borderWidth;
            d = rectangle.getHeight() - (double)rectangle2.height - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            d2 = 0.0 + (double)this.borderWidth;
            d = 0.0 + (double)this.borderWidth;
        } else {
            d2 = rectangle.getWidth() - (double)rectangle2.width - (double)this.borderWidth;
            d = rectangle.getHeight() - (double)rectangle2.height - (double)this.borderWidth;
        }
        if (this.locationOffset != null) {
            d2 += this.locationOffset.x;
            d += this.locationOffset.y;
        }
        return new Point((int)d2, (int)d);
    }

    protected void clearControls() {
        this.removeAllRenderables();
        this.controlPan = null;
        this.controlLook = null;
        this.controlHeadingLeft = null;
        this.controlHeadingRight = null;
        this.controlZoomIn = null;
        this.controlZoomOut = null;
        this.controlPitchUp = null;
        this.controlPitchDown = null;
        this.controlFovNarrow = null;
        this.controlFovWide = null;
        this.controlVeUp = null;
        this.controlVeDown = null;
        this.initialized = false;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.ViewControlsLayer.Name");
    }
}

