/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WorldMapLayer
extends AbstractLayer {
    protected String iconFilePath;
    protected double toViewportScale = 0.2;
    protected double iconScale = 0.5;
    protected int borderWidth = 20;
    protected String position = "gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest";
    protected String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    protected int iconWidth;
    protected int iconHeight;
    protected Vec4 locationCenter = null;
    protected Vec4 locationOffset = null;
    protected Color color = Color.white;
    protected Color backColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    protected boolean showFootprint = true;
    protected ArrayList<? extends LatLon> footPrintPositions;
    protected PickSupport pickSupport = new PickSupport();
    protected long frameStampForPicking;
    protected long frameStampForDrawing;
    protected OrderedIcon orderedImage = new OrderedIcon();

    public WorldMapLayer() {
        this.setOpacity(0.6);
        this.setIconFilePath(Configuration.getStringValue("gov.nasa.worldwind.avkey.WorldMapImagePath"));
    }

    public WorldMapLayer(String string) {
        this.setOpacity(0.6);
        this.setIconFilePath(string);
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.iconFilePath = string;
    }

    public double getToViewportScale() {
        return this.toViewportScale;
    }

    public void setToViewportScale(double d) {
        this.toViewportScale = d;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(double d) {
        this.iconScale = d;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
    }

    public Color getBackgrounColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.backColor = color;
    }

    public boolean getShowFootprint() {
        return this.showFootprint;
    }

    public void setShowFootprint(boolean bl) {
        this.showFootprint = bl;
    }

    public List<? extends LatLon> getFootPrintPositions() {
        return this.footPrintPositions;
    }

    @Override
    public void doRender(DrawContext drawContext) {
        if (drawContext.isContinuous2DGlobe() && this.frameStampForDrawing == drawContext.getFrameTimeStamp()) {
            return;
        }
        drawContext.addOrderedRenderable(this.orderedImage);
        this.frameStampForDrawing = drawContext.getFrameTimeStamp();
    }

    @Override
    public void doPick(DrawContext drawContext, Point point) {
        if (drawContext.isContinuous2DGlobe() && this.frameStampForPicking == drawContext.getFrameTimeStamp()) {
            return;
        }
        drawContext.addOrderedRenderable(this.orderedImage);
        this.frameStampForPicking = drawContext.getFrameTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawIcon(DrawContext drawContext) {
        if (this.getIconFilePath() == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            Texture texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
            if (texture == null) {
                this.initializeTexture(drawContext);
                texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
                if (texture == null) {
                    String string = Logging.getMessage("generic.ImageReadFailed");
                    Logging.logger().finer(string);
                    return;
                }
            }
            gL2.glDisable(2929);
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            double d = this.getScaledIconWidth();
            double d2 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            oGLStackHandler.pushProjectionIdentity(gL2);
            double d3 = d > d2 ? d : d2;
            gL2.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            oGLStackHandler.pushModelviewIdentity(gL2);
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL2.glTranslated(vec4.x(), vec4.y(), vec4.z());
            gL2.glScaled(d4, d4, 1.0);
            gL2.glScaled(d, d2, 1.0);
            if (!drawContext.isPickingMode()) {
                gL2.glEnable(3042);
                gL2.glBlendFunc(770, 771);
                gL2.glColor4ub((byte)this.backColor.getRed(), (byte)this.backColor.getGreen(), (byte)this.backColor.getBlue(), (byte)((double)this.backColor.getAlpha() * this.getOpacity()));
                drawContext.drawUnitQuad();
                gL2.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                gL2.glEnable(3553);
                texture.bind(gL2);
                TextureCoords textureCoords = texture.getImageTexCoords();
                drawContext.drawUnitQuad(textureCoords);
                gL2.glBindTexture(3553, 0);
                gL2.glDisable(3553);
                gL2.glLoadIdentity();
                gL2.glTranslated(vec4.x(), vec4.y(), vec4.z());
                gL2.glScaled(d4, d4, 1.0);
                float[] fArray = this.color.getRGBColorComponents(null);
                gL2.glColor4d(fArray[0], fArray[1], fArray[2], this.getOpacity());
                Position position = this.computeGroundPosition(drawContext, drawContext.getView());
                if (position != null) {
                    int n = (int)(d * (position.getLongitude().degrees + 180.0) / 360.0);
                    int n2 = (int)(d2 * (position.getLatitude().degrees + 90.0) / 180.0);
                    int n3 = 10;
                    gL2.glBegin(3);
                    gL2.glVertex3d(n - n3, n2, 0.0);
                    gL2.glVertex3d(n + n3 + 1, n2, 0.0);
                    gL2.glEnd();
                    gL2.glBegin(3);
                    gL2.glVertex3d(n, n2 - n3, 0.0);
                    gL2.glVertex3d(n, n2 + n3 + 1, 0.0);
                    gL2.glEnd();
                }
                if (!drawContext.is2DGlobe() && this.showFootprint) {
                    this.footPrintPositions = this.computeViewFootPrint(drawContext, 32);
                    if (this.footPrintPositions != null) {
                        gL2.glBegin(3);
                        LatLon latLon = this.footPrintPositions.get(0);
                        for (LatLon latLon2 : this.footPrintPositions) {
                            int n = (int)(d * (latLon2.getLongitude().degrees + 180.0) / 360.0);
                            int n4 = (int)(d2 * (latLon2.getLatitude().degrees + 90.0) / 180.0);
                            if (LatLon.locationsCrossDateline(latLon, latLon2)) {
                                int n5 = (int)(d2 * (latLon.getLatitude().degrees + 90.0) / 180.0);
                                gL2.glVertex3d((double)n < d / 2.0 ? d : 0.0, (n5 + n4) / 2, 0.0);
                                gL2.glEnd();
                                gL2.glBegin(3);
                                gL2.glVertex3d((double)n < d / 2.0 ? 0.0 : d, (n5 + n4) / 2, 0.0);
                            }
                            gL2.glVertex3d(n, n4, 0.0);
                            latLon = latLon2;
                        }
                        gL2.glEnd();
                    }
                }
                gL2.glBegin(3);
                gL2.glVertex3d(0.0, 0.0, 0.0);
                gL2.glVertex3d(d, 0.0, 0.0);
                gL2.glVertex3d(d, d2 - 1.0, 0.0);
                gL2.glVertex3d(0.0, d2 - 1.0, 0.0);
                gL2.glVertex3d(0.0, 0.0, 0.0);
                gL2.glEnd();
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Position position = this.computePickPosition(drawContext, vec4, new Dimension((int)(d * d4), (int)(d2 * d4)));
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                this.pickSupport.addPickableObject(n, this, position, false);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                drawContext.drawUnitQuad();
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this);
            }
        }
        finally {
            drawContext.restoreDefaultDepthTesting();
            drawContext.restoreDefaultCurrentColor();
            if (drawContext.isPickingMode()) {
                drawContext.restoreDefaultBlending();
            }
            oGLStackHandler.pop(gL2);
        }
    }

    protected double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly")) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeStretch")) {
            return this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize")) {
            return 1.0;
        }
        return 1.0;
    }

    protected double getScaledIconWidth() {
        return (double)this.iconWidth * this.iconScale;
    }

    protected double getScaledIconHeight() {
        return (double)this.iconHeight * this.iconScale;
    }

    protected Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.locationCenter != null) {
            d3 = this.locationCenter.x - d6 / 2.0;
            d2 = this.locationCenter.y - d7 / 2.0;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderWidth;
        }
        if (this.locationOffset != null) {
            d3 += this.locationOffset.x;
            d2 += this.locationOffset.y;
        }
        return new Vec4(d3, d2, 0.0);
    }

    protected void initializeTexture(DrawContext drawContext) {
        Object object;
        Texture texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
        if (texture != null) {
            return;
        }
        GL gL = drawContext.getGL();
        try {
            Object object2;
            object = this.getClass().getResourceAsStream("/" + this.getIconFilePath());
            if (object == null && ((File)(object2 = new File(this.iconFilePath))).exists()) {
                object = new FileInputStream((File)object2);
            }
            object2 = OGLUtil.newTextureData(gL.getGLProfile(), (InputStream)object, false);
            texture = TextureIO.newTexture((TextureData)object2);
            texture.bind(gL);
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            drawContext.getTextureCache().put(this.getIconFilePath(), texture);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        object = new int[1];
        gL.glGetIntegerv(34047, (int[])object, 0);
        gL.glTexParameteri(3553, 34046, (int)object[0]);
    }

    protected Position computeGroundPosition(DrawContext drawContext, View view) {
        if (view == null) {
            return null;
        }
        Position position = view.computePositionFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
        if (position == null) {
            return null;
        }
        double d = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        return new Position(position.getLatitude(), position.getLongitude(), d * drawContext.getVerticalExaggeration());
    }

    protected Position computePickPosition(DrawContext drawContext, Vec4 vec4, Dimension dimension) {
        Position position = null;
        Point point = drawContext.getPickPoint();
        if (point != null) {
            Rectangle rectangle = drawContext.getView().getViewport();
            if (point.getX() >= vec4.getX() && point.getX() < vec4.getX() + (double)dimension.width && (double)rectangle.height - point.getY() >= vec4.getY() && (double)rectangle.height - point.getY() < vec4.getY() + (double)dimension.height) {
                double d = (point.getX() - vec4.getX()) / (double)dimension.width * 360.0 - 180.0;
                double d2 = ((double)rectangle.height - point.getY() - vec4.getY()) / (double)dimension.height * 180.0 - 90.0;
                double d3 = 1000000.0;
                position = new Position(Angle.fromDegrees(d2), Angle.fromDegrees(d), d3);
            }
        }
        return position;
    }

    protected ArrayList<LatLon> computeViewFootPrint(DrawContext drawContext, int n) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Position position = drawContext.getView().getEyePosition();
        Angle angle = Angle.fromRadians(Math.asin(drawContext.getView().getFarClipDistance() / (drawContext.getGlobe().getRadius() + position.getElevation())));
        if (angle.degrees > 10.0) {
            double d = 360.0 / (double)n;
            Angle angle2 = Angle.ZERO;
            for (int i = 0; i <= n; ++i) {
                LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle2, angle);
                arrayList.add(latLon);
                angle2 = angle2.addDegrees(d);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.WorldMapLayer.Name");
    }

    protected class OrderedIcon
    implements OrderedRenderable {
        protected OrderedIcon() {
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            WorldMapLayer.this.drawIcon(drawContext);
        }

        @Override
        public void render(DrawContext drawContext) {
            WorldMapLayer.this.drawIcon(drawContext);
        }
    }
}

