/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.mercator;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.mercator.MercatorSector;
import gov.nasa.worldwind.layers.mercator.MercatorTextureTile;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public abstract class MercatorTiledImageLayer
extends AbstractLayer {
    private static final LevelComparer levelComparer = new LevelComparer();
    private final LevelSet levels;
    private ArrayList<MercatorTextureTile> topLevels;
    private boolean forceLevelZeroLoads = false;
    private boolean levelZeroLoaded = false;
    private boolean retainLevelZeroTiles = false;
    private String tileCountName;
    private double splitScale = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.MapTileSplitScale");
    private boolean useMipMaps = false;
    private ArrayList<String> supportedImageFormats = new ArrayList();
    private boolean showImageTileOutlines = false;
    private boolean drawTileBoundaries = false;
    private boolean useTransparentTextures = false;
    private boolean drawTileIDs = false;
    private boolean drawBoundingVolumes = false;
    private ArrayList<MercatorTextureTile> currentTiles = new ArrayList();
    private MercatorTextureTile currentResourceTile;
    private Vec4 referencePoint;
    private boolean atMaxResolution = false;
    private PriorityBlockingQueue<Runnable> requestQ = new PriorityBlockingQueue(200);

    protected abstract void requestTexture(DrawContext var1, MercatorTextureTile var2);

    protected abstract void forceTextureLoad(MercatorTextureTile var1);

    public MercatorTiledImageLayer(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levels = new LevelSet(levelSet);
        this.createTopLevelTiles();
        this.setPickEnabled(false);
        this.tileCountName = this.getName() + " Tiles";
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.tileCountName = this.getName() + " Tiles";
    }

    public boolean isUseTransparentTextures() {
        return this.useTransparentTextures;
    }

    public void setUseTransparentTextures(boolean bl) {
        this.useTransparentTextures = bl;
    }

    public boolean isForceLevelZeroLoads() {
        return this.forceLevelZeroLoads;
    }

    public void setForceLevelZeroLoads(boolean bl) {
        this.forceLevelZeroLoads = bl;
    }

    public boolean isRetainLevelZeroTiles() {
        return this.retainLevelZeroTiles;
    }

    public void setRetainLevelZeroTiles(boolean bl) {
        this.retainLevelZeroTiles = bl;
    }

    public boolean isDrawTileIDs() {
        return this.drawTileIDs;
    }

    public void setDrawTileIDs(boolean bl) {
        this.drawTileIDs = bl;
    }

    public boolean isDrawTileBoundaries() {
        return this.drawTileBoundaries;
    }

    public void setDrawTileBoundaries(boolean bl) {
        this.drawTileBoundaries = bl;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public boolean isDrawBoundingVolumes() {
        return this.drawBoundingVolumes;
    }

    public void setDrawBoundingVolumes(boolean bl) {
        this.drawBoundingVolumes = bl;
    }

    protected LevelSet getLevels() {
        return this.levels;
    }

    protected PriorityBlockingQueue<Runnable> getRequestQ() {
        return this.requestQ;
    }

    @Override
    public boolean isMultiResolution() {
        return this.getLevels() != null && this.getLevels().getNumLevels() > 1;
    }

    @Override
    public boolean isAtMaxResolution() {
        return this.atMaxResolution;
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    public void setUseMipMaps(boolean bl) {
        this.useMipMaps = bl;
    }

    private void createTopLevelTiles() {
        MercatorSector mercatorSector = (MercatorSector)this.levels.getSector();
        gov.nasa.worldwind.util.Level level = this.levels.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.levels.getTileOrigin().getLatitude();
        Angle angle4 = this.levels.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, mercatorSector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, mercatorSector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, mercatorSector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, mercatorSector.getMaxLongitude(), angle4);
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        this.topLevels = new ArrayList(n5 * n6);
        double d = angle.degrees / 90.0;
        double d2 = -1.0 + d * (double)n;
        for (int i = n; i <= n3; ++i) {
            double d3 = d2 + d;
            Angle angle5 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Angle angle6 = angle5.add(angle2);
                this.topLevels.add(new MercatorTextureTile(new MercatorSector(d2, d3, angle5, angle6), level, i, j));
                angle5 = angle6;
            }
            d2 = d3;
        }
    }

    private void loadAllTopLevelTextures(DrawContext drawContext) {
        for (MercatorTextureTile mercatorTextureTile : this.topLevels) {
            if (mercatorTextureTile.isTextureInMemory(drawContext.getTextureCache())) continue;
            this.forceTextureLoad(mercatorTextureTile);
        }
        this.levelZeroLoaded = true;
    }

    private void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        for (MercatorTextureTile mercatorTextureTile : this.topLevels) {
            if (!this.isTileVisible(drawContext, mercatorTextureTile)) continue;
            this.currentResourceTile = null;
            this.addTileOrDescendants(drawContext, mercatorTextureTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTileOrDescendants(DrawContext drawContext, MercatorTextureTile mercatorTextureTile) {
        if (this.meetsRenderCriteria(drawContext, mercatorTextureTile)) {
            this.addTile(drawContext, mercatorTextureTile);
            return;
        }
        MercatorTextureTile mercatorTextureTile2 = null;
        try {
            MercatorTextureTile[] mercatorTextureTileArray;
            if (mercatorTextureTile.isTextureInMemory(drawContext.getTextureCache()) || mercatorTextureTile.getLevelNumber() == 0) {
                mercatorTextureTile2 = this.currentResourceTile;
                this.currentResourceTile = mercatorTextureTile;
            } else if (!mercatorTextureTile.getLevel().isEmpty() && mercatorTextureTile.getLevelNumber() < this.levels.getNumLevels() && !this.levels.isResourceAbsent(mercatorTextureTile)) {
                this.requestTexture(drawContext, mercatorTextureTile);
            }
            for (MercatorTextureTile mercatorTextureTile3 : mercatorTextureTileArray = mercatorTextureTile.createSubTiles(this.levels.getLevel(mercatorTextureTile.getLevelNumber() + 1))) {
                if (!this.isTileVisible(drawContext, mercatorTextureTile3)) continue;
                this.addTileOrDescendants(drawContext, mercatorTextureTile3);
            }
        }
        finally {
            if (mercatorTextureTile2 != null) {
                this.currentResourceTile = mercatorTextureTile2;
            }
        }
    }

    private void addTile(DrawContext drawContext, MercatorTextureTile mercatorTextureTile) {
        mercatorTextureTile.setFallbackTile(null);
        if (mercatorTextureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.addTileToCurrent(mercatorTextureTile);
            return;
        }
        if (mercatorTextureTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !mercatorTextureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.forceTextureLoad(mercatorTextureTile);
            if (mercatorTextureTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.addTileToCurrent(mercatorTextureTile);
                return;
            }
        }
        if (mercatorTextureTile.getLevelNumber() < this.levels.getNumLevels() && !this.levels.isResourceAbsent(mercatorTextureTile)) {
            this.requestTexture(drawContext, mercatorTextureTile);
        }
        if (this.currentResourceTile != null) {
            if (this.currentResourceTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache()) && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.forceTextureLoad(this.currentResourceTile);
            }
            if (this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                mercatorTextureTile.setFallbackTile(this.currentResourceTile);
                this.addTileToCurrent(mercatorTextureTile);
            }
        }
    }

    private void addTileToCurrent(MercatorTextureTile mercatorTextureTile) {
        this.currentTiles.add(mercatorTextureTile);
    }

    private boolean isTileVisible(DrawContext drawContext, MercatorTextureTile mercatorTextureTile) {
        return mercatorTextureTile.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates()) && (drawContext.getVisibleSector() == null || drawContext.getVisibleSector().intersects(mercatorTextureTile.getSector()));
    }

    private boolean meetsRenderCriteria(DrawContext drawContext, MercatorTextureTile mercatorTextureTile) {
        return this.levels.isFinalLevel(mercatorTextureTile.getLevelNumber()) || !this.needToSplit(drawContext, mercatorTextureTile.getSector());
    }

    private boolean needToSplit(DrawContext drawContext, Sector sector) {
        double d;
        Vec4[] vec4Array = sector.computeCornerPoints(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        Vec4 vec4 = sector.computeCenterPoint(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        View view = drawContext.getView();
        double d2 = view.getEyePoint().distanceTo3(vec4Array[0]);
        double d3 = view.getEyePoint().distanceTo3(vec4Array[1]);
        double d4 = view.getEyePoint().distanceTo3(vec4Array[2]);
        double d5 = view.getEyePoint().distanceTo3(vec4Array[3]);
        double d6 = view.getEyePoint().distanceTo3(vec4);
        double d7 = d2;
        if (d3 < d7) {
            d7 = d3;
        }
        if (d4 < d7) {
            d7 = d4;
        }
        if (d5 < d7) {
            d7 = d5;
        }
        if (d6 < d7) {
            d7 = d6;
        }
        return !(Math.log10(d = Math.PI * sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius() / 20.0) <= Math.log10(d7) - this.splitScale);
    }

    private boolean atMaxLevel(DrawContext drawContext) {
        Position position = drawContext.getViewportCenterPosition();
        if (drawContext.getView() == null || this.getLevels() == null || position == null) {
            return false;
        }
        if (!this.getLevels().getSector().contains(position.getLatitude(), position.getLongitude())) {
            return true;
        }
        gov.nasa.worldwind.util.Level level = this.getLevels().getNextToLastLevel();
        if (level == null) {
            return true;
        }
        Sector sector = level.computeSectorForPosition(position.getLatitude(), position.getLongitude(), this.getLevels().getTileOrigin());
        return this.needToSplit(drawContext, sector);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.atMaxResolution = this.atMaxLevel(drawContext);
        super.render(drawContext);
    }

    @Override
    protected final void doRender(DrawContext drawContext) {
        if (this.forceLevelZeroLoads && !this.levelZeroLoaded) {
            this.loadAllTopLevelTextures(drawContext);
        }
        if (drawContext.getSurfaceGeometry() == null || drawContext.getSurfaceGeometry().size() < 1) {
            return;
        }
        drawContext.getGeographicSurfaceTileRenderer().setShowImageTileOutlines(this.showImageTileOutlines);
        this.draw(drawContext);
    }

    private void draw(DrawContext drawContext) {
        this.referencePoint = this.computeReferencePoint(drawContext);
        this.assembleTiles(drawContext);
        if (this.currentTiles.size() >= 1) {
            MercatorTextureTile[] mercatorTextureTileArray = new MercatorTextureTile[this.currentTiles.size()];
            mercatorTextureTileArray = this.currentTiles.toArray(mercatorTextureTileArray);
            Arrays.sort(mercatorTextureTileArray, levelComparer);
            GL2 gL2 = drawContext.getGL().getGL2();
            if (this.isUseTransparentTextures() || this.getOpacity() < 1.0) {
                gL2.glPushAttrib(16393);
                gL2.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                gL2.glEnable(3042);
                gL2.glBlendFunc(770, 771);
            } else {
                gL2.glPushAttrib(16392);
            }
            gL2.glPolygonMode(1028, 6914);
            gL2.glEnable(2884);
            gL2.glCullFace(1029);
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.ImageTileCount", this.tileCountName, this.currentTiles.size());
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.currentTiles);
            gL2.glPopAttrib();
            if (this.drawTileIDs) {
                this.drawTileIDs(drawContext, this.currentTiles);
            }
            if (this.drawBoundingVolumes) {
                this.drawBoundingVolumes(drawContext, this.currentTiles);
            }
            this.currentTiles.clear();
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    private void sendRequests() {
        Runnable runnable = this.requestQ.poll();
        while (runnable != null) {
            if (!WorldWind.getTaskService().isFull()) {
                WorldWind.getTaskService().addTask(runnable);
            }
            runnable = this.requestQ.poll();
        }
    }

    @Override
    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return drawContext.getVisibleSector() == null || this.levels.getSector().intersects(drawContext.getVisibleSector());
    }

    private Vec4 computeReferencePoint(DrawContext drawContext) {
        if (drawContext.getViewportCenterPosition() != null) {
            return drawContext.getGlobe().computePointFromPosition(drawContext.getViewportCenterPosition());
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.5 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    protected Vec4 getReferencePoint() {
        return this.referencePoint;
    }

    private void drawTileIDs(DrawContext drawContext, ArrayList<MercatorTextureTile> arrayList) {
        Rectangle rectangle = drawContext.getView().getViewport();
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), Font.decode("Arial-Plain-13"));
        drawContext.getGL().glDisable(2929);
        drawContext.getGL().glDisable(3042);
        drawContext.getGL().glDisable(3553);
        textRenderer.setColor(Color.YELLOW);
        textRenderer.beginRendering(rectangle.width, rectangle.height);
        for (MercatorTextureTile mercatorTextureTile : arrayList) {
            Object object = mercatorTextureTile.getLabel();
            if (mercatorTextureTile.getFallbackTile() != null) {
                object = (String)object + "/" + mercatorTextureTile.getFallbackTile().getLabel();
            }
            LatLon latLon = mercatorTextureTile.getSector().getCentroid();
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
            vec4 = drawContext.getView().project(vec4);
            textRenderer.draw((String)object, (int)vec4.x, (int)vec4.y);
        }
        textRenderer.endRendering();
    }

    private void drawBoundingVolumes(DrawContext drawContext, ArrayList<MercatorTextureTile> arrayList) {
        GL2 gL2 = drawContext.getGL().getGL2();
        float[] fArray = new float[4];
        gL2.glGetFloatv(2816, fArray, 0);
        gL2.glColor3d(0.0, 1.0, 0.0);
        for (MercatorTextureTile mercatorTextureTile : arrayList) {
            ((Cylinder)mercatorTextureTile.getExtent(drawContext)).render(drawContext);
        }
        Cylinder cylinder = Sector.computeBoundingCylinder(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.levels.getSector());
        gL2.glColor3d(1.0, 1.0, 0.0);
        cylinder.render(drawContext);
        gL2.glColor4fv(fArray, 0);
    }

    public List<String> getAvailableImageFormats() {
        return new ArrayList<String>(this.supportedImageFormats);
    }

    public boolean isImageFormatAvailable(String string) {
        return string != null && this.supportedImageFormats.contains(string);
    }

    public String getDefaultImageFormat() {
        return this.supportedImageFormats.size() > 0 ? this.supportedImageFormats.get(0) : null;
    }

    protected void setAvailableImageFormats(String[] stringArray) {
        this.supportedImageFormats.clear();
        if (stringArray != null) {
            this.supportedImageFormats.addAll(Arrays.asList(stringArray));
        }
    }

    private BufferedImage requestImage(MercatorTextureTile mercatorTextureTile, String string) throws URISyntaxException {
        String string2 = mercatorTextureTile.getPath().substring(0, mercatorTextureTile.getPath().lastIndexOf("."));
        String string3 = WWIO.makeSuffixForMimeType(string);
        String string4 = string2 + string3;
        URL uRL = this.getDataFileStore().findFile(string4, false);
        if (uRL == null) {
            return null;
        }
        if (WWIO.isFileOutOfDate(uRL, mercatorTextureTile.getLevel().getExpiryTime())) {
            this.getDataFileStore().removeFile(uRL);
            String string5 = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string5);
        } else {
            try {
                File file = new File(uRL.toURI());
                BufferedImage bufferedImage = ImageIO.read(file);
                if (bufferedImage == null) {
                    String string6 = Logging.getMessage("generic.ImageReadFailed", file);
                    throw new RuntimeException(string6);
                }
                this.levels.unmarkResourceAbsent(mercatorTextureTile);
                return bufferedImage;
            }
            catch (IOException iOException) {
                this.getDataFileStore().removeFile(uRL);
                this.levels.markResourceAbsent(mercatorTextureTile);
                String string7 = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string7);
            }
        }
        return null;
    }

    private void downloadImage(MercatorTextureTile mercatorTextureTile, String string) throws Exception {
        URL uRL = mercatorTextureTile.getResourceURL(string);
        String string2 = uRL.getProtocol();
        if (!"http".equalsIgnoreCase(string2)) {
            String string3 = Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL);
            throw new RuntimeException(string3);
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new HttpRetrievalPostProcessor(mercatorTextureTile));
        hTTPRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        hTTPRetriever.setConnectTimeout(10000);
        hTTPRetriever.setReadTimeout(20000);
        hTTPRetriever.call();
    }

    public int computeLevelForResolution(Sector sector, Globe globe, double d) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        double d2 = 0.0;
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        for (int i = 0; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            if (this.levels.isLevelEmpty(i) || (d2 = this.levels.getLevel(i).getTexelSize()) > d) continue;
            level = this.levels.getLevel(i);
            break;
        }
        Logging.logger().info(Logging.getMessage("layers.TiledImageLayer.LevelSelection", level.getLevelNumber(), d2));
        return level.getLevelNumber();
    }

    public BufferedImage composeImageForSector(Sector sector, int n, int n2, int n3, String string, boolean bl, BufferedImage bufferedImage) {
        if (sector == null) {
            String string2 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (n3 < 0) {
            n3 = this.levels.getLastLevel().getLevelNumber();
        } else if (n3 > this.levels.getLastLevel().getLevelNumber()) {
            Logging.logger().warning(Logging.getMessage("generic.LevelRequestedGreaterThanMaxLevel", n3, this.levels.getLastLevel().getLevelNumber()));
            n3 = this.levels.getLastLevel().getLevelNumber();
        }
        MercatorTextureTile[][] mercatorTextureTileArray = this.getTilesInSector(sector, n3);
        if (mercatorTextureTileArray.length == 0 || mercatorTextureTileArray[0].length == 0) {
            Logging.logger().severe(Logging.getMessage("layers.TiledImageLayer.NoImagesAvailable"));
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        MercatorTextureTile[][] mercatorTextureTileArray2 = mercatorTextureTileArray;
        int n4 = mercatorTextureTileArray2.length;
        for (int i = 0; i < n4; ++i) {
            MercatorTextureTile[] mercatorTextureTileArray3;
            for (MercatorTextureTile mercatorTextureTile : mercatorTextureTileArray3 = mercatorTextureTileArray2[i]) {
                if (mercatorTextureTile == null) continue;
                try {
                    BufferedImage bufferedImage2 = this.getImage(mercatorTextureTile, string);
                    double d = (double)n2 / (double)bufferedImage2.getHeight() * mercatorTextureTile.getSector().getDeltaLat().divide(sector.getDeltaLat());
                    double d2 = (double)n / (double)bufferedImage2.getWidth() * mercatorTextureTile.getSector().getDeltaLon().divide(sector.getDeltaLon());
                    double d3 = (double)n2 * (-mercatorTextureTile.getSector().getMaxLatitude().subtract((Angle)sector.getMaxLatitude()).degrees / sector.getDeltaLat().degrees);
                    double d4 = (double)n * (mercatorTextureTile.getSector().getMinLongitude().subtract((Angle)sector.getMinLongitude()).degrees / sector.getDeltaLon().degrees);
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(d4, d3);
                    graphics2D.scale(d2, d);
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                    graphics2D.setTransform(affineTransform);
                }
                catch (Exception exception) {
                    if (bl) {
                        throw new RuntimeException(exception);
                    }
                    String string3 = Logging.getMessage("generic.ExceptionWhileRequestingImage", mercatorTextureTile.getPath());
                    Logging.logger().log(Level.WARNING, string3, exception);
                }
            }
        }
        return bufferedImage;
    }

    public int countImagesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        Angle angle = this.levels.getTileOrigin().getLatitude();
        Angle angle2 = this.levels.getTileOrigin().getLongitude();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), angle);
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), angle2);
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), angle);
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), angle2);
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        return n6 * n7;
    }

    private MercatorTextureTile[][] getTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        Angle angle = this.levels.getTileOrigin().getLatitude();
        Angle angle2 = this.levels.getTileOrigin().getLongitude();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), angle);
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), angle2);
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), angle);
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), angle2);
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        MercatorTextureTile[][] mercatorTextureTileArray = new MercatorTextureTile[n6][n7];
        for (int i = n2; i >= n4; --i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector2 = this.levels.computeSectorForKey(tileKey);
                MercatorSector mercatorSector = MercatorSector.fromSector(sector2);
                mercatorTextureTileArray[n2 - i][j - n3] = new MercatorTextureTile(mercatorSector, level, i, j);
            }
        }
        return mercatorTextureTileArray;
    }

    private BufferedImage getImage(MercatorTextureTile mercatorTextureTile, String string) throws Exception {
        BufferedImage bufferedImage = this.requestImage(mercatorTextureTile, string);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        this.downloadImage(mercatorTextureTile, string);
        bufferedImage = this.requestImage(mercatorTextureTile, string);
        if (bufferedImage == null) {
            String string2 = Logging.getMessage("layers.TiledImageLayer.ImageUnavailable", mercatorTextureTile.getPath());
            throw new RuntimeException(string2);
        }
        return bufferedImage;
    }

    private static class LevelComparer
    implements Comparator<MercatorTextureTile> {
        private LevelComparer() {
        }

        @Override
        public int compare(MercatorTextureTile mercatorTextureTile, MercatorTextureTile mercatorTextureTile2) {
            int n;
            int n2 = mercatorTextureTile.getFallbackTile() == null ? mercatorTextureTile.getLevelNumber() : mercatorTextureTile.getFallbackTile().getLevelNumber();
            int n3 = n = mercatorTextureTile2.getFallbackTile() == null ? mercatorTextureTile2.getLevelNumber() : mercatorTextureTile2.getFallbackTile().getLevelNumber();
            return n2 < n ? -1 : (n2 == n ? 0 : 1);
        }
    }

    private class HttpRetrievalPostProcessor
    implements RetrievalPostProcessor {
        private MercatorTextureTile tile;

        public HttpRetrievalPostProcessor(MercatorTextureTile mercatorTextureTile) {
            this.tile = mercatorTextureTile;
        }

        @Override
        public ByteBuffer run(Retriever retriever) {
            if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                return null;
            }
            HTTPRetriever hTTPRetriever = (HTTPRetriever)retriever;
            if (hTTPRetriever.getResponseCode() == 204) {
                MercatorTiledImageLayer.this.levels.markResourceAbsent(this.tile);
                return null;
            }
            if (hTTPRetriever.getResponseCode() != 200) {
                return null;
            }
            URLRetriever uRLRetriever = (URLRetriever)retriever;
            ByteBuffer byteBuffer = uRLRetriever.getBuffer();
            String string = WWIO.makeSuffixForMimeType(hTTPRetriever.getContentType());
            if (string == null) {
                return null;
            }
            Object object = this.tile.getPath().substring(0, this.tile.getPath().lastIndexOf("."));
            object = (String)object + string;
            File file = MercatorTiledImageLayer.this.getDataFileStore().newFile((String)object);
            if (file == null) {
                return null;
            }
            try {
                WWIO.saveBuffer(byteBuffer, file);
                return byteBuffer;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
    }
}

