/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.placename;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.util.Logging;
import java.util.LinkedList;
import java.util.List;

public class PlaceNameServiceSet
extends WWObjectImpl
implements AVList {
    private final List<PlaceNameService> serviceList = new LinkedList<PlaceNameService>();
    private long expiryTime = 0L;

    public boolean addService(PlaceNameService placeNameService, boolean bl) {
        if (placeNameService == null) {
            String string = Logging.getMessage("nullValue.PlaceNameServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < this.serviceList.size(); ++i) {
            PlaceNameService placeNameService2 = this.serviceList.get(i);
            if (!placeNameService.getService().equals(placeNameService2.getService()) || !placeNameService.getDataset().equals(placeNameService2.getDataset())) continue;
            if (bl) {
                this.serviceList.set(i, placeNameService);
                return true;
            }
            return false;
        }
        this.serviceList.add(placeNameService);
        return true;
    }

    public PlaceNameServiceSet deepCopy() {
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        placeNameServiceSet.setValues(this);
        for (int i = 0; i < this.serviceList.size(); ++i) {
            placeNameServiceSet.serviceList.add(i, this.serviceList.get(i).deepCopy());
        }
        placeNameServiceSet.expiryTime = this.expiryTime;
        return placeNameServiceSet;
    }

    public final int getServiceCount() {
        return this.serviceList.size();
    }

    public final PlaceNameService getService(int n) {
        return this.serviceList.get(n);
    }

    public final long getExpiryTime() {
        return this.expiryTime;
    }

    public final void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public List<PlaceNameService> getServices() {
        return this.serviceList;
    }

    public PlaceNameService getService(String string) {
        for (int i = 0; i < this.serviceList.size(); ++i) {
            if (!this.serviceList.get(i).getDataset().equalsIgnoreCase(string)) continue;
            return this.serviceList.get(i);
        }
        return null;
    }
}

