/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceVisualScene;
import gov.nasa.worldwind.ogc.collada.impl.ColladaRenderable;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class ColladaScene
extends ColladaAbstractObject
implements ColladaRenderable {
    protected boolean sceneFetched = false;
    protected ColladaInstanceVisualScene instanceVisualScene;

    public ColladaScene(String string) {
        super(string);
    }

    protected ColladaInstanceVisualScene getInstanceVisualScene() {
        if (!this.sceneFetched) {
            this.instanceVisualScene = (ColladaInstanceVisualScene)this.getField("instance_visual_scene");
            this.sceneFetched = true;
        }
        return this.instanceVisualScene;
    }

    @Override
    public Box getLocalExtent(ColladaTraversalContext colladaTraversalContext) {
        if (colladaTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ColladaInstanceVisualScene colladaInstanceVisualScene = this.getInstanceVisualScene();
        return colladaInstanceVisualScene != null ? colladaInstanceVisualScene.getLocalExtent(colladaTraversalContext) : null;
    }

    @Override
    public void preRender(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        ColladaInstanceVisualScene colladaInstanceVisualScene = this.getInstanceVisualScene();
        if (colladaInstanceVisualScene != null) {
            colladaInstanceVisualScene.preRender(colladaTraversalContext, drawContext);
        }
    }

    @Override
    public void render(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        ColladaInstanceVisualScene colladaInstanceVisualScene = this.getInstanceVisualScene();
        if (colladaInstanceVisualScene != null) {
            colladaInstanceVisualScene.render(colladaTraversalContext, drawContext);
        }
    }
}

