/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLLink;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLinkControl;
import gov.nasa.worldwind.ogc.kml.KMLRegion;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

public class KMLNetworkLink
extends KMLAbstractContainer
implements PropertyChangeListener {
    protected AtomicReference<KMLRoot> networkResource = new AtomicReference();
    protected AtomicLong networkResourceRetrievalTime = new AtomicLong(-1L);
    protected AtomicLong firstRetrievalTime;
    protected boolean linkFetched = false;
    protected KMLLink link;
    protected boolean invalidTarget;
    protected KMLRoot root;

    public KMLNetworkLink(String string) {
        super(string);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getRoot().firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void onMessage(Message message) {
        KMLRoot kMLRoot;
        KMLLink kMLLink = this.getLinkOrUrl();
        if (kMLLink != null) {
            kMLLink.onMessage(message);
        }
        if ((kMLRoot = this.getNetworkResource()) != null) {
            kMLRoot.onMessage(message);
        }
    }

    @Override
    public KMLRoot getRoot() {
        if (this.root == null) {
            this.root = super.getRoot();
        }
        return this.root;
    }

    public Boolean getRefreshVisibility() {
        return (Boolean)this.getField("refreshVisibility");
    }

    public Boolean getFlyToView() {
        return (Boolean)this.getField("flyToView");
    }

    public KMLLink getNetworkLink() {
        if (!this.linkFetched) {
            this.linkFetched = true;
            this.link = (KMLLink)this.getField("Link");
        }
        return this.link;
    }

    public KMLLink getUrl() {
        return (KMLLink)this.getField("Url");
    }

    protected KMLLink getLinkOrUrl() {
        KMLLink kMLLink = this.getNetworkLink();
        if (kMLLink != null) {
            return kMLLink;
        }
        return this.getUrl();
    }

    public KMLRoot getNetworkResource() {
        return this.networkResource.get();
    }

    @Override
    protected boolean isFeatureActive(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getVisibility() != null && !this.getVisibility().booleanValue()) {
            return false;
        }
        KMLRegion kMLRegion = this.getRegion();
        if (kMLRegion == null) {
            kMLRegion = kMLTraversalContext.peekRegion();
        }
        return kMLRegion == null || kMLRegion.isActive(kMLTraversalContext, drawContext);
    }

    protected boolean hasNetworkLinkControl() {
        return this.getRoot().getNetworkLinkControl() != null;
    }

    @Override
    public String getName() {
        if (this.hasNetworkLinkControl() && !WWUtil.isEmpty(this.getRoot().getNetworkLinkControl().getLinkName())) {
            return this.getRoot().getNetworkLinkControl().getLinkName();
        }
        return super.getName();
    }

    @Override
    public String getDescription() {
        if (this.hasNetworkLinkControl() && !WWUtil.isEmpty(this.getRoot().getNetworkLinkControl().getLinkDescription())) {
            return this.getRoot().getNetworkLinkControl().getLinkDescription();
        }
        return super.getDescription();
    }

    @Override
    public Object getSnippet() {
        if (this.hasNetworkLinkControl() && !WWUtil.isEmpty(this.getRoot().getNetworkLinkControl().getLinkSnippet())) {
            return this.getRoot().getNetworkLinkControl().getLinkSnippet();
        }
        return super.getSnippet();
    }

    public void setNetworkResource(final KMLRoot kMLRoot) {
        KMLRoot kMLRoot2 = this.getNetworkResource();
        if (kMLRoot2 != null) {
            kMLRoot2.removePropertyChangeListener(this);
        }
        this.networkResource.set(kMLRoot);
        this.networkResourceRetrievalTime.set(System.currentTimeMillis());
        if (this.firstRetrievalTime == null) {
            this.firstRetrievalTime = new AtomicLong(this.networkResourceRetrievalTime.get());
        }
        if (kMLRoot != null) {
            kMLRoot.addPropertyChangeListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (kMLRoot.getNetworkLinkControl() != null && kMLRoot.getNetworkLinkControl().getUpdate() != null && !kMLRoot.getNetworkLinkControl().getUpdate().isUpdatesApplied()) {
                        kMLRoot.getNetworkLinkControl().getUpdate().applyOperations();
                    }
                }
            });
        }
    }

    @Override
    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        super.doPreRender(kMLTraversalContext, drawContext);
        if (this.mustRetrieveNetworkResource()) {
            this.requestResource(drawContext);
        }
        if (this.getNetworkResource() != null) {
            this.getNetworkResource().preRender(kMLTraversalContext, drawContext);
        }
    }

    @Override
    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        super.doRender(kMLTraversalContext, drawContext);
        if (this.getNetworkResource() != null) {
            this.getNetworkResource().render(kMLTraversalContext, drawContext);
        }
    }

    protected boolean mustRetrieveNetworkResource() {
        long l;
        KMLLink kMLLink = this.getLinkOrUrl();
        if (kMLLink == null) {
            return false;
        }
        if (this.invalidTarget) {
            return false;
        }
        KMLNetworkLinkControl kMLNetworkLinkControl = this.getRoot().getNetworkLinkControl();
        if (kMLNetworkLinkControl != null && kMLNetworkLinkControl.getMinRefreshPeriod() != null) {
            l = System.currentTimeMillis();
            if (this.firstRetrievalTime != null && (double)this.networkResourceRetrievalTime.get() + kMLNetworkLinkControl.getMinRefreshPeriod() * 1000.0 > (double)l) {
                return false;
            }
        }
        if (kMLNetworkLinkControl != null && kMLNetworkLinkControl.getMaxSessionLength() != null && this.firstRetrievalTime != null) {
            l = System.currentTimeMillis();
            if ((double)this.firstRetrievalTime.get() + kMLNetworkLinkControl.getMaxSessionLength() * 1000.0 > (double)l) {
                return false;
            }
        }
        return this.getNetworkResource() == null || kMLLink.getUpdateTime() > this.networkResourceRetrievalTime.get();
    }

    protected void requestResource(DrawContext drawContext) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        KMLLink kMLLink = this.getLinkOrUrl();
        if (kMLLink == null) {
            return;
        }
        Object object = kMLLink.getAddress(drawContext);
        if (object != null) {
            object = ((String)object).trim();
        }
        if (WWUtil.isEmpty(object)) {
            return;
        }
        if (this.hasNetworkLinkControl() && this.getRoot().getNetworkLinkControl().getCookie() != null) {
            object = (String)object + this.getRoot().getNetworkLinkControl().getCookie();
        }
        WorldWind.getTaskService().addTask(new RequestTask(this, (String)object));
    }

    protected void retrieveNetworkResource(String string) {
        Object object;
        long l = 0L;
        KMLLink kMLLink = this.getLinkOrUrl();
        if (kMLLink != null) {
            l = kMLLink.getUpdateTime();
        }
        if ((object = this.getRoot().resolveNetworkLink(string, this.isLinkCacheable(), l)) instanceof KMLRoot) {
            KMLRoot kMLRoot = (KMLRoot)object;
            this.setNetworkResource(kMLRoot);
            long l2 = this.computeExpiryRefreshTime(kMLRoot, string);
            this.getLinkOrUrl().setExpirationTime(l2);
            this.getRoot().firePropertyChange("gov.nasa.worldwind.avkey.RetrievalStateSuccessful", null, this);
        } else if (object != null) {
            String string2 = Logging.getMessage("KML.InvalidNetworkLinkTarget", string);
            Logging.logger().warning(string2);
            this.invalidTarget = true;
        }
    }

    protected long computeExpiryRefreshTime(KMLRoot kMLRoot, String string) {
        KMLNetworkLinkControl kMLNetworkLinkControl = kMLRoot.getNetworkLinkControl();
        if (kMLNetworkLinkControl != null && kMLNetworkLinkControl.getExpires() != null) {
            Long l = WWUtil.parseTimeString(kMLNetworkLinkControl.getExpires());
            return l != null ? l : 0L;
        }
        return this.getRoot().getExpiration(string);
    }

    public boolean isLinkCacheable() {
        KMLLink kMLLink = this.getLinkOrUrl();
        return kMLLink != null && !"onInterval".equalsIgnoreCase(kMLLink.getRefreshMode()) && !"onExpire".equalsIgnoreCase(kMLLink.getRefreshMode()) && !"onStop".equalsIgnoreCase(kMLLink.getViewRefreshMode());
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLNetworkLink)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLNetworkLink kMLNetworkLink = (KMLNetworkLink)kMLAbstractObject;
        if (kMLNetworkLink.getLinkOrUrl() != null) {
            this.reset();
        }
        super.applyChange(kMLAbstractObject);
    }

    @Override
    public void onChange(Message message) {
        if ("KMLAbstractObject.LinkChanged".equals(message.getName())) {
            this.reset();
        }
        super.onChange(message);
    }

    protected void reset() {
        this.networkResource.set(null);
        this.networkResourceRetrievalTime.set(-1L);
        this.firstRetrievalTime = null;
        this.linkFetched = false;
        this.link = null;
        this.invalidTarget = false;
        this.getRoot().requestRedraw();
    }

    protected static class RequestTask
    implements Runnable {
        protected final KMLNetworkLink link;
        protected final String address;

        protected RequestTask(KMLNetworkLink kMLNetworkLink, String string) {
            if (kMLNetworkLink == null) {
                String string2 = Logging.getMessage("nullValue.ObjectIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (string == null) {
                String string3 = Logging.getMessage("nullValue.PathIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            this.link = kMLNetworkLink;
            this.address = string;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.link.retrieveNetworkResource(this.address);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            if (!this.address.equals(requestTask.address)) {
                return false;
            }
            return this.link.equals(requestTask.link);
        }

        public int hashCode() {
            int n = this.link.hashCode();
            n = 31 * n + this.address.hashCode();
            return n;
        }

        public String toString() {
            return this.address;
        }
    }
}

