/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.cache.ShapeDataCache;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLLatLonAltBox;
import gov.nasa.worldwind.ogc.kml.KMLLod;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.List;

public class KMLRegion
extends KMLAbstractObject {
    protected static final int DEFAULT_DATA_GENERATION_INTERVAL = 6000;
    protected static final int DEFAULT_UNUSED_DATA_LIFETIME = 60000;
    protected static final double DEFAULT_DETAIL_HINT_ORIGIN = 2.8;
    protected long maxExpiryTime = 6000L;
    protected long minExpiryTime = Math.max(5000, 0);
    protected ShapeDataCache regionDataCache = new ShapeDataCache(60000L);
    protected RegionData currentData;
    protected double detailHintOrigin = 2.8;

    public KMLRegion(String string) {
        super(string);
    }

    public KMLLatLonAltBox getLatLonAltBox() {
        return (KMLLatLonAltBox)this.getField("LatLonAltBox");
    }

    public KMLLod getLod() {
        return (KMLLod)this.getField("Lod");
    }

    public boolean isActive(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeRegionData(drawContext);
        if (drawContext.getFrameTimeStamp() != this.getCurrentData().getActiveFrameNumber()) {
            this.getCurrentData().setActive(this.isRegionActive(kMLTraversalContext, drawContext));
            this.getCurrentData().setActiveFrameNumber(drawContext.getFrameTimeStamp());
        }
        return this.getCurrentData().isActive();
    }

    protected void makeRegionData(DrawContext drawContext) {
        this.currentData = (RegionData)this.regionDataCache.getEntry(drawContext.getGlobe());
        if (this.currentData == null) {
            this.currentData = this.createCacheEntry(drawContext);
            this.regionDataCache.addEntry(this.currentData);
        }
        if (drawContext.getFrameTimeStamp() != this.getCurrentData().getFrameNumber()) {
            if (this.mustRegenerateData(drawContext)) {
                this.doMakeRegionData(drawContext);
                this.getCurrentData().restartTimer(drawContext);
                this.getCurrentData().setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
                this.getCurrentData().setVerticalExaggeration(drawContext.getVerticalExaggeration());
            }
            this.getCurrentData().setFrameNumber(drawContext.getFrameTimeStamp());
        }
    }

    protected RegionData getCurrentData() {
        return this.currentData;
    }

    protected RegionData createCacheEntry(DrawContext drawContext) {
        return new RegionData(drawContext, this.minExpiryTime, this.maxExpiryTime);
    }

    protected boolean mustRegenerateData(DrawContext drawContext) {
        return this.getCurrentData().isExpired(drawContext) || !this.getCurrentData().isValid(drawContext);
    }

    protected void doMakeRegionData(DrawContext drawContext) {
        this.getCurrentData().setExtent(null);
        this.getCurrentData().setSector(null);
        this.getCurrentData().setPoints(null);
        KMLLatLonAltBox kMLLatLonAltBox = this.getLatLonAltBox();
        if (kMLLatLonAltBox == null) {
            return;
        }
        int n = KMLUtil.convertAltitudeMode(kMLLatLonAltBox.getAltitudeMode(), 1);
        this.getCurrentData().setAltitudeMode(n);
        if (n == 1) {
            this.doMakeClampToGroundRegionData(drawContext, kMLLatLonAltBox);
        } else if (n == 2) {
            this.doMakeRelativeToGroundRegionData(drawContext, kMLLatLonAltBox);
        } else {
            this.doMakeAbsoluteRegionData(drawContext, kMLLatLonAltBox);
        }
    }

    protected void doMakeClampToGroundRegionData(DrawContext drawContext, KMLLatLonAltBox kMLLatLonAltBox) {
        Sector sector = KMLUtil.createSectorFromLatLonBox(kMLLatLonAltBox);
        if (sector == null) {
            return;
        }
        if (!this.isSectorSupported(sector)) {
            String string = Logging.getMessage("KML.UnsupportedRegion", sector);
            Logging.logger().warning(string);
            return;
        }
        double[] dArray = drawContext.getGlobe().getMinAndMaxElevations(sector);
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), sector, dArray[0], dArray[1]);
        this.getCurrentData().setExtent(box);
        this.getCurrentData().setSector(sector);
        Vec4[] vec4Array = sector.computeCornerPoints(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        Vec4 vec4 = sector.computeCenterPoint(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        this.getCurrentData().setPoints(Arrays.asList(vec4Array[0], vec4Array[1], vec4Array[2], vec4Array[3], vec4));
    }

    protected void doMakeRelativeToGroundRegionData(DrawContext drawContext, KMLLatLonAltBox kMLLatLonAltBox) {
        Double d;
        Sector sector = KMLUtil.createSectorFromLatLonBox(kMLLatLonAltBox);
        if (sector == null) {
            return;
        }
        if (!this.isSectorSupported(sector)) {
            String string = Logging.getMessage("KML.UnsupportedRegion", sector);
            Logging.logger().warning(string);
            return;
        }
        Double d2 = kMLLatLonAltBox.getMinAltitude();
        if (d2 == null) {
            d2 = 0.0;
        }
        if ((d = kMLLatLonAltBox.getMaxAltitude()) == null) {
            d = 0.0;
        }
        double[] dArray = drawContext.getGlobe().getMinAndMaxElevations(sector);
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), sector, dArray[0] + d2, dArray[1] + d);
        this.getCurrentData().setExtent(box);
        this.getCurrentData().setSector(sector);
    }

    protected void doMakeAbsoluteRegionData(DrawContext drawContext, KMLLatLonAltBox kMLLatLonAltBox) {
        Double d;
        Sector sector = KMLUtil.createSectorFromLatLonBox(kMLLatLonAltBox);
        if (sector == null) {
            return;
        }
        if (!this.isSectorSupported(sector)) {
            String string = Logging.getMessage("KML.UnsupportedRegion", sector);
            Logging.logger().warning(string);
            return;
        }
        Double d2 = kMLLatLonAltBox.getMinAltitude();
        if (d2 == null) {
            d2 = 0.0;
        }
        if ((d = kMLLatLonAltBox.getMaxAltitude()) == null) {
            d = 0.0;
        }
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), sector, d2, d);
        this.getCurrentData().setExtent(box);
        this.getCurrentData().setSector(sector);
    }

    protected boolean isSectorSupported(Sector sector) {
        return sector.isWithinLatLonLimits();
    }

    protected boolean isRegionActive(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        return this.isRegionVisible(drawContext) && this.meetsLodCriteria(kMLTraversalContext, drawContext);
    }

    protected boolean isRegionVisible(DrawContext drawContext) {
        if (this.getCurrentData().getAltitudeMode() == 1 && drawContext.getVisibleSector() != null && this.getCurrentData().getSector() != null && !drawContext.getVisibleSector().intersects(this.getCurrentData().getSector())) {
            return false;
        }
        if (this.getCurrentData().getExtent() != null && drawContext.isSmall(this.getCurrentData().getExtent(), 1)) {
            return false;
        }
        return this.intersectsFrustum(drawContext);
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        Extent extent = this.getCurrentData().getExtent();
        if (extent == null) {
            return true;
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    protected boolean meetsLodCriteria(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        KMLLod kMLLod = this.getLod();
        if (kMLLod == null) {
            return true;
        }
        if ((kMLLod.getMinLodPixels() == null || kMLLod.getMinLodPixels() <= 0.0) && (kMLLod.getMaxLodPixels() == null || kMLLod.getMaxLodPixels() < 0.0)) {
            return true;
        }
        if (kMLLod.getMaxLodPixels() != null && kMLLod.getMaxLodPixels() == 0.0) {
            return false;
        }
        int n = this.getCurrentData().getAltitudeMode();
        if (n == 1) {
            return this.meetsClampToGroundLodCriteria(kMLTraversalContext, drawContext, kMLLod);
        }
        if (n == 2) {
            return this.meetsRelativeToGroundLodCriteria(kMLTraversalContext, drawContext, kMLLod);
        }
        return this.meetsAbsoluteLodCriteria(kMLTraversalContext, drawContext, kMLLod);
    }

    protected boolean meetsClampToGroundLodCriteria(KMLTraversalContext kMLTraversalContext, DrawContext drawContext, KMLLod kMLLod) {
        Sector sector = this.getCurrentData().getSector();
        List<Vec4> list = this.getCurrentData().getPoints();
        if (sector == null || list == null || list.size() != 5) {
            return true;
        }
        View view = drawContext.getView();
        double d = view.getEyePoint().distanceTo3(list.get(0));
        double d2 = view.getEyePoint().distanceTo3(list.get(1));
        double d3 = view.getEyePoint().distanceTo3(list.get(2));
        double d4 = view.getEyePoint().distanceTo3(list.get(3));
        double d5 = view.getEyePoint().distanceTo3(list.get(4));
        double d6 = d;
        double d7 = Math.sqrt(sector.getDeltaLatRadians() * sector.getDeltaLonRadians());
        double d8 = list.get(0).getLength3() * d7;
        if (d2 < d6) {
            d6 = d2;
            d8 = list.get(1).getLength3() * d7;
        }
        if (d3 < d6) {
            d6 = d3;
            d8 = list.get(2).getLength3() * d7;
        }
        if (d4 < d6) {
            d6 = d4;
            d8 = list.get(3).getLength3() * d7;
        }
        if (d5 < d6) {
            d6 = d5;
            d8 = list.get(4).getLength3() * d7;
        }
        Double d9 = kMLLod.getMinLodPixels();
        Double d10 = kMLLod.getMaxLodPixels();
        double d11 = d6 * Math.pow(10.0, -this.getDetailFactor(kMLTraversalContext));
        return (d9 == null || d9 <= 0.0 || d8 / d9 >= d11) && (d10 == null || d10 < 0.0 || d8 / d10 < d11);
    }

    protected boolean meetsRelativeToGroundLodCriteria(KMLTraversalContext kMLTraversalContext, DrawContext drawContext, KMLLod kMLLod) {
        return this.meetsScreenAreaCriteria(drawContext, kMLLod);
    }

    protected boolean meetsAbsoluteLodCriteria(KMLTraversalContext kMLTraversalContext, DrawContext drawContext, KMLLod kMLLod) {
        return this.meetsScreenAreaCriteria(drawContext, kMLLod);
    }

    protected boolean meetsScreenAreaCriteria(DrawContext drawContext, KMLLod kMLLod) {
        Extent extent = this.getCurrentData().getExtent();
        if (extent == null) {
            return true;
        }
        double d = extent.getProjectedArea(drawContext.getView());
        if (d != Double.POSITIVE_INFINITY) {
            d = Math.sqrt(d);
        }
        Double d2 = kMLLod.getMinLodPixels();
        Double d3 = kMLLod.getMaxLodPixels();
        return (d2 == null || d2 <= 0.0 || d2 <= d) && (d3 == null || d3 < 0.0 || d3 > d);
    }

    protected double getDetailFactor(KMLTraversalContext kMLTraversalContext) {
        return this.detailHintOrigin + kMLTraversalContext.getDetailHint();
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLRegion)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.reset();
        super.applyChange(kMLAbstractObject);
    }

    @Override
    public void onChange(Message message) {
        if ("KMLAbstractObject.BoxChanged".equals(message.getName())) {
            this.reset();
        }
        super.onChange(message);
    }

    protected void reset() {
        this.regionDataCache.removeAllEntries();
        this.currentData = null;
    }

    protected static class RegionData
    extends ShapeDataCache.ShapeDataCacheEntry {
        protected long frameNumber = -1L;
        protected long activeFrameNumber = -1L;
        protected boolean isActive;
        protected int altitudeMode = -1;
        protected Sector sector;
        protected List<Vec4> points;

        public RegionData(DrawContext drawContext, long l, long l2) {
            super(drawContext, l, l2);
        }

        public long getFrameNumber() {
            return this.frameNumber;
        }

        public void setFrameNumber(long l) {
            this.frameNumber = l;
        }

        public long getActiveFrameNumber() {
            return this.activeFrameNumber;
        }

        public void setActiveFrameNumber(long l) {
            this.activeFrameNumber = l;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean bl) {
            this.isActive = bl;
        }

        public int getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(int n) {
            this.altitudeMode = n;
        }

        public Sector getSector() {
            return this.sector;
        }

        public void setSector(Sector sector) {
            this.sector = sector;
        }

        public List<Vec4> getPoints() {
            return this.points;
        }

        public void setPoints(List<Vec4> list) {
            this.points = list;
        }
    }
}

