/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractLatLonBoxType;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLLineString;
import gov.nasa.worldwind.ogc.kml.KMLLineStyle;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.ogc.kml.KMLLocation;
import gov.nasa.worldwind.ogc.kml.KMLModel;
import gov.nasa.worldwind.ogc.kml.KMLMultiGeometry;
import gov.nasa.worldwind.ogc.kml.KMLPoint;
import gov.nasa.worldwind.ogc.kml.KMLPolyStyle;
import gov.nasa.worldwind.ogc.kml.KMLPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class KMLUtil {
    public static final String KML_PIXELS = "pixels";
    public static final String KML_FRACTION = "fraction";
    public static final String KML_INSET_PIXELS = "insetPixels";

    public static ShapeAttributes assembleLineAttributes(ShapeAttributes shapeAttributes, KMLLineStyle kMLLineStyle) {
        if (kMLLineStyle.getWidth() != null) {
            shapeAttributes.setOutlineWidth(kMLLineStyle.getWidth());
        }
        if (kMLLineStyle.getColor() != null) {
            shapeAttributes.setOutlineMaterial(new Material(WWUtil.decodeColorABGR(kMLLineStyle.getColor())));
        }
        if (kMLLineStyle.getColorMode() != null && "random".equals(kMLLineStyle.getColorMode())) {
            shapeAttributes.setOutlineMaterial(new Material(WWUtil.makeRandomColor(shapeAttributes.getOutlineMaterial().getDiffuse())));
        }
        return shapeAttributes;
    }

    public static ShapeAttributes assembleInteriorAttributes(ShapeAttributes shapeAttributes, KMLPolyStyle kMLPolyStyle) {
        if (kMLPolyStyle.getColor() != null) {
            Color color = WWUtil.decodeColorABGR(kMLPolyStyle.getColor());
            shapeAttributes.setInteriorMaterial(new Material(color));
            shapeAttributes.setInteriorOpacity((double)color.getAlpha() / 255.0);
        }
        if (kMLPolyStyle.getColorMode() != null && "random".equals(kMLPolyStyle.getColorMode())) {
            shapeAttributes.setInteriorMaterial(new Material(WWUtil.makeRandomColor(shapeAttributes.getOutlineMaterial().getDiffuse())));
        }
        return shapeAttributes;
    }

    public static boolean isHighlightStyleState(KMLAbstractSubStyle kMLAbstractSubStyle) {
        if (kMLAbstractSubStyle == null) {
            return false;
        }
        String string = (String)kMLAbstractSubStyle.getField("styleState");
        return string != null && string.equals("highlight");
    }

    public static int convertAltitudeMode(String string, int n) {
        if ("clampToGround".equals(string)) {
            return 1;
        }
        if ("relativeToGround".equals(string)) {
            return 2;
        }
        if ("absolute".equals(string)) {
            return 0;
        }
        return n;
    }

    public static String kmlUnitsToWWUnits(String string) {
        if (KML_PIXELS.equals(string)) {
            return "gov.nasa.worldwind.avkey.Pixels";
        }
        if (KML_FRACTION.equals(string)) {
            return "gov.nasa.worldwind.avkey.Fraction";
        }
        if (KML_INSET_PIXELS.equals(string)) {
            return "gov.nasa.worldwind.avkey.InsetPixels";
        }
        return null;
    }

    public static String wwUnitsToKMLUnits(String string) {
        if ("gov.nasa.worldwind.avkey.Pixels".equals(string)) {
            return KML_PIXELS;
        }
        if ("gov.nasa.worldwind.avkey.Fraction".equals(string)) {
            return KML_FRACTION;
        }
        if ("gov.nasa.worldwind.avkey.InsetPixels".equals(string)) {
            return KML_INSET_PIXELS;
        }
        return null;
    }

    public static Sector createSectorFromLatLonBox(KMLAbstractLatLonBoxType kMLAbstractLatLonBoxType) {
        if (kMLAbstractLatLonBoxType == null) {
            String string = Logging.getMessage("nullValue.BoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLAbstractLatLonBoxType.getNorth() == null || kMLAbstractLatLonBoxType.getSouth() == null || kMLAbstractLatLonBoxType.getEast() == null || kMLAbstractLatLonBoxType.getWest() == null) {
            return null;
        }
        double d = kMLAbstractLatLonBoxType.getNorth();
        double d2 = kMLAbstractLatLonBoxType.getSouth();
        double d3 = kMLAbstractLatLonBoxType.getEast();
        double d4 = kMLAbstractLatLonBoxType.getWest();
        double d5 = Math.min(d, d2);
        double d6 = Math.max(d, d2);
        double d7 = Math.min(d3, d4);
        double d8 = Math.max(d3, d4);
        return Sector.fromDegrees(d5, d6, d7, d8);
    }

    public static void getPositions(Globe globe, KMLAbstractGeometry kMLAbstractGeometry, List<Position> list) {
        if (kMLAbstractGeometry instanceof KMLPoint) {
            KMLPoint kMLPoint = (KMLPoint)kMLAbstractGeometry;
            Position position = kMLPoint.getCoordinates();
            if (position != null) {
                list.add(KMLUtil.computeAltitude(globe, position, kMLPoint.getAltitudeMode()));
            }
        } else if (kMLAbstractGeometry instanceof KMLModel) {
            Position position;
            KMLModel kMLModel = (KMLModel)kMLAbstractGeometry;
            KMLLocation kMLLocation = kMLModel.getLocation();
            if (kMLLocation != null && (position = kMLLocation.getPosition()) != null) {
                list.add(KMLUtil.computeAltitude(globe, position, kMLModel.getAltitudeMode()));
            }
        } else if (kMLAbstractGeometry instanceof KMLLineString) {
            KMLLineString kMLLineString = (KMLLineString)kMLAbstractGeometry;
            Position.PositionList positionList = kMLLineString.getCoordinates();
            if (positionList != null) {
                list.addAll(KMLUtil.computeAltitude(globe, positionList.list, kMLLineString.getAltitudeMode()));
            }
        } else if (kMLAbstractGeometry instanceof KMLPolygon) {
            KMLLinearRing kMLLinearRing = ((KMLPolygon)kMLAbstractGeometry).getOuterBoundary();
            KMLUtil.getPositions(globe, kMLLinearRing, list);
        } else if (kMLAbstractGeometry instanceof KMLMultiGeometry) {
            List<KMLAbstractGeometry> list2 = ((KMLMultiGeometry)kMLAbstractGeometry).getGeometries();
            for (KMLAbstractGeometry kMLAbstractGeometry2 : list2) {
                KMLUtil.getPositions(globe, kMLAbstractGeometry2, list);
            }
        }
    }

    public static List<Position> computeAltitude(Globe globe, List<? extends Position> list, String string) {
        ArrayList<Position> arrayList = new ArrayList<Position>(list.size());
        for (Position position : list) {
            arrayList.add(KMLUtil.computeAltitude(globe, position, string));
        }
        return arrayList;
    }

    public static Position computeAltitude(Globe globe, Position position, String string) {
        Angle angle = position.getLatitude();
        Angle angle2 = position.getLongitude();
        int n = KMLUtil.convertAltitudeMode(string, 1);
        double d = n == 1 ? globe.getElevation(angle, angle2) : (n == 2 ? globe.getElevation(angle, angle2) + position.getAltitude() : position.getAltitude());
        return new Position(angle, angle2, d);
    }

    public static List<LatLon> rotateSector(Globe globe, Sector sector, Angle angle) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon[] latLonArray = sector.getCorners();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(latLonArray.length);
        Vec4[] vec4Array = sector.computeCornerPoints(globe, 1.0);
        Vec4 vec4 = vec4Array[2].subtract3(vec4Array[0]).cross3(vec4Array[3].subtract3(vec4Array[1])).normalize3();
        Matrix matrix = Matrix.fromAxisAngle(angle, vec4);
        Vec4 vec42 = sector.computeCenterPoint(globe, 1.0);
        for (Vec4 vec43 : vec4Array) {
            vec43 = vec43.subtract3(vec42).transformBy3(matrix).add3(vec42);
            Position position = globe.computePositionFromPoint(vec43);
            arrayList.add(position);
        }
        return arrayList;
    }
}

