/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.io;

import gov.nasa.worldwind.ogc.kml.io.KMLDoc;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class KMLInputStream
implements KMLDoc {
    protected InputStream inputStream;
    protected URI uri;

    public KMLInputStream(InputStream inputStream, URI uRI) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.inputStream = inputStream;
        this.uri = uRI;
    }

    @Override
    public InputStream getKMLStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public InputStream getSupportFileStream(String string) throws IOException {
        URL uRL;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.getSupportFilePath(string);
        if (string3 != null && (uRL = WWIO.makeURL(string)) != null) {
            return uRL.openStream();
        }
        return null;
    }

    @Override
    public String getSupportFilePath(String string) {
        URI uRI;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.uri != null && (uRI = this.uri.resolve(string)) != null) {
            return uRI.toString();
        }
        return null;
    }
}

