/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSAddress
extends AbstractXMLEventParser {
    protected List<String> deliveryPoints = new ArrayList<String>(1);
    protected List<String> postalCodes = new ArrayList<String>(1);
    protected List<String> countries = new ArrayList<String>(1);
    protected List<String> emails = new ArrayList<String>(1);

    public OWSAddress(String string) {
        super(string);
    }

    public String getCity() {
        return (String)(this.getField("City") != null ? this.getField("City") : this.getField("city"));
    }

    public String getAdministrativeArea() {
        return (String)(this.getField("AdministrativeArea") != null ? this.getField("AdministrativeArea") : this.getField("administrativeArea"));
    }

    public List<String> getDeliveryPoints() {
        return this.deliveryPoints;
    }

    public List<String> getPostalCodes() {
        return this.postalCodes;
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public List<String> getElectronicMailAddresses() {
        return this.emails;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "DeliveryPoint") || xMLEventParserContext.isStartElement(xMLEvent, "deliveryPoint")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.deliveryPoints.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "PostalCode") || xMLEventParserContext.isStartElement(xMLEvent, "postalCode")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.postalCodes.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Country") || xMLEventParserContext.isStartElement(xMLEvent, "country")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.countries.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "ElectronicMailAddress") || xMLEventParserContext.isStartElement(xMLEvent, "electronicMailAddress")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.emails.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

