/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSAddress;
import gov.nasa.worldwind.ogc.ows.OWSAllowedValues;
import gov.nasa.worldwind.ogc.ows.OWSConstraint;
import gov.nasa.worldwind.ogc.ows.OWSContactInfo;
import gov.nasa.worldwind.ogc.ows.OWSDCP;
import gov.nasa.worldwind.ogc.ows.OWSHTTP;
import gov.nasa.worldwind.ogc.ows.OWSOperation;
import gov.nasa.worldwind.ogc.ows.OWSOperationsMetadata;
import gov.nasa.worldwind.ogc.ows.OWSParameter;
import gov.nasa.worldwind.ogc.ows.OWSPhone;
import gov.nasa.worldwind.ogc.ows.OWSServiceContact;
import gov.nasa.worldwind.ogc.ows.OWSServiceIdentification;
import gov.nasa.worldwind.ogc.ows.OWSServiceProvider;
import gov.nasa.worldwind.ogc.ows.OWSWGS84BoundingBox;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.AttributesOnlyXMLEventParser;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public abstract class OWSCapabilities
extends AbstractXMLEventParser {
    protected String owsNamespaceURI;
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;

    protected abstract void determineNamespaces();

    public OWSCapabilities(String string, Object object) {
        super(string);
        this.eventReader = this.createReader(object);
        this.initialize();
    }

    protected void initialize() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        this.parserContext = new BasicXMLEventParserContext(xMLEventReader);
        this.parserContext.setDefaultNamespaceURI(this.getNamespaceURI());
        return this.parserContext;
    }

    public XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public String getUpdateSequence() {
        return (String)this.getField("updateSequence");
    }

    public OWSServiceIdentification getServiceIdentification() {
        return (OWSServiceIdentification)this.getField("ServiceIdentification");
    }

    public OWSServiceProvider getServiceProvider() {
        return (OWSServiceProvider)this.getField("ServiceProvider");
    }

    public OWSOperationsMetadata getOperationsMetadata() {
        return (OWSOperationsMetadata)this.getField("OperationsMetadata");
    }

    public OWSCapabilities parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.parserContext;
        QName qName = new QName(this.getNamespaceURI(), "Capabilities");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().equals(qName)) {
                this.doParseEventAttributes(xMLEventParserContext, xMLEvent, new Object[0]);
                this.determineNamespaces();
                xMLEventParserContext.setDefaultNamespaceURI(this.getNamespaceURI());
                this.registerParsers(xMLEventParserContext);
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    protected void setOWSNamespaceURI(String string) {
        this.owsNamespaceURI = string;
    }

    public String getOWSNamespaceURI() {
        return this.owsNamespaceURI;
    }

    protected void registerParsers(XMLEventParserContext xMLEventParserContext) {
        xMLEventParserContext.addStringParsers(this.getOWSNamespaceURI(), new String[]{"Abstract", "AccessConstraints", "AdministrativeArea", "City", "ContactInstructions", "Country", "DeliveryPoint", "ElectronicMailAddress", "Facsimile", "Fees", "HoursOfService", "IndividualName", "Keyword", "LowerCorner", "PositionName", "PostalCode", "Profile", "ProviderName", "Role", "ServiceType", "ServiceTypeVersion", "Title", "UpperCorner", "Value", "Voice"});
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Address"), new OWSAddress(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "AllowedValues"), new OWSAllowedValues(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "WGS84BoundingBox"), new OWSWGS84BoundingBox(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Constraint"), new OWSConstraint(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "ContactInfo"), new OWSContactInfo(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "DCP"), new OWSDCP(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Get"), new AttributesOnlyXMLEventParser(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "HTTP"), new OWSHTTP(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Keywords"), new StringListXMLEventParser(this.getOWSNamespaceURI(), new QName(this.getOWSNamespaceURI(), "Keyword")));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "OnlineResource"), new AttributesOnlyXMLEventParser(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Operation"), new OWSOperation(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "OperationsMetadata"), new OWSOperationsMetadata(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Parameter"), new OWSParameter(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Phone"), new OWSPhone(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "Post"), new AttributesOnlyXMLEventParser(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "ProviderSite"), new AttributesOnlyXMLEventParser(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "ServiceContact"), new OWSServiceContact(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "ServiceIdentification"), new OWSServiceIdentification(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "ServiceProvider"), new OWSServiceProvider(this.getOWSNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getOWSNamespaceURI(), "WGS84BoundingBox"), new OWSWGS84BoundingBox(this.getOWSNamespaceURI()));
    }
}

