/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSConstraint;
import gov.nasa.worldwind.ogc.ows.OWSDCP;
import gov.nasa.worldwind.ogc.ows.OWSHTTP;
import gov.nasa.worldwind.ogc.ows.OWSOperation;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSOperationsMetadata
extends AbstractXMLEventParser {
    protected List<OWSOperation> operations = new ArrayList<OWSOperation>(2);
    protected List<OWSConstraint> constraints = new ArrayList<OWSConstraint>(1);

    public OWSOperationsMetadata(String string) {
        super(string);
    }

    public List<OWSOperation> getOperations() {
        return this.operations;
    }

    public List<OWSConstraint> getConstraints() {
        return this.constraints;
    }

    public OWSOperation getOperation(String string) {
        for (OWSOperation oWSOperation : this.getOperations()) {
            if (!oWSOperation.getName().equals(string)) continue;
            return oWSOperation;
        }
        return null;
    }

    public String getGetOperationAddress(String string, String string2) {
        OWSOperation oWSOperation = this.getOperation(string2);
        if (string2 != null) {
            for (OWSDCP oWSDCP : oWSOperation.getDCPs()) {
                OWSHTTP oWSHTTP = oWSDCP.getHTTP();
                if (oWSHTTP == null) continue;
                if (string.equals("Get") && oWSHTTP.getGetAddress() != null) {
                    return oWSHTTP.getGetAddress();
                }
                if (!string.equals("Post") || oWSHTTP.getPostAddress() == null) continue;
                return oWSHTTP.getPostAddress();
            }
        }
        return null;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "Operation")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OWSOperation) {
                this.operations.add((OWSOperation)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Constraint")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OWSConstraint) {
                this.constraints.add((OWSConstraint)object);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

