/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs;

import gov.nasa.worldwind.ogc.ows.OWSCapabilities;
import gov.nasa.worldwind.ogc.wcs.WCSContents;
import gov.nasa.worldwind.ogc.wcs.WCSCoverageSummary;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AttributesOnlyXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.namespace.QName;

public class WCSCapabilities
extends OWSCapabilities {
    public WCSCapabilities(Object object) {
        super("http://www.opengis.net/wcs/1.1.1", object);
    }

    public WCSContents getContents() {
        return (WCSContents)this.getField("Contents");
    }

    public String getOtherSource() {
        AttributesOnlyXMLEventParser attributesOnlyXMLEventParser = (AttributesOnlyXMLEventParser)this.getField("OtherSource");
        return attributesOnlyXMLEventParser != null ? (String)attributesOnlyXMLEventParser.getField("href") : null;
    }

    public String getDefaultNamespaceURI() {
        return this.namespaceURI;
    }

    public String getWCSNamespace() {
        return this.namespaceURI;
    }

    @Override
    protected void determineNamespaces() {
        String string = this.getVersion();
        if (string == null) {
            this.setOWSNamespaceURI("http://www.opengis.net/ows/1.1");
            this.setNamespaceURI("http://www.opengis.net/wcs/1.1.1");
        } else if (WWUtil.compareVersion(string, "1.1.1") == 0) {
            this.setOWSNamespaceURI("http://www.opengis.net/ows/1.1");
            this.setNamespaceURI("http://www.opengis.net/wcs/1.1.1");
        } else {
            this.setOWSNamespaceURI("http://www.opengis.net/ows/1.1");
            this.setNamespaceURI("http://www.opengis.net/wcs/1.1.1");
        }
    }

    @Override
    protected void registerParsers(XMLEventParserContext xMLEventParserContext) {
        super.registerParsers(xMLEventParserContext);
        xMLEventParserContext.addStringParsers(this.namespaceURI, new String[]{"Identifier", "SupportedCRS", "SupportedFormat"});
        xMLEventParserContext.registerParser(new QName(this.getWCSNamespace(), "Contents"), new WCSContents(this.namespaceURI));
        xMLEventParserContext.registerParser(new QName(this.getWCSNamespace(), "CoverageSummary"), new WCSCoverageSummary(this.namespaceURI));
        xMLEventParserContext.registerParser(new QName(this.getWCSNamespace(), "OtherSource"), new AttributesOnlyXMLEventParser(this.namespaceURI));
    }
}

