/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs;

import gov.nasa.worldwind.ogc.wcs.WCSCoverageSummary;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.AttributesOnlyXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WCSContents
extends AbstractXMLEventParser {
    protected List<WCSCoverageSummary> coverageSummaries = new ArrayList<WCSCoverageSummary>(1);
    protected List<AttributesOnlyXMLEventParser> otherSources = new ArrayList<AttributesOnlyXMLEventParser>(1);
    protected List<String> supportedCRSs = new ArrayList<String>(1);
    protected List<String> supportedFormats = new ArrayList<String>(1);

    public WCSContents(String string) {
        super(string);
    }

    public List<WCSCoverageSummary> getCoverageSummaries() {
        return this.coverageSummaries;
    }

    public List<String> getSupportedCRSs() {
        return this.supportedCRSs;
    }

    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public List<String> getOtherSources() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (AttributesOnlyXMLEventParser attributesOnlyXMLEventParser : this.otherSources) {
            String string = (String)attributesOnlyXMLEventParser.getField("href");
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "CoverageSummary")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WCSCoverageSummary) {
                this.coverageSummaries.add((WCSCoverageSummary)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "OtherSource")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof AttributesOnlyXMLEventParser) {
                this.otherSources.add((AttributesOnlyXMLEventParser)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "SupportedCRS")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.supportedCRSs.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "SupportedFormat")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.supportedFormats.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

