/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs;

import gov.nasa.worldwind.ogc.ows.OWSWGS84BoundingBox;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WCSCoverageSummary
extends AbstractXMLEventParser {
    protected List<String> abstracts = new ArrayList<String>(1);
    protected List<OWSWGS84BoundingBox> boundingBoxes = new ArrayList<OWSWGS84BoundingBox>(1);
    protected List<WCSCoverageSummary> coverageSummaries = new ArrayList<WCSCoverageSummary>(1);
    protected List<String> supportedCRSs = new ArrayList<String>(1);
    protected List<String> supportedFormats = new ArrayList<String>(1);
    protected List<String> titles = new ArrayList<String>(1);

    public WCSCoverageSummary(String string) {
        super(string);
    }

    public List<String> getAbstracts() {
        return this.abstracts;
    }

    public String getAbstract() {
        Iterator<String> iterator = this.abstracts.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public List<OWSWGS84BoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public OWSWGS84BoundingBox getBoundingBox() {
        Iterator<OWSWGS84BoundingBox> iterator = this.boundingBoxes.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public List<WCSCoverageSummary> getCoverageSummaries() {
        return this.coverageSummaries;
    }

    public String getIdentifier() {
        return (String)this.getField("Identifier");
    }

    public List<String> getKeywords() {
        return ((StringListXMLEventParser)this.getField("Keywords")).getStrings();
    }

    public List<String> getSupportedCRSs() {
        return this.supportedCRSs;
    }

    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public String getTitle() {
        Iterator<String> iterator = this.titles.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "Abstract")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.abstracts.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "WGS84BoundingBox")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OWSWGS84BoundingBox) {
                this.boundingBoxes.add((OWSWGS84BoundingBox)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "CoverageSummary")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WCSCoverageSummary) {
                this.coverageSummaries.add((WCSCoverageSummary)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "SupportedCRS")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.supportedCRSs.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "SupportedFormat")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.supportedFormats.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Title")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.titles.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

