/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs.wcs100;

import gov.nasa.worldwind.ogc.gml.GMLPos;
import gov.nasa.worldwind.ogc.ows.OWSAddress;
import gov.nasa.worldwind.ogc.ows.OWSContactInfo;
import gov.nasa.worldwind.ogc.ows.OWSPhone;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Capability;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100ContentMetadata;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100CoverageOfferingBrief;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100DCPType;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Exception;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100HTTP;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100LonLatEnvelope;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100MetadataLink;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Request;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100RequestDescription;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100ResponsibleParty;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Service;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.AttributesOnlyXMLEventParser;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WCS100Capabilities
extends AbstractXMLEventParser {
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;

    public static WCS100Capabilities retrieve(URI uRI) throws Exception {
        try {
            CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(uRI, "WCS");
            capabilitiesRequest.setVersion("1.0.0");
            return new WCS100Capabilities((Object)capabilitiesRequest.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = Logging.getMessage("OGC.GetCapabilitiesURIInvalid", uRI);
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
    }

    public WCS100Capabilities(Object object) {
        super("http://www.opengis.net/wcs");
        this.eventReader = this.createReader(object);
        this.initialize();
    }

    protected void initialize() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        this.parserContext = new BasicXMLEventParserContext(xMLEventReader);
        this.parserContext.setDefaultNamespaceURI(this.getNamespaceURI());
        return this.parserContext;
    }

    public XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public String getUpdateSequence() {
        return (String)this.getField("updateSequence");
    }

    public WCS100Service getService() {
        return (WCS100Service)this.getField("Service");
    }

    public WCS100Capability getCapability() {
        return (WCS100Capability)this.getField("Capability");
    }

    public WCS100ContentMetadata getContentMetadata() {
        return (WCS100ContentMetadata)this.getField("ContentMetadata");
    }

    public WCS100Capabilities parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.parserContext;
        QName qName = new QName(this.getNamespaceURI(), "WCS_Capabilities");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().equals(qName)) {
                this.doParseEventAttributes(xMLEventParserContext, xMLEvent, new Object[0]);
                xMLEventParserContext.setDefaultNamespaceURI(this.getNamespaceURI());
                this.registerParsers(xMLEventParserContext);
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    protected void registerParsers(XMLEventParserContext xMLEventParserContext) {
        xMLEventParserContext.addStringParsers(this.getNamespaceURI(), new String[]{"accessConstraints", "administrativeArea", "city", "country", "deliveryPoint", "description", "electronicMailAddress", "facsimile", "fees", "Format", "individualName", "label", "keyword", "name", "organisationName", "positionName", "postalCode", "voice"});
        xMLEventParserContext.addStringParsers("http://www.opengis.net/gml", new String[]{"timePosition"});
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "address"), new OWSAddress(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Capability"), new WCS100Capability(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "contactInfo"), new OWSContactInfo(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "ContentMetadata"), new WCS100ContentMetadata(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "CoverageOfferingBrief"), new WCS100CoverageOfferingBrief(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "DCPType"), new WCS100DCPType(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "DescribeCoverage"), new WCS100RequestDescription(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Exception"), new WCS100Exception(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Get"), new AttributesOnlyXMLEventParser(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "GetCapabilities"), new WCS100RequestDescription(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "GetCoverage"), new WCS100RequestDescription(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "HTTP"), new WCS100HTTP(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "keywords"), new StringListXMLEventParser(this.getNamespaceURI(), new QName(this.getNamespaceURI(), "keyword")));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "lonLatEnvelope"), new WCS100LonLatEnvelope(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "metadataLink"), new WCS100MetadataLink(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "OnlineResource"), new AttributesOnlyXMLEventParser(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "onlineResource"), new AttributesOnlyXMLEventParser(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "phone"), new OWSPhone(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "pos"), new GMLPos("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Post"), new AttributesOnlyXMLEventParser(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Request"), new WCS100Request(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "responsibleParty"), new WCS100ResponsibleParty(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Service"), new WCS100Service(this.getNamespaceURI()));
    }
}

