/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs.wcs100;

import gov.nasa.worldwind.ogc.gml.GMLEnvelope;
import gov.nasa.worldwind.ogc.gml.GMLGrid;
import gov.nasa.worldwind.ogc.gml.GMLGridEnvelope;
import gov.nasa.worldwind.ogc.gml.GMLLimits;
import gov.nasa.worldwind.ogc.gml.GMLOrigin;
import gov.nasa.worldwind.ogc.gml.GMLPos;
import gov.nasa.worldwind.ogc.gml.GMLRectifiedGrid;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100AxisDescription;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100AxisDescriptionHolder;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100CoverageOffering;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100DomainSet;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Interval;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100LonLatEnvelope;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Max;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100MetadataLink;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Min;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100RangeSet;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100RangeSetHolder;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100SingleValue;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100SpatialDomain;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100SupportedCRSs;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100SupportedFormats;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100SupportedInterpolations;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Values;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.wms.Request;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WCS100DescribeCoverage
extends AbstractXMLEventParser {
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;
    protected List<WCS100CoverageOffering> coverageOfferings = new ArrayList<WCS100CoverageOffering>(1);

    public static WCS100DescribeCoverage retrieve(URI uRI, final String string) throws URISyntaxException {
        Request request = new Request(uRI, "WCS"){

            @Override
            protected void initialize(String string2) {
                super.initialize(string2);
                this.setParam("REQUEST", "DescribeCoverage");
                this.setParam("VERSION", "1.0.0");
                this.setParam("coverage", string);
            }
        };
        return new WCS100DescribeCoverage((Object)request.toString());
    }

    public WCS100DescribeCoverage(Object object) {
        super("http://www.opengis.net/wcs");
        this.eventReader = this.createReader(object);
        this.initialize();
    }

    protected void initialize() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        this.parserContext = new BasicXMLEventParserContext(xMLEventReader);
        this.parserContext.setDefaultNamespaceURI(this.getNamespaceURI());
        return this.parserContext;
    }

    public XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public String getUpdateSequence() {
        return (String)this.getField("updateSequence");
    }

    public List<WCS100CoverageOffering> getCoverageOfferings() {
        return this.coverageOfferings;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "CoverageOffering")) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WCS100CoverageOffering) {
                this.coverageOfferings.add((WCS100CoverageOffering)object);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public WCS100DescribeCoverage parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.parserContext;
        QName qName = new QName(this.getNamespaceURI(), "CoverageDescription");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().equals(qName)) {
                this.doParseEventAttributes(xMLEventParserContext, xMLEvent, new Object[0]);
                xMLEventParserContext.setDefaultNamespaceURI(this.getNamespaceURI());
                this.registerParsers(xMLEventParserContext);
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    protected void registerParsers(XMLEventParserContext xMLEventParserContext) {
        xMLEventParserContext.addStringParsers(this.getNamespaceURI(), new String[]{"description", "label", "keyword", "name", "res", "singleValue"});
        xMLEventParserContext.addStringParsers("http://www.opengis.net/gml", new String[]{"axisName", "high", "low", "offsetVector", "timePosition"});
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "axisDescription"), new WCS100AxisDescriptionHolder(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "AxisDescription"), new WCS100AxisDescription(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "CoverageOffering"), new WCS100CoverageOffering(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "domainSet"), new WCS100DomainSet(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "Envelope"), new GMLEnvelope("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "Grid"), new GMLGrid("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "GridEnvelope"), new GMLGridEnvelope("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "interval"), new WCS100Interval(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "keywords"), new StringListXMLEventParser(this.getNamespaceURI(), new QName(this.getNamespaceURI(), "keyword")));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "limits"), new GMLLimits("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "lonLatEnvelope"), new WCS100LonLatEnvelope(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "max"), new WCS100Max(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "metadataLink"), new WCS100MetadataLink(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "min"), new WCS100Min(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "nullValues"), new WCS100Values(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "origin"), new GMLOrigin("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "pos"), new GMLPos("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "rangeSet"), new WCS100RangeSetHolder(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "rangeSet"), new WCS100RangeSetHolder(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "RangeSet"), new WCS100RangeSet(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName("http://www.opengis.net/gml", "RectifiedGrid"), new GMLRectifiedGrid("http://www.opengis.net/gml"));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "supportedFormats"), new WCS100SupportedFormats(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "supportedInterpolations"), new WCS100SupportedInterpolations(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "singleValue"), new WCS100SingleValue(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "spatialDomain"), new WCS100SpatialDomain(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "supportedCRSs"), new WCS100SupportedCRSs(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "values"), new WCS100Values(this.getNamespaceURI()));
    }
}

