/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wcs.wcs100;

import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100MetadataLink;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100ResponsibleParty;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WCS100Service
extends AbstractXMLEventParser {
    protected List<String> accessConstraints = new ArrayList<String>(1);

    public WCS100Service(String string) {
        super(string);
    }

    public String getDescription() {
        return (String)this.getField("description");
    }

    public String getName() {
        return (String)this.getField("name");
    }

    public String getLabel() {
        return (String)this.getField("label");
    }

    public List<String> getAccessConstraints() {
        return this.accessConstraints;
    }

    public String getFees() {
        return (String)this.getField("fees");
    }

    public WCS100MetadataLink getMetadataLink() {
        return (WCS100MetadataLink)this.getField("metadataLink");
    }

    public List<String> getKeywords() {
        return ((StringListXMLEventParser)this.getField("keywords")).getStrings();
    }

    public WCS100ResponsibleParty getResponsibleParty() {
        return (WCS100ResponsibleParty)this.getField("responsibleParty");
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "accessConstraints")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.accessConstraints.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

