/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.pick;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import java.awt.Point;

public class PickedObject
extends AVListImpl {
    protected Point pickPoint;
    protected int colorCode;
    protected Object userObject;
    protected boolean isOnTop = false;
    protected boolean isTerrain = false;

    public PickedObject(int n, Object object) {
        this.pickPoint = null;
        this.colorCode = n;
        this.userObject = object;
        this.isOnTop = false;
        this.isTerrain = false;
    }

    public PickedObject(int n, Object object, Position position, boolean bl) {
        this.pickPoint = null;
        this.colorCode = n;
        this.userObject = object;
        this.isOnTop = false;
        this.isTerrain = bl;
        this.setPosition(position);
    }

    public PickedObject(Point point, int n, Object object, Angle angle, Angle angle2, double d, boolean bl) {
        this.pickPoint = point;
        this.colorCode = n;
        this.userObject = object;
        this.isOnTop = false;
        this.isTerrain = bl;
        this.setPosition(new Position(angle, angle2, d));
    }

    public Point getPickPoint() {
        return this.pickPoint;
    }

    public int getColorCode() {
        return this.colorCode;
    }

    public Object getObject() {
        return this.userObject;
    }

    public void setOnTop() {
        this.isOnTop = true;
    }

    public boolean isOnTop() {
        return this.isOnTop;
    }

    public boolean isTerrain() {
        return this.isTerrain;
    }

    public void setParentLayer(Layer layer) {
        this.setValue("gov.nasa.worldwind.avkey.PickedObject.ParentLayer", layer);
    }

    public Layer getParentLayer() {
        return (Layer)this.getValue("gov.nasa.worldwind.avkey.PickedObject.ParentLayer");
    }

    public void setPosition(Position position) {
        this.setValue("gov.nasa.worldwind.avkey.Position", position);
    }

    public Position getPosition() {
        return (Position)this.getValue("gov.nasa.worldwind.avkey.Position");
    }

    public boolean hasPosition() {
        return this.hasKey("gov.nasa.worldwind.avkey.Position");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PickedObject pickedObject = (PickedObject)object;
        if (this.colorCode != pickedObject.colorCode) {
            return false;
        }
        if (this.isOnTop != pickedObject.isOnTop) {
            return false;
        }
        return !(this.userObject != null ? !this.userObject.equals(pickedObject.userObject) : pickedObject.userObject != null);
    }

    public int hashCode() {
        int n = this.colorCode;
        n = 31 * n + (this.userObject != null ? this.userObject.hashCode() : 0);
        n = 31 * n + (this.isOnTop ? 1 : 0);
        return n;
    }
}

