/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.pick;

import gov.nasa.worldwind.pick.PickedObject;
import java.util.ArrayList;
import java.util.List;

public class PickedObjectList
extends ArrayList<PickedObject> {
    public PickedObjectList() {
    }

    public PickedObjectList(PickedObjectList pickedObjectList) {
        super(pickedObjectList);
    }

    public PickedObject getTopPickedObject() {
        int n = this.size();
        if (1 < n) {
            for (PickedObject pickedObject : this) {
                if (!pickedObject.isOnTop()) continue;
                return pickedObject;
            }
        }
        if (0 < n) {
            return (PickedObject)this.get(0);
        }
        return null;
    }

    public Object getTopObject() {
        PickedObject pickedObject = this.getTopPickedObject();
        return pickedObject != null ? pickedObject.getObject() : null;
    }

    public PickedObject getTerrainObject() {
        for (PickedObject pickedObject : this) {
            if (!pickedObject.isTerrain()) continue;
            return pickedObject;
        }
        return null;
    }

    public PickedObject getMostRecentPickedObject() {
        return this.size() > 0 ? (PickedObject)this.get(this.size() - 1) : null;
    }

    public List<PickedObject> getAllTopPickedObjects() {
        ArrayList<PickedObject> arrayList = null;
        for (PickedObject pickedObject : this) {
            if (!pickedObject.isOnTop()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PickedObject>();
            }
            arrayList.add(pickedObject);
        }
        return arrayList;
    }

    public List<?> getAllTopObjects() {
        ArrayList<Object> arrayList = null;
        for (PickedObject pickedObject : this) {
            if (!pickedObject.isOnTop()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(pickedObject.getObject());
        }
        return arrayList;
    }

    public boolean hasNonTerrainObjects() {
        return this.size() > 1 || this.size() == 1 && this.getTerrainObject() == null;
    }
}

