/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.poi;

import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.exception.ServiceException;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.poi.BasicPointOfInterest;
import gov.nasa.worldwind.poi.Gazetteer;
import gov.nasa.worldwind.poi.POIUtils;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YahooGazetteer
implements Gazetteer {
    protected static final String GEOCODE_SERVICE = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.places%20where%20text%3D";

    @Override
    public List<PointOfInterest> findPlaces(String object) throws NoItemException, ServiceException {
        String string;
        String string2;
        if (object == null || ((String)object).length() < 1) {
            return null;
        }
        try {
            string2 = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.places%20where%20text%3D%22" + URLEncoder.encode((String)object, "UTF-8") + "%22";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.places%20where%20text%3D%22" + ((String)object).replaceAll(" ", "+") + "%22";
        }
        if (this.isNumber((String)object)) {
            object = (String)object + "%20and%20gflags%3D%22R%22";
        }
        if ((string = POIUtils.callService(string2)) == null || string.length() < 1) {
            return null;
        }
        return this.parseLocationString(string);
    }

    protected boolean isNumber(String string) {
        return (string = string.trim()).startsWith("-") || string.startsWith("+") || Character.isDigit(string.charAt(0));
    }

    protected ArrayList<PointOfInterest> parseLocationString(String string) throws WWRuntimeException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/query/results/place", document, XPathConstants.NODESET);
            ArrayList<PointOfInterest> arrayList = new ArrayList<PointOfInterest>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string2 = xPath.evaluate("centroid/latitude", node);
                String string3 = xPath.evaluate("centroid/longitude", node);
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = xPath.evaluate("placeTypeName", node);
                String string5 = xPath.evaluate("name", node);
                String string6 = xPath.evaluate("locality1", node);
                String string7 = xPath.evaluate("admin1", node);
                if (string4 != null && !string4.equals("")) {
                    stringBuilder.append(string4);
                    stringBuilder.append(": ");
                }
                if (string5 != null && !string5.equals("")) {
                    stringBuilder.append(string5);
                    stringBuilder.append(". ");
                }
                if (string6 != null && !string6.equals("")) {
                    stringBuilder.append(string6);
                    stringBuilder.append(", ");
                }
                if (string7 != null && !string7.equals("")) {
                    stringBuilder.append(string7);
                    stringBuilder.append(", ");
                }
                stringBuilder.append(xPath.evaluate("country", node));
                if (string2 == null || string3 == null) continue;
                LatLon latLon = LatLon.fromDegrees(Double.parseDouble(string2), Double.parseDouble(string3));
                BasicPointOfInterest basicPointOfInterest = new BasicPointOfInterest(latLon);
                basicPointOfInterest.setValue("gov.nasa.worldwind.avkey.DisplayName", stringBuilder.toString());
                arrayList.add(basicPointOfInterest);
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string8 = Logging.getMessage("Gazetteer.URLException", string);
            Logging.logger().log(Level.SEVERE, string8);
            throw new WWRuntimeException(string8);
        }
    }
}

