/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.AnnotationLayoutManager;
import gov.nasa.worldwind.render.AnnotationNullLayout;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAnnotation
extends AVListImpl
implements Annotation {
    protected boolean alwaysOnTop = false;
    protected boolean pickEnabled = true;
    protected String text;
    protected AnnotationAttributes attributes;
    protected List<Annotation> childList;
    protected AnnotationLayoutManager layoutManager;
    protected PickSupport pickSupport;
    protected Object delegateOwner;
    protected static DoubleBuffer vertexBuffer;
    protected Map<Object, String> wrappedTextMap;
    protected Map<Object, Rectangle> textBoundsMap;
    protected double minActiveAltitude = -1.7976931348623157E308;
    protected double maxActiveAltitude = Double.MAX_VALUE;

    protected AbstractAnnotation() {
        this.attributes = new AnnotationAttributes();
        this.childList = new ArrayList<Annotation>();
        this.layoutManager = new AnnotationNullLayout();
        this.wrappedTextMap = new HashMap<Object, String>();
        this.textBoundsMap = new HashMap<Object, Rectangle>();
    }

    @Override
    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    @Override
    public boolean isPickEnabled() {
        return this.pickEnabled;
    }

    @Override
    public void setPickEnabled(boolean bl) {
        this.pickEnabled = bl;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.text = string;
    }

    @Override
    public AnnotationAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(AnnotationAttributes annotationAttributes) {
        if (annotationAttributes == null) {
            String string = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = annotationAttributes;
    }

    @Override
    public double getMinActiveAltitude() {
        return this.minActiveAltitude;
    }

    @Override
    public void setMinActiveAltitude(double d) {
        this.minActiveAltitude = d;
    }

    @Override
    public double getMaxActiveAltitude() {
        return this.maxActiveAltitude;
    }

    @Override
    public void setMaxActiveAltitude(double d) {
        this.maxActiveAltitude = d;
    }

    @Override
    public List<? extends Annotation> getChildren() {
        return Collections.unmodifiableList(this.childList);
    }

    @Override
    public void addChild(Annotation annotation) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.childList.add(annotation);
    }

    @Override
    public boolean removeChild(Annotation annotation) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.childList.remove(annotation);
    }

    @Override
    public void removeAllChildren() {
        this.childList.clear();
    }

    @Override
    public AnnotationLayoutManager getLayout() {
        return this.layoutManager;
    }

    @Override
    public void setLayout(AnnotationLayoutManager annotationLayoutManager) {
        if (annotationLayoutManager == null) {
            String string = Logging.getMessage("nullValue.LayoutIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.layoutManager = annotationLayoutManager;
    }

    @Override
    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    @Override
    public void setPickSupport(PickSupport pickSupport) {
        if (pickSupport == null) {
            String string = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport = pickSupport;
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.getAttributes().isVisible()) {
            return;
        }
        drawContext.getAnnotationRenderer().render(drawContext, this, null, drawContext.getCurrentLayer());
    }

    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.getAttributes().isVisible()) {
            return;
        }
        if (!this.isPickEnabled()) {
            return;
        }
        drawContext.getAnnotationRenderer().pick(drawContext, this, null, point, null);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Dimension getPreferredSize(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Dimension dimension = new Dimension(this.getAttributes().getSize());
        if (dimension.width < 1) {
            dimension.width = 1;
        }
        if (dimension.height < 0) {
            dimension.height = 0;
        }
        Rectangle rectangle = this.computeInsetBounds(dimension.width, dimension.height);
        Dimension dimension2 = new Dimension(rectangle.width, rectangle.height);
        dimension2 = this.adjustSizeToText(drawContext, dimension2.width, dimension2.height);
        dimension2 = this.adjustSizeToChildren(drawContext, dimension2.width, dimension2.height);
        Insets insets = this.getAttributes().getInsets();
        return new Dimension(dimension2.width + (insets.left + insets.right), dimension2.height + (insets.top + insets.bottom));
    }

    @Override
    public void renderNow(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.getAttributes().isVisible()) {
            return;
        }
        if (drawContext.isPickingMode() && !this.isPickEnabled()) {
            return;
        }
        this.doRenderNow(drawContext);
    }

    @Override
    public void draw(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d * this.computeOpacity(drawContext);
        this.doDraw(drawContext, n, n2, d2, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTopLevelAnnotation(DrawContext drawContext, int n, int n2, int n3, int n4, double d, double d2, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        this.beginDraw(drawContext, oGLStackHandler);
        try {
            this.applyScreenTransform(drawContext, n, n2, n3, n4, d);
            this.draw(drawContext, n3, n4, d2, position);
        }
        finally {
            this.endDraw(drawContext, oGLStackHandler);
        }
    }

    protected void applyScreenTransform(DrawContext drawContext, int n, int n2, int n3, int n4, double d) {
        double d2 = d * this.computeScale(drawContext);
        Point point = this.getAttributes().getDrawOffset();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTranslated(n, n2, 0.0);
        gL2.glScaled(d2, d2, 1.0);
        gL2.glTranslated(point.x, point.y, 0.0);
        gL2.glTranslated(-n3 / 2, 0.0, 0.0);
    }

    protected double computeScale(DrawContext drawContext) {
        double d = this.attributes.getScale();
        if (this.attributes.isHighlighted()) {
            d *= this.attributes.getHighlightScale();
        }
        return d;
    }

    protected double computeOpacity(DrawContext drawContext) {
        double d = this.attributes.getOpacity();
        if (this.attributes.isHighlighted()) {
            d = 1.0;
        }
        return d;
    }

    protected abstract void doRenderNow(DrawContext var1);

    protected abstract Rectangle computeBounds(DrawContext var1);

    @Override
    public Rectangle getBounds(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView().getViewport() == null) {
            return null;
        }
        return this.computeBounds(drawContext);
    }

    protected void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (!this.getAttributes().isVisible()) {
            return;
        }
        if (!drawContext.isPickingMode() || this.isPickEnabled()) {
            this.drawContent(drawContext, n, n2, d, position);
        }
        this.drawChildren(drawContext, n, n2, d, position);
    }

    protected void drawContent(DrawContext drawContext, int n, int n2, double d, Position position) {
        this.drawBackground(drawContext, n, n2, d, position);
        this.drawBackgroundImage(drawContext, n, n2, d, position);
        this.drawBorder(drawContext, n, n2, d, position);
        this.drawText(drawContext, n, n2, d, position);
    }

    protected void beginDraw(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        oGLStackHandler.pushModelviewIdentity(gL2);
    }

    protected void endDraw(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        oGLStackHandler.pop(gL2);
    }

    protected void drawBackground(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (drawContext.isPickingMode()) {
            this.bindPickableObject(drawContext, position);
        }
        this.applyColor(drawContext, this.getAttributes().getBackgroundColor(), d, true);
        this.drawCallout(drawContext, 6, n, n2, false);
    }

    protected void drawBackgroundImage(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (drawContext.isPickingMode()) {
            return;
        }
        WWTexture wWTexture = this.getAttributes().getBackgroundTexture(drawContext);
        if (wWTexture == null) {
            return;
        }
        this.doDrawBackgroundTexture(drawContext, n, n2, d, position, wWTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawBackgroundTexture(DrawContext drawContext, int n, int n2, double d, Position position, WWTexture wWTexture) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        try {
            if (wWTexture.bind(drawContext)) {
                gL2.glEnable(3553);
                this.transformImageCoordsToBackgroundImageCoords(drawContext, wWTexture);
                this.transformBackgroundImageCoordsToAnnotationCoords(drawContext, n, n2, wWTexture);
                this.applyBackgroundTextureState(drawContext, n, n2, d, wWTexture);
                this.drawCallout(drawContext, 6, n, n2, true);
            }
        }
        finally {
            gL2.glPopMatrix();
            gL2.glMatrixMode(5888);
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
        }
    }

    protected void applyBackgroundTextureState(DrawContext drawContext, int n, int n2, double d, WWTexture wWTexture) {
        GL gL = drawContext.getGL();
        String string = this.getAttributes().getImageRepeat();
        int n3 = string.equals("gov.nasa.worldwind.avkey.RepeatX") || string.equals("gov.nasa.worldwind.avkey.RepeatXY") ? 10497 : 33069;
        int n4 = string.equals("gov.nasa.worldwind.avkey.RepeatY") || string.equals("gov.nasa.worldwind.avkey.RepeatXY") ? 10497 : 33069;
        gL.glTexParameteri(3553, 10242, n3);
        gL.glTexParameteri(3553, 10243, n4);
        double d2 = d * this.getAttributes().getImageOpacity();
        this.applyColor(drawContext, Color.WHITE, d2, true);
    }

    protected void transformImageCoordsToBackgroundImageCoords(DrawContext drawContext, WWTexture wWTexture) {
        GL2 gL2 = drawContext.getGL().getGL2();
        wWTexture.applyInternalTransform(drawContext);
        gL2.glScaled(1.0, -1.0, 1.0);
        gL2.glTranslated(0.0, -1.0, 0.0);
        gL2.glScaled(1.0 / (double)wWTexture.getWidth(drawContext), 1.0 / (double)wWTexture.getHeight(drawContext), 1.0);
    }

    protected void transformBackgroundImageCoordsToAnnotationCoords(DrawContext drawContext, int n, int n2, WWTexture wWTexture) {
        GL2 gL2 = drawContext.getGL().getGL2();
        double d = this.getAttributes().getImageScale();
        gL2.glScaled(1.0 / d, 1.0 / d, 1.0);
        Point point = this.getAttributes().getImageOffset();
        if (point != null) {
            gL2.glTranslated(-point.x, -point.y, 0.0);
        }
        gL2.glScaled(1.0, -1.0, 1.0);
        gL2.glTranslated(0.0, -n2, 0.0);
    }

    protected void drawBorder(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (this.getAttributes().getBorderWidth() <= 0.0) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        if (drawContext.isPickingMode()) {
            gL2.glDisable(2848);
        } else {
            gL2.glEnable(2848);
            gL2.glHint(3154, this.getAttributes().getAntiAliasHint());
        }
        if (drawContext.isPickingMode() || this.getAttributes().getBorderStippleFactor() <= 0) {
            gL2.glDisable(2852);
        } else {
            gL2.glEnable(2852);
            gL2.glLineStipple(this.getAttributes().getBorderStippleFactor(), this.getAttributes().getBorderStipplePattern());
        }
        gL2.glLineWidth((float)this.getAttributes().getBorderWidth());
        this.applyColor(drawContext, this.getAttributes().getBorderColor(), d, false);
        this.drawCallout(drawContext, 3, n, n2, false);
    }

    protected void drawText(DrawContext drawContext, int n, int n2, double d, Position position) {
        Cloneable cloneable;
        Object object;
        AnnotationAttributes annotationAttributes = this.getAttributes();
        String string = this.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Rectangle rectangle = this.computeInsetBounds(n, n2);
        if (drawContext.isPickingMode()) {
            if (drawContext.getPickPoint() == null) {
                return;
            }
            object = this.transformByModelview(drawContext, rectangle);
            if (!((Rectangle)object).contains((Point)(cloneable = this.glPointFromAWTPoint(drawContext, drawContext.getPickPoint())))) {
                return;
            }
        }
        object = this.getWrappedText(drawContext, rectangle.width, rectangle.height, string, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        cloneable = this.getTextBounds(drawContext, (String)object, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        int n3 = (int)((double)((Rectangle)cloneable).y / 6.0);
        int n4 = rectangle.x;
        int n5 = rectangle.y + n3 + 2;
        if (annotationAttributes.getTextAlign().equals("gov.nasa.worldwind.avkey.Center")) {
            n4 = (int)rectangle.getCenterX();
        } else if (annotationAttributes.getTextAlign().equals("gov.nasa.worldwind.avkey.Right")) {
            n4 = (int)rectangle.getMaxX();
        }
        n5 = rectangle.height > 0 ? (n5 += rectangle.height) : (n5 += ((Rectangle)cloneable).height);
        int n6 = (int)((RectangularShape)cloneable).getMinY();
        Object object2 = this.delegateOwner != null ? this.delegateOwner : this;
        this.drawText(drawContext, n4, n5, n6, d, object2, position, (String)object);
    }

    protected void drawText(DrawContext drawContext, int n, int n2, int n3, double d, Object object, Position position, String string) {
        boolean bl = MultiLineTextRenderer.containsHTML(string);
        if (bl) {
            this.drawHTML(drawContext, n, n2, n3, d, object, position, string);
        } else {
            this.drawPlainText(drawContext, n, n2, n3, d, object, position, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPlainText(DrawContext drawContext, int n, int n2, int n3, double d, Object object, Position position, String string) {
        AnnotationAttributes annotationAttributes = this.getAttributes();
        MultiLineTextRenderer multiLineTextRenderer = this.getMultiLineTextRenderer(drawContext, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        Color color = this.modulateColorOpacity(annotationAttributes.getTextColor(), d);
        Color color2 = this.modulateColorOpacity(annotationAttributes.getBackgroundColor(), d);
        multiLineTextRenderer.setTextColor(color);
        multiLineTextRenderer.setBackColor(color2);
        if (drawContext.isPickingMode()) {
            multiLineTextRenderer.pick(string, n, n2, n3, drawContext, this.pickSupport, object, position);
        } else {
            multiLineTextRenderer.getTextRenderer().begin3DRendering();
            try {
                multiLineTextRenderer.draw(string, n, n2, n3, annotationAttributes.getEffect());
            }
            finally {
                multiLineTextRenderer.getTextRenderer().end3DRendering();
            }
        }
    }

    protected void drawHTML(DrawContext drawContext, int n, int n2, int n3, double d, Object object, Position position, String string) {
        AnnotationAttributes annotationAttributes = this.getAttributes();
        MultiLineTextRenderer multiLineTextRenderer = this.getMultiLineTextRenderer(drawContext, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        Color color = this.modulateColorOpacity(annotationAttributes.getTextColor(), d);
        Color color2 = this.modulateColorOpacity(annotationAttributes.getBackgroundColor(), d);
        multiLineTextRenderer.setTextColor(color);
        multiLineTextRenderer.setBackColor(color2);
        if (drawContext.isPickingMode()) {
            multiLineTextRenderer.pickHTML(string, n, n2, drawContext.getTextRendererCache(), drawContext, this.pickSupport, object, position);
        } else {
            multiLineTextRenderer.drawHTML(string, n, n2, drawContext.getTextRendererCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawChildren(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (this.childList.isEmpty()) {
            return;
        }
        Rectangle rectangle = this.computeInsetBounds(n, n2);
        this.beginDrawChildren(drawContext, rectangle);
        try {
            this.doDrawChildren(drawContext, rectangle, d, position);
        }
        finally {
            this.endDrawChildren(drawContext);
        }
    }

    protected void doDrawChildren(DrawContext drawContext, Rectangle rectangle, double d, Position position) {
        this.layoutManager.setPickSupport(this.pickSupport);
        this.layoutManager.drawAnnotations(drawContext, rectangle, this.childList, d, position);
    }

    protected void beginDrawChildren(DrawContext drawContext, Rectangle rectangle) {
        this.layoutManager.beginDrawAnnotations(drawContext, rectangle);
    }

    protected void endDrawChildren(DrawContext drawContext) {
        this.layoutManager.endDrawAnnotations(drawContext);
    }

    protected void bindPickableObject(DrawContext drawContext, Position position) {
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        Object object = this.delegateOwner != null ? this.delegateOwner : this;
        this.pickSupport.addPickableObject(n, object, position, false);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
    }

    protected void drawCallout(DrawContext drawContext, int n, int n2, int n3, boolean bl) {
        String string = this.getAttributes().getFrameShape();
        if (string == null) {
            return;
        }
        Point point = this.getAttributes().getDrawOffset();
        Point point2 = new Point(n2 / 2 - point.x, -point.y);
        int n4 = this.getAttributes().getLeaderGapWidth();
        int n5 = this.getAttributes().getCornerRadius();
        DoubleBuffer doubleBuffer = vertexBuffer;
        doubleBuffer = this.getAttributes().getLeader().equals("gov.nasa.worldwind.avkey.ShapeTriangle") ? FrameFactory.createShapeWithLeaderBuffer(string, n2, n3, point2, n4, n5, doubleBuffer) : FrameFactory.createShapeBuffer(string, n2, n3, n5, doubleBuffer);
        if (doubleBuffer != null) {
            vertexBuffer = doubleBuffer;
        }
        if (doubleBuffer == null) {
            return;
        }
        int n6 = doubleBuffer.remaining() / 2;
        if (bl) {
            FrameFactory.drawBuffer(drawContext, n, n6, doubleBuffer, doubleBuffer);
        } else {
            FrameFactory.drawBuffer(drawContext, n, n6, doubleBuffer);
        }
    }

    protected void applyColor(DrawContext drawContext, Color color, double d, boolean bl) {
        if (drawContext.isPickingMode()) {
            return;
        }
        double d2 = d * ((double)color.getAlpha() / 255.0);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(3042);
        OGLUtil.applyBlending(gL2, bl);
        OGLUtil.applyColor(gL2, color, d2, bl);
    }

    protected Color modulateColorOpacity(Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = fArray[3] * (float)d;
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    protected Rectangle transformByModelview(DrawContext drawContext, Rectangle rectangle) {
        double[] dArray = new double[16];
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glGetDoublev(2982, dArray, 0);
        Matrix matrix = Matrix.fromArray(dArray, 0, false);
        Vec4 vec4 = new Vec4(rectangle.x, rectangle.y, 1.0);
        Vec4 vec42 = new Vec4(rectangle.width, rectangle.height, 0.0);
        vec4 = vec4.transformBy4(matrix);
        vec42 = vec42.transformBy3(matrix);
        return new Rectangle((int)vec4.x, (int)vec4.y, (int)vec42.x, (int)vec42.y);
    }

    protected Point glPointFromAWTPoint(DrawContext drawContext, Point point) {
        if (drawContext.getView() == null || drawContext.getView().getViewport() == null) {
            return null;
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        return new Point(point.x, rectangle.height - point.y - 1);
    }

    protected TextRenderer getTextRenderer(DrawContext drawContext, Font font) {
        return OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
    }

    protected MultiLineTextRenderer getMultiLineTextRenderer(DrawContext drawContext, Font font, String string) {
        TextRenderer textRenderer = this.getTextRenderer(drawContext, font);
        MultiLineTextRenderer multiLineTextRenderer = new MultiLineTextRenderer(textRenderer);
        multiLineTextRenderer.setTextAlign(string);
        return multiLineTextRenderer;
    }

    protected String getWrappedText(DrawContext drawContext, int n, int n2, String string, Font font, String string2) {
        TextCacheKey textCacheKey = new TextCacheKey(n, n2, string, font, string2);
        String string3 = this.wrappedTextMap.get(textCacheKey);
        if (string3 == null) {
            string3 = this.wrapText(drawContext, n, n2, string, font, string2);
            this.wrappedTextMap.put(textCacheKey, string3);
        }
        return string3;
    }

    protected Rectangle getTextBounds(DrawContext drawContext, String string, Font font, String string2) {
        TextCacheKey textCacheKey = new TextCacheKey(0, 0, string, font, string2);
        Rectangle rectangle = this.textBoundsMap.get(textCacheKey);
        if (rectangle == null) {
            rectangle = this.computeTextBounds(drawContext, string, font, string2);
            this.textBoundsMap.put(textCacheKey, rectangle);
        }
        return new Rectangle(rectangle);
    }

    protected String wrapText(DrawContext drawContext, int n, int n2, String string, Font font, String string2) {
        if (string.length() > 0) {
            MultiLineTextRenderer multiLineTextRenderer = this.getMultiLineTextRenderer(drawContext, font, string2);
            if (MultiLineTextRenderer.containsHTML(string)) {
                string = MultiLineTextRenderer.processLineBreaksHTML(string);
                string = multiLineTextRenderer.wrapHTML(string, n, n2, drawContext.getTextRendererCache());
            } else {
                string = multiLineTextRenderer.wrap(string, n, n2);
            }
        }
        return string;
    }

    protected Rectangle computeTextBounds(DrawContext drawContext, String string, Font font, String string2) {
        if (string.length() > 0) {
            MultiLineTextRenderer multiLineTextRenderer = this.getMultiLineTextRenderer(drawContext, font, string2);
            if (MultiLineTextRenderer.containsHTML(string)) {
                return multiLineTextRenderer.getBoundsHTML(string, drawContext.getTextRendererCache());
            }
            return multiLineTextRenderer.getBounds(string);
        }
        return new Rectangle();
    }

    protected Rectangle computeInsetBounds(int n, int n2) {
        Insets insets = this.getAttributes().getInsets();
        int n3 = n - (insets.left + insets.right);
        int n4 = n2 - (insets.bottom + insets.top);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0 && n2 > 0) {
            n4 = 1;
        } else if (n4 < 0) {
            n4 = 0;
        }
        return new Rectangle(insets.left, insets.bottom, n3, n4);
    }

    protected Rectangle computeFreeBounds(DrawContext drawContext, int n, int n2) {
        AnnotationAttributes annotationAttributes = this.getAttributes();
        Rectangle rectangle = this.computeInsetBounds(n, n2);
        String string = this.getWrappedText(drawContext, n, n2, this.getText(), annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        Rectangle rectangle2 = this.getTextBounds(drawContext, string, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        rectangle.height -= rectangle2.height;
        return rectangle;
    }

    protected Dimension adjustSizeToText(DrawContext drawContext, int n, int n2) {
        AnnotationAttributes annotationAttributes = this.getAttributes();
        String string = this.getWrappedText(drawContext, n, n2, this.getText(), annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        Rectangle rectangle = this.getTextBounds(drawContext, string, annotationAttributes.getFont(), annotationAttributes.getTextAlign());
        if (annotationAttributes.getAdjustWidthToText().equals("gov.nasa.worldwind.avkey.SizeFitText") && string.length() > 0) {
            n = rectangle.width;
        }
        if (n2 <= 0) {
            n2 = rectangle.height;
        }
        return new Dimension(n, n2);
    }

    protected Dimension adjustSizeToChildren(DrawContext drawContext, int n, int n2) {
        Dimension dimension;
        if (this.layoutManager != null && (dimension = this.layoutManager.getPreferredSize(drawContext, this.childList)) != null) {
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (n2 < dimension.height) {
                n2 = dimension.height;
            }
        }
        return new Dimension(n, n2);
    }

    protected Rectangle computeBoundingRectangle(Rectangle rectangle, int n, int n2) {
        if (rectangle.contains(n, n2)) {
            return rectangle;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n < rectangle.x) {
            n3 = n - rectangle.x;
            n5 = -n3;
        } else if (n > rectangle.x + rectangle.width - 1) {
            n5 = n - (rectangle.x + rectangle.width - 1);
        }
        if (n2 < rectangle.y) {
            n4 = n2 - rectangle.y;
            n6 = -n4;
        } else if (n2 > rectangle.y + rectangle.height - 1) {
            n6 = n2 - (rectangle.y + rectangle.height - 1);
        }
        rectangle.setBounds(rectangle.x + n3, rectangle.y + n4, rectangle.width + n5, rectangle.height + n6);
        return rectangle;
    }

    @Override
    public String getRestorableState() {
        String string;
        RestorableSupport restorableSupport = null;
        if (this.attributes != null && (string = this.attributes.getRestorableState()) != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.text != null) {
            restorableSupport.addStateValueAsString("text", this.text, true);
        }
        restorableSupport.addStateValueAsBoolean("alwaysOnTop", this.alwaysOnTop);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        Boolean bl;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AnnotationAttributes annotationAttributes = this.attributes;
        if (annotationAttributes == null) {
            annotationAttributes = new AnnotationAttributes();
        }
        annotationAttributes.restoreState(string);
        this.setAttributes(annotationAttributes);
        String string4 = restorableSupport.getStateValueAsString("text");
        if (string4 != null) {
            this.setText(string4);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("alwaysOnTop")) != null) {
            this.setAlwaysOnTop(bl);
        }
    }

    protected static class TextCacheKey {
        private final int width;
        private final int height;
        private final String text;
        private final Font font;
        private final String align;

        public TextCacheKey(int n, int n2, String string, Font font, String string2) {
            this.width = n;
            this.height = n2;
            this.text = string;
            this.font = font;
            this.align = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextCacheKey textCacheKey = (TextCacheKey)object;
            return this.width == textCacheKey.width && this.height == textCacheKey.height && this.align.equals(textCacheKey.align) && (this.text != null ? this.text.equals(textCacheKey.text) : textCacheKey.text == null) && (this.font != null ? this.font.equals(textCacheKey.font) : textCacheKey.font == null);
        }

        public int hashCode() {
            int n = this.width;
            n = 31 * n + this.height;
            n = 31 * n + (this.text != null ? this.text.hashCode() : 0);
            n = 31 * n + (this.font != null ? this.font.hashCode() : 0);
            n = 31 * n + (this.align != null ? this.align.hashCode() : 0);
            return n;
        }
    }
}

