/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.SurfaceObject;
import gov.nasa.worldwind.render.SurfaceObjectTileBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSurfaceObject
extends WWObjectImpl
implements SurfaceObject {
    protected boolean visible;
    protected final long uniqueId;
    protected long lastModifiedTime;
    protected Object delegateOwner;
    protected boolean enableBatchPicking;
    protected boolean drawBoundingSectors;
    protected Map<Object, CacheEntry> extentCache = new HashMap<Object, CacheEntry>();
    protected Layer pickLayer;
    protected PickSupport pickSupport = new PickSupport();
    protected SurfaceObjectTileBuilder pickTileBuilder;
    protected static long nextUniqueId = 1L;

    public AbstractSurfaceObject() {
        this.visible = true;
        this.uniqueId = AbstractSurfaceObject.nextUniqueId();
        this.lastModifiedTime = System.currentTimeMillis();
        this.enableBatchPicking = true;
    }

    public AbstractSurfaceObject(AbstractSurfaceObject abstractSurfaceObject) {
        super(abstractSurfaceObject);
        this.visible = abstractSurfaceObject.visible;
        this.uniqueId = AbstractSurfaceObject.nextUniqueId();
        this.lastModifiedTime = System.currentTimeMillis();
        this.enableBatchPicking = abstractSurfaceObject.enableBatchPicking;
    }

    protected static synchronized long nextUniqueId() {
        return nextUniqueId++;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        this.updateModifiedTime();
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return new SurfaceObjectStateKey(this.getUniqueId(), this.lastModifiedTime);
    }

    @Override
    public double getDistanceFromEye() {
        return 0.0;
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    public boolean isDrawBoundingSectors() {
        return this.drawBoundingSectors;
    }

    public void setDrawBoundingSectors(boolean bl) {
        this.drawBoundingSectors = bl;
        this.updateModifiedTime();
    }

    @Override
    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    @Override
    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CacheEntry cacheEntry = this.extentCache.get(drawContext.getGlobe().getGlobeStateKey());
        if (cacheEntry != null) {
            return (Extent)cacheEntry.object;
        }
        cacheEntry = new CacheEntry(this.computeExtent(drawContext), drawContext);
        this.extentCache.put(drawContext.getGlobe().getGlobeStateKey(), cacheEntry);
        return (Extent)cacheEntry.object;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!drawContext.isOrderedRenderingMode()) {
            this.makeOrderedPreRenderable(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.pickOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchPicking()) {
                this.pickBatched(drawContext, this.pickSupport);
            }
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected long getUniqueId() {
        return this.uniqueId;
    }

    protected void updateModifiedTime() {
        this.lastModifiedTime = System.currentTimeMillis();
    }

    protected void clearCaches() {
        this.extentCache.clear();
    }

    protected Extent computeExtent(DrawContext drawContext) {
        List<Sector> list = this.getSectors(drawContext);
        if (list == null) {
            return null;
        }
        return this.computeExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), list);
    }

    protected Extent computeExtent(Globe globe, double d, List<Sector> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return Sector.computeBoundingBox(globe, d, list.get(0));
        }
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        for (Sector sector : list) {
            Box box = Sector.computeBoundingBox(globe, d, sector);
            arrayList.addAll(Arrays.asList(box.getCorners()));
        }
        return Box.computeBoundingBox(arrayList);
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    protected boolean intersectsPickFrustum(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        return extent != null && drawContext.getPickFrustums().intersectsAny(extent);
    }

    protected boolean intersectsVisibleSector(DrawContext drawContext) {
        if (drawContext.getVisibleSector() == null) {
            return false;
        }
        List<Sector> list = this.getSectors(drawContext);
        if (list == null) {
            return false;
        }
        for (Sector sector : list) {
            if (!sector.intersects(drawContext.getVisibleSector())) continue;
            return true;
        }
        return false;
    }

    protected void makeOrderedPreRenderable(DrawContext drawContext) {
        if (!this.intersectsVisibleSector(drawContext)) {
            return;
        }
        if ((drawContext.getCurrentLayer() == null || drawContext.getCurrentLayer().isPickEnabled()) && this.intersectsPickFrustum(drawContext)) {
            this.buildPickRepresentation(drawContext);
        }
        if (this.intersectsFrustum(drawContext)) {
            drawContext.addOrderedSurfaceRenderable(this);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (!drawContext.isPickingMode()) {
            return;
        }
        if (!this.intersectsVisibleSector(drawContext) || !this.intersectsFrustum(drawContext)) {
            return;
        }
        this.pickLayer = drawContext.getCurrentLayer();
        drawContext.addOrderedSurfaceRenderable(this);
    }

    protected void pickOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        Color color = drawContext.getUniquePickColor();
        pickSupport.addPickableObject(this.createPickedObject(drawContext, color));
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        this.drawPickRepresentation(drawContext);
    }

    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        Object object = this.getDelegateOwner() != null ? this.getDelegateOwner() : this;
        Position position = drawContext.getPickedObjects().getTerrainObject() != null ? drawContext.getPickedObjects().getTerrainObject().getPosition() : null;
        return new PickedObject(color.getRGB(), object, position, false);
    }

    protected void pickBatched(DrawContext drawContext, PickSupport pickSupport) {
        OrderedRenderable orderedRenderable = drawContext.getOrderedSurfaceRenderables().peek();
        while (orderedRenderable != null && orderedRenderable instanceof AbstractSurfaceObject) {
            AbstractSurfaceObject abstractSurfaceObject = (AbstractSurfaceObject)orderedRenderable;
            if (abstractSurfaceObject.pickLayer != this.pickLayer || !abstractSurfaceObject.isEnableBatchPicking()) break;
            drawContext.getOrderedSurfaceRenderables().poll();
            abstractSurfaceObject.pickOrderedRenderable(drawContext, pickSupport);
            orderedRenderable = drawContext.getOrderedSurfaceRenderables().peek();
        }
    }

    protected void drawOrderedRenderable(DrawContext drawContext) {
        SurfaceTileDrawContext surfaceTileDrawContext = (SurfaceTileDrawContext)drawContext.getValue("gov.nasa.worldwind.avkey.SurfaceTileDrawContext");
        if (surfaceTileDrawContext == null) {
            Logging.logger().warning(Logging.getMessage("nullValue.SurfaceTileDrawContextIsNull"));
            return;
        }
        this.drawGeographic(drawContext, surfaceTileDrawContext);
        if (this.isDrawBoundingSectors() && !drawContext.isPickingMode()) {
            this.drawBoundingSectors(drawContext, surfaceTileDrawContext);
        }
    }

    protected abstract void drawGeographic(DrawContext var1, SurfaceTileDrawContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPickRepresentation(DrawContext drawContext) {
        if (this.pickTileBuilder == null) {
            this.pickTileBuilder = this.createPickTileBuilder();
        }
        boolean bl = drawContext.isPickingMode();
        boolean bl2 = drawContext.isOrderedRenderingMode();
        try {
            if (!bl) {
                drawContext.enablePickingMode();
            }
            drawContext.setOrderedRenderingMode(true);
            this.pickTileBuilder.buildTiles(drawContext, Arrays.asList(this));
        }
        finally {
            if (!bl) {
                drawContext.disablePickingMode();
            }
            drawContext.setOrderedRenderingMode(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPickRepresentation(DrawContext drawContext) {
        if (this.pickTileBuilder == null || this.pickTileBuilder.getTileCount(drawContext) == 0) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 8);
        try {
            gL2.glEnable(2884);
            gL2.glCullFace(1029);
            gL2.glPolygonMode(1028, 6914);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.pickTileBuilder.getTiles(drawContext));
        }
        finally {
            oGLStackHandler.pop(gL2);
            this.pickTileBuilder.clearTiles(drawContext);
        }
    }

    protected SurfaceObjectTileBuilder createPickTileBuilder() {
        return new SurfaceObjectTileBuilder(new Dimension(512, 512), 32828, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBoundingSectors(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        List<Sector> list = this.getSectors(drawContext);
        if (list == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 16389;
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, n);
        oGLStackHandler.pushModelview(gL2);
        try {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
            gL2.glDisable(2848);
            gL2.glLineWidth(1.0f);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
            Matrix matrix = surfaceTileDrawContext.getModelviewMatrix();
            gL2.glMultMatrixd(matrix.toArray(new double[16], 0, false), 0);
            for (Sector sector : list) {
                LatLon[] latLonArray = sector.getCorners();
                gL2.glBegin(2);
                gL2.glVertex2f((float)latLonArray[0].getLongitude().degrees, (float)latLonArray[0].getLatitude().degrees);
                gL2.glVertex2f((float)latLonArray[1].getLongitude().degrees, (float)latLonArray[1].getLatitude().degrees);
                gL2.glVertex2f((float)latLonArray[2].getLongitude().degrees, (float)latLonArray[2].getLatitude().degrees);
                gL2.glVertex2f((float)latLonArray[3].getLongitude().degrees, (float)latLonArray[3].getLatitude().degrees);
                gL2.glEnd();
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected static class SurfaceObjectStateKey
    implements Cacheable {
        protected final long uniqueId;
        protected final long modifiedTime;

        public SurfaceObjectStateKey(long l, long l2) {
            this.uniqueId = l;
            this.modifiedTime = l2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SurfaceObjectStateKey surfaceObjectStateKey = (SurfaceObjectStateKey)object;
            return this.uniqueId == surfaceObjectStateKey.uniqueId && this.modifiedTime == surfaceObjectStateKey.modifiedTime;
        }

        public int hashCode() {
            return 31 * (int)(this.uniqueId ^ this.uniqueId >>> 32) + (int)(this.modifiedTime ^ this.modifiedTime >>> 32);
        }

        @Override
        public long getSizeInBytes() {
            return 16L;
        }
    }

    protected static class CacheEntry {
        public Object object;
        protected Object globeStateKey;

        public CacheEntry(Object object, DrawContext drawContext) {
            this.object = object;
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }
    }
}

