/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSurfaceRenderable
extends AbstractSurfaceObject {
    private double opacity = 1.0;

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.updateModifiedTime();
    }

    protected Angle getViewHeading(DrawContext drawContext) {
        Angle angle = Angle.ZERO;
        if (drawContext.getView() instanceof OrbitView) {
            angle = drawContext.getView().getHeading();
        }
        return angle;
    }

    protected double computePixelSizeAtLocation(DrawContext drawContext, LatLon latLon) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), globe.getElevation(latLon.getLatitude(), latLon.getLongitude()));
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        return drawContext.getView().computePixelSizeAtDistance(d);
    }

    protected double computeDrawPixelSize(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        return drawContext.getGlobe().getRadius() * surfaceTileDrawContext.getSector().getDeltaLatRadians() / (double)surfaceTileDrawContext.getViewport().height;
    }

    protected Vec4 computeDrawPoint(LatLon latLon, SurfaceTileDrawContext surfaceTileDrawContext) {
        Vec4 vec4 = new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 1.0);
        return vec4.transformBy4(surfaceTileDrawContext.getModelviewMatrix());
    }

    protected Sector computeRotatedSectorBounds(Sector sector, LatLon latLon, Angle angle) {
        if (Math.abs(angle.degrees) < 0.001) {
            return sector;
        }
        LatLon[] latLonArray = new LatLon[]{new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()), new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()), new LatLon(sector.getMinLatitude(), sector.getMinLongitude()), new LatLon(sector.getMinLatitude(), sector.getMaxLongitude())};
        for (int i = 0; i < latLonArray.length; ++i) {
            Angle angle2 = LatLon.greatCircleAzimuth(latLon, latLonArray[i]);
            Angle angle3 = LatLon.greatCircleDistance(latLon, latLonArray[i]);
            latLonArray[i] = LatLon.greatCircleEndPosition(latLon, angle2.add(angle), angle3);
        }
        return Sector.boundingSector(Arrays.asList(latLonArray));
    }

    protected List<Sector> computeNormalizedSectors(Sector sector) {
        Angle angle = sector.getMinLatitude();
        Angle angle2 = sector.getMaxLatitude();
        Angle angle3 = sector.getMinLongitude();
        Angle angle4 = sector.getMaxLongitude();
        angle = angle.degrees >= -90.0 ? angle : Angle.NEG90;
        angle2 = angle2.degrees <= 90.0 ? angle2 : Angle.POS90;
        ArrayList<Sector> arrayList = new ArrayList<Sector>();
        if (angle3.degrees >= -180.0 && angle4.degrees <= 180.0) {
            arrayList.add(new Sector(angle, angle2, angle3, angle4));
        } else if (angle3.degrees < -180.0 && angle4.degrees > 180.0) {
            arrayList.add(new Sector(angle, angle2, Angle.NEG180, Angle.POS180));
        } else {
            while (angle3.degrees < -180.0) {
                angle3 = angle3.addDegrees(360.0);
            }
            while (angle4.degrees > 180.0) {
                angle4 = angle4.subtractDegrees(360.0);
            }
            if (angle.degrees > angle2.degrees) {
                sector = new Sector(angle, angle2, angle3, angle4);
                arrayList.addAll(Arrays.asList(Sector.splitBoundingSectors(sector)));
            } else {
                arrayList.add(new Sector(angle, angle2, Angle.NEG180, Angle.POS180));
            }
        }
        return arrayList;
    }

    protected int computeHemisphereOffset(Sector sector, LatLon latLon) {
        Angle angle = sector.getCentroid().getLongitude();
        Angle angle2 = latLon.getLongitude();
        if (Math.abs(angle2.degrees - angle.degrees) > 180.0 && Math.signum(angle2.degrees) != Math.signum(angle.degrees)) {
            return (int)(360.0 * Math.signum(angle.degrees));
        }
        return 0;
    }

    protected void applyPremultipliedAlphaColor(GL2 gL2, Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp(d, 0.0, 1.0);
        fArray[0] = fArray[0] * fArray[3];
        fArray[1] = fArray[1] * fArray[3];
        fArray[2] = fArray[2] * fArray[3];
        gL2.glColor4fv(fArray, 0);
    }

    protected void applyNonPremultipliedAlphaColor(GL2 gL2, Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp(d, 0.0, 1.0);
        gL2.glColor4fv(fArray, 0);
    }
}

