/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.combine.Combinable;
import gov.nasa.worldwind.util.combine.CombineContext;
import gov.nasa.worldwind.util.measure.AreaMeasurer;
import java.awt.Color;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractSurfaceShape
extends AbstractSurfaceObject
implements SurfaceShape,
Movable,
Movable2,
Combinable,
Draggable {
    protected static final Material DEFAULT_INTERIOR_MATERIAL = Material.LIGHT_GRAY;
    protected static final Material DEFAULT_OUTLINE_MATERIAL = Material.DARK_GRAY;
    protected static final Material DEFAULT_HIGHLIGHT_MATERIAL = Material.WHITE;
    protected static final String DEFAULT_PATH_TYPE = "gov.nasa.worldwind.avkey.GreatCircle";
    protected static final int DEFAULT_TEXELS_PER_EDGE_INTERVAL = 50;
    protected static final int DEFAULT_MIN_EDGE_INTERVALS = 0;
    protected static final int DEFAULT_MAX_EDGE_INTERVALS = 100;
    protected static final ShapeAttributes defaultAttrs = new BasicShapeAttributes();
    protected boolean highlighted;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected ShapeAttributes normalAttrs;
    protected ShapeAttributes highlightAttrs;
    protected ShapeAttributes activeAttrs = this.createActiveAttributes();
    protected String pathType = "gov.nasa.worldwind.avkey.GreatCircle";
    protected double texelsPerEdgeInterval = 50.0;
    protected int minEdgeIntervals = 0;
    protected int maxEdgeIntervals = 100;
    protected List<List<LatLon>> activeGeometry = new ArrayList<List<LatLon>>();
    protected List<List<LatLon>> activeOutlineGeometry = new ArrayList<List<LatLon>>();
    protected WWTexture texture;
    protected Map<Object, AbstractSurfaceObject.CacheEntry> sectorCache = new HashMap<Object, AbstractSurfaceObject.CacheEntry>();
    protected Map<Object, AbstractSurfaceObject.CacheEntry> geometryCache = new HashMap<Object, AbstractSurfaceObject.CacheEntry>();
    protected OGLStackHandler stackHandler = new OGLStackHandler();
    protected static FloatBuffer vertexBuffer;
    protected AreaMeasurer areaMeasurer;
    protected long areaMeasurerLastModifiedTime;

    public AbstractSurfaceShape() {
    }

    public AbstractSurfaceShape(ShapeAttributes shapeAttributes) {
        this.setAttributes(shapeAttributes);
    }

    public AbstractSurfaceShape(AbstractSurfaceShape abstractSurfaceShape) {
        super(abstractSurfaceShape);
        this.highlighted = abstractSurfaceShape.highlighted;
        this.normalAttrs = abstractSurfaceShape.normalAttrs;
        this.highlightAttrs = abstractSurfaceShape.highlightAttrs;
        this.pathType = abstractSurfaceShape.pathType;
        this.texelsPerEdgeInterval = abstractSurfaceShape.texelsPerEdgeInterval;
        this.minEdgeIntervals = abstractSurfaceShape.minEdgeIntervals;
        this.maxEdgeIntervals = abstractSurfaceShape.maxEdgeIntervals;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
        this.updateModifiedTime();
    }

    @Override
    public ShapeAttributes getAttributes() {
        return this.normalAttrs;
    }

    @Override
    public void setAttributes(ShapeAttributes shapeAttributes) {
        this.normalAttrs = shapeAttributes;
        this.updateModifiedTime();
    }

    @Override
    public ShapeAttributes getHighlightAttributes() {
        return this.highlightAttrs;
    }

    @Override
    public void setHighlightAttributes(ShapeAttributes shapeAttributes) {
        this.highlightAttrs = shapeAttributes;
        this.updateModifiedTime();
    }

    @Override
    public String getPathType() {
        return this.pathType;
    }

    @Override
    public void setPathType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.pathType = string;
        this.onShapeChanged();
    }

    @Override
    public double getTexelsPerEdgeInterval() {
        return this.texelsPerEdgeInterval;
    }

    @Override
    public void setTexelsPerEdgeInterval(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "texelsPerEdgeInterval <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.texelsPerEdgeInterval = d;
        this.onShapeChanged();
    }

    @Override
    public int[] getMinAndMaxEdgeIntervals() {
        return new int[]{this.minEdgeIntervals, this.maxEdgeIntervals};
    }

    @Override
    public void setMinAndMaxEdgeIntervals(int n, int n2) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "minEdgeIntervals < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxEdgeIntervals < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minEdgeIntervals = n;
        this.maxEdgeIntervals = n2;
        this.onShapeChanged();
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return new SurfaceShapeStateKey(this.getUniqueId(), this.lastModifiedTime, this.getActiveAttributes().copy(), null);
    }

    @Override
    public List<Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AbstractSurfaceObject.CacheEntry cacheEntry = this.sectorCache.get(drawContext.getGlobe().getGlobeStateKey());
        if (cacheEntry != null) {
            return (List)cacheEntry.object;
        }
        cacheEntry = new AbstractSurfaceObject.CacheEntry(this.computeSectors(drawContext), drawContext);
        this.sectorCache.put(drawContext.getGlobe().getGlobeStateKey(), cacheEntry);
        return (List)cacheEntry.object;
    }

    protected List<Sector> computeSectors(DrawContext drawContext) {
        return this.computeSectors(drawContext.getGlobe());
    }

    protected List<Sector> computeSectors(Globe globe) {
        Object object;
        Iterable<? extends LatLon> iterable = this.getLocations(globe);
        if (iterable == null) {
            return null;
        }
        List<Sector> list = null;
        String string = this.containsPole(iterable);
        if (string != null) {
            object = Sector.boundingSector(iterable);
            object = "gov.nasa.worldwind.avkey.North".equals(string) ? new Sector(((Sector)object).getMinLatitude(), Angle.POS90, Angle.NEG180, Angle.POS180) : new Sector(Angle.NEG90, ((Sector)object).getMaxLatitude(), Angle.NEG180, Angle.POS180);
            list = Arrays.asList(object);
        } else if (LatLon.locationsCrossDateLine(iterable)) {
            object = Sector.splitBoundingSectors(iterable);
            if (object != null && ((Sector[])object).length == 2 && !AbstractSurfaceShape.isSectorEmpty((Sector)object[0]) && !AbstractSurfaceShape.isSectorEmpty((Sector)object[1])) {
                list = Arrays.asList(object);
            }
        } else {
            object = Sector.boundingSector(iterable);
            if (!AbstractSurfaceShape.isSectorEmpty((Sector)object)) {
                list = Arrays.asList(object);
            }
        }
        if (list == null) {
            return null;
        }
        if (DEFAULT_PATH_TYPE.equals(this.getPathType())) {
            for (int i = 0; i < list.size(); ++i) {
                Sector sector = list.get(i);
                LatLon[] latLonArray = LatLon.greatCircleArcExtremeLocations(iterable);
                double d = sector.getMinLatitude().degrees;
                double d2 = sector.getMaxLatitude().degrees;
                if (d > latLonArray[0].getLatitude().degrees) {
                    d = latLonArray[0].getLatitude().degrees;
                }
                if (d2 < latLonArray[1].getLatitude().degrees) {
                    d2 = latLonArray[1].getLatitude().degrees;
                }
                Angle angle = Angle.fromDegreesLatitude(d);
                Angle angle2 = Angle.fromDegreesLatitude(d2);
                list.set(i, new Sector(angle, angle2, sector.getMinLongitude(), sector.getMaxLongitude()));
            }
        }
        return list;
    }

    protected static boolean isSectorEmpty(Sector sector) {
        if (sector == null) {
            return true;
        }
        if (sector.equals(Sector.EMPTY_SECTOR)) {
            return true;
        }
        return sector.getMinLatitude().equals(sector.getMaxLatitude()) && sector.getMinLongitude().equals(sector.getMaxLongitude());
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List<Sector> list = this.computeSectors(globe);
        if (list == null) {
            return null;
        }
        return this.computeExtent(globe, d, list);
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    @Override
    public double getArea(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getArea(globe);
    }

    @Override
    public double getArea(Globe globe, boolean bl) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        areaMeasurer.setFollowTerrain(bl);
        return areaMeasurer.getArea(globe);
    }

    @Override
    public double getPerimeter(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getPerimeter(globe);
    }

    @Override
    public double getWidth(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getWidth(globe);
    }

    @Override
    public double getHeight(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getHeight(globe);
    }

    @Override
    public double getLength(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getLength(globe);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.doMoveTo(position2, position);
    }

    @Override
    public void moveTo(Globe globe, Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.doMoveTo(globe, position2, position);
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, 1);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    @Override
    public void combine(CombineContext combineContext) {
        if (combineContext == null) {
            String string = Logging.getMessage("nullValue.CombineContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (combineContext.isBoundingSectorMode()) {
            this.combineBounds(combineContext);
        } else {
            this.combineContours(combineContext);
        }
    }

    @Override
    public abstract Position getReferencePosition();

    protected abstract void doMoveTo(Position var1, Position var2);

    protected abstract void doMoveTo(Globe var1, Position var2, Position var3);

    protected void onShapeChanged() {
        this.updateModifiedTime();
        this.clearCaches();
    }

    @Override
    protected void clearCaches() {
        super.clearCaches();
        this.sectorCache.clear();
        this.geometryCache.clear();
    }

    @Override
    protected void makeOrderedPreRenderable(DrawContext drawContext) {
        this.determineActiveAttributes();
        super.makeOrderedPreRenderable(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (surfaceTileDrawContext == null) {
            String string = Logging.getMessage("nullValue.SurfaceTileDrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginDrawing(drawContext, surfaceTileDrawContext);
        try {
            this.doDrawGeographic(drawContext, surfaceTileDrawContext);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.stackHandler.pushAttrib(gL2, 28685);
        this.stackHandler.pushClientAttrib(gL2, 2);
        this.stackHandler.pushTextureIdentity(gL2);
        this.stackHandler.pushProjection(gL2);
        this.stackHandler.pushModelview(gL2);
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        gL2.glDisable(2929);
        gL2.glEnable(2884);
        gL2.glCullFace(1029);
        gL2.glEnableClientState(32884);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
        }
        this.applyModelviewTransform(drawContext, surfaceTileDrawContext);
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (this.texture != null && !drawContext.isPickingMode()) {
            gL2.glTexGeni(8192, 9472, 9216);
            gL2.glTexGeni(8193, 9472, 9216);
            gL2.glTexGendv(8192, 9473, OGLUtil.DEFAULT_TEXTURE_GEN_S_OBJECT_PLANE, 0);
            gL2.glTexGendv(8193, 9473, OGLUtil.DEFAULT_TEXTURE_GEN_T_OBJECT_PLANE, 0);
            gL2.glBindTexture(3553, 0);
        }
        this.stackHandler.pop(gL2);
    }

    protected void doDrawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        this.determineActiveGeometry(drawContext, surfaceTileDrawContext);
        if (this.getActiveAttributes().isDrawInterior() && this.getActiveAttributes().getInteriorOpacity() > 0.0) {
            this.drawInterior(drawContext, surfaceTileDrawContext);
        }
        if (this.getActiveAttributes().isDrawOutline() && this.getActiveAttributes().getOutlineOpacity() > 0.0) {
            this.drawOutline(drawContext, surfaceTileDrawContext);
        }
    }

    protected void applyModelviewTransform(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        Object object;
        Matrix matrix = surfaceTileDrawContext.getModelviewMatrix();
        Position position = this.getReferencePosition();
        if (position != null) {
            object = Matrix.fromTranslation(position.getLongitude().degrees, position.getLatitude().degrees, 0.0);
            matrix = matrix.multiply((Matrix)object);
        }
        object = drawContext.getGL().getGL2();
        object.glMultMatrixd(matrix.toArray(new double[16], 0, false), 0);
    }

    protected void determineActiveAttributes() {
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttrs.copy(this.getHighlightAttributes());
            } else {
                if (this.getAttributes() != null) {
                    this.activeAttrs.copy(this.getAttributes());
                }
                this.activeAttrs.setOutlineMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeAttrs.setInteriorMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeAttrs.setOutlineOpacity(1.0);
                this.activeAttrs.setInteriorOpacity(1.0);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttrs.copy(this.getAttributes());
        } else {
            this.activeAttrs.copy(defaultAttrs);
        }
    }

    protected ShapeAttributes createActiveAttributes() {
        return new BasicShapeAttributes();
    }

    protected ShapeAttributes getActiveAttributes() {
        return this.activeAttrs;
    }

    protected void determineActiveGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        this.activeGeometry.clear();
        this.activeOutlineGeometry.clear();
        List<List<LatLon>> list = this.getCachedGeometry(drawContext, surfaceTileDrawContext);
        if (list == null) {
            return;
        }
        for (List<LatLon> list2 : list) {
            List<Object> list3;
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>(list2);
            String string = this.containsPole(arrayList);
            if (string != null) {
                list3 = this.cutAlongDateLine(arrayList, string, drawContext.getGlobe());
                this.activeGeometry.add(list3);
                List<List<LatLon>> list4 = this.repeatAroundDateline(arrayList);
                this.activeOutlineGeometry.addAll(list4);
                continue;
            }
            if (LatLon.locationsCrossDateLine(arrayList)) {
                list3 = this.repeatAroundDateline(arrayList);
                this.activeGeometry.addAll(list3);
                this.activeOutlineGeometry.addAll(list3);
                continue;
            }
            this.activeGeometry.add(arrayList);
            this.activeOutlineGeometry.add(arrayList);
        }
    }

    protected boolean canContainPole() {
        return true;
    }

    protected String containsPole(Iterable<? extends LatLon> iterable) {
        if (!this.canContainPole()) {
            return null;
        }
        return LatLon.locationsContainPole(iterable);
    }

    protected List<LatLon> cutAlongDateLine(List<LatLon> list, String string, Globe globe) {
        if (string == null) {
            return list;
        }
        return LatLon.cutLocationsAlongDateLine(list, string, globe);
    }

    protected List<List<LatLon>> repeatAroundDateline(List<LatLon> list) {
        return LatLon.repeatLocationsAroundDateline(list);
    }

    protected List<List<LatLon>> getActiveGeometry() {
        return this.activeGeometry;
    }

    protected void drawInterior(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.getActiveGeometry().isEmpty()) {
            return;
        }
        this.applyInteriorState(drawContext, surfaceTileDrawContext, this.getActiveAttributes(), this.getInteriorTexture(), this.getReferencePosition());
        this.tessellateInterior(drawContext);
    }

    protected void drawOutline(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.activeOutlineGeometry.isEmpty()) {
            return;
        }
        this.applyOutlineState(drawContext, this.getActiveAttributes());
        for (List<LatLon> list : this.activeOutlineGeometry) {
            this.drawLineStrip(drawContext, list);
        }
    }

    protected void drawLineStrip(DrawContext drawContext, List<LatLon> list) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        if (vertexBuffer == null || vertexBuffer.capacity() < 2 * list.size()) {
            vertexBuffer = Buffers.newDirectFloatBuffer(2 * list.size());
        }
        vertexBuffer.clear();
        for (LatLon latLon : list) {
            vertexBuffer.put((float)(latLon.getLongitude().degrees - position.getLongitude().degrees));
            vertexBuffer.put((float)(latLon.getLatitude().degrees - position.getLatitude().degrees));
        }
        vertexBuffer.flip();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(2, 5126, 0, vertexBuffer);
        gL2.glDrawArrays(3, 0, list.size());
    }

    protected WWTexture getInteriorTexture() {
        if (this.getActiveAttributes().getImageSource() == null) {
            this.texture = null;
        } else if (this.texture == null || this.texture.getImageSource() != this.getActiveAttributes().getImageSource()) {
            this.texture = new BasicWWTexture(this.getActiveAttributes().getImageSource(), true);
        }
        return this.texture;
    }

    protected List<List<LatLon>> getCachedGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = this.createGeometryKey(drawContext, surfaceTileDrawContext);
        AbstractSurfaceObject.CacheEntry cacheEntry = this.geometryCache.get(object);
        if (cacheEntry != null) {
            return (List)cacheEntry.object;
        }
        cacheEntry = new AbstractSurfaceObject.CacheEntry(this.createGeometry(drawContext.getGlobe(), surfaceTileDrawContext), drawContext);
        this.geometryCache.put(object, cacheEntry);
        return (List)cacheEntry.object;
    }

    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        return this.createGeometry(globe, d);
    }

    protected abstract List<List<LatLon>> createGeometry(Globe var1, double var2);

    protected Object createGeometryKey(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        return new GeometryKey(drawContext, this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext));
    }

    protected double computeEdgeIntervalsPerDegree(SurfaceTileDrawContext surfaceTileDrawContext) {
        double d = Math.max((double)surfaceTileDrawContext.getViewport().width / surfaceTileDrawContext.getSector().getDeltaLonDegrees(), surfaceTileDrawContext.getViewport().getHeight() / surfaceTileDrawContext.getSector().getDeltaLatDegrees());
        double d2 = 1.0 / this.getTexelsPerEdgeInterval();
        return d2 * d;
    }

    protected double computeEdgeIntervalsPerDegree(double d) {
        double d2 = d * 180.0 / Math.PI;
        double d3 = 1.0 / d2;
        return d3;
    }

    protected void combineBounds(CombineContext combineContext) {
        List<Sector> list = this.computeSectors(combineContext.getGlobe());
        if (list == null) {
            return;
        }
        combineContext.addBoundingSector(Sector.union(list));
    }

    protected void combineContours(CombineContext combineContext) {
        List<Sector> list = this.computeSectors(combineContext.getGlobe());
        if (list == null) {
            return;
        }
        if (!combineContext.getSector().intersectsAny(list)) {
            return;
        }
        this.doCombineContours(combineContext);
    }

    protected void doCombineContours(CombineContext combineContext) {
        double d = this.computeEdgeIntervalsPerDegree(combineContext.getResolution());
        List<List<LatLon>> list = this.createGeometry(combineContext.getGlobe(), d);
        if (list == null) {
            return;
        }
        for (List<LatLon> list2 : list) {
            List<Object> list3;
            String string = this.containsPole(list2);
            if (string != null) {
                list3 = this.cutAlongDateLine(list2, string, combineContext.getGlobe());
                this.doCombineContour(combineContext, list3);
                continue;
            }
            if (LatLon.locationsCrossDateLine(list2)) {
                list3 = this.repeatAroundDateline(list2);
                this.doCombineContour(combineContext, (Iterable)list3.get(0));
                this.doCombineContour(combineContext, (Iterable)list3.get(1));
                continue;
            }
            this.doCombineContour(combineContext, list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCombineContour(CombineContext combineContext, Iterable<? extends LatLon> iterable) {
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        try {
            GLU.gluTessBeginContour(gLUtessellator);
            for (LatLon latLon : iterable) {
                double[] dArray = new double[]{latLon.longitude.degrees, latLon.latitude.degrees, 0.0};
                GLU.gluTessVertex(gLUtessellator, dArray, 0, dArray);
            }
        }
        finally {
            GLU.gluTessEndContour(gLUtessellator);
        }
    }

    protected void applyInteriorState(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext, ShapeAttributes shapeAttributes, WWTexture wWTexture, LatLon latLon) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (wWTexture != null && !drawContext.isPickingMode()) {
            this.applyInteriorTextureState(drawContext, surfaceTileDrawContext, shapeAttributes, wWTexture, latLon);
        } else {
            if (!drawContext.isPickingMode()) {
                OGLUtil.applyBlending(gL2, false);
                Color color = shapeAttributes.getInteriorMaterial().getDiffuse();
                int n = (int)(255.0 * shapeAttributes.getInteriorOpacity() + 0.5);
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)n);
            }
            gL2.glDisable(3553);
            gL2.glDisable(3168);
            gL2.glDisable(3169);
        }
    }

    protected void applyOutlineState(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        GL2 gL2 = drawContext.getGL().getGL2();
        double d = shapeAttributes.getOutlineWidth();
        if (drawContext.isPickingMode() && !shapeAttributes.isDrawInterior() && d != 0.0) {
            d += 5.0;
        }
        gL2.glLineWidth((float)d);
        if (!drawContext.isPickingMode() && shapeAttributes.isEnableAntialiasing()) {
            gL2.glEnable(2848);
        } else {
            gL2.glDisable(2848);
        }
        if (drawContext.isPickingMode() || shapeAttributes.getOutlineStippleFactor() <= 0) {
            gL2.glDisable(2852);
        } else {
            gL2.glEnable(2852);
            gL2.glLineStipple(shapeAttributes.getOutlineStippleFactor(), shapeAttributes.getOutlineStipplePattern());
        }
        if (!drawContext.isPickingMode()) {
            OGLUtil.applyBlending(gL2, false);
            Color color = shapeAttributes.getOutlineMaterial().getDiffuse();
            int n = (int)(255.0 * shapeAttributes.getOutlineOpacity() + 0.5);
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)n);
        }
        gL2.glDisable(3553);
        gL2.glDisable(3168);
        gL2.glDisable(3169);
    }

    protected void applyInteriorTextureState(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext, ShapeAttributes shapeAttributes, WWTexture wWTexture, LatLon latLon) {
        double d;
        double d2;
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!wWTexture.bind(drawContext)) {
            return;
        }
        if (!drawContext.isPickingMode()) {
            OGLUtil.applyBlending(gL2, true);
            OGLUtil.applyColor(gL2, Color.WHITE, shapeAttributes.getInteriorOpacity(), true);
        }
        double[] dArray = new double[]{1.0, 0.0, 0.0, 1.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0, 1.0};
        gL2.glEnable(3168);
        gL2.glEnable(3169);
        gL2.glTexGeni(8192, 9472, 9217);
        gL2.glTexGeni(8193, 9472, 9217);
        gL2.glTexGendv(8192, 9473, dArray, 0);
        gL2.glTexGendv(8193, 9473, dArray2, 0);
        Matrix matrix = Matrix.IDENTITY;
        if (latLon != null) {
            d2 = latLon.getLatitude().degrees;
            d = latLon.getLongitude().degrees;
            matrix = Matrix.fromTranslation(d, d2, 0.0).multiply(matrix);
        }
        d2 = latLon != null ? latLon.getLatitude().cos() : 1.0;
        d = shapeAttributes.getImageScale();
        matrix = Matrix.fromScale(d2 / d, 1.0 / d, 1.0).multiply(matrix);
        double d3 = drawContext.getGlobe().getRadius() * surfaceTileDrawContext.getSector().getDeltaLatRadians() / (double)surfaceTileDrawContext.getViewport().height;
        double d4 = drawContext.getGlobe().getRadius() * Angle.fromDegrees((double)1.0).radians / (double)wWTexture.getHeight(drawContext);
        double d5 = d4 / d3;
        matrix = Matrix.fromScale(d5, d5, 1.0).multiply(matrix);
        double[] dArray3 = matrix.toArray(new double[16], 0, false);
        gL2.glMatrixMode(5890);
        gL2.glLoadIdentity();
        wWTexture.applyInternalTransform(drawContext);
        gL2.glMultMatrixd(dArray3, 0);
        gL2.glMatrixMode(5888);
        gL2.glEnable(3553);
        gL2.glTexParameteri(3553, 10242, 10497);
        gL2.glTexParameteri(3553, 10243, 10497);
    }

    protected void generateIntermediateLocations(Iterable<? extends LatLon> iterable, double d, boolean bl, List<LatLon> list) {
        LatLon latLon = null;
        LatLon latLon2 = null;
        for (LatLon latLon3 : iterable) {
            if (latLon == null) {
                latLon = latLon3;
            }
            if (latLon2 != null) {
                this.addIntermediateLocations(latLon2, latLon3, d, list);
            }
            list.add(latLon3);
            latLon2 = latLon3;
        }
        if (bl && latLon != null && latLon2 != null && !latLon.equals(latLon2)) {
            this.addIntermediateLocations(latLon2, latLon, d, list);
            list.add(latLon);
        }
    }

    protected void addIntermediateLocations(LatLon latLon, LatLon latLon2, double d, List<LatLon> list) {
        block5: {
            block4: {
                if (this.pathType == null || this.pathType != DEFAULT_PATH_TYPE) break block4;
                Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
                double d2 = WWMath.clamp(d * angle.degrees, (double)this.minEdgeIntervals, (double)this.maxEdgeIntervals);
                int n = (int)Math.ceil(d2);
                if (n <= 1) break block5;
                double d3 = LatLon.greatCircleAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
                double d4 = angle.radians / (double)(n + 1);
                for (int i = 1; i <= n; ++i) {
                    list.add(LatLon.greatCircleEndPosition(latLon, d3, (double)i * d4));
                }
                break block5;
            }
            if (this.pathType != null && (this.pathType == "gov.nasa.worldwind.avkey.RhumbLine" || this.pathType == "gov.nasa.worldwind.avkey.Loxodrome")) {
                Angle angle = LatLon.rhumbDistance(latLon, latLon2);
                double d5 = WWMath.clamp(d * angle.degrees, (double)this.minEdgeIntervals, (double)this.maxEdgeIntervals);
                int n = (int)Math.ceil(d5);
                if (n > 1) {
                    double d6 = LatLon.rhumbAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
                    double d7 = angle.radians / (double)(n + 1);
                    for (int i = 1; i <= n; ++i) {
                        list.add(LatLon.rhumbEndPosition(latLon, d6, (double)i * d7));
                    }
                }
            }
        }
    }

    protected Integer tessellateInterior(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return this.doTessellateInterior(drawContext);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
            Logging.logger().log(Level.SEVERE, string, outOfMemoryError);
            drawContext.addRenderingException(new WWRuntimeException(string, outOfMemoryError));
            this.handleUnsuccessfulInteriorTessellation(drawContext);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doTessellateInterior(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        GLUtessellatorCallback gLUtessellatorCallback = GLUTessellatorSupport.createOGLDrawPrimitivesCallback(gL2);
        GLUTessellatorSupport gLUTessellatorSupport = new GLUTessellatorSupport();
        gLUTessellatorSupport.beginTessellation(gLUtessellatorCallback, new Vec4(0.0, 0.0, 1.0));
        try {
            Integer n = this.tessellateInteriorVertices(gLUTessellatorSupport.getGLUtessellator());
            return n;
        }
        finally {
            gLUTessellatorSupport.endTessellation();
        }
    }

    protected Integer tessellateInteriorVertices(GLUtessellator gLUtessellator) {
        if (this.getActiveGeometry().isEmpty()) {
            return null;
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        int n = 0;
        GLU.gluTessBeginPolygon(gLUtessellator, null);
        for (List<LatLon> list : this.getActiveGeometry()) {
            GLU.gluTessBeginContour(gLUtessellator);
            for (LatLon latLon : list) {
                double[] dArray = new double[3];
                dArray[0] = latLon.getLongitude().degrees - position.getLongitude().degrees;
                dArray[1] = latLon.getLatitude().degrees - position.getLatitude().degrees;
                GLU.gluTessVertex(gLUtessellator, dArray, 0, dArray);
                n += 24;
            }
            GLU.gluTessEndContour(gLUtessellator);
        }
        GLU.gluTessEndPolygon(gLUtessellator);
        return n;
    }

    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
    }

    protected AreaMeasurer setupAreaMeasurer(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.areaMeasurer == null) {
            this.areaMeasurer = new AreaMeasurer();
        }
        if (this.areaMeasurerLastModifiedTime < this.lastModifiedTime) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            Iterable<? extends LatLon> iterable = this.getLocations(globe);
            if (iterable != null) {
                for (LatLon latLon : iterable) {
                    arrayList.add(latLon);
                }
                if (arrayList.size() > 1 && !((LatLon)arrayList.get(0)).equals(arrayList.get(arrayList.size() - 1))) {
                    arrayList.add((LatLon)arrayList.get(0));
                }
            }
            this.areaMeasurer.setPositions(arrayList, 0.0);
            this.areaMeasurerLastModifiedTime = this.lastModifiedTime;
        }
        this.areaMeasurer.setFollowTerrain(true);
        return this.areaMeasurer;
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsBoolean(stateObject, "highlighted", this.isHighlighted());
        restorableSupport.addStateValueAsString(stateObject, "pathType", this.getPathType());
        restorableSupport.addStateValueAsDouble(stateObject, "texelsPerEdgeInterval", this.getTexelsPerEdgeInterval());
        int[] nArray = this.getMinAndMaxEdgeIntervals();
        restorableSupport.addStateValueAsInteger(stateObject, "minEdgeIntervals", nArray[0]);
        restorableSupport.addStateValueAsInteger(stateObject, "maxEdgeIntervals", nArray[1]);
        if (this.getAttributes() != null) {
            this.getAttributes().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
        }
        if (this.getHighlightAttributes() != null) {
            this.getHighlightAttributes().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "highlightAttrs"));
        }
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(null, "avlist");
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            this.getRestorableStateForAVPair(entry.getKey(), entry.getValue() != null ? entry.getValue() : "", restorableSupport, stateObject2);
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject2;
        Integer n;
        Object object;
        String string;
        this.legacyRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "visible");
        if (bl != null) {
            this.setVisible(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "highlighted")) != null) {
            this.setHighlighted(bl);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "pathType")) != null && (object = this.pathTypeFromString(string)) != null) {
            this.setPathType((String)object);
        }
        if ((object = restorableSupport.getStateValueAsDouble(stateObject, "texelsPerEdgeInterval")) != null) {
            this.setTexelsPerEdgeInterval((Double)object);
        }
        int[] nArray = this.getMinAndMaxEdgeIntervals();
        Integer n2 = restorableSupport.getStateValueAsInteger(stateObject, "minEdgeIntervals");
        if (n2 != null) {
            nArray[0] = n2;
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "maxEdgeIntervals")) != null) {
            nArray[1] = n;
        }
        if (n2 != null || n != null) {
            this.setMinAndMaxEdgeIntervals(nArray[0], nArray[1]);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "attributes")) != null) {
            stateObjectArray = this.getAttributes() != null ? this.getAttributes() : new BasicShapeAttributes();
            stateObjectArray.restoreState(restorableSupport, stateObject2);
            this.setAttributes((ShapeAttributes)stateObjectArray);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "highlightAttrs")) != null) {
            stateObjectArray = this.getHighlightAttributes() != null ? this.getHighlightAttributes() : new BasicShapeAttributes();
            stateObjectArray.restoreState(restorableSupport, stateObject2);
            this.setHighlightAttributes((ShapeAttributes)stateObjectArray);
        }
        if ((stateObject2 = restorableSupport.getStateObject(null, "avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "")) != null) {
            for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                if (stateObject3 == null) continue;
                this.setValue(stateObject3.getName(), stateObject3.getValue());
            }
        }
        this.onShapeChanged();
    }

    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        ShapeAttributes shapeAttributes = this.getAttributes();
        Color color = restorableSupport.getStateValueAsColor(stateObject, "color");
        if (color != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setInteriorMaterial(new Material(color));
        }
        if ((color = restorableSupport.getStateValueAsColor(stateObject, "borderColor")) != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setOutlineMaterial(new Material(color));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "lineWidth")) != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setOutlineWidth(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawBorder")) != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setDrawOutline(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior")) != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "antialias")) != null) {
            (shapeAttributes != null ? shapeAttributes : (shapeAttributes = new BasicShapeAttributes())).setEnableAntialiasing(bl);
        }
        if (shapeAttributes != null) {
            this.setAttributes(shapeAttributes);
        }
    }

    protected String pathTypeFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(DEFAULT_PATH_TYPE)) {
            return DEFAULT_PATH_TYPE;
        }
        if (string.equals("gov.nasa.worldwind.avkey.Linear")) {
            return "gov.nasa.worldwind.avkey.Linear";
        }
        if (string.equals("gov.nasa.worldwind.avkey.Loxodrome")) {
            return "gov.nasa.worldwind.avkey.Loxodrome";
        }
        if (string.equals("gov.nasa.worldwind.avkey.RhumbLine")) {
            return "gov.nasa.worldwind.avkey.RhumbLine";
        }
        return null;
    }

    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    public void export(String string, Object object) throws IOException, UnsupportedOperationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
    }

    static {
        defaultAttrs.setInteriorMaterial(DEFAULT_INTERIOR_MATERIAL);
        defaultAttrs.setOutlineMaterial(DEFAULT_OUTLINE_MATERIAL);
    }

    protected static class SurfaceShapeStateKey
    extends AbstractSurfaceObject.SurfaceObjectStateKey {
        protected final ShapeAttributes attributes;
        protected final Object globeStateKey;

        public SurfaceShapeStateKey(long l, long l2, ShapeAttributes shapeAttributes, Object object) {
            super(l, l2);
            this.attributes = shapeAttributes;
            this.globeStateKey = object;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SurfaceShapeStateKey surfaceShapeStateKey = (SurfaceShapeStateKey)object;
            return super.equals(object) && (this.attributes != null ? this.attributes.equals(surfaceShapeStateKey.attributes) : surfaceShapeStateKey.attributes == null) && (this.globeStateKey != null ? this.globeStateKey.equals(surfaceShapeStateKey.globeStateKey) : surfaceShapeStateKey.globeStateKey == null);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.attributes != null ? this.attributes.hashCode() : 0);
            n = 31 * n + (this.globeStateKey != null ? this.globeStateKey.hashCode() : 0);
            return n;
        }

        @Override
        public long getSizeInBytes() {
            return super.getSizeInBytes() + 64L;
        }
    }

    protected static class GeometryKey {
        protected Globe globe;
        protected double edgeIntervalsPerDegree;

        public GeometryKey(DrawContext drawContext, double d) {
            this.globe = drawContext.getGlobe();
            this.edgeIntervalsPerDegree = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GeometryKey geometryKey = (GeometryKey)object;
            return this.globe.equals(geometryKey.globe) && this.edgeIntervalsPerDegree == geometryKey.edgeIntervalsPerDegree;
        }

        public int hashCode() {
            int n = this.globe.hashCode();
            long l = this.edgeIntervalsPerDegree != 0.0 ? Double.doubleToLongBits(this.edgeIntervalsPerDegree) : 0L;
            return 31 * n + (int)(l ^ l >>> 32);
        }
    }
}

