/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;

public class BasicWWTexture
implements WWTexture {
    private Object imageSource;
    private boolean useMipMaps;
    private boolean useAnisotropy = true;
    protected Integer width;
    protected Integer height;
    protected TextureCoords texCoords;
    protected boolean textureInitializationFailed = false;

    public BasicWWTexture(Object object, boolean bl) {
        this.initialize(object, bl);
    }

    public BasicWWTexture(Object object) {
        this(object, false);
    }

    protected void initialize(Object object, boolean bl) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.useMipMaps = bl;
    }

    @Override
    public Object getImageSource() {
        return this.imageSource;
    }

    @Override
    public int getWidth(DrawContext drawContext) {
        if (this.width != null) {
            return this.width;
        }
        Texture texture = this.getTexture(drawContext, true);
        return texture != null ? texture.getWidth() : 0;
    }

    @Override
    public int getHeight(DrawContext drawContext) {
        if (this.height != null) {
            return this.height;
        }
        Texture texture = this.getTexture(drawContext, true);
        return texture != null ? texture.getHeight() : 0;
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    @Override
    public TextureCoords getTexCoords() {
        return this.texCoords;
    }

    @Override
    public boolean isTextureCurrent(DrawContext drawContext) {
        return true;
    }

    public boolean isUseAnisotropy() {
        return this.useAnisotropy;
    }

    public void setUseAnisotropy(boolean bl) {
        this.useAnisotropy = bl;
    }

    @Override
    public boolean isTextureInitializationFailed() {
        return this.textureInitializationFailed;
    }

    protected Texture getTexture(DrawContext drawContext, boolean bl) {
        Texture texture = this.getTextureFromCache(drawContext);
        if (texture == null && bl) {
            texture = this.initializeTexture(drawContext, this.imageSource);
        }
        return texture;
    }

    protected Texture getTextureFromCache(DrawContext drawContext) {
        Texture texture = drawContext.getTextureCache().getTexture(this.imageSource);
        if (texture != null && this.width == null) {
            this.width = texture.getWidth();
            this.height = texture.getHeight();
            this.texCoords = texture.getImageTexCoords();
        }
        return texture;
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTextureFromCache(drawContext);
        if (texture == null && (texture = this.initializeTexture(drawContext, this.imageSource)) != null) {
            return true;
        }
        if (texture != null) {
            texture.bind(drawContext.getGL());
        }
        if (texture != null && this.width == 0 && this.height == 0) {
            this.width = texture.getWidth();
            this.height = texture.getHeight();
            this.texCoords = texture.getImageTexCoords();
        }
        return texture != null;
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTextureFromCache(drawContext);
        if (texture == null) {
            texture = this.initializeTexture(drawContext, this.imageSource);
        }
        if (texture != null && texture.getMustFlipVertically()) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glMatrixMode(5890);
            gL2.glLoadIdentity();
            gL2.glScaled(1.0, -1.0, 1.0);
            gL2.glTranslated(0.0, -1.0, 0.0);
        }
    }

    protected Texture initializeTexture(DrawContext drawContext, Object object) {
        boolean bl;
        Texture texture;
        Object object2;
        Object object3;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.textureInitializationFailed) {
            return null;
        }
        GL gL = drawContext.getGL();
        if (object instanceof String) {
            object3 = (String)object;
            object2 = WWIO.getFileOrResourceAsStream((String)object3, this.getClass());
            if (object2 == null || object2 instanceof Exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", object2 != null ? object2 : object3);
                this.textureInitializationFailed = true;
                return null;
            }
            try {
                TextureData textureData = OGLUtil.newTextureData(gL.getGLProfile(), (InputStream)object2, this.useMipMaps);
                texture = TextureIO.newTexture(textureData);
                bl = textureData.getMipmapData() != null;
            }
            catch (Exception exception) {
                String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", object);
                Logging.logger().log(Level.SEVERE, string, exception);
                this.textureInitializationFailed = true;
                return null;
            }
        } else if (object instanceof BufferedImage) {
            try {
                object3 = AWTTextureIO.newTextureData(gL.getGLProfile(), (BufferedImage)object, this.useMipMaps);
                texture = TextureIO.newTexture((TextureData)object3);
                bl = ((TextureData)object3).getMipmapData() != null;
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
                Logging.logger().log(Level.SEVERE, string, exception);
                this.textureInitializationFailed = true;
                return null;
            }
        } else if (object instanceof URL) {
            try {
                object3 = ((URL)object).openStream();
                if (object3 == null) {
                    Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", object);
                    this.textureInitializationFailed = true;
                    return null;
                }
                object2 = OGLUtil.newTextureData(gL.getGLProfile(), (InputStream)object3, this.useMipMaps);
                texture = TextureIO.newTexture((TextureData)object2);
                bl = ((TextureData)object2).getMipmapData() != null;
            }
            catch (Exception exception) {
                String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", object);
                Logging.logger().log(Level.SEVERE, string, exception);
                this.textureInitializationFailed = true;
                return null;
            }
        } else {
            Logging.logger().log(Level.SEVERE, "generic.UnrecognizedImageSourceType", object.getClass().getName());
            this.textureInitializationFailed = true;
            return null;
        }
        if (texture == null) {
            Logging.logger().log(Level.SEVERE, "generic.TextureUnreadable", object instanceof String ? object : object.getClass().getName());
            this.textureInitializationFailed = true;
            return null;
        }
        drawContext.getTextureCache().put(object, texture);
        texture.bind(gL);
        boolean bl2 = this.useMipMaps && (bl || texture.isUsingAutoMipmapGeneration());
        gL.glTexParameteri(3553, 10241, bl2 ? 9987 : 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        if (this.isUseAnisotropy() && bl2) {
            double d = drawContext.getGLRuntimeCapabilities().getMaxTextureAnisotropy();
            if (drawContext.getGLRuntimeCapabilities().isUseAnisotropicTextureFilter() && d >= 2.0) {
                gL.glTexParameterf(3553, 34046, (float)d);
            }
        }
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        this.texCoords = texture.getImageTexCoords();
        return texture;
    }
}

