/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.nio.DoubleBuffer;

public class FrameFactory {
    @Deprecated
    public static final String SHAPE_RECTANGLE = "gov.nasa.worldwind.avkey.ShapeRectangle";
    @Deprecated
    public static final String SHAPE_ELLIPSE = "gov.nasa.worldwind.avkey.ShapeEllipse";
    @Deprecated
    public static final String SHAPE_NONE = "gov.nasa.worldwind.avkey.ShapeNone";
    @Deprecated
    public static final String LEADER_TRIANGLE = "gov.nasa.worldwind.avkey.ShapeTriangle";
    @Deprecated
    public static final String LEADER_NONE = "gov.nasa.worldwind.avkey.ShapeNone";
    private static int cornerSteps = 16;
    private static int circleSteps = 64;

    public static void drawShape(DrawContext drawContext, String string, double d, double d2, int n, int n2) {
        if (!string.equals("gov.nasa.worldwind.avkey.ShapeNone")) {
            FrameFactory.drawBuffer(drawContext, n, FrameFactory.createShapeBuffer(string, d, d2, n2, null));
        }
    }

    public static void drawShapeWithLeader(DrawContext drawContext, String string, double d, double d2, Point point, double d3, int n, int n2) {
        if (!string.equals("gov.nasa.worldwind.avkey.ShapeNone")) {
            FrameFactory.drawBuffer(drawContext, n, FrameFactory.createShapeWithLeaderBuffer(string, d, d2, point, d3, n2, null));
        }
    }

    public static DoubleBuffer createShapeBuffer(String string, double d, double d2, int n, DoubleBuffer doubleBuffer) {
        if (string.equals(SHAPE_RECTANGLE)) {
            return FrameFactory.createRoundedRectangleBuffer(d, d2, n, doubleBuffer);
        }
        if (string.equals(SHAPE_ELLIPSE)) {
            return FrameFactory.createEllipseBuffer(d, d2, circleSteps, doubleBuffer);
        }
        if (string.equals("gov.nasa.worldwind.avkey.ShapeNone")) {
            return null;
        }
        return FrameFactory.createRoundedRectangleBuffer(d, d2, n, doubleBuffer);
    }

    public static DoubleBuffer createShapeWithLeaderBuffer(String string, double d, double d2, Point point, double d3, int n, DoubleBuffer doubleBuffer) {
        if (string.equals(SHAPE_RECTANGLE)) {
            return FrameFactory.createRoundedRectangleWithLeaderBuffer(d, d2, point, d3, n, doubleBuffer);
        }
        if (string.equals(SHAPE_ELLIPSE)) {
            return FrameFactory.createEllipseWithLeaderBuffer(d, d2, point, d3, circleSteps, doubleBuffer);
        }
        if (string.equals("gov.nasa.worldwind.avkey.ShapeNone")) {
            return null;
        }
        return FrameFactory.createRoundedRectangleWithLeaderBuffer(d, d2, point, d3, n, doubleBuffer);
    }

    public static void drawBuffer(DrawContext drawContext, int n, int n2, DoubleBuffer doubleBuffer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushClientAttrib(2);
        gL2.glEnableClientState(32884);
        gL2.glVertexPointer(2, 5130, 0, doubleBuffer);
        gL2.glDrawArrays(n, 0, n2);
        gL2.glPopClientAttrib();
    }

    public static void drawBuffer(DrawContext drawContext, int n, int n2, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null || doubleBuffer2 == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushClientAttrib(2);
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32888);
        gL2.glVertexPointer(2, 5130, 0, doubleBuffer);
        gL2.glTexCoordPointer(2, 5130, 0, doubleBuffer2);
        gL2.glDrawArrays(n, 0, n2);
        gL2.glPopClientAttrib();
    }

    public static void drawBuffer(DrawContext drawContext, int n, DoubleBuffer doubleBuffer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = doubleBuffer.remaining() / 2;
        FrameFactory.drawBuffer(drawContext, n, n2, doubleBuffer);
    }

    private static DoubleBuffer createRoundedRectangleBuffer(double d, double d2, int n, DoubleBuffer doubleBuffer) {
        int n2 = 9 + (n < 1 ? 0 : 4 * (cornerSteps - 2));
        doubleBuffer = FrameFactory.allocateVertexBuffer(n2, doubleBuffer);
        int n3 = 0;
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, 0.0);
        n3 = FrameFactory.drawCorner(d - (double)n, n, n, -1.5707963267948966, 0.0, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, d2 - (double)n);
        n3 = FrameFactory.drawCorner(d - (double)n, d2 - (double)n, n, 0.0, 1.5707963267948966, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, d2);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d2);
        n3 = FrameFactory.drawCorner(n, d2 - (double)n, n, 1.5707963267948966, Math.PI, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d2 - (double)n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, n);
        n3 = FrameFactory.drawCorner(n, n, n, Math.PI, 4.71238898038469, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.limit(n3);
        return doubleBuffer;
    }

    private static DoubleBuffer createRoundedRectangleWithLeaderBuffer(double d, double d2, Point point, double d3, int n, DoubleBuffer doubleBuffer) {
        int n2 = 12 + (n < 1 ? 0 : 4 * (cornerSteps - 2));
        doubleBuffer = FrameFactory.allocateVertexBuffer(n2, doubleBuffer);
        int n3 = 0;
        doubleBuffer.put(n3++, d / 2.0 + d3 / 2.0);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, 0.0);
        n3 = FrameFactory.drawCorner(d - (double)n, n, n, -1.5707963267948966, 0.0, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, d2 - (double)n);
        n3 = FrameFactory.drawCorner(d - (double)n, d2 - (double)n, n, 0.0, 1.5707963267948966, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, d2);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d2);
        n3 = FrameFactory.drawCorner(n, d2 - (double)n, n, 1.5707963267948966, Math.PI, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d2 - (double)n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, n);
        n3 = FrameFactory.drawCorner(n, n, n, Math.PI, 4.71238898038469, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d / 2.0 - d3 / 2.0);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, point.x);
        doubleBuffer.put(n3++, point.y);
        doubleBuffer.put(n3++, d / 2.0 + d3 / 2.0);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.limit(n3);
        return doubleBuffer;
    }

    private static int drawCorner(double d, double d2, double d3, double d4, double d5, int n, DoubleBuffer doubleBuffer, int n2) {
        if (d3 < 1.0) {
            return n2;
        }
        double d6 = (d5 - d4) / (double)(n - 1);
        for (int i = 1; i < n - 1; ++i) {
            double d7 = d4 + d6 * (double)i;
            double d8 = d + Math.cos(d7) * d3;
            double d9 = d2 + Math.sin(d7) * d3;
            doubleBuffer.put(n2++, d8);
            doubleBuffer.put(n2++, d9);
        }
        return n2;
    }

    private static DoubleBuffer createEllipseBuffer(double d, double d2, int n, DoubleBuffer doubleBuffer) {
        int n2 = n + 1;
        doubleBuffer = FrameFactory.allocateVertexBuffer(n2, doubleBuffer);
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        double d5 = 1.5707963267948966;
        double d6 = d3;
        double d7 = d4;
        double d8 = Math.PI * 2 / (double)n;
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            double d9 = d8 * (double)i - d5;
            double d10 = d6 + Math.cos(d9) * d3;
            double d11 = d7 + Math.sin(d9) * d4;
            doubleBuffer.put(n3++, d10);
            doubleBuffer.put(n3++, d11);
        }
        doubleBuffer.limit(n3);
        return doubleBuffer;
    }

    private static DoubleBuffer createEllipseWithLeaderBuffer(double d, double d2, Point point, double d3, int n, DoubleBuffer doubleBuffer) {
        int n2 = n + 3;
        doubleBuffer = FrameFactory.allocateVertexBuffer(n2, doubleBuffer);
        double d4 = d / 2.0;
        double d5 = d2 / 2.0;
        double d6 = 1.5707963267948966;
        double d7 = d4;
        double d8 = d5;
        double d9 = Math.PI * 2 / (double)n;
        double d10 = d3 / 2.0 / d4;
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            double d11 = d9 * (double)i - d6;
            if (i == 0) {
                d11 += d10;
            }
            if (i == n) {
                d11 -= d10;
            }
            double d12 = d7 + Math.cos(d11) * d4;
            double d13 = d8 + Math.sin(d11) * d5;
            doubleBuffer.put(n3++, d12);
            doubleBuffer.put(n3++, d13);
        }
        doubleBuffer.put(n3++, point.x);
        doubleBuffer.put(n3++, point.y);
        doubleBuffer.put(n3++, d7 + Math.cos(d10 - d6) * d4);
        doubleBuffer.put(n3++, d8 + Math.sin(d10 - d6) * d5);
        doubleBuffer.limit(n3);
        return doubleBuffer;
    }

    private static DoubleBuffer allocateVertexBuffer(int n, DoubleBuffer doubleBuffer) {
        int n2 = 2 * n;
        if (doubleBuffer != null) {
            doubleBuffer.clear();
        }
        if (doubleBuffer == null || doubleBuffer.capacity() < n2) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(n2);
        }
        return doubleBuffer;
    }
}

