/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;

public class Material {
    private final Color ambient;
    private final Color diffuse;
    private final Color specular;
    private final Color emission;
    private final double shininess;
    public static final Material WHITE = new Material(Color.WHITE);
    public static final Material LIGHT_GRAY = new Material(Color.LIGHT_GRAY);
    public static final Material GRAY = new Material(Color.GRAY);
    public static final Material DARK_GRAY = new Material(Color.DARK_GRAY);
    public static final Material BLACK = new Material(Color.BLACK);
    public static final Material RED = new Material(Color.RED);
    public static final Material PINK = new Material(Color.PINK);
    public static final Material ORANGE = new Material(Color.ORANGE);
    public static final Material YELLOW = new Material(Color.YELLOW);
    public static final Material GREEN = new Material(Color.GREEN);
    public static final Material MAGENTA = new Material(Color.MAGENTA);
    public static final Material CYAN = new Material(Color.CYAN);
    public static final Material BLUE = new Material(Color.BLUE);

    public Material(Color color, Color color2, Color color3, Color color4, float f) {
        if (color == null || color2 == null || color3 == null || color4 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ambient = color3;
        this.diffuse = color2;
        this.specular = color;
        this.emission = color4;
        this.shininess = f;
    }

    public Material(Color color, float f) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ambient = this.makeDarker(color);
        this.diffuse = color;
        this.specular = new Color(255, 255, 255, color.getAlpha());
        this.emission = new Color(0, 0, 0, color.getAlpha());
        this.shininess = f;
    }

    public Material(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ambient = this.makeDarker(color);
        this.diffuse = color;
        this.specular = new Color(255, 255, 255, color.getAlpha());
        this.emission = new Color(0, 0, 0, color.getAlpha());
        this.shininess = 80.0;
    }

    public final Color getAmbient() {
        return this.ambient;
    }

    public final Color getDiffuse() {
        return this.diffuse;
    }

    public final Color getSpecular() {
        return this.specular;
    }

    public final Color getEmission() {
        return this.emission;
    }

    public final double getShininess() {
        return this.shininess;
    }

    public void apply(GL2 gL2, int n) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glMaterial(gL2, n, 4608, this.ambient);
        this.glMaterial(gL2, n, 4609, this.diffuse);
        this.glMaterial(gL2, n, 4610, this.specular);
        this.glMaterial(gL2, n, 5632, this.emission);
        gL2.glMaterialf(n, 5633, (float)this.shininess);
    }

    public void apply(GL2 gL2, int n, float f) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glMaterial(gL2, n, 4608, this.ambient, 0.0f);
        this.glMaterial(gL2, n, 4609, this.diffuse, f);
        this.glMaterial(gL2, n, 4610, this.specular, 0.0f);
        this.glMaterial(gL2, n, 5632, this.emission, 0.0f);
        gL2.glMaterialf(n, 5633, (float)this.shininess);
    }

    protected void glMaterial(GL2 gL2, int n, int n2, Color color) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        gL2.glMaterialfv(n, n2, fArray, 0);
    }

    protected void glMaterial(GL2 gL2, int n, int n2, Color color, float f) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = f;
        gL2.glMaterialfv(n, n2, fArray, 0);
    }

    protected Color makeDarker(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = 0.3f;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return new Color(Math.max(0, (int)((float)n * f)), Math.max(0, (int)((float)n2 * f)), Math.max(0, (int)((float)n3 * f)), n4);
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string = RestorableSupport.encodeColor(this.ambient);
        if (string != null) {
            restorableSupport.addStateValueAsString(stateObject, "ambient", string);
        }
        if ((string = RestorableSupport.encodeColor(this.diffuse)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "diffuse", string);
        }
        if ((string = RestorableSupport.encodeColor(this.specular)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "specular", string);
        }
        if ((string = RestorableSupport.encodeColor(this.emission)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "emission", string);
        }
        restorableSupport.addStateValueAsDouble(stateObject, "shininess", this.shininess);
    }

    public Material restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        Color color;
        String string2;
        Color color2;
        String string3;
        Color color3;
        String string4;
        Color color4;
        double d = this.getShininess();
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "shininess");
        if (d2 != null) {
            d = d2;
        }
        if ((color4 = RestorableSupport.decodeColor(string4 = restorableSupport.getStateValueAsString(stateObject, "ambient"))) == null) {
            color4 = this.getAmbient();
        }
        if ((color3 = RestorableSupport.decodeColor(string3 = restorableSupport.getStateValueAsString(stateObject, "diffuse"))) == null) {
            color3 = this.getDiffuse();
        }
        if ((color2 = RestorableSupport.decodeColor(string2 = restorableSupport.getStateValueAsString(stateObject, "specular"))) == null) {
            color2 = this.getSpecular();
        }
        if ((color = RestorableSupport.decodeColor(string = restorableSupport.getStateValueAsString(stateObject, "emission"))) == null) {
            color = this.getEmission();
        }
        return new Material(color2, color3, color4, color, (float)d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Material material = (Material)object;
        if (Double.compare(this.shininess, material.shininess) != 0) {
            return false;
        }
        if (this.ambient != null ? !this.ambient.equals(material.ambient) : material.ambient != null) {
            return false;
        }
        if (this.diffuse != null ? !this.diffuse.equals(material.diffuse) : material.diffuse != null) {
            return false;
        }
        if (this.specular != null ? !this.specular.equals(material.specular) : material.specular != null) {
            return false;
        }
        return !(this.emission != null ? !this.emission.equals(material.emission) : material.emission != null);
    }

    public int hashCode() {
        long l = this.shininess != 0.0 ? Double.doubleToLongBits(this.shininess) : 0L;
        int n = (int)(l ^ l >>> 32);
        n = 31 * n + (this.ambient != null ? this.ambient.hashCode() : 0);
        n = 31 * n + (this.diffuse != null ? this.diffuse.hashCode() : 0);
        n = 31 * n + (this.specular != null ? this.specular.hashCode() : 0);
        n = 31 * n + (this.emission != null ? this.emission.hashCode() : 0);
        return n;
    }
}

