/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.util.BrowserOpener;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ScreenCreditController
implements Renderable,
SelectListener,
Disposable {
    private int creditWidth = 32;
    private int creditHeight = 32;
    private int leftMargin = 240;
    private int bottomMargin = 10;
    private int separation = 10;
    private double baseOpacity = 0.5;
    private double highlightOpacity = 1.0;
    private WorldWindow wwd;
    private boolean enabled = true;
    private Set<String> badURLsReported = new HashSet<String>();

    public ScreenCreditController(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        if (worldWindow.getSceneController().getScreenCreditController() != null) {
            worldWindow.getSceneController().getScreenCreditController().dispose();
        }
        worldWindow.getSceneController().setScreenCreditController(this);
        worldWindow.addSelectListener(this);
    }

    @Override
    public void dispose() {
        this.wwd.removeSelectListener(this);
        if (this.wwd.getSceneController() == this) {
            this.wwd.getSceneController().setScreenCreditController(null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (drawContext.getScreenCredits() == null || drawContext.getScreenCredits().size() < 1) {
            return;
        }
        Set<Map.Entry<ScreenCredit, Long>> set = drawContext.getScreenCredits().entrySet();
        int n = drawContext.getView().getViewport().height - (this.bottomMargin + this.creditHeight / 2);
        int n2 = this.leftMargin + this.creditWidth / 2;
        for (Map.Entry<ScreenCredit, Long> entry : set) {
            ScreenCredit screenCredit = entry.getKey();
            Rectangle rectangle = new Rectangle(n2, n, this.creditWidth, this.creditHeight);
            screenCredit.setViewport(rectangle);
            screenCredit.pick(drawContext, point);
            n2 += this.separation + this.creditWidth;
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getScreenCredits() == null || drawContext.getScreenCredits().size() < 1) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Set<Map.Entry<ScreenCredit, Long>> set = drawContext.getScreenCredits().entrySet();
        int n = drawContext.getView().getViewport().height - (this.bottomMargin + this.creditHeight / 2);
        int n2 = this.leftMargin + this.creditWidth / 2;
        for (Map.Entry<ScreenCredit, Long> entry : set) {
            ScreenCredit screenCredit = entry.getKey();
            Rectangle rectangle = new Rectangle(n2, n, this.creditWidth, this.creditHeight);
            screenCredit.setViewport(rectangle);
            if (entry.getValue().longValue() == drawContext.getFrameTimeStamp()) {
                Object object = drawContext.getPickedObjects().getTopObject();
                screenCredit.setOpacity(object != null && object instanceof ScreenCredit ? this.highlightOpacity : this.baseOpacity);
                screenCredit.render(drawContext);
            }
            n2 += this.separation + this.creditWidth;
        }
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent.getMouseEvent() != null && selectEvent.getMouseEvent().isConsumed()) {
            return;
        }
        Object object = selectEvent.getTopObject();
        if (object != null && object instanceof ScreenCredit && selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftDoubleClick")) {
            this.openBrowser((ScreenCredit)object);
        }
    }

    protected void openBrowser(ScreenCredit screenCredit) {
        if (screenCredit.getLink() != null && screenCredit.getLink().length() > 0) {
            try {
                BrowserOpener.browse(new URL(screenCredit.getLink()));
            }
            catch (MalformedURLException malformedURLException) {
                if (!this.badURLsReported.contains(screenCredit.getLink())) {
                    String string = Logging.getMessage("generic.URIInvalid", screenCredit.getLink() != null ? screenCredit.getLink() : "null");
                    Logging.logger().warning(string);
                    this.badURLsReported.add(screenCredit.getLink());
                }
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionAttemptingToInvokeWebBrower for URL", screenCredit.getLink());
                Logging.logger().warning(string);
            }
        }
    }
}

