/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FBOTexture;
import gov.nasa.worldwind.render.FramebufferTexture;
import gov.nasa.worldwind.render.LazilyLoadedTexture;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfaceImage
extends WWObjectImpl
implements SurfaceTile,
OrderedRenderable,
PreRenderable,
Movable,
Disposable,
Exportable,
Draggable {
    private Sector sector;
    private Position referencePosition;
    private double opacity = 1.0;
    private boolean pickEnabled = true;
    protected boolean alwaysOnTop = false;
    protected PickSupport pickSupport;
    protected Layer pickLayer;
    protected Object imageSource;
    protected WWTexture sourceTexture;
    protected WWTexture generatedTexture;
    protected List<LatLon> corners;
    protected WWTexture previousSourceTexture;
    protected WWTexture previousGeneratedTexture;
    protected boolean generatedTextureExpired;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected List<SurfaceImage> thisList = Arrays.asList(this);

    public SurfaceImage() {
    }

    public SurfaceImage(Object object, Sector sector) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setImageSource(object, sector);
    }

    public SurfaceImage(Object object, Iterable<? extends LatLon> iterable) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setImageSource(object, iterable);
    }

    @Override
    public void dispose() {
        this.generatedTexture = null;
    }

    public void setImageSource(Object object, Sector sector) {
        this.setImageSource(object, (Iterable<? extends LatLon>)sector);
    }

    public void setImageSource(Object object, Iterable<? extends LatLon> iterable) {
        if (this.sourceTexture != null && object instanceof BufferedImage) {
            this.previousSourceTexture = this.sourceTexture;
        }
        if (this.generatedTexture != null) {
            this.previousGeneratedTexture = this.generatedTexture;
        }
        this.imageSource = object;
        this.sourceTexture = null;
        this.initializeGeometry(iterable);
    }

    public boolean isPickEnabled() {
        return this.pickEnabled;
    }

    public void setPickEnabled(boolean bl) {
        this.pickEnabled = bl;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    protected void initializeGeometry(Iterable<? extends LatLon> iterable) {
        this.corners = new ArrayList<LatLon>(4);
        for (LatLon latLon : iterable) {
            this.corners.add(latLon);
        }
        this.sector = Sector.boundingSector(this.corners);
        this.referencePosition = new Position(this.sector.getCentroid(), 0.0);
        this.generatedTextureExpired = true;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    @Override
    public Sector getSector() {
        return this.sector;
    }

    public void setCorners(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initializeGeometry(iterable);
    }

    public List<LatLon> getCorners() {
        return new ArrayList<LatLon>(this.corners);
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Sector.computeBoundingCylinder(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.getSector());
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        return this.generatedTexture != null && this.generatedTexture.bind(drawContext);
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext, boolean bl) {
        if (this.generatedTexture != null) {
            this.generatedTexture.applyInternalTransform(drawContext);
        }
    }

    @Override
    public double getDistanceFromEye() {
        return 0.0;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        WWTexture wWTexture;
        if (drawContext.isOrderedRenderingMode()) {
            return;
        }
        if (this.previousSourceTexture != null) {
            drawContext.getTextureCache().remove(this.previousSourceTexture.getImageSource());
            this.previousSourceTexture = null;
        }
        if (this.getImageSource() != null && this.sourceTexture == null) {
            this.initializeSourceTexture(drawContext);
        }
        if (this.sourceTexture == null) {
            return;
        }
        if ((this.generatedTexture == null || this.generatedTextureExpired) && (wWTexture = this.initializeGeneratedTexture(drawContext)) != null) {
            this.generatedTexture = wWTexture;
            this.generatedTextureExpired = false;
            if (this.previousGeneratedTexture != null) {
                drawContext.getTextureCache().remove(this.previousGeneratedTexture);
                this.previousGeneratedTexture = null;
            }
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.isPickingMode() && !this.isPickEnabled()) {
            return;
        }
        if (this.getSector() == null || !this.getSector().intersects(drawContext.getVisibleSector())) {
            return;
        }
        if (this.sourceTexture == null && this.generatedTexture == null) {
            return;
        }
        if (!drawContext.isOrderedRenderingMode() && this.isAlwaysOnTop()) {
            this.pickLayer = drawContext.getCurrentLayer();
            drawContext.addOrderedSurfaceRenderable(this);
            return;
        }
        this.draw(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (this.pickSupport == null) {
            this.pickSupport = new PickSupport();
        }
        try {
            this.pickSupport.beginPicking(drawContext);
            Color color = drawContext.getUniquePickColor();
            drawContext.getGL().getGL2().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            this.pickSupport.addPickableObject(color.getRGB(), this);
            this.draw(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            if (!drawContext.isPickingMode()) {
                double d;
                double d2 = d = drawContext.getCurrentLayer() != null ? this.getOpacity() * drawContext.getCurrentLayer().getOpacity() : this.getOpacity();
                if (d < 1.0) {
                    gL2.glPushAttrib(16393);
                    gL2.glColor4d(d, d, d, d);
                } else {
                    gL2.glPushAttrib(16392);
                }
                gL2.glEnable(3042);
                gL2.glBlendFunc(1, 771);
            } else {
                gL2.glPushAttrib(8);
            }
            gL2.glPolygonMode(1028, 6914);
            gL2.glEnable(2884);
            gL2.glCullFace(1029);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.thisList);
        }
        finally {
            gL2.glPopAttrib();
        }
    }

    protected void initializeSourceTexture(DrawContext drawContext) {
        this.sourceTexture = new LazilyLoadedTexture(this.getImageSource(), true);
    }

    protected WWTexture initializeGeneratedTexture(DrawContext drawContext) {
        if (Sector.isSector(this.corners) && this.sector.isSameSector(this.corners)) {
            if (this.sourceTexture.bind(drawContext)) {
                this.generatedTexture = this.sourceTexture;
                return this.generatedTexture;
            }
            return null;
        }
        FramebufferTexture framebufferTexture = drawContext.getGLRuntimeCapabilities().isUseFramebufferObject() ? new FBOTexture(this.sourceTexture, this.sector, this.corners) : new FramebufferTexture(this.sourceTexture, this.sector, this.corners);
        framebufferTexture.bind(drawContext);
        return framebufferTexture;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        for (int i = 0; i < this.corners.size(); ++i) {
            LatLon latLon = this.corners.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position2, (LatLon)latLon).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)latLon).radians;
            LatLon latLon2 = LatLon.greatCircleEndPosition((LatLon)position, d2, d);
            this.corners.set(i, latLon2);
        }
        this.setCorners(this.corners);
    }

    @Override
    public Position getReferencePosition() {
        return this.referencePosition;
    }

    protected void setReferencePosition(Position position) {
        this.referencePosition = position;
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, 1);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SurfaceImage surfaceImage = (SurfaceImage)object;
        if (this.getSector() == null || surfaceImage.getSector() == null) {
            return false;
        }
        if (this.getImageSource() == null) {
            return surfaceImage.imageSource == null && this.getSector().equals(surfaceImage.getSector());
        }
        return this.getImageSource().equals(surfaceImage.getImageSource()) && this.getSector().equals(surfaceImage.getSector());
    }

    public int hashCode() {
        int n = this.getImageSource() != null ? this.getImageSource().hashCode() : 0;
        n = 31 * n + this.getSector().hashCode();
        return n;
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.writeStartElement("GroundOverlay");
        String string = null;
        Object object2 = this.getImageSource();
        if (object2 instanceof String || object2 instanceof URL) {
            string = object2.toString();
        }
        if (string != null) {
            xMLStreamWriter.writeStartElement("Icon");
            xMLStreamWriter.writeStartElement("href");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        } else {
            String string2 = Logging.getMessage("Export.UnableToExportImageSource", object2 != null ? object2.getClass().getName() : "null");
            Logging.logger().info(string2);
        }
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        if (Sector.isSector(this.corners)) {
            this.exportKMLLatLonBox(xMLStreamWriter);
        } else {
            this.exportKMLLatLonQuad(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    protected void exportKMLLatLonBox(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("LatLonBox");
        xMLStreamWriter.writeStartElement("north");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMaxLatitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("south");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMinLatitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("east");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMinLongitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("west");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMaxLongitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    protected void exportKMLLatLonQuad(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("http://www.google.com/kml/ext/2.2", "LatLonQuad");
        xMLStreamWriter.writeStartElement("coordinates");
        for (LatLon latLon : this.corners) {
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLongitude().getDegrees()));
            xMLStreamWriter.writeCharacters(",");
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLatitude().getDegrees()));
            xMLStreamWriter.writeCharacters(" ");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }
}

