/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.ContourList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class SurfaceMultiPolygon
extends AbstractSurfaceShape {
    protected ContourList boundaries = new ContourList();

    public SurfaceMultiPolygon() {
    }

    public SurfaceMultiPolygon(SurfaceMultiPolygon surfaceMultiPolygon) {
        super(surfaceMultiPolygon);
        this.boundaries.addAllContours(surfaceMultiPolygon.boundaries);
    }

    public SurfaceMultiPolygon(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceMultiPolygon(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addContour(iterable);
    }

    public SurfaceMultiPolygon(ContourList contourList) {
        if (contourList == null) {
            String string = Logging.getMessage("nullValue.ContourListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addAllContours(contourList);
    }

    public SurfaceMultiPolygon(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes);
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addContour(iterable);
    }

    public SurfaceMultiPolygon(ShapeAttributes shapeAttributes, ContourList contourList) {
        super(shapeAttributes);
        if (contourList == null) {
            String string = Logging.getMessage("nullValue.ContourListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addAllContours(contourList);
    }

    public int getBoundaryCount() {
        return this.boundaries.getContourCount();
    }

    public Iterable<? extends LatLon> getBoundary(int n) {
        return this.boundaries.getContour(n);
    }

    public void addBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addContour(iterable);
    }

    public void addAllBoundaries(ContourList contourList) {
        if (contourList == null) {
            String string = Logging.getMessage("nullValue.ContourListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.addAllContours(contourList);
    }

    public void removeAllBoundaries() {
        this.boundaries.removeAllContours();
    }

    @Override
    public Position getReferencePosition() {
        if (this.boundaries.getContourCount() == 0) {
            return null;
        }
        Iterator<? extends LatLon> iterator = this.boundaries.getContour(0).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return new Position(iterator.next(), 0.0);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (this.boundaries.getContourCount() == 0) {
            return;
        }
        for (int i = 0; i < this.boundaries.getContourCount(); ++i) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (LatLon latLon : this.boundaries.getContour(i)) {
                Angle angle = LatLon.greatCircleAzimuth(position, latLon);
                Angle angle2 = LatLon.greatCircleDistance(position, latLon);
                arrayList.add(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
            }
            this.boundaries.setContour(i, arrayList);
        }
        this.onShapeChanged();
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (this.boundaries.getContourCount() == 0) {
            return;
        }
        for (int i = 0; i < this.boundaries.getContourCount(); ++i) {
            List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, this.boundaries.getContour(i));
            this.boundaries.setContour(i, list);
        }
        this.onShapeChanged();
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, double d) {
        if (this.boundaries.getContourCount() == 0) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList = new ArrayList<List<LatLon>>();
        for (int i = 0; i < this.boundaries.getContourCount(); ++i) {
            ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
            this.generateIntermediateLocations(this.boundaries.getContour(i), d, true, arrayList2);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (this.boundaries.getContourCount() == 0) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (int i = 0; i < this.boundaries.getContourCount(); ++i) {
            for (LatLon latLon : this.boundaries.getContour(i)) {
                arrayList.add(latLon);
            }
        }
        return arrayList;
    }

    @Override
    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
        super.handleUnsuccessfulInteriorTessellation(drawContext);
        this.boundaries.removeAllContours();
        this.onShapeChanged();
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        if (this.boundaries.getContourCount() > 0) {
            RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "boundaries");
            for (int i = 0; i < this.boundaries.getContourCount(); ++i) {
                restorableSupport.addStateValueAsLatLonList(stateObject2, "boundary", this.boundaries.getContour(i));
            }
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "boundaries");
        if (stateObject2 != null) {
            this.boundaries.removeAllContours();
            RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "boundary");
            if (stateObjectArray != null) {
                for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                    List<LatLon> list;
                    if (stateObject3 == null || (list = restorableSupport.getStateObjectAsLatLonList(stateObject3)) == null) continue;
                    this.boundaries.addContour(list);
                }
            }
            this.onShapeChanged();
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException("KML output not supported for SurfaceMultiPolygon");
    }
}

