/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;

public class SurfaceText
extends AbstractSurfaceObject
implements GeographicText,
Movable,
Draggable {
    public static final double DEFAULT_TEXT_SIZE_IN_METERS = 1000.0;
    public static final Font DEFAULT_FONT = Font.decode("Arial-BOLD-24");
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Offset DEFAULT_OFFSET = new Offset(-0.5, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    protected CharSequence text;
    protected Position location;
    protected double textSizeInMeters = 1000.0;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected Font font = DEFAULT_FONT;
    protected Color color = DEFAULT_COLOR;
    protected Color bgColor;
    protected double priority;
    protected Offset offset = DEFAULT_OFFSET;
    protected Rectangle2D textBounds;
    protected double pixelSizeInMeters;
    protected double scale;
    protected LatLon drawLocation;
    protected boolean spansAntimeridian = false;

    public SurfaceText(String string, Position position) {
        this.setText(string);
        this.setPosition(position);
    }

    public SurfaceText(String string, Position position, Font font, Color color) {
        this.setText(string);
        this.setPosition(position);
        this.setFont(font);
        this.setColor(color);
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public void setText(CharSequence charSequence) {
        if (charSequence == null) {
            String string = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.text = charSequence;
        this.textBounds = null;
        this.updateModifiedTime();
    }

    @Override
    public Position getPosition() {
        return this.location;
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = position;
        this.updateModifiedTime();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!font.equals(this.font)) {
            this.font = font;
            this.textBounds = null;
            this.updateModifiedTime();
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!color.equals(this.color)) {
            this.color = color;
            this.updateModifiedTime();
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.bgColor == null || !this.bgColor.equals(color)) {
            this.bgColor = color;
            this.updateModifiedTime();
        }
    }

    @Override
    public void setPriority(double d) {
        this.priority = d;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        if (offset == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!offset.equals(this.offset)) {
            this.offset = offset;
            this.updateModifiedTime();
        }
    }

    public double getTextSize() {
        return this.textSizeInMeters;
    }

    public void setTextSize(double d) {
        this.textSizeInMeters = d;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (this.textBounds == null) {
            this.updateTextBounds(drawContext);
        }
        super.preRender(drawContext);
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.location, 0.0);
    }

    @Override
    public void move(Position position) {
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        this.setPosition(position);
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, 1);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    @Override
    public List<Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Arrays.asList(this.computeSector(drawContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 4097);
        oGLStackHandler.pushModelview(gL2);
        try {
            this.computeGeometry(drawContext, surfaceTileDrawContext);
            if (this.isSmall()) {
                return;
            }
            this.applyDrawTransform(drawContext, surfaceTileDrawContext);
            this.drawText(drawContext);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawText(DrawContext drawContext) {
        TextRenderer textRenderer = this.getTextRenderer(drawContext);
        Point2D.Double double_ = this.getOffset().computeOffset(this.textBounds.getWidth(), this.textBounds.getHeight(), null, null);
        int n = (int)((Point2D)double_).getX();
        int n2 = (int)((Point2D)double_).getY();
        try {
            textRenderer.begin3DRendering();
            Color color = this.determineBackgroundColor(this.color);
            CharSequence charSequence = this.getText();
            textRenderer.setColor(color);
            textRenderer.draw(charSequence, n + 1, n2 - 1);
            textRenderer.setColor(this.getColor());
            textRenderer.draw(charSequence, n, n2);
        }
        finally {
            textRenderer.end3DRendering();
        }
    }

    protected void computeGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        this.pixelSizeInMeters = this.computePixelSize(drawContext, surfaceTileDrawContext);
        double d = this.pixelSizeInMeters * this.textBounds.getHeight();
        this.scale = this.textSizeInMeters / d;
    }

    protected void applyDrawTransform(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        Vec4 vec4 = new Vec4(this.location.getLongitude().degrees, this.location.getLatitude().degrees, 1.0);
        if (this.spansAntimeridian && Math.signum(surfaceTileDrawContext.getSector().getMinLongitude().degrees) != Math.signum(this.drawLocation.longitude.degrees)) {
            vec4 = new Vec4(this.location.getLongitude().degrees - 360.0, this.location.getLatitude().degrees, 1.0);
        }
        vec4 = vec4.transformBy4(surfaceTileDrawContext.getModelviewMatrix());
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTranslated(vec4.x(), vec4.y(), vec4.z());
        gL2.glScaled(this.scale, this.scale, 1.0);
    }

    protected boolean isSmall() {
        return this.scale * this.textSizeInMeters < this.pixelSizeInMeters;
    }

    protected double computePixelSize(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        return drawContext.getGlobe().getRadius() * surfaceTileDrawContext.getSector().getDeltaLatRadians() / (double)surfaceTileDrawContext.getViewport().height;
    }

    protected Color determineBackgroundColor(Color color) {
        Color color2 = this.getBackgroundColor();
        if (color2 != null) {
            return color2;
        }
        return this.computeBackgroundColor(color);
    }

    protected Color computeBackgroundColor(Color color) {
        float[] fArray = new float[4];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        if ((double)fArray[2] > 0.5) {
            return new Color(0.0f, 0.0f, 0.0f, 0.7f);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.7f);
    }

    protected Sector[] computeSector(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        double d = this.textBounds.getWidth();
        double d2 = this.textBounds.getHeight();
        double d3 = this.textSizeInMeters;
        double d4 = d3 * (d / d2);
        double d5 = globe.getRadius();
        double d6 = d3 / d5;
        double d7 = d4 / d5;
        Point2D.Double double_ = this.getOffset().computeOffset(d, d2, null, null);
        double d8 = d3 / d2;
        double d9 = ((Point2D)double_).getX() * d8 / d5;
        double d10 = ((Point2D)double_).getY() * d8 / d5;
        double d11 = this.location.latitude.addRadians((double)d10).degrees;
        double d12 = this.location.latitude.addRadians((double)(d10 + d6)).degrees;
        double d13 = this.location.longitude.addRadians((double)d9).degrees;
        double d14 = this.location.longitude.addRadians((double)(d9 + d7)).degrees;
        this.drawLocation = LatLon.fromDegrees(d11, d13);
        if (d14 > 180.0) {
            Sector[] sectorArray = new Sector[]{Sector.fromDegrees(d11, d12, d13, 180.0), Sector.fromDegrees(d11, d12, -180.0, d14 - 360.0)};
            this.spansAntimeridian = true;
            return sectorArray;
        }
        this.spansAntimeridian = false;
        return new Sector[]{Sector.fromDegrees(d11, d12, d13, d14)};
    }

    protected TextRenderer getTextRenderer(DrawContext drawContext) {
        return OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), this.getFont(), true, false, false);
    }

    protected void updateTextBounds(DrawContext drawContext) {
        this.textBounds = this.getTextRenderer(drawContext).getBounds(this.text);
    }
}

