/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.render.airspaces.SurfaceBox;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class Box
extends AbstractAirspace {
    protected static final int DEFAULT_PILLARS = 8;
    protected static final int DEFAULT_STACKS = 2;
    protected static final int DEFAULT_CENTER_LINE_STIPPLE_FACTOR = 2;
    protected static final short DEFAULT_CENTER_LINE_STIPPLE_PATTERN = -4370;
    protected static final double DEFAULT_CENTER_LINE_OFFSET = 0.999;
    private LatLon beginLocation = LatLon.ZERO;
    private LatLon endLocation = LatLon.ZERO;
    private double leftWidth = 1.0;
    private double rightWidth = 1.0;
    private Angle beginLeftAzimuth = null;
    private Angle beginRightAzimuth = null;
    private Angle endLeftAzimuth = null;
    private Angle endRightAzimuth = null;
    private boolean enableStartCap = true;
    private boolean enableEndCap = true;
    private boolean enableCenterLine;
    private boolean forceCullFace = false;
    private int pillars = 8;
    private int stacks = 2;
    private Object geometryCacheKey = new Object();

    public Box(LatLon latLon, LatLon latLon2, double d, double d2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "leftWidth < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "rightWidth < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginLocation = latLon;
        this.endLocation = latLon2;
        this.leftWidth = d;
        this.rightWidth = d2;
        this.makeDefaultDetailLevels();
    }

    public Box(Box box) {
        super(box);
        this.beginLocation = box.beginLocation;
        this.endLocation = box.endLocation;
        this.leftWidth = box.leftWidth;
        this.rightWidth = box.rightWidth;
        this.beginLeftAzimuth = box.beginLeftAzimuth;
        this.beginRightAzimuth = box.beginRightAzimuth;
        this.endLeftAzimuth = box.endLeftAzimuth;
        this.endRightAzimuth = box.endRightAzimuth;
        this.enableStartCap = box.enableStartCap;
        this.enableEndCap = box.enableEndCap;
        this.enableCenterLine = box.enableCenterLine;
        this.forceCullFace = box.forceCullFace;
        this.pillars = box.pillars;
        this.stacks = box.stacks;
        this.makeDefaultDetailLevels();
    }

    public Box(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public Box() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Pillars", 8);
        screenSizeDetailLevel.setValue("Stacks", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Pillars", 6);
        screenSizeDetailLevel.setValue("Stacks", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Pillars", 4);
        screenSizeDetailLevel.setValue("Stacks", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Pillars", 2);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Pillars", 1);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon[] getLocations() {
        return new LatLon[]{this.beginLocation, this.endLocation};
    }

    public void setLocations(LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginLocation = latLon;
        this.endLocation = latLon2;
        this.invalidateGeometry();
    }

    public double[] getWidths() {
        double[] dArray = new double[]{this.leftWidth, this.rightWidth};
        return dArray;
    }

    public void setWidths(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "leftWidth=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "rightWidth=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leftWidth = d;
        this.rightWidth = d2;
        this.invalidateGeometry();
    }

    public Angle[] getCornerAzimuths() {
        return new Angle[]{this.beginLeftAzimuth, this.beginRightAzimuth, this.endLeftAzimuth, this.endRightAzimuth};
    }

    public void setCornerAzimuths(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        this.beginLeftAzimuth = angle;
        this.beginRightAzimuth = angle2;
        this.endLeftAzimuth = angle3;
        this.endRightAzimuth = angle4;
        this.invalidateGeometry();
    }

    public boolean[] isEnableCaps() {
        boolean[] blArray = new boolean[]{this.enableStartCap, this.enableEndCap};
        return blArray;
    }

    public void setEnableCaps(boolean bl, boolean bl2) {
        this.enableStartCap = bl;
        this.enableEndCap = bl2;
        this.invalidateGeometry();
    }

    public void setEnableCaps(boolean bl) {
        this.setEnableCaps(bl, bl);
    }

    public void setEnableStartCap(boolean bl) {
        this.setEnableCaps(bl, this.enableEndCap);
    }

    public void setEnableEndCap(boolean bl) {
        this.setEnableCaps(this.enableStartCap, bl);
    }

    public boolean isEnableCenterLine() {
        return this.enableCenterLine;
    }

    public void setEnableCenterLine(boolean bl) {
        this.enableCenterLine = bl;
        this.invalidateGeometry();
    }

    @Override
    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.beginLocation, dArray[0]);
    }

    protected void invalidateGeometry() {
        this.invalidateAirspaceData();
        this.geometryCacheKey = new Object();
    }

    @Override
    protected gov.nasa.worldwind.geom.Box computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return gov.nasa.worldwind.geom.Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        List<LatLon> list = this.makeCapLocations(globe, 8, 2);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, list, arrayList);
        return arrayList;
    }

    @Override
    protected SurfaceShape createSurfaceShape() {
        return new SurfaceBox();
    }

    @Override
    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        int n = this.getPillars();
        int n2 = this.getStacks();
        List<LatLon> list = this.makeSideLocations(drawContext.getGlobe(), n, n2);
        ((SurfaceBox)surfaceShape).setLocations(list);
        ((SurfaceBox)surfaceShape).setLengthSegments(n);
        ((SurfaceBox)surfaceShape).setWidthSegments(n2);
        ((SurfaceBox)surfaceShape).setEnableCaps(this.isEnableCaps()[0], this.isEnableCaps()[1]);
        ((SurfaceBox)surfaceShape).setEnableCenterLine(this.isEnableCenterLine());
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(2);
        arrayList.add(this.getLocations()[0]);
        arrayList.add(this.getLocations()[1]);
        List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, arrayList);
        this.setLocations(list.get(0), list.get(1));
        super.doMoveTo(position, position2);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        LatLon[] latLonArray = this.getLocations();
        int n = latLonArray.length;
        for (int i = 0; i < n; ++i) {
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLonArray[i]).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLonArray[i]).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(latLonArray[0], latLonArray[1]);
    }

    protected boolean isForceCullFace() {
        return this.forceCullFace;
    }

    protected void setForceCullFace(boolean bl) {
        this.forceCullFace = bl;
    }

    protected int getPillars() {
        return this.pillars;
    }

    protected void setPillars(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pillars = n;
    }

    protected int getStacks() {
        return this.stacks;
    }

    protected void setStacks(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "stacks=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.stacks = n;
    }

    protected int getHeightStacks() {
        return 1;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        return extent != null ? extent.getCenter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        int n = this.getPillars();
        int n2 = this.getStacks();
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Pillars");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        this.setExpiryTime(this.nextExpiryTime(drawContext, this.isTerrainConforming()));
        this.clearElevationMap();
        object2 = drawContext.getGL().getGL2();
        object = new OGLStackHandler();
        try {
            if (this.forceCullFace || !this.enableStartCap || !this.enableEndCap) {
                ((OGLStackHandler)object).pushAttrib((GL2)object2, 8);
                object2.glEnable(2884);
                object2.glFrontFace(2305);
            }
            if ("Airspace.DrawStyleFill".equals(string)) {
                this.drawBox(drawContext, dArray, blArray, n, n2);
            } else if ("Airspace.DrawStyleOutline".equals(string)) {
                this.drawBoxOutline(drawContext, dArray, blArray, n, n2);
                if (this.enableCenterLine) {
                    this.drawBoxCenterLine(drawContext, dArray, blArray, n, n2);
                }
            }
        }
        finally {
            ((OGLStackHandler)object).pop((GL2)object2);
        }
    }

    protected void applyCenterLineState(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        AirspaceAttributes airspaceAttributes = this.getActiveAttributes();
        if (airspaceAttributes.getOutlineStippleFactor() <= 0) {
            gL2.glEnable(2852);
            gL2.glLineStipple(2, (short)-4370);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBox(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2) {
        BoxGeometry boxGeometry = this.getBoxGeometry(drawContext, dArray, blArray, n, n2);
        try {
            drawContext.getView().pushReferenceCenter(drawContext, boxGeometry.referencePoint);
            this.drawGeometry(drawContext, boxGeometry.sideGeometry, boxGeometry.sideGeometry);
            this.drawGeometry(drawContext, boxGeometry.capGeometry, boxGeometry.capGeometry);
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBoxOutline(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2) {
        BoxGeometry boxGeometry = this.getBoxGeometry(drawContext, dArray, blArray, n, n2);
        try {
            drawContext.getView().pushReferenceCenter(drawContext, boxGeometry.referencePoint);
            this.drawGeometry(drawContext, boxGeometry.outlineIndices, boxGeometry.sideGeometry);
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBoxCenterLine(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2) {
        BoxGeometry boxGeometry = this.getBoxGeometry(drawContext, dArray, blArray, n, n2);
        try {
            drawContext.getView().pushReferenceCenter(drawContext, boxGeometry.referencePoint);
            drawContext.pushProjectionOffest(0.999);
            this.applyCenterLineState(drawContext);
            this.drawGeometry(drawContext, boxGeometry.centerLineIndices, boxGeometry.capGeometry);
        }
        finally {
            drawContext.popProjectionOffest();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    private BoxGeometry getBoxGeometry(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Box.Geometry", this.geometryCacheKey, dArray, blArray, n, n2);
        BoxGeometry boxGeometry = (BoxGeometry)this.getGeometryCache().getObject(cacheKey);
        if (boxGeometry != null && !this.isExpired(drawContext, boxGeometry.sideGeometry)) {
            return boxGeometry;
        }
        if (boxGeometry == null) {
            boxGeometry = new BoxGeometry();
        }
        this.makeBoxGeometry(drawContext, dArray, blArray, n, n2, boxGeometry);
        this.updateExpiryCriteria(drawContext, boxGeometry.sideGeometry);
        this.getGeometryCache().add(cacheKey, boxGeometry);
        return boxGeometry;
    }

    private void makeBoxGeometry(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2, BoxGeometry boxGeometry) {
        boxGeometry.referencePoint = this.computeReferenceCenter(drawContext);
        this.makeSideGeometry(drawContext.getTerrain(), dArray, blArray, n, n2, boxGeometry);
        this.makeCapGeometry(drawContext.getTerrain(), dArray, blArray, n, n2, boxGeometry);
    }

    private void makeSideGeometry(Terrain terrain, double[] dArray, boolean[] blArray, int n, int n2, BoxGeometry boxGeometry) {
        int n3;
        int n4;
        List<LatLon> list = this.makeSideLocations(terrain.getGlobe(), n, n2);
        int n5 = 2 * list.size();
        float[] fArray = new float[3 * n5];
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray);
        for (LatLon object2 : list) {
            for (n4 = 1; n4 >= 0; --n4) {
                Vec4 n6 = blArray[n4] ? terrain.getSurfacePoint(object2.latitude, object2.longitude, dArray[n4]) : terrain.getGlobe().computePointFromPosition(object2.latitude, object2.longitude, dArray[n4]);
                floatBuffer.put((float)(n6.x - boxGeometry.referencePoint.x));
                floatBuffer.put((float)(n6.y - boxGeometry.referencePoint.y));
                floatBuffer.put((float)(n6.z - boxGeometry.referencePoint.z));
            }
        }
        Object object3 = new int[]{2 * n2, n, 2 * n2, n};
        boolean[] blArray2 = new boolean[]{this.enableStartCap, true, this.enableEndCap, true};
        n4 = 0;
        int n6 = 8;
        for (n3 = 0; n3 < 4; ++n3) {
            if (!blArray2[n3]) continue;
            n4 += 6 * object3[n3];
            n6 += 4 * object3[n3];
        }
        n3 = 0;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n6];
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        IntBuffer intBuffer2 = IntBuffer.wrap(nArray2);
        for (int fArray2 = 0; fArray2 < 4; ++fArray2) {
            for (int geometryBuilder = 0; geometryBuilder < object3[fArray2]; ++geometryBuilder) {
                if (blArray2[fArray2]) {
                    intBuffer.put(n3).put(n3 + 1).put(n3 + 2);
                    intBuffer.put(n3 + 2).put(n3 + 1).put(n3 + 3);
                    intBuffer2.put(n3).put(n3 + 2);
                    intBuffer2.put(n3 + 1).put(n3 + 3);
                }
                n3 += 2;
            }
            intBuffer2.put(n3).put(n3 + 1);
            n3 += 2;
        }
        float[] fArray2 = new float[3 * n5];
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        geometryBuilder.makeIndexedTriangleArrayNormals(0, n4, nArray, 0, n5, fArray, fArray2);
        boxGeometry.sideGeometry.setVertexData(n5, fArray);
        boxGeometry.sideGeometry.setNormalData(n5, fArray2);
        boxGeometry.sideGeometry.setElementData(4, n4, nArray);
        boxGeometry.outlineIndices.setElementData(1, n6, nArray2);
    }

    private void makeCapGeometry(Terrain terrain, double[] dArray, boolean[] blArray, int n, int n2, BoxGeometry boxGeometry) {
        int n3;
        int n4;
        Object object;
        List<LatLon> list = this.makeCapLocations(terrain.getGlobe(), n, n2);
        int n5 = 2 * list.size();
        float[] fArray = new float[3 * n5];
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray);
        for (LatLon latLon : list) {
            for (int i = 1; i >= 0; --i) {
                object = blArray[i] ? terrain.getSurfacePoint(latLon.latitude, latLon.longitude, dArray[i]) : terrain.getGlobe().computePointFromPosition(latLon.latitude, latLon.longitude, dArray[i]);
                floatBuffer.put((float)(((Vec4)object).x - boxGeometry.referencePoint.x));
                floatBuffer.put((float)(((Vec4)object).y - boxGeometry.referencePoint.y));
                floatBuffer.put((float)(((Vec4)object).z - boxGeometry.referencePoint.z));
            }
        }
        int n6 = 4 * n * n2;
        int n7 = 6 * n6;
        int[] nArray = new int[n7];
        object = IntBuffer.wrap(nArray);
        int n8 = 0;
        int n9 = 4 * n2 + 2;
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < 2 * n2; ++n3) {
                ((IntBuffer)object).put(n8).put(n8 + 2).put(n8 + n9);
                ((IntBuffer)object).put(n8 + n9).put(n8 + 2).put(n8 + n9 + 2);
                ((IntBuffer)object).put(++n8).put(n8 + n9).put(n8 + 2);
                ((IntBuffer)object).put(n8 + 2).put(n8 + n9).put(n8 + n9 + 2);
                ++n8;
            }
            n8 += 2;
        }
        n4 = 2 * n + (this.enableStartCap ? 1 : 0) + (this.enableEndCap ? 1 : 0);
        n3 = 2 * n4;
        int[] nArray2 = new int[n3];
        IntBuffer intBuffer = IntBuffer.wrap(nArray2);
        n8 = 2 * n2;
        if (this.enableStartCap) {
            intBuffer.put(n8).put(n8 + 1);
        }
        for (int i = 0; i < n; ++i) {
            intBuffer.put(n8).put(n8 + n9);
            intBuffer.put(n8 + 1).put(n8 + n9 + 1);
            n8 += n9;
        }
        if (this.enableEndCap) {
            intBuffer.put(n8).put(n8 + 1);
        }
        float[] fArray2 = new float[3 * n5];
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        geometryBuilder.makeIndexedTriangleArrayNormals(0, n7, nArray, 0, n5, fArray, fArray2);
        boxGeometry.capGeometry.setVertexData(n5, fArray);
        boxGeometry.capGeometry.setNormalData(n5, fArray2);
        boxGeometry.capGeometry.setElementData(4, n7, nArray);
        boxGeometry.centerLineIndices.setElementData(1, n3, nArray2);
    }

    private List<LatLon> makeSideLocations(Globe globe, int n, int n2) {
        LatLon latLon;
        double d;
        LatLon latLon2;
        double d2;
        int n3;
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        BoxCorners boxCorners = this.computeBoxCorners(globe);
        this.appendLocations(boxCorners.beginLeft, this.beginLocation, boxCorners.beginRight, n2, arrayList);
        arrayList.add(boxCorners.beginRight);
        for (n3 = 1; n3 < n; ++n3) {
            d2 = (double)n3 / (double)n;
            latLon2 = LatLon.interpolateGreatCircle(d2, boxCorners.beginRightProj, boxCorners.endRightProj);
            d = LatLon.greatCircleAzimuth((LatLon)latLon2, (LatLon)boxCorners.endRightProj).radians + 1.5707963267948966;
            latLon = LatLon.greatCircleEndPosition(latLon2, d, boxCorners.rightArcLength);
            arrayList.add(latLon);
        }
        arrayList.add(boxCorners.endRight);
        this.appendLocations(boxCorners.endRight, this.endLocation, boxCorners.endLeft, n2, arrayList);
        arrayList.add(boxCorners.endLeft);
        for (n3 = 1; n3 < n; ++n3) {
            d2 = (double)n3 / (double)n;
            latLon2 = LatLon.interpolateGreatCircle(d2, boxCorners.endLeftProj, boxCorners.beginLeftProj);
            d = LatLon.greatCircleAzimuth((LatLon)latLon2, (LatLon)boxCorners.endLeftProj).radians - 1.5707963267948966;
            latLon = LatLon.greatCircleEndPosition(latLon2, d, boxCorners.leftArcLength);
            arrayList.add(latLon);
        }
        arrayList.add(boxCorners.beginLeft);
        return arrayList;
    }

    private List<LatLon> makeCapLocations(Globe globe, int n, int n2) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        BoxCorners boxCorners = this.computeBoxCorners(globe);
        this.appendLocations(boxCorners.beginLeft, this.beginLocation, boxCorners.beginRight, n2, arrayList);
        for (int i = 1; i < n; ++i) {
            double d = (double)i / (double)n;
            LatLon latLon = LatLon.interpolateGreatCircle(d, this.beginLocation, this.endLocation);
            LatLon latLon2 = LatLon.interpolateGreatCircle(d, boxCorners.beginLeftProj, boxCorners.endLeftProj);
            LatLon latLon3 = LatLon.interpolateGreatCircle(d, boxCorners.beginRightProj, boxCorners.endRightProj);
            double d2 = LatLon.greatCircleAzimuth((LatLon)latLon2, (LatLon)boxCorners.endLeftProj).radians - 1.5707963267948966;
            double d3 = LatLon.greatCircleAzimuth((LatLon)latLon3, (LatLon)boxCorners.endRightProj).radians + 1.5707963267948966;
            LatLon latLon4 = LatLon.greatCircleEndPosition(latLon2, d2, boxCorners.leftArcLength);
            LatLon latLon5 = LatLon.greatCircleEndPosition(latLon3, d3, boxCorners.rightArcLength);
            this.appendLocations(latLon4, latLon, latLon5, n2, arrayList);
        }
        this.appendLocations(boxCorners.endLeft, this.endLocation, boxCorners.endRight, n2, arrayList);
        return arrayList;
    }

    private BoxCorners computeBoxCorners(Globe globe) {
        double d;
        double d2;
        double d3;
        BoxCorners boxCorners = new BoxCorners();
        double d4 = LatLon.greatCircleAzimuth((LatLon)this.beginLocation, (LatLon)this.endLocation).radians;
        double d5 = LatLon.greatCircleAzimuth((LatLon)this.endLocation, (LatLon)this.beginLocation).radians;
        double d6 = LatLon.greatCircleDistance((LatLon)this.beginLocation, (LatLon)this.endLocation).radians;
        boxCorners.leftArcLength = this.leftWidth / globe.getRadius();
        boxCorners.rightArcLength = this.rightWidth / globe.getRadius();
        boxCorners.beginLeft = LatLon.greatCircleEndPosition(this.beginLocation, d4 - 1.5707963267948966, boxCorners.leftArcLength);
        boxCorners.beginLeftProj = this.beginLocation;
        if (this.beginLeftAzimuth != null) {
            d3 = d4 - this.beginLeftAzimuth.radians;
            d2 = Math.asin(Math.cos(d3) * Math.sin(boxCorners.leftArcLength) / Math.sin(d3));
            d = Math.asin(Math.sin(boxCorners.leftArcLength) / Math.sin(d3));
            if (d2 < d6) {
                boxCorners.beginLeft = LatLon.greatCircleEndPosition(this.beginLocation, this.beginLeftAzimuth.radians, d);
                boxCorners.beginLeftProj = LatLon.greatCircleEndPosition(this.beginLocation, d4, d2);
            }
        }
        boxCorners.beginRight = LatLon.greatCircleEndPosition(this.beginLocation, d4 + 1.5707963267948966, boxCorners.rightArcLength);
        boxCorners.beginRightProj = this.beginLocation;
        if (this.beginRightAzimuth != null) {
            d3 = this.beginRightAzimuth.radians - d4;
            d2 = Math.asin(Math.cos(d3) * Math.sin(boxCorners.rightArcLength) / Math.sin(d3));
            d = Math.asin(Math.sin(boxCorners.rightArcLength) / Math.sin(d3));
            if (d2 < d6) {
                boxCorners.beginRight = LatLon.greatCircleEndPosition(this.beginLocation, this.beginRightAzimuth.radians, d);
                boxCorners.beginRightProj = LatLon.greatCircleEndPosition(this.beginLocation, d4, d2);
            }
        }
        boxCorners.endLeft = LatLon.greatCircleEndPosition(this.endLocation, d5 + 1.5707963267948966, boxCorners.leftArcLength);
        boxCorners.endLeftProj = this.endLocation;
        if (this.endLeftAzimuth != null) {
            d3 = this.endLeftAzimuth.radians - d5;
            d2 = Math.asin(Math.cos(d3) * Math.sin(boxCorners.leftArcLength) / Math.sin(d3));
            d = Math.asin(Math.sin(boxCorners.leftArcLength) / Math.sin(d3));
            if (d2 < d6) {
                boxCorners.endLeft = LatLon.greatCircleEndPosition(this.endLocation, this.endLeftAzimuth.radians, d);
                boxCorners.endLeftProj = LatLon.greatCircleEndPosition(this.endLocation, d5, d2);
            }
        }
        boxCorners.endRight = LatLon.greatCircleEndPosition(this.endLocation, d5 - 1.5707963267948966, boxCorners.rightArcLength);
        boxCorners.endRightProj = this.endLocation;
        if (this.endRightAzimuth != null) {
            d3 = d5 - this.endRightAzimuth.radians;
            d2 = Math.asin(Math.cos(d3) * Math.sin(boxCorners.rightArcLength) / Math.sin(d3));
            d = Math.asin(Math.sin(boxCorners.rightArcLength) / Math.sin(d3));
            if (d2 < d6) {
                boxCorners.endRight = LatLon.greatCircleEndPosition(this.endLocation, this.endRightAzimuth.radians, d);
                boxCorners.endRightProj = LatLon.greatCircleEndPosition(this.endLocation, d5, d2);
            }
        }
        return boxCorners;
    }

    private void appendLocations(LatLon latLon, LatLon latLon2, LatLon latLon3, int n, List<LatLon> list) {
        double d;
        int n2;
        for (n2 = 0; n2 <= n; ++n2) {
            d = (double)n2 / (double)n;
            list.add(LatLon.interpolateGreatCircle(d, latLon, latLon2));
        }
        for (n2 = 1; n2 <= n; ++n2) {
            d = (double)n2 / (double)n;
            list.add(LatLon.interpolateGreatCircle(d, latLon2, latLon3));
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "location1", this.beginLocation);
        restorableSupport.addStateValueAsLatLon(stateObject, "location2", this.endLocation);
        restorableSupport.addStateValueAsDouble(stateObject, "leftWidth", this.leftWidth);
        restorableSupport.addStateValueAsDouble(stateObject, "rightWidth", this.rightWidth);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableStartCap", this.enableStartCap);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableEndCap", this.enableEndCap);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon2 = restorableSupport.getStateValueAsLatLon(stateObject, "location1");
        if (latLon2 == null) {
            latLon2 = this.getLocations()[0];
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "location2")) == null) {
            latLon = this.getLocations()[1];
        }
        this.setLocations(latLon2, latLon);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "leftWidth");
        if (d2 == null) {
            d2 = this.getWidths()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "rightWidth")) == null) {
            d = this.getWidths()[1];
        }
        this.setWidths(d2, d);
        Boolean bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableStartCap");
        if (bl2 == null) {
            bl2 = this.isEnableCaps()[0];
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableEndCap")) == null) {
            bl = this.isEnableCaps()[1];
        }
        this.setEnableCaps(bl2, bl);
    }

    private static class BoxGeometry
    implements Cacheable {
        public Geometry sideGeometry = new Geometry();
        public Geometry capGeometry = new Geometry();
        public Geometry outlineIndices = new Geometry();
        public Geometry centerLineIndices = new Geometry();
        public Vec4 referencePoint;

        private BoxGeometry() {
        }

        @Override
        public long getSizeInBytes() {
            return this.sideGeometry.getSizeInBytes() + this.capGeometry.getSizeInBytes() + this.outlineIndices.getSizeInBytes() + this.centerLineIndices.getSizeInBytes();
        }
    }

    private static class BoxCorners {
        public LatLon beginLeft;
        public LatLon beginRight;
        public LatLon endLeft;
        public LatLon endRight;
        public LatLon beginLeftProj;
        public LatLon beginRightProj;
        public LatLon endLeftProj;
        public LatLon endRightProj;
        public double leftArcLength;
        public double rightArcLength;

        private BoxCorners() {
        }
    }
}

