/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CappedCylinder
extends AbstractAirspace {
    protected static final int DEFAULT_SLICES = 32;
    protected static final int DEFAULT_STACKS = 1;
    protected static final int DEFAULT_LOOPS = 8;
    protected static final int MINIMAL_GEOMETRY_SLICES = 8;
    protected static final int MINIMAL_GEOMETRY_LOOPS = 4;
    private LatLon center = LatLon.ZERO;
    private double innerRadius = 0.0;
    private double outerRadius = 1.0;
    private boolean enableCaps = true;
    private int slices = 32;
    private final int stacks = 1;
    private int loops = 8;

    public CappedCylinder(LatLon latLon, double d) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.outerRadius = d;
        this.makeDefaultDetailLevels();
    }

    public CappedCylinder(CappedCylinder cappedCylinder) {
        super(cappedCylinder);
        this.center = cappedCylinder.center;
        this.innerRadius = cappedCylinder.innerRadius;
        this.outerRadius = cappedCylinder.outerRadius;
        this.enableCaps = cappedCylinder.enableCaps;
        this.slices = cappedCylinder.slices;
        this.loops = cappedCylinder.loops;
        this.makeDefaultDetailLevels();
    }

    public CappedCylinder(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public CappedCylinder() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Slices", 32);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 8);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Slices", 26);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 6);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Slices", 20);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 4);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Slices", 14);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Slices", 8);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.invalidateAirspaceData();
    }

    public double[] getRadii() {
        double[] dArray = new double[]{this.innerRadius, this.outerRadius};
        return dArray;
    }

    public void setRadii(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "innerRadius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "outerRadius=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.innerRadius = d;
        this.outerRadius = d2;
        this.invalidateAirspaceData();
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setRadii(0.0, d);
    }

    public boolean isEnableCaps() {
        return this.enableCaps;
    }

    public void setEnableCaps(boolean bl) {
        this.enableCaps = bl;
    }

    @Override
    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.center, dArray[0]);
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Vec4 vec4 = globe.computePointFromLocation(this.getCenter());
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        for (Vec4 vec43 : list) {
            Vec4 vec44 = vec43.subtract3(vec4);
            double d5 = vec44.dot3(vec42);
            double d6 = vec44.perpendicularTo3(vec42).getLengthSquared3();
            if (d2 > d5) {
                d2 = d5;
            }
            if (d3 < d5) {
                d3 = d5;
            }
            if (!(d4 < d6)) continue;
            d4 = d6;
        }
        if (d2 != d3 && d4 > 0.0) {
            Vec4 vec43;
            Vec4 vec45 = vec4.add3(vec42.multiply3(d2));
            vec43 = vec4.add3(vec42.multiply3(d3));
            double d7 = Math.sqrt(d4);
            return new Cylinder(vec45, vec43, d7);
        }
        return Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        LatLon[] latLonArray = geometryBuilder.makeDiskLocations(globe, this.center, this.innerRadius, this.outerRadius, 8, 4);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, Arrays.asList(latLonArray), arrayList);
        return arrayList;
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(1);
        arrayList.add(this.getCenter());
        List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, arrayList);
        this.setCenter(list.get(0));
        super.doMoveTo(position, position2);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        LatLon latLon = this.getCenter();
        double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLon).radians;
        double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLon).radians;
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, d2, d));
    }

    @Override
    protected SurfaceShape createSurfaceShape() {
        return new SurfacePolygon();
    }

    @Override
    protected void updateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        super.updateSurfaceShape(drawContext, surfaceShape);
        boolean bl = this.getActiveAttributes().isDrawInterior() && this.isEnableCaps();
        surfaceShape.getAttributes().setDrawInterior(bl);
    }

    @Override
    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        LatLon[] latLonArray = geometryBuilder.makeCylinderLocations(drawContext.getGlobe(), this.center, this.outerRadius, this.slices);
        ((SurfacePolygon)surfaceShape).getBoundaries().clear();
        ((SurfacePolygon)surfaceShape).setOuterBoundary(Arrays.asList(latLonArray));
        if (this.innerRadius > 0.0) {
            latLonArray = geometryBuilder.makeCylinderLocations(drawContext.getGlobe(), this.center, this.innerRadius, this.slices);
            ((SurfacePolygon)surfaceShape).addInnerBoundary(Arrays.asList(latLonArray));
        }
    }

    protected int getSlices() {
        return this.slices;
    }

    protected void setSlices(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.slices = n;
    }

    protected int getStacks() {
        return this.stacks;
    }

    protected int getLoops() {
        return this.loops;
    }

    protected void setLoops(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "loops=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.loops = n;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        return drawContext.getGlobe().computePointFromPosition(this.center.getLatitude(), this.center.getLongitude(), dArray[0]);
    }

    protected Matrix computeEllipsoidalTransform(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes(d);
        return globe.computeEllipsoidalOrientationAtPosition(this.center.latitude, this.center.longitude, dArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        LatLon latLon = this.getCenter();
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        double[] dArray2 = this.getRadii();
        int n = this.slices;
        int n2 = this.stacks;
        int n3 = this.loops;
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Slices");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("Loops")) != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
            if ("Airspace.DrawStyleOutline".equals(string)) {
                if (dArray2[1] != 0.0) {
                    this.drawCylinderOutline(drawContext, latLon, dArray2[1], dArray, blArray, n, n2, 0, (Vec4)object2);
                }
                if (dArray2[0] != 0.0) {
                    this.drawCylinderOutline(drawContext, latLon, dArray2[0], dArray, blArray, n, n2, 1, (Vec4)object2);
                }
            } else if ("Airspace.DrawStyleFill".equals(string)) {
                if (this.enableCaps) {
                    oGLStackHandler.pushAttrib((GL2)object, 8);
                    object.glEnable(2884);
                    object.glFrontFace(2305);
                }
                if (this.enableCaps && dArray2[0] != dArray2[1]) {
                    this.drawDisk(drawContext, latLon, dArray2, dArray[1], blArray[1], n, n3, 0, (Vec4)object2);
                    if (!this.isAirspaceCollapsed()) {
                        this.drawDisk(drawContext, latLon, dArray2, dArray[0], blArray[0], n, n3, 1, (Vec4)object2);
                    }
                }
                if (!this.isAirspaceCollapsed()) {
                    if (dArray2[1] != 0.0) {
                        this.drawCylinder(drawContext, latLon, dArray2[1], dArray, blArray, n, n2, 0, (Vec4)object2);
                    }
                    if (dArray2[0] != 0.0) {
                        this.drawCylinder(drawContext, latLon, dArray2[0], dArray, blArray, n, n2, 1, (Vec4)object2);
                    }
                }
            }
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
            oGLStackHandler.pop((GL2)object);
        }
    }

    private void drawCylinder(DrawContext drawContext, LatLon latLon, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createCylinderVertexGeometry(drawContext, latLon, d, dArray, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeCylinderIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.drawGeometry(drawContext, geometry2, geometry);
    }

    private void drawCylinderOutline(DrawContext drawContext, LatLon latLon, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createCylinderVertexGeometry(drawContext, latLon, d, dArray, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder.OutlineIndices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeCylinderOutlineIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.drawGeometry(drawContext, geometry2, geometry);
    }

    private Geometry createCylinderVertexGeometry(DrawContext drawContext, LatLon latLon, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Cylinder.Vertices", latLon, d, dArray[0], dArray[1], blArray[0], blArray[1], n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeCylinder(drawContext, latLon, d, dArray, blArray, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makeCylinder(DrawContext drawContext, LatLon latLon, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderVertexCount(n, n2);
        float[] fArray = new float[3 * n4];
        float[] fArray2 = new float[3 * n4];
        geometryBuilder.makeCylinderVertices(drawContext.getTerrain(), latLon, d, dArray, blArray, n, n2, vec4, fArray);
        geometryBuilder.makeCylinderNormals(n, n2, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makeCylinderIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderDrawMode();
        int n5 = geometryBuilder.getCylinderIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeCylinderIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void makeCylinderOutlineIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderOutlineDrawMode();
        int n5 = geometryBuilder.getCylinderOutlineIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeCylinderOutlineIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void drawDisk(DrawContext drawContext, LatLon latLon, double[] dArray, double d, boolean bl, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Disk.Vertices", latLon, dArray[0], dArray[1], d, bl, n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeDisk(drawContext, latLon, dArray, d, bl, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        cacheKey = new Geometry.CacheKey(this.getClass(), "Disk.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeDiskIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.drawGeometry(drawContext, geometry2, geometry);
    }

    private void makeDisk(DrawContext drawContext, LatLon latLon, double[] dArray, double d, boolean bl, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getDiskVertexCount(n, n2);
        float[] fArray = new float[3 * n4];
        float[] fArray2 = new float[3 * n4];
        geometryBuilder.makeDiskVertices(drawContext.getTerrain(), latLon, dArray[0], dArray[1], d, bl, n, n2, vec4, fArray);
        geometryBuilder.makeDiskVertexNormals((float)dArray[0], (float)dArray[1], n, n2, fArray, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makeDiskIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderDrawMode();
        int n5 = geometryBuilder.getDiskIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeDiskIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "capsVisible", this.isEnableCaps());
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "innerRadius", this.getRadii()[0]);
        restorableSupport.addStateValueAsDouble(stateObject, "outerRadius", this.getRadii()[1]);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Double d2;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "capsVisible");
        if (bl != null) {
            this.setEnableCaps(bl);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center")) != null) {
            this.setCenter(latLon);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "innerRadius")) == null) {
            d2 = this.getRadii()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outerRadius")) == null) {
            d = this.getRadii()[1];
        }
        this.setRadii(d2, d);
    }
}

