/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class Polygon
extends AbstractAirspace {
    protected static final int DEFAULT_SUBDIVISIONS = 3;
    protected static final int MINIMAL_GEOMETRY_SUBDIVISIONS = 2;
    private List<LatLon> locations = new ArrayList<LatLon>();
    private boolean enableCaps = true;
    private int subdivisions = 3;

    public Polygon(Polygon polygon) {
        super(polygon);
        this.enableCaps = polygon.enableCaps;
        this.subdivisions = polygon.subdivisions;
        this.addLocations(polygon.locations);
        this.makeDefaultDetailLevels();
    }

    public Polygon(Iterable<? extends LatLon> iterable) {
        this.addLocations(iterable);
        this.makeDefaultDetailLevels();
    }

    public Polygon(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public Polygon() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Subdivisions", 4);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Subdivisions", 3);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Subdivisions", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Subdivisions", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Subdivisions", 0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public List<LatLon> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        this.locations.clear();
        this.addLocations(iterable);
    }

    protected List<LatLon> getLocationList() {
        return this.locations;
    }

    protected void addLocations(Iterable<? extends LatLon> iterable) {
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                if (latLon == null) continue;
                this.locations.add(latLon);
            }
        }
        this.invalidateAirspaceData();
    }

    public boolean isEnableCaps() {
        return this.enableCaps;
    }

    public void setEnableCaps(boolean bl) {
        this.enableCaps = bl;
    }

    @Override
    public Position getReferencePosition() {
        return this.computeReferencePosition(this.locations, this.getAltitudes());
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Vec4 vec4 = Vec4.computeAveragePoint(list);
        Position position = globe.computePositionFromPoint(vec4);
        this.makeExtremePoints(globe, d, Arrays.asList(position), list);
        return Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        List<LatLon> list = this.getLocations();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(list);
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        this.makeTessellatedLocations(globe, 2, arrayList, arrayList2);
        ArrayList<Vec4> arrayList3 = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, arrayList2, arrayList3);
        return arrayList3;
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, this.getLocations());
        this.setLocations(list);
        super.doMoveTo(position, position2);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        int n = this.locations.size();
        LatLon[] latLonArray = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            LatLon latLon = this.locations.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLon).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLon).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(Arrays.asList(latLonArray));
    }

    @Override
    protected SurfaceShape createSurfaceShape() {
        return new SurfacePolygon();
    }

    @Override
    protected void updateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        super.updateSurfaceShape(drawContext, surfaceShape);
        boolean bl = this.getActiveAttributes().isDrawInterior() && this.isEnableCaps();
        surfaceShape.getAttributes().setDrawInterior(bl);
    }

    @Override
    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        ((SurfacePolygon)surfaceShape).setOuterBoundary(this.locations);
    }

    protected int getSubdivisions() {
        return this.subdivisions;
    }

    protected void setSubdivisions(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.subdivisions = n;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        return extent != null ? extent.getCenter() : null;
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        this.doRenderGeometry(drawContext, string, this.locations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRenderGeometry(DrawContext drawContext, String string, List<LatLon> list, List<Boolean> list2) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (list == null) {
            String string4 = "nullValue.LocationsIsNull";
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (list.size() == 0) {
            return;
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        boolean bl = this.isEnableCaps();
        int n = this.subdivisions;
        if (this.getAltitudeDatum()[0].equals("gov.nasa.worldwind.avkey.AboveGroundReference") || this.getAltitudeDatum()[1].equals("gov.nasa.worldwind.avkey.AboveGroundReference")) {
            this.adjustForGroundReference(drawContext, blArray, dArray);
        }
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Subdivisions");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
            if ("Airspace.DrawStyleFill".equals(string)) {
                if (bl && !this.isAirspaceCollapsed()) {
                    oGLStackHandler.pushAttrib((GL2)object, 8);
                    object.glEnable(2884);
                    object.glFrontFace(2305);
                }
                this.drawPolygonFill(drawContext, list, list2, dArray, blArray, bl, n, (Vec4)object2);
            } else if ("Airspace.DrawStyleOutline".equals(string)) {
                this.drawPolygonOutline(drawContext, list, list2, dArray, blArray, bl, n, (Vec4)object2);
            }
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
            oGLStackHandler.pop((GL2)object);
        }
    }

    protected void adjustForGroundReference(DrawContext drawContext, boolean[] blArray, double[] dArray) {
        LatLon latLon = this.getGroundReference();
        if (latLon == null && this.getLocationList().size() > 0) {
            latLon = this.getLocationList().get(0);
        }
        this.adjustForGroundReference(drawContext, blArray, dArray, latLon);
    }

    protected int computeEllipsoidalPolygon(Globe globe, List<? extends LatLon> list, List<Boolean> list2, Vec4[] vec4Array, Boolean[] booleanArray, Matrix[] matrixArray) {
        LatLon latLon;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < 1 + list.size()) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (1 + list.size()));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrixArray == null) {
            String string = "nullValue.TransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrixArray.length < 1) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "transform.length < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            latLon = list.get(i);
            vec4Array[i] = globe.computeEllipsoidalPointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            if (booleanArray == null) continue;
            booleanArray[i] = list2 != null ? list2.get(i) : true;
        }
        Vec4 vec4 = Vec4.computeAveragePoint(Arrays.asList(vec4Array));
        if (!vec4Array[0].equals(vec4Array[n - 1])) {
            vec4Array[n] = vec4Array[0];
            if (booleanArray != null) {
                booleanArray[n] = booleanArray[0];
            }
            ++n;
        }
        latLon = globe.computePositionFromEllipsoidalPoint(vec4);
        Matrix matrix = globe.computeEllipsoidalOrientationAtPosition(((Position)latLon).latitude, ((Position)latLon).longitude, ((Position)latLon).elevation);
        Matrix matrix2 = matrix.getInverse();
        for (int i = 0; i < n; ++i) {
            vec4Array[i] = vec4Array[i].transformBy4(matrix2);
        }
        matrixArray[0] = matrix;
        return n;
    }

    private void makePolygonVertices(int n, Vec4[] vec4Array, float[] fArray) {
        for (int i = 0; i < n; ++i) {
            int n2 = 3 * i;
            fArray[n2] = (float)vec4Array[i].x;
            fArray[n2 + 1] = (float)vec4Array[i].y;
            fArray[n2 + 2] = (float)vec4Array[i].z;
        }
    }

    private PolygonGeometry getPolygonGeometry(DrawContext drawContext, List<LatLon> list, List<Boolean> list2, double[] dArray, boolean[] blArray, boolean bl, int n, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Polygon", list, list2, dArray[0], dArray[1], blArray[0], blArray[1], bl, n, vec4);
        try {
            PolygonGeometry polygonGeometry = (PolygonGeometry)this.getGeometryCache().getObject(cacheKey);
            if (polygonGeometry == null || this.isExpired(drawContext, polygonGeometry.getVertexGeometry())) {
                if (polygonGeometry == null) {
                    polygonGeometry = new PolygonGeometry();
                }
                this.makePolygon(drawContext, list, list2, dArray, blArray, bl, n, vec4, polygonGeometry);
                this.updateExpiryCriteria(drawContext, polygonGeometry.getVertexGeometry());
                this.getGeometryCache().add(cacheKey, polygonGeometry);
            }
            return polygonGeometry;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
            Logging.logger().log(Level.SEVERE, string, outOfMemoryError);
            drawContext.addRenderingException(new WWRuntimeException(string, outOfMemoryError));
            this.handleUnsuccessfulGeometryCreation();
            return null;
        }
    }

    protected void handleUnsuccessfulGeometryCreation() {
        this.locations = Collections.emptyList();
        this.invalidateAirspaceData();
    }

    private void drawPolygonFill(DrawContext drawContext, List<LatLon> list, List<Boolean> list2, double[] dArray, boolean[] blArray, boolean bl, int n, Vec4 vec4) {
        PolygonGeometry polygonGeometry = this.getPolygonGeometry(drawContext, list, list2, dArray, blArray, bl, n, vec4);
        if (polygonGeometry != null) {
            this.drawGeometry(drawContext, polygonGeometry.getFillIndexGeometry(), polygonGeometry.getVertexGeometry());
        }
    }

    private void drawPolygonOutline(DrawContext drawContext, List<LatLon> list, List<Boolean> list2, double[] dArray, boolean[] blArray, boolean bl, int n, Vec4 vec4) {
        PolygonGeometry polygonGeometry = this.getPolygonGeometry(drawContext, list, list2, dArray, blArray, bl, n, vec4);
        if (polygonGeometry != null) {
            this.drawGeometry(drawContext, polygonGeometry.getOutlineIndexGeometry(), polygonGeometry.getVertexGeometry());
        }
    }

    private void makePolygon(DrawContext drawContext, List<LatLon> list, List<Boolean> list2, double[] dArray, boolean[] blArray, boolean bl, int n, Vec4 vec4, PolygonGeometry polygonGeometry) {
        if (list.size() == 0) {
            return;
        }
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        Vec4[] vec4Array = new Vec4[list.size() + 1];
        Boolean[] booleanArray = new Boolean[list.size() + 1];
        Matrix[] matrixArray = new Matrix[1];
        int n2 = this.computeEllipsoidalPolygon(drawContext.getGlobe(), list, list2, vec4Array, booleanArray, matrixArray);
        int n3 = geometryBuilder.computePolygonWindingOrder2(0, n2, vec4Array);
        if (n3 != 0) {
            geometryBuilder.reversePoints(0, n2, vec4Array);
            geometryBuilder.reversePoints(0, n2, booleanArray);
        }
        float[] fArray = new float[3 * n2];
        this.makePolygonVertices(n2, vec4Array, fArray);
        int n4 = 4;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        GeometryBuilder.IndexedTriangleArray indexedTriangleArray = null;
        n6 += this.getEdgeFillIndexCount(n2, n);
        n7 += this.getEdgeOutlineIndexCount(n2, n, booleanArray);
        n8 += this.getEdgeVertexCount(n2, n);
        if (bl) {
            indexedTriangleArray = geometryBuilder.tessellatePolygon2(0, n2, fArray);
            for (int i = 0; i < n; ++i) {
                geometryBuilder.subdivideIndexedTriangleArray(indexedTriangleArray);
            }
            n6 += indexedTriangleArray.getIndexCount();
            n8 += indexedTriangleArray.getVertexCount();
            if (!this.isAirspaceCollapsed()) {
                n6 += indexedTriangleArray.getIndexCount();
                n8 += indexedTriangleArray.getVertexCount();
            }
        }
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n7];
        float[] fArray2 = new float[3 * n8];
        float[] fArray3 = new float[3 * n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        this.makeEdge(drawContext, n2, fArray, booleanArray, dArray, blArray, n, 0, matrixArray[0], vec4, n9, nArray, n10, nArray2, n11, fArray2, fArray3);
        n9 += this.getEdgeFillIndexCount(n2, n);
        n10 += this.getEdgeOutlineIndexCount(n2, n, booleanArray);
        n11 += this.getEdgeVertexCount(n2, n);
        if (bl) {
            this.makeCap(drawContext, indexedTriangleArray, dArray[1], blArray[1], 0, matrixArray[0], vec4, n9, nArray, n11, fArray2, fArray3);
            n9 += indexedTriangleArray.getIndexCount();
            n11 += indexedTriangleArray.getVertexCount();
            if (!this.isAirspaceCollapsed()) {
                this.makeCap(drawContext, indexedTriangleArray, dArray[0], blArray[0], 1, matrixArray[0], vec4, n9, nArray, n11, fArray2, fArray3);
                n9 += indexedTriangleArray.getIndexCount();
                n11 += indexedTriangleArray.getVertexCount();
            }
        }
        polygonGeometry.getFillIndexGeometry().setElementData(n4, n6, nArray);
        polygonGeometry.getOutlineIndexGeometry().setElementData(n5, n7, nArray2);
        polygonGeometry.getVertexGeometry().setVertexData(n8, fArray2);
        polygonGeometry.getVertexGeometry().setNormalData(n8, fArray3);
    }

    protected void makeTessellatedLocations(Globe globe, int n, List<LatLon> list, List<LatLon> list2) {
        int n2;
        LatLon latLon2;
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        for (LatLon latLon2 : list) {
            arrayList.add(globe.computeEllipsoidalPointFromPosition(latLon2.latitude, latLon2.longitude, 0.0));
        }
        if (WWMath.computeWindingOrderOfLocations(list) != "gov.nasa.worldwind.avkey.CounterClockWise") {
            Collections.reverse(list);
        }
        Vec4 vec4 = Vec4.computeAveragePoint(arrayList);
        latLon2 = globe.computePositionFromEllipsoidalPoint(vec4);
        Vec4 vec42 = globe.computeEllipsoidalNormalAtLocation(((Position)latLon2).latitude, ((Position)latLon2).longitude);
        int n3 = arrayList.size();
        float[] fArray = new float[3 * n3];
        for (int i = 0; i < n3; ++i) {
            ((Vec4)arrayList.get(i)).toFloatArray(fArray, 3 * i, 3);
        }
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        GeometryBuilder.IndexedTriangleArray indexedTriangleArray = geometryBuilder.tessellatePolygon(0, n3, fArray, vec42);
        for (n2 = 0; n2 < n; ++n2) {
            geometryBuilder.subdivideIndexedTriangleArray(indexedTriangleArray);
        }
        for (n2 = 0; n2 < indexedTriangleArray.getVertexCount(); ++n2) {
            Vec4 vec43 = Vec4.fromFloatArray(indexedTriangleArray.getVertices(), 3 * n2, 3);
            list2.add(globe.computePositionFromEllipsoidalPoint(vec43));
        }
    }

    private int getEdgeFillIndexCount(int n, int n2) {
        return (n - 1) * this.getSectionFillIndexCount(n2);
    }

    private int getEdgeOutlineIndexCount(int n, int n2, Boolean[] booleanArray) {
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            n3 += this.getSectionOutlineIndexCount(n2, booleanArray[i], booleanArray[i + 1]);
        }
        return n3;
    }

    private int getEdgeVertexCount(int n, int n2) {
        return (n - 1) * this.getSectionVertexCount(n2);
    }

    private int getSectionFillIndexCount(int n) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        return 6 * (geometryBuilder.getSubdivisionPointsVertexCount(n) - 1);
    }

    private int getSectionOutlineIndexCount(int n, boolean bl, boolean bl2) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n2 = 4 * (geometryBuilder.getSubdivisionPointsVertexCount(n) - 1);
        if (bl) {
            n2 += 2;
        }
        if (bl2) {
            n2 += 2;
        }
        return n2;
    }

    private int getSectionVertexCount(int n) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        return 2 * geometryBuilder.getSubdivisionPointsVertexCount(n);
    }

    private void makeEdge(DrawContext drawContext, int n, float[] fArray, Boolean[] booleanArray, double[] dArray, boolean[] blArray, int n2, int n3, Matrix matrix, Vec4 vec4, int n4, int[] nArray, int n5, int[] nArray2, int n6, float[] fArray2, float[] fArray3) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n7 = this.getSectionFillIndexCount(n2);
        int n8 = this.getSectionVertexCount(n2);
        for (int i = 0; i < n - 1; ++i) {
            boolean bl = booleanArray[i];
            boolean bl2 = booleanArray[i + 1];
            this.makeSectionFillIndices(n2, n6, n4, nArray);
            this.makeSectionOutlineIndices(n2, n6, n5, nArray2, bl, bl2);
            this.makeSectionVertices(drawContext, i, fArray, dArray, blArray, n2, matrix, vec4, n6, fArray2);
            geometryBuilder.makeIndexedTriangleArrayNormals(n4, n7, nArray, n6, n8, fArray2, fArray3);
            n4 += n7;
            n5 += this.getSectionOutlineIndexCount(n2, bl, bl2);
            n6 += n8;
        }
    }

    private void makeSectionFillIndices(int n, int n2, int n3, int[] nArray) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n4 = geometryBuilder.getSubdivisionPointsVertexCount(n);
        int n5 = n3;
        for (int i = 0; i < n4 - 1; ++i) {
            int n6 = n2 + 2 * i;
            int n7 = n2 + 2 * (i + 1);
            nArray[n5++] = n6 + 1;
            nArray[n5++] = n6;
            nArray[n5++] = n7 + 1;
            nArray[n5++] = n7 + 1;
            nArray[n5++] = n6;
            nArray[n5++] = n7;
        }
    }

    private void makeSectionOutlineIndices(int n, int n2, int n3, int[] nArray, boolean bl, boolean bl2) {
        int n4;
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n5 = geometryBuilder.getSubdivisionPointsVertexCount(n);
        int n6 = n3;
        if (bl) {
            n4 = n2;
            nArray[n6++] = n4;
            nArray[n6++] = n4 + 1;
        }
        for (int i = 0; i < n5 - 1; ++i) {
            n4 = n2 + 2 * i;
            int n7 = n2 + 2 * (i + 1);
            nArray[n6++] = n4;
            nArray[n6++] = n7;
            nArray[n6++] = n4 + 1;
            nArray[n6++] = n7 + 1;
        }
        if (bl2) {
            n4 = n2 + 2 * (n5 - 1);
            nArray[n6++] = n4;
            nArray[n6] = n4 + 1;
        }
    }

    private void makeSectionVertices(DrawContext drawContext, int n, float[] fArray, double[] dArray, boolean[] blArray, int n2, Matrix matrix, Vec4 vec4, int n3, float[] fArray2) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n4 = geometryBuilder.getSubdivisionPointsVertexCount(n2);
        Globe globe = drawContext.getGlobe();
        int n5 = 3 * n;
        int n6 = 3 * (n + 1);
        float[] fArray3 = new float[3 * n4];
        geometryBuilder.makeSubdivisionPoints(fArray[n5], fArray[n5 + 1], fArray[n5 + 2], fArray[n6], fArray[n6 + 1], fArray[n6 + 2], n2, fArray3);
        for (int i = 0; i < n4; ++i) {
            int n7 = 3 * i;
            Vec4 vec42 = new Vec4(fArray3[n7], fArray3[n7 + 1], fArray3[n7 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromEllipsoidalPoint(vec42);
            for (int j = 0; j < 2; ++j) {
                vec42 = this.computePointFromPosition(drawContext, position.getLatitude(), position.getLongitude(), dArray[j], blArray[j]);
                n7 = 2 * i + j;
                n7 = 3 * (n3 + n7);
                fArray2[n7] = (float)(vec42.x - vec4.x);
                fArray2[n7 + 1] = (float)(vec42.y - vec4.y);
                fArray2[n7 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    private void makeCap(DrawContext drawContext, GeometryBuilder.IndexedTriangleArray indexedTriangleArray, double d, boolean bl, int n, Matrix matrix, Vec4 vec4, int n2, int[] nArray, int n3, float[] fArray, float[] fArray2) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        Globe globe = drawContext.getGlobe();
        int n4 = indexedTriangleArray.getIndexCount();
        int n5 = indexedTriangleArray.getVertexCount();
        int[] nArray2 = indexedTriangleArray.getIndices();
        float[] fArray3 = indexedTriangleArray.getVertices();
        this.copyIndexArray(n4, n == 1, nArray2, n3, n2, nArray);
        for (int i = 0; i < n5; ++i) {
            int n6 = 3 * i;
            Vec4 vec42 = new Vec4(fArray3[n6], fArray3[n6 + 1], fArray3[n6 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromEllipsoidalPoint(vec42);
            vec42 = this.computePointFromPosition(drawContext, position.getLatitude(), position.getLongitude(), d, bl);
            n6 = 3 * (n3 + i);
            fArray[n6] = (float)(vec42.x - vec4.x);
            fArray[n6 + 1] = (float)(vec42.y - vec4.y);
            fArray[n6 + 2] = (float)(vec42.z - vec4.z);
        }
        geometryBuilder.makeIndexedTriangleArrayNormals(n2, n4, nArray, n3, n5, fArray, fArray2);
    }

    private void copyIndexArray(int n, boolean bl, int[] nArray, int n2, int n3, int[] nArray2) {
        for (int i = 0; i < n; i += 3) {
            if (bl) {
                nArray2[n3 + i] = n2 + nArray[i + 2];
                nArray2[n3 + i + 1] = n2 + nArray[i + 1];
                nArray2[n3 + i + 2] = n2 + nArray[i];
                continue;
            }
            nArray2[n3 + i] = n2 + nArray[i];
            nArray2[n3 + i + 1] = n2 + nArray[i + 1];
            nArray2[n3 + i + 2] = n2 + nArray[i + 2];
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableCaps", this.enableCaps);
        if (this.locations != null) {
            restorableSupport.addStateValueAsLatLonList(stateObject, "locations", this.locations);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        List<LatLon> list;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableCaps");
        if (bl != null) {
            this.setEnableCaps(bl);
        }
        if ((list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations")) != null) {
            this.setLocations(list);
        }
    }

    protected static class PolygonGeometry
    implements Cacheable {
        private Geometry fillIndexGeometry = new Geometry();
        private Geometry outlineIndexGeometry = new Geometry();
        private Geometry vertexGeometry = new Geometry();

        public Geometry getFillIndexGeometry() {
            return this.fillIndexGeometry;
        }

        public Geometry getOutlineIndexGeometry() {
            return this.outlineIndexGeometry;
        }

        public Geometry getVertexGeometry() {
            return this.vertexGeometry;
        }

        @Override
        public long getSizeInBytes() {
            long l = 0L;
            l += this.fillIndexGeometry != null ? this.fillIndexGeometry.getSizeInBytes() : 0L;
            l += this.outlineIndexGeometry != null ? this.outlineIndexGeometry.getSizeInBytes() : 0L;
            return l += this.vertexGeometry != null ? this.vertexGeometry.getSizeInBytes() : 0L;
        }
    }
}

