/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.List;

public class SphereAirspace
extends AbstractAirspace {
    protected static final int DEFAULT_SUBDIVISIONS = 3;
    private LatLon location = LatLon.ZERO;
    private double radius = 1.0;
    private int subdivisions = 3;

    public SphereAirspace(LatLon latLon, double d) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = latLon;
        this.radius = d;
        this.makeDefaultDetailLevels();
    }

    public SphereAirspace(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public SphereAirspace() {
        this.makeDefaultDetailLevels();
    }

    public SphereAirspace(SphereAirspace sphereAirspace) {
        super(sphereAirspace);
        this.location = sphereAirspace.location;
        this.radius = sphereAirspace.radius;
        this.subdivisions = sphereAirspace.subdivisions;
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeLinearScreenSizeRamp(7, 10.0, 600.0);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Subdivisions", 6);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Subdivisions", 5);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Subdivisions", 4);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Subdivisions", 3);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Subdivisions", 2);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[5], "Detail-Level-5");
        screenSizeDetailLevel.setValue("Subdivisions", 1);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[6], "Detail-Level-6");
        screenSizeDetailLevel.setValue("Subdivisions", 0);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = latLon;
        this.invalidateAirspaceData();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.radius = d;
        this.invalidateAirspaceData();
    }

    @Override
    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.location, dArray[0]);
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        double d2 = this.getAltitudes(d)[0];
        boolean bl = this.isTerrainConforming()[0];
        double d3 = this.getRadius();
        if (bl) {
            double[] dArray = globe.getMinAndMaxElevations(this.location.getLatitude(), this.location.getLongitude());
            double d4 = d * dArray[0] + d2 - d3;
            double d5 = d * dArray[1] + d2 + d3;
            Vec4 vec4 = globe.computePointFromPosition(this.location, d4);
            Vec4 vec42 = globe.computePointFromPosition(this.location, d5);
            return new Cylinder(vec4, vec42, d3);
        }
        Vec4 vec4 = globe.computePointFromPosition(this.location, d2);
        return new Sphere(vec4, d3);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        return null;
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeExtent(drawContext);
    }

    @Override
    protected Sphere computeExtent(DrawContext drawContext) {
        double d = this.getAltitudes(drawContext.getVerticalExaggeration())[0];
        boolean bl = this.isTerrainConforming()[0];
        double d2 = this.getRadius();
        this.clearElevationMap();
        Vec4 vec4 = this.computePointFromPosition(drawContext, this.location.getLatitude(), this.location.getLongitude(), d, bl);
        return new Sphere(vec4, d2);
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(1);
        arrayList.add(this.getLocation());
        List<LatLon> list = LatLon.computeShiftedLocations(globe, position, position2, arrayList);
        this.setLocation(list.get(0));
        super.doMoveTo(position, position2);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        this.setLocation(position2);
    }

    @Override
    protected double computeEyeDistance(DrawContext drawContext) {
        Sphere sphere = this.computeExtent(drawContext);
        Vec4 vec4 = drawContext.getView().getEyePoint();
        double d = sphere.getCenter().distanceTo3(vec4);
        return Math.abs(d - sphere.getRadius());
    }

    @Override
    protected SurfaceShape createSurfaceShape() {
        return new SurfaceCircle();
    }

    @Override
    protected void updateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        super.updateSurfaceShape(drawContext, surfaceShape);
        surfaceShape.getAttributes().setDrawOutline(false);
    }

    @Override
    protected void regenerateSurfaceShape(DrawContext drawContext, SurfaceShape surfaceShape) {
        ((SurfaceCircle)surfaceShape).setCenter(this.location);
        ((SurfaceCircle)surfaceShape).setRadius(this.radius);
    }

    protected int getSubdivisions() {
        return this.subdivisions;
    }

    protected void setSubdivisions(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.subdivisions = n;
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.clearElevationMap();
        if ("Airspace.DrawStyleFill".equals(string)) {
            this.drawSphere(drawContext);
        } else if ("Airspace.DrawStyleOutline".equals(string)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSphere(DrawContext drawContext) {
        Object object;
        Object object2;
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        int n = this.getSubdivisions();
        if (this.isEnableLevelOfDetail() && (object2 = (object = this.computeDetailLevel(drawContext)).getValue("Subdivisions")) != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        object = this.computePointFromPosition(drawContext, this.location.getLatitude(), this.location.getLongitude(), dArray[0], blArray[0]);
        object2 = drawContext.getView().getModelviewMatrix();
        object2 = ((Matrix)object2).multiply(Matrix.fromTranslation((Vec4)object));
        object2 = ((Matrix)object2).multiply(Matrix.fromScale(this.getRadius()));
        double[] dArray2 = new double[16];
        ((Matrix)object2).toArray(dArray2, 0, false);
        this.setExpiryTime(-1L);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(4104);
        try {
            gL2.glEnable(2884);
            gL2.glFrontFace(2305);
            gL2.glEnable(32826);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            try {
                gL2.glLoadMatrixd(dArray2, 0);
                this.drawUnitSphere(drawContext, n);
            }
            finally {
                gL2.glPopMatrix();
            }
        }
        finally {
            gL2.glPopAttrib();
        }
    }

    protected void drawUnitSphere(DrawContext drawContext, int n) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Sphere", n);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeSphere(1.0, n, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        this.drawGeometry(drawContext, geometry, geometry);
    }

    protected void makeSphere(double d, int n, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(0);
        GeometryBuilder.IndexedTriangleArray indexedTriangleArray = geometryBuilder.tessellateSphere((float)d, n);
        float[] fArray = new float[3 * indexedTriangleArray.getVertexCount()];
        geometryBuilder.makeIndexedTriangleArrayNormals(indexedTriangleArray, fArray);
        geometry.setElementData(4, indexedTriangleArray.getIndexCount(), indexedTriangleArray.getIndices());
        geometry.setVertexData(indexedTriangleArray.getVertexCount(), indexedTriangleArray.getVertices());
        geometry.setNormalData(indexedTriangleArray.getVertexCount(), fArray);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "location", this.getLocation());
        restorableSupport.addStateValueAsDouble(stateObject, "radius", this.getRadius());
        restorableSupport.addStateValueAsInteger(stateObject, "subdivisions", this.getSubdivisions());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Integer n;
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "location");
        if (latLon != null) {
            this.setLocation(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "radius")) != null) {
            this.setRadius(d);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "subdivisions")) != null) {
            this.setSubdivisions(n);
        }
    }
}

